/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;

public abstract class AbstractDataManagementStrategy
implements DataManagementStrategy {
    protected ScenarioSimulationModel model;
    protected ScenarioSimulationContext scenarioSimulationContext;
    protected ResultHolder factModelTreeHolder = new ResultHolder();

    @Override
    public void setModel(ScenarioSimulationModel model) {
        this.model = model;
    }

    protected static FactModelTree getSimpleClassFactModelTree(Class clazz) {
        String key = clazz.getSimpleName();
        HashMap<String, String> simpleProperties = new HashMap<String, String>();
        String fullName = clazz.getCanonicalName();
        simpleProperties.put("value", fullName);
        String packageName = fullName.substring(0, fullName.lastIndexOf("."));
        return new FactModelTree(key, packageName, simpleProperties, new HashMap());
    }

    protected Map<String, List<String>> getPropertiesToHide(ScenarioGridModel scenarioGridModel) {
        HashMap<String, List<String>> toReturn = new HashMap<String, List<String>>();
        ScenarioGridColumn selectedColumn = (ScenarioGridColumn)scenarioGridModel.getSelectedColumn();
        if (selectedColumn != null && selectedColumn.isInstanceAssigned()) {
            toReturn.put(selectedColumn.getInformationHeaderMetaData().getTitle(), this.getPropertiesToHide(selectedColumn, scenarioGridModel));
        }
        return toReturn;
    }

    protected List<String> getPropertiesToHide(ScenarioGridColumn selectedColumn, ScenarioGridModel scenarioGridModel) {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (!selectedColumn.isPropertyAssigned()) {
            scenarioGridModel.getSimulation().ifPresent(simulation -> {
                SimulationDescriptor simulationDescriptor = simulation.getSimulationDescriptor();
                List<ScenarioGridColumn> instanceColumns = scenarioGridModel.getInstanceScenarioGridColumns(selectedColumn);
                toReturn.addAll(instanceColumns.stream().filter(ScenarioGridColumn::isPropertyAssigned).map(instanceColumn -> scenarioGridModel.getColumns().indexOf(instanceColumn)).map(columnIndex -> {
                    String propertyString = String.join((CharSequence)".", simulationDescriptor.getFactMappingByIndex(columnIndex.intValue()).getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList()));
                    propertyString = propertyString.isEmpty() ? "value" : propertyString;
                    return propertyString;
                }).collect(Collectors.toList()));
            });
        }
        return toReturn;
    }

    protected void storeData(FactModelTuple factModelTuple, RightPanelView.Presenter rightPanelPresenter, ScenarioGridModel scenarioGridModel) {
        Map<String, List<String>> propertiesToHide = this.getPropertiesToHide(scenarioGridModel);
        SortedMap visibleFacts = factModelTuple.getVisibleFacts();
        Map<Boolean, List<Map.Entry>> partitionBy = visibleFacts.entrySet().stream().collect(Collectors.partitioningBy(stringFactModelTreeEntry -> ((FactModelTree)stringFactModelTreeEntry.getValue()).isSimple()));
        TreeMap<String, FactModelTree> complexDataObjects = new TreeMap<String, FactModelTree>(partitionBy.get(false).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        TreeMap<String, FactModelTree> simpleDataObjects = new TreeMap<String, FactModelTree>(partitionBy.get(true).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        SortedMap<String, FactModelTree> instanceFieldsMap = this.getInstanceMap(visibleFacts);
        rightPanelPresenter.setInstanceFieldsMap(instanceFieldsMap);
        rightPanelPresenter.setDataObjectFieldsMap(complexDataObjects);
        rightPanelPresenter.setSimpleJavaTypeFieldsMap(simpleDataObjects);
        rightPanelPresenter.setHiddenFieldsMap(factModelTuple.getHiddenFacts());
        rightPanelPresenter.hideProperties(propertiesToHide);
        TreeMap<String, FactModelTree> context = new TreeMap<String, FactModelTree>();
        context.putAll(visibleFacts);
        context.putAll(factModelTuple.getHiddenFacts());
        this.scenarioSimulationContext.setDataObjectFieldsMap(context);
        HashSet<String> dataObjectsInstancesName = new HashSet<String>(visibleFacts.keySet());
        dataObjectsInstancesName.addAll(instanceFieldsMap.keySet());
        scenarioGridModel.setDataObjectsInstancesName(dataObjectsInstancesName);
        SortedMap<String, FactModelTree> simpleJavaTypeInstanceFieldsMap = this.getInstanceMap(simpleDataObjects);
        HashSet<String> simpleJavaTypeInstancesName = new HashSet<String>(simpleDataObjects.keySet());
        simpleJavaTypeInstancesName.addAll(simpleJavaTypeInstanceFieldsMap.keySet());
        scenarioGridModel.setSimpleJavaTypeInstancesName(simpleJavaTypeInstancesName);
    }

    protected SortedMap<String, FactModelTree> getInstanceMap(SortedMap<String, FactModelTree> sourceMap) {
        TreeMap<String, FactModelTree> toReturn = new TreeMap<String, FactModelTree>();
        if (this.model != null) {
            SimulationDescriptor simulationDescriptor = this.model.getSimulation().getSimulationDescriptor();
            simulationDescriptor.getUnmodifiableFactMappings().stream().filter(factMapping -> !Objects.equals(FactMappingType.OTHER, factMapping.getExpressionIdentifier().getType())).forEach(factMapping -> {
                FactModelTree factModelTree;
                String instanceName;
                String dataObjectName = factMapping.getFactIdentifier().getClassName();
                if (dataObjectName.contains(".")) {
                    dataObjectName = dataObjectName.substring(dataObjectName.lastIndexOf(".") + 1);
                }
                if (!(instanceName = factMapping.getFactAlias()).equals(dataObjectName) && (factModelTree = (FactModelTree)sourceMap.get(dataObjectName)) != null) {
                    toReturn.put(instanceName, factModelTree);
                }
            });
        }
        return toReturn;
    }

    protected static class ResultHolder {
        FactModelTuple factModelTuple;

        protected ResultHolder() {
        }

        public FactModelTuple getFactModelTuple() {
            return this.factModelTuple;
        }

        public void setFactModelTuple(FactModelTuple factModelTuple) {
            this.factModelTuple = factModelTuple;
        }
    }
}

