/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.ButtonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.AbstractCollectionEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ElementView;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class ElementPresenterTest<E extends ElementView, T extends ElementView.Presenter<E>>
extends AbstractCollectionEditorTest {
    protected static final String ELEMENT1_ID = "ELEMENT1_ID";
    protected static final String ELEMENT2_ID = "ELEMENT2_ID";
    protected T elementPresenter;
    protected List<E> elementViewListLocal = new ArrayList();
    protected E elementView1Mock;
    protected E elementView2Mock;
    @Mock
    protected ButtonElement editItemButtonMock;
    @Mock
    protected ButtonElement deleteItemButtonMock;

    @Override
    protected void setup() {
        super.setup();
        Mockito.when((Object)this.elementView1Mock.getEditItemButton()).thenReturn((Object)this.editItemButtonMock);
        Mockito.when((Object)this.elementView2Mock.getEditItemButton()).thenReturn((Object)this.editItemButtonMock);
        Mockito.when((Object)this.elementView1Mock.getDeleteItemButton()).thenReturn((Object)this.deleteItemButtonMock);
        Mockito.when((Object)this.elementView2Mock.getDeleteItemButton()).thenReturn((Object)this.deleteItemButtonMock);
        Mockito.when((Object)this.elementView1Mock.getItemId()).thenReturn((Object)ELEMENT1_ID);
        Mockito.when((Object)this.elementView2Mock.getItemId()).thenReturn((Object)ELEMENT2_ID);
        Mockito.when((Object)this.elementView1Mock.getItemSeparator()).thenReturn((Object)this.itemSeparatorMock);
        Mockito.when((Object)this.elementView1Mock.getItemSeparator()).thenReturn((Object)this.itemSeparatorMock);
        Mockito.when((Object)this.elementView1Mock.getFaAngleRight()).thenReturn((Object)this.faAngleRightMock);
        Mockito.when((Object)this.elementView2Mock.getFaAngleRight()).thenReturn((Object)this.faAngleRightMock);
        Mockito.when((Object)this.elementView1Mock.getItemContainer()).thenReturn((Object)this.itemContainerMock);
        Mockito.when((Object)this.elementView2Mock.getItemContainer()).thenReturn((Object)this.itemContainerMock);
        Mockito.when((Object)this.elementView1Mock.getInnerItemContainer()).thenReturn((Object)this.innerItemContainerMock);
        Mockito.when((Object)this.elementView2Mock.getInnerItemContainer()).thenReturn((Object)this.innerItemContainerMock);
        Mockito.when((Object)this.elementView1Mock.getSaveChange()).thenReturn((Object)this.saveChangeMock);
        Mockito.when((Object)this.elementView2Mock.getSaveChange()).thenReturn((Object)this.saveChangeMock);
        this.elementViewListLocal.add(this.elementView1Mock);
        this.elementViewListLocal.add(this.elementView2Mock);
        for (String el : Arrays.asList(ELEMENT1_ID, ELEMENT2_ID)) {
            Mockito.when((Object)this.propertyPresenterMock.getSimpleProperties((String)Matchers.eq((Object)(el + "#KEY")))).thenReturn(new HashMap());
            Mockito.when((Object)this.propertyPresenterMock.getSimpleProperties((String)Matchers.eq((Object)(el + "#VALUE")))).thenReturn(new HashMap());
        }
    }

    @Test
    public void onToggleRowExpansionTrue() {
        this.commonOnToggleRowExpansion(true);
    }

    @Test
    public void onToggleRowExpansionFalse() {
        this.commonOnToggleRowExpansion(false);
    }

    @Test
    public void updateCommonToggleStatusNotIsShown() {
        this.commonUpdateCommonToggleStatus(false, true);
        this.commonUpdateCommonToggleStatus(false, false);
    }

    @Test
    public void updateCommonToggleStatusIsShown() {
        this.commonUpdateCommonToggleStatus(true, true);
        this.commonUpdateCommonToggleStatus(true, false);
    }

    @Test
    public void remove() {
        this.elementPresenter.remove();
        this.elementViewListLocal.forEach(elementViewMock -> ((ElementView.Presenter)Mockito.verify(this.elementPresenter, (VerificationMode)Mockito.times((int)1))).onDeleteItem((ElementView)Matchers.eq((Object)elementViewMock)));
    }

    @Test
    public void toggleEditItemButtonStatusToDisableTrue() {
        this.elementPresenter.toggleEditingStatus(true);
        this.elementViewListLocal.forEach(elementViewMock -> {
            ((ElementView)Mockito.verify((Object)elementViewMock, (VerificationMode)Mockito.times((int)1))).getEditItemButton();
            ((ElementView)Mockito.verify((Object)elementViewMock, (VerificationMode)Mockito.times((int)1))).getDeleteItemButton();
        });
        ((ButtonElement)Mockito.verify((Object)this.editItemButtonMock, (VerificationMode)Mockito.times((int)2))).setDisabled(true);
        ((ButtonElement)Mockito.verify((Object)this.deleteItemButtonMock, (VerificationMode)Mockito.times((int)2))).setDisabled(true);
    }

    @Test
    public void toggleEditItemButtonStatusToDisableFalse() {
        this.elementPresenter.toggleEditingStatus(false);
        this.elementViewListLocal.forEach(elementViewMock -> {
            ((ElementView)Mockito.verify((Object)elementViewMock, (VerificationMode)Mockito.times((int)1))).getEditItemButton();
            ((ElementView)Mockito.verify((Object)elementViewMock, (VerificationMode)Mockito.times((int)1))).getDeleteItemButton();
        });
        ((ButtonElement)Mockito.verify((Object)this.editItemButtonMock, (VerificationMode)Mockito.times((int)2))).setDisabled(false);
        ((ButtonElement)Mockito.verify((Object)this.deleteItemButtonMock, (VerificationMode)Mockito.times((int)2))).setDisabled(false);
    }

    private void commonUpdateCommonToggleStatus(boolean isShown, boolean allEquals) {
        if (allEquals) {
            this.elementViewListLocal.forEach(elementViewMock -> ((ElementView)Mockito.doReturn((Object)(!isShown ? 1 : 0)).when(elementViewMock)).isShown());
        } else {
            ((ElementView)Mockito.doReturn((Object)(!isShown ? 1 : 0)).when(this.elementView1Mock)).isShown();
            ((ElementView)Mockito.doReturn((Object)isShown).when(this.elementView2Mock)).isShown();
        }
        this.elementPresenter.updateCommonToggleStatus(isShown);
        if (allEquals) {
            ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).updateRowExpansionStatus(Matchers.eq((boolean)isShown));
        } else {
            ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.never())).updateRowExpansionStatus(Matchers.eq((boolean)isShown));
        }
        Mockito.reset((Object[])new CollectionPresenter[]{this.collectionPresenterMock});
    }

    private void commonOnToggleRowExpansion(boolean isShown) {
        this.elementPresenter.onToggleRowExpansion(isShown);
        this.elementViewListLocal.forEach(elementViewMock -> ((ElementView.Presenter)Mockito.verify(this.elementPresenter, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion((ElementView)Matchers.eq((Object)elementViewMock), Matchers.eq((boolean)isShown)));
    }
}

