/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.AbstractCollectionEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.PropertyPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.PropertyView;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.PropertyViewImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class PropertyPresenterTest
extends AbstractCollectionEditorTest {
    private static final String INNER_TEXT = "INNER_TEXT";
    private static final String ITEM_ID = "ITEM_ID";
    private static final String TEST_PROPERTYNAME = "TEST-PROPERTYNAME";
    private static final String TEST_PROPERTYVALUE = "TEST-PROPERTYVALUE";
    private static final String TEST_NEWVALUE = "TEST_NEWVALUE";
    @Mock
    private PropertyView propertyViewMock;
    @Mock
    private PropertyViewImpl propertyViewImplMock;
    @Mock
    private LIElement liElementMock;
    @Mock
    private SpanElement spanElementMock;
    @Mock
    private InputElement propertyValueInputMock;
    @Mock
    private LIElement propertyFieldsMock;
    private Map<String, SpanElement> propertySpanElementMapLocal = new HashMap<String, SpanElement>();
    private Map<String, List<PropertyView>> propertyViewMapLocal = new HashMap<String, List<PropertyView>>();
    @Mock
    private Style styleMock;
    private PropertyPresenter propertyEditorPresenter;

    @Override
    @Before
    public void setup() {
        ArrayList<PropertyView> propertyViewListLocal = new ArrayList<PropertyView>();
        propertyViewListLocal.add(this.propertyViewMock);
        this.propertyViewMapLocal.put(ITEM_ID, propertyViewListLocal);
        this.propertySpanElementMapLocal.put(TEST_PROPERTYNAME, this.spanElementMock);
        Mockito.when((Object)this.liElementMock.getStyle()).thenReturn((Object)this.styleMock);
        this.propertyEditorPresenter = (PropertyPresenter)Mockito.spy((Object)new PropertyPresenter(){
            {
                this.viewsProvider = PropertyPresenterTest.this.viewsProviderMock;
                this.propertySpanElementMap = PropertyPresenterTest.this.propertySpanElementMapLocal;
                this.propertyViewMap = PropertyPresenterTest.this.propertyViewMapLocal;
            }
        });
        Mockito.when((Object)this.spanElementMock.getInnerText()).thenReturn((Object)INNER_TEXT);
        Mockito.when((Object)this.spanElementMock.getStyle()).thenReturn((Object)this.styleMock);
        Mockito.when((Object)this.spanElementMock.getAttribute("data-i18n-key")).thenReturn((Object)TEST_PROPERTYNAME);
        Mockito.when((Object)this.viewsProviderMock.getPropertyEditorView()).thenReturn((Object)this.propertyViewMock);
        Mockito.when((Object)this.propertyValueInputMock.getStyle()).thenReturn((Object)this.styleMock);
        Mockito.when((Object)this.propertyValueInputMock.getValue()).thenReturn((Object)TEST_NEWVALUE);
        Mockito.when((Object)this.propertyViewMock.getPropertyName()).thenReturn((Object)this.spanElementMock);
        Mockito.when((Object)this.propertyViewMock.getPropertyValueSpan()).thenReturn((Object)this.spanElementMock);
        Mockito.when((Object)this.propertyViewMock.getPropertyFields()).thenReturn((Object)this.propertyFieldsMock);
        Mockito.when((Object)this.propertyViewMock.getPropertyValueInput()).thenReturn((Object)this.propertyValueInputMock);
        Mockito.when((Object)this.propertyViewImplMock.getPropertyFields()).thenReturn((Object)this.liElementMock);
        Mockito.when((Object)this.propertyFieldsMock.getStyle()).thenReturn((Object)this.styleMock);
    }

    @Test
    public void getPropertyValueContainsKey() throws Exception {
        Assert.assertEquals((Object)INNER_TEXT, (Object)this.propertyEditorPresenter.getPropertyValue(TEST_PROPERTYNAME));
    }

    @Test(expected=Exception.class)
    public void getPropertyValueNotContainsKey() throws Exception {
        this.propertySpanElementMapLocal.clear();
        this.propertyEditorPresenter.getPropertyValue(TEST_PROPERTYNAME);
    }

    @Test
    public void editProperties() {
        this.propertyEditorPresenter.editProperties(ITEM_ID);
        ((SpanElement)Mockito.verify((Object)this.spanElementMock, (VerificationMode)Mockito.times((int)1))).getStyle();
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.NONE);
        ((InputElement)Mockito.verify((Object)this.propertyValueInputMock, (VerificationMode)Mockito.times((int)1))).setValue(Matchers.anyString());
        ((InputElement)Mockito.verify((Object)this.propertyValueInputMock, (VerificationMode)Mockito.times((int)1))).getStyle();
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.INLINE);
        ((InputElement)Mockito.verify((Object)this.propertyValueInputMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)false));
    }

    @Test
    public void stopEditProperties() {
        this.propertyEditorPresenter.stopEditProperties(ITEM_ID);
        ((PropertyPresenter)Mockito.verify((Object)this.propertyEditorPresenter, (VerificationMode)Mockito.times((int)1))).stopEdit((String)Matchers.eq((Object)ITEM_ID), Matchers.eq((boolean)false));
    }

    @Test
    public void updateProperties() {
        Assert.assertNotNull((Object)this.propertyEditorPresenter.updateProperties(ITEM_ID));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyEditorPresenter, (VerificationMode)Mockito.times((int)1))).stopEdit((String)Matchers.eq((Object)ITEM_ID), Matchers.eq((boolean)true));
    }

    @Test
    public void getProperties() {
        Assert.assertNotNull((Object)this.propertyEditorPresenter.getSimpleProperties(ITEM_ID));
    }

    @Test
    public void getPropertyFields() {
        String hashedPropertyName = "#TEST-PROPERTYNAME";
        this.propertyViewMapLocal.clear();
        LIElement retireved = this.propertyEditorPresenter.getPropertyFields(ITEM_ID, TEST_PROPERTYNAME, TEST_PROPERTYVALUE);
        Assert.assertNotNull((Object)retireved);
        ((InputElement)Mockito.verify((Object)this.propertyValueInputMock, (VerificationMode)Mockito.times((int)1))).setAttribute((String)Matchers.eq((Object)"placeholder"), (String)Matchers.eq((Object)hashedPropertyName));
        ((InputElement)Mockito.verify((Object)this.propertyValueInputMock, (VerificationMode)Mockito.times((int)1))).setAttribute((String)Matchers.eq((Object)"data-field"), (String)Matchers.eq((Object)("propertyValue" + hashedPropertyName)));
        ((InputElement)Mockito.verify((Object)this.propertyValueInputMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)true));
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((LIElement)Mockito.verify((Object)this.propertyFieldsMock, (VerificationMode)Mockito.times((int)1))).setAttribute((String)Matchers.eq((Object)"data-field"), (String)Matchers.eq((Object)("propertyFields" + hashedPropertyName)));
        Assert.assertTrue((boolean)this.propertyViewMapLocal.containsKey(ITEM_ID));
        Assert.assertTrue((boolean)this.propertyViewMapLocal.get(ITEM_ID).contains(this.propertyViewMock));
    }

    @Test
    public void getEditingPropertyFields() {
        Assert.assertNotNull((Object)this.propertyEditorPresenter.getEditingPropertyFields(ITEM_ID, TEST_PROPERTYNAME, TEST_PROPERTYVALUE));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyEditorPresenter, (VerificationMode)Mockito.times((int)1))).getPropertyFields((String)Matchers.eq((Object)ITEM_ID), (String)Matchers.eq((Object)TEST_PROPERTYNAME), (String)Matchers.eq((Object)TEST_PROPERTYVALUE));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyEditorPresenter, (VerificationMode)Mockito.times((int)1))).editProperties((String)Matchers.eq((Object)ITEM_ID));
    }

    @Test
    public void onToggleRowExpansion() {
        this.propertyEditorPresenter.onToggleRowExpansion(ITEM_ID, true);
        ((LIElement)Mockito.verify((Object)this.propertyFieldsMock, (VerificationMode)Mockito.times((int)1))).addClassName((String)Matchers.eq((Object)"node-hidden"));
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        this.propertyEditorPresenter.onToggleRowExpansion(ITEM_ID, false);
        ((LIElement)Mockito.verify((Object)this.propertyFieldsMock, (VerificationMode)Mockito.times((int)1))).removeClassName((String)Matchers.eq((Object)"node-hidden"));
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
    }

    @Test
    public void deleteProperties() {
        this.propertyEditorPresenter.deleteProperties(ITEM_ID);
        ((LIElement)Mockito.verify((Object)this.propertyFieldsMock, (VerificationMode)Mockito.times((int)1))).removeFromParent();
        Assert.assertFalse((boolean)this.propertySpanElementMapLocal.containsKey(TEST_PROPERTYNAME));
        Assert.assertFalse((boolean)this.propertyViewMapLocal.containsKey(ITEM_ID));
    }

    @Test
    public void stopEditToUpdateTrue() {
        this.commonStopEdit(true);
    }

    @Test
    public void stopEditToUpdateFalse() {
        this.commonStopEdit(false);
    }

    private void commonStopEdit(boolean toUdate) {
        Map retrieved = this.propertyEditorPresenter.stopEdit(ITEM_ID, toUdate);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.containsKey(INNER_TEXT));
        if (toUdate) {
            ((SpanElement)Mockito.verify((Object)this.spanElementMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)TEST_NEWVALUE));
        }
        Assert.assertEquals((Object)INNER_TEXT, retrieved.get(INNER_TEXT));
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.INLINE);
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.NONE);
        ((InputElement)Mockito.verify((Object)this.propertyValueInputMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)true));
    }
}

