/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommandTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractSelectedColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.impl.BaseSingletonDOMElementFactory;

public abstract class AbstractSelectedColumnCommandTest
extends AbstractScenarioSimulationCommandTest {
    private final String CLASS_NAME = "ClassName";
    private final String FULL_CLASSNAME_CREATED = "test.scesim.ClassName";
    private final String LIST_PROPERTY_NAME = "listProperty";
    private final String FULL_PROPERTY_PATH = "ClassName.listProperty";
    @Mock
    protected List<GridColumn<?>> gridColumnsMock;
    @Mock
    protected FactModelTree factModelTreeMock;

    @Override
    public void setup() {
        super.setup();
        Mockito.when((Object)this.gridColumnsMock.indexOf(this.gridColumnMock)).thenReturn((Object)3);
        Mockito.when((Object)this.simulationDescriptorMock.getType()).thenReturn((Object)ScenarioSimulationModel.Type.RULE);
        Mockito.when((Object)this.factModelTreeMock.getExpandableProperties()).thenReturn(Mockito.mock(SortedMap.class));
        Mockito.when(this.dataObjectFieldsMapMock.get(Matchers.anyString())).thenReturn((Object)this.factModelTreeMock);
        this.scenarioSimulationContextLocal.getStatus().setFullPackage("test.scesim");
        this.scenarioSimulationContextLocal.getStatus().setValue("value");
        this.scenarioSimulationContextLocal.getStatus().setValueClassName(this.VALUE_CLASS_NAME);
        this.scenarioSimulationContextLocal.getStatus().setColumnId("COLUMN ID");
        this.scenarioSimulationContextLocal.getStatus().setColumnIndex(3);
    }

    @Test
    public void executeIfSelected() {
        this.command.execute(this.scenarioSimulationContextLocal);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.command), (VerificationMode)Mockito.times((int)1))).executeIfSelectedColumn(this.scenarioSimulationContextLocal, this.gridColumnMock);
    }

    @Test
    public void executeIfSelected_NoColumn() {
        this.gridColumnMock = null;
        this.command.execute(this.scenarioSimulationContextLocal);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.command), (VerificationMode)Mockito.never())).executeIfSelectedColumn(this.scenarioSimulationContextLocal, this.gridColumnMock);
    }

    @Test
    public void insertNewColumn_NotToClone() {
        this.insertNewColumnCommon(3, false);
    }

    @Test
    public void insertNewColumn_ToClone() {
        this.insertNewColumnCommon(3, true);
    }

    protected void insertNewColumnCommon(int columnIndex, boolean cloneInstance) {
        int instanceNum = this.simulationDescriptorMock.getUnmodifiableFactMappings().size();
        ScenarioGridColumn createdColumn = ((AbstractSelectedColumnCommand)this.command).insertNewColumn(this.scenarioSimulationContextLocal, this.gridColumnMock, columnIndex, cloneInstance);
        String columnGroup = this.gridColumnMock.getInformationHeaderMetaData().getColumnGroup();
        String originalInstanceTitle = this.gridColumnMock.getInformationHeaderMetaData().getTitle();
        String instanceTitle = cloneInstance ? originalInstanceTitle : "INSTANCE " + instanceNum;
        String propertyTitle = "PROPERTY " + instanceNum;
        FactMappingType factMappingType = FactMappingType.valueOf((String)columnGroup.toUpperCase());
        ((AbstractScenarioSimulationCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)1))).getScenarioGridColumnLocal((String)Matchers.eq((Object)instanceTitle), (String)Matchers.eq((Object)propertyTitle), Matchers.anyString(), (String)Matchers.eq((Object)columnGroup), (FactMappingType)Matchers.eq((Object)factMappingType), (ScenarioHeaderTextBoxSingletonDOMElementFactory)Matchers.eq((Object)this.scenarioHeaderTextBoxSingletonDOMElementFactoryTest), (ScenarioCellTextAreaSingletonDOMElementFactory)Matchers.eq((Object)this.scenarioCellTextAreaSingletonDOMElementFactoryTest), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.defineValidType()));
        if (cloneInstance) {
            ((ScenarioGridColumn)Mockito.verify((Object)createdColumn, (VerificationMode)Mockito.times((int)1))).setFactIdentifier((FactIdentifier)Matchers.eq((Object)this.gridColumnMock.getFactIdentifier()));
        } else {
            ((ScenarioGridColumn)Mockito.verify((Object)createdColumn, (VerificationMode)Mockito.never())).setFactIdentifier((FactIdentifier)Matchers.any());
        }
        ((ScenarioGridColumn)Mockito.verify((Object)createdColumn, (VerificationMode)Mockito.times((int)1))).setInstanceAssigned(Matchers.eq((boolean)cloneInstance));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).insertColumn(3, (GridColumn)createdColumn);
    }

    @Test
    public void executeKeepDataFalseDMN() {
        this.scenarioSimulationContextLocal.getStatus().setKeepData(false);
        Mockito.when((Object)this.simulationDescriptorMock.getType()).thenReturn((Object)ScenarioSimulationModel.Type.DMN);
        this.commonSetPropertyHeader(ScenarioSimulationModel.Type.DMN, false, "value", this.VALUE_CLASS_NAME);
    }

    @Test
    public void executeKeepDataFalseRule() {
        this.scenarioSimulationContextLocal.getStatus().setKeepData(false);
        Mockito.when((Object)this.simulationDescriptorMock.getType()).thenReturn((Object)ScenarioSimulationModel.Type.RULE);
        this.commonSetPropertyHeader(ScenarioSimulationModel.Type.RULE, false, "value", this.VALUE_CLASS_NAME);
    }

    @Test
    public void executeKeepDataTrue() {
        this.scenarioSimulationContextLocal.getStatus().setKeepData(true);
        this.commonSetPropertyHeader(ScenarioSimulationModel.Type.RULE, true, "value", this.VALUE_CLASS_NAME);
    }

    @Test
    public void executeWithPropertyAsCollection() {
        this.scenarioSimulationContextLocal.getStatus().setValueClassName(this.LIST_CLASS_NAME);
        this.scenarioSimulationContextLocal.getStatus().setValue("ClassName.listProperty");
        List<String> fullPropertyPathElements = Arrays.asList("ClassName.listProperty".split("\\."));
        ((AbstractSelectedColumnCommand)this.command).setPropertyHeader(this.scenarioSimulationContextLocal, this.gridColumnMock, "ClassName.listProperty", this.LIST_CLASS_NAME, Optional.empty());
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setColumnGroup(Matchers.anyString());
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle("listProperty");
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(false);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateColumnProperty(Matchers.anyInt(), (GridColumn)Matchers.eq((Object)this.gridColumnMock), (String)Matchers.eq((Object)"ClassName.listProperty"), (String)Matchers.eq((Object)this.LIST_CLASS_NAME), Matchers.anyBoolean());
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.command), (VerificationMode)Mockito.times((int)1))).manageCollectionProperty((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), (String)Matchers.eq((Object)"test.scesim.ClassName"), Matchers.eq((int)0), (List)Matchers.eq(fullPropertyPathElements));
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.command), (VerificationMode)Mockito.times((int)1))).navigateComplexObject((FactModelTree)Matchers.eq((Object)this.factModelTreeMock), (List)Matchers.eq(fullPropertyPathElements), (SortedMap)Matchers.eq((Object)this.scenarioSimulationContextLocal.getDataObjectFieldsMap()));
    }

    public void manageCollectionProperty() {
        this.scenarioSimulationContextLocal.getStatus().setValueClassName(this.LIST_CLASS_NAME);
        this.scenarioSimulationContextLocal.getStatus().setValue("ClassName.listProperty");
        List<String> fullPropertyPathElements = Arrays.asList("ClassName.listProperty".split("\\."));
        ((AbstractSelectedColumnCommand)this.command).manageCollectionProperty(this.scenarioSimulationContextLocal, this.gridColumnMock, "ClassName.listProperty", 0, fullPropertyPathElements);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.command), (VerificationMode)Mockito.times((int)1))).navigateComplexObject((FactModelTree)Matchers.eq((Object)this.factModelTreeMock), (List)Matchers.eq(fullPropertyPathElements), (SortedMap)Matchers.eq((Object)this.scenarioSimulationContextLocal.getDataObjectFieldsMap()));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setFactory((BaseSingletonDOMElementFactory)Matchers.eq((Object)this.scenarioSimulationContextLocal.getCollectionEditorSingletonDOMElementFactory()));
        ((FactMapping)Mockito.verify((Object)this.factMappingMock, (VerificationMode)Mockito.times((int)1))).setGenericTypes((List)Matchers.eq((Object)this.factModelTreeMock.getGenericTypeInfo("listProperty")));
    }

    protected void commonSetPropertyHeader(ScenarioSimulationModel.Type type, boolean keepData, String value, String propertyClass) {
        ((AbstractSelectedColumnCommand)this.command).setPropertyHeader(this.scenarioSimulationContextLocal, this.gridColumnMock, value, propertyClass, Optional.empty());
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setEditableHeaders(Matchers.eq((!type.equals((Object)ScenarioSimulationModel.Type.DMN) ? 1 : 0) != 0));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setColumnGroup(Matchers.anyString());
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle(value);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(false);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateColumnProperty(Matchers.anyInt(), (GridColumn)Matchers.isA(ScenarioGridColumn.class), (String)Matchers.eq((Object)value), (String)Matchers.eq((Object)propertyClass), Matchers.eq((boolean)keepData));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationContextLocal.getScenarioSimulationEditorPresenter(), (VerificationMode)Mockito.times((int)1))).reloadTestTools(false);
    }

    protected void navigateComplexObject() {
        FactModelTree book = new FactModelTree("Book", "com.Book", new HashMap(), new HashMap());
        book.addExpandableProperty("author", "Author");
        FactModelTree author = new FactModelTree("Author", "com.Author", new HashMap(), new HashMap());
        SortedMap sortedMap = (SortedMap)Mockito.spy(new TreeMap());
        sortedMap.put("Book", book);
        sortedMap.put("Author", author);
        List<String> elements = Arrays.asList("Book", "author", "currentlyPrinted");
        FactModelTree target = ((AbstractSelectedColumnCommand)this.command).navigateComplexObject(book, elements, sortedMap);
        Assert.assertEquals((Object)target, (Object)author);
        ((SortedMap)Mockito.verify((Object)sortedMap, (VerificationMode)Mockito.times((int)1))).get("Author");
    }

    protected void getPropertyHeaderTitle() {
        Optional emptyMatching = Optional.empty();
        ((AbstractSelectedColumnCommand)Mockito.doReturn(emptyMatching).when((Object)((AbstractSelectedColumnCommand)this.command))).getMatchingExpressionAlias((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"value"), (FactIdentifier)Matchers.eq((Object)this.factIdentifierMock));
        String retrieved = ((AbstractSelectedColumnCommand)this.command).getPropertyHeaderTitle(this.scenarioSimulationContextLocal, "value", this.factIdentifierMock);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.command), (VerificationMode)Mockito.times((int)1))).getMatchingExpressionAlias((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"value"), (FactIdentifier)Matchers.eq((Object)this.factIdentifierMock));
        Assert.assertEquals((Object)"value", (Object)retrieved);
        String EXPECTED_VALUE_STRING = "EXPECTED_VALUE_STRING";
        Optional<String> expectedValue = Optional.of("EXPECTED_VALUE_STRING");
        ((AbstractSelectedColumnCommand)Mockito.doReturn(expectedValue).when((Object)((AbstractSelectedColumnCommand)this.command))).getMatchingExpressionAlias((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"TestClass.testProperty"), (FactIdentifier)Matchers.eq((Object)this.factIdentifierMock));
        retrieved = ((AbstractSelectedColumnCommand)this.command).getPropertyHeaderTitle(this.scenarioSimulationContextLocal, "TestClass.testProperty", this.factIdentifierMock);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.command), (VerificationMode)Mockito.times((int)1))).getMatchingExpressionAlias((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"TestClass.testProperty"), (FactIdentifier)Matchers.eq((Object)this.factIdentifierMock));
        Assert.assertEquals((Object)EXPECTED_VALUE_STRING, (Object)retrieved);
        String aliasedPropertyName = "ClassName_ALIAS.testProperty";
        retrieved = ((AbstractSelectedColumnCommand)this.command).getPropertyHeaderTitle(this.scenarioSimulationContextLocal, aliasedPropertyName, this.factIdentifierMock);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.command), (VerificationMode)Mockito.times((int)2))).getMatchingExpressionAlias((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"TestClass.testProperty"), (FactIdentifier)Matchers.eq((Object)this.factIdentifierMock));
        Assert.assertEquals((Object)EXPECTED_VALUE_STRING, (Object)retrieved);
    }

    protected void getMatchingExpressionAlias() {
        Optional retrieved = ((AbstractSelectedColumnCommand)this.command).getMatchingExpressionAlias(this.scenarioSimulationContextLocal, "value", this.factIdentifierMock);
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingsByFactName((String)Matchers.eq((Object)this.factIdentifierMock.getName()));
        Assert.assertEquals(Optional.empty(), (Object)retrieved);
        ArrayList<FactMapping> factMappingList = new ArrayList<FactMapping>();
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingsByFactName("FACT_IDENTIFIER_NAME")).thenReturn(factMappingList);
        factMappingList.add(this.factMappingMock);
        String EXPRESSION_ALIAS = "EXPRESSION_ALIAS";
        Mockito.when((Object)this.factMappingMock.getExpressionAlias()).thenReturn((Object)EXPRESSION_ALIAS);
        retrieved = ((AbstractSelectedColumnCommand)this.command).getMatchingExpressionAlias(this.scenarioSimulationContextLocal, "TestClass.testProperty", this.factIdentifierMock);
        Assert.assertEquals(Optional.empty(), (Object)retrieved);
        Mockito.when((Object)this.factMappingMock.getFullExpression()).thenReturn((Object)"TestClass.testProperty");
        retrieved = ((AbstractSelectedColumnCommand)this.command).getMatchingExpressionAlias(this.scenarioSimulationContextLocal, "TestClass.testProperty", this.factIdentifierMock);
        Assert.assertEquals(Optional.of(EXPRESSION_ALIAS), (Object)retrieved);
    }
}

