/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractSelectedColumnCommandTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.DuplicateInstanceCommand;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

@RunWith(value=GwtMockitoTestRunner.class)
public class DuplicateInstanceCommandTest
extends AbstractSelectedColumnCommandTest {
    protected String GRID_COLUMN_ID_1 = "GRID_COLUMN_ID_1";
    protected String GRID_PROPERTY_TITLE_1 = "GRID_PROPERTY_TITLE_1";
    protected String FACT_ALIAS_1 = "FACT_ALIAS_1";
    protected String FULL_CLASS_NAME_1 = "test.scesim.TestClass_1";
    protected String FACT_IDENTIFIER_NAME_1 = "FACT_IDENTIFIER_NAME_1";
    protected String VALUE_1 = "value_1";
    @Mock
    protected ScenarioGridColumn scenarioGridColumnMock1;
    @Mock
    protected ScenarioGridColumn scenarioGridColumnMock2;
    @Mock
    protected ScenarioGridColumn scenarioGridColumnMock3;
    @Mock
    protected FactMapping factMappingMock1;
    @Mock
    protected FactMapping factMappingMock2;
    @Mock
    protected FactMapping factMappingMock3;
    @Mock
    protected FactMappingValue factMappingValueMock1;
    @Mock
    protected FactMappingValue factMappingValueMock2;
    @Mock
    protected FactMappingValue factMappingValueMock3;
    @Mock
    protected FactIdentifier factIdentifierMock1;
    @Mock
    protected FactIdentifier factIdentifierMock2;
    @Mock
    protected List<GridColumn.HeaderMetaData> headerMetaDatasMock1;
    @Mock
    protected List<GridColumn.HeaderMetaData> headerMetaDatasMock2;
    @Mock
    protected List<GridColumn.HeaderMetaData> headerMetaDatasMock3;
    @Mock
    protected ScenarioHeaderMetaData informationHeaderMetaDataMock1;
    @Mock
    protected ScenarioHeaderMetaData informationHeaderMetaDataMock2;
    @Mock
    protected ScenarioHeaderMetaData propertyHeaderMetaDataMock1;
    @Mock
    protected ScenarioHeaderMetaData propertyHeaderMetaDataMock2;
    @Mock
    protected ScenarioHeaderMetaData propertyHeaderMetaDataMock3;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.command = (AbstractScenarioSimulationCommand)Mockito.spy((Object)new DuplicateInstanceCommand(){

            protected void setInstanceHeader(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn, String alias, String fullClassName) {
            }

            protected ScenarioGridColumn getScenarioGridColumnLocal(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader, ScenarioCellTextAreaSingletonDOMElementFactory factoryCell, String placeHolder) {
                return DuplicateInstanceCommandTest.this.gridColumnMock;
            }
        });
        Assert.assertTrue((boolean)this.command.isUndoable());
        this.addNewColumn(this.scenarioGridColumnMock1, this.headerMetaDatasMock1, this.informationHeaderMetaDataMock1, this.propertyHeaderMetaDataMock1, this.factIdentifierMock1, this.factMappingMock1, this.factMappingValueMock1, 4, 4, 4, this.VALUE_1, this.GRID_PROPERTY_TITLE_1, this.GRID_COLUMN_ID_1, this.FACT_ALIAS_1, this.VALUE_CLASS_NAME, "test", this.FULL_CLASS_NAME_1, this.FACT_IDENTIFIER_NAME_1);
    }

    @Test
    public void executeIfSelectedColumn_WithoutInstanceAndProperty() {
        Mockito.when((Object)this.scenarioGridColumnMock1.isInstanceAssigned()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.scenarioGridColumnMock1.isPropertyAssigned()).thenReturn((Object)Boolean.FALSE);
        ((DuplicateInstanceCommand)this.command).executeIfSelectedColumn(this.scenarioSimulationContextLocal, this.scenarioGridColumnMock1);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)VerificationModeFactory.times((int)1))).getInstancesCount((String)Matchers.eq((Object)this.scenarioGridColumnMock1.getFactIdentifier().getClassName()));
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)VerificationModeFactory.times((int)1))).insertNewColumn((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)Matchers.eq((Object)this.scenarioGridColumnMock1), Matchers.eq((int)5), ((Boolean)Matchers.eq((Object)Boolean.FALSE)).booleanValue());
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)Mockito.never())).setInstanceHeader((ScenarioSimulationContext)Matchers.any(), (ScenarioGridColumn)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)Mockito.never())).setPropertyHeader((ScenarioSimulationContext)Matchers.any(), (ScenarioGridColumn)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (Optional)Matchers.any());
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.never())).duplicateColumnValues(Matchers.anyInt(), Matchers.eq((int)0));
    }

    @Test
    public void executeIfSelectedColumn_WithInstanceOnly() {
        Mockito.when((Object)this.scenarioGridColumnMock1.isPropertyAssigned()).thenReturn((Object)Boolean.FALSE);
        ((DuplicateInstanceCommand)this.command).executeIfSelectedColumn(this.scenarioSimulationContextLocal, this.scenarioGridColumnMock1);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)VerificationModeFactory.times((int)1))).getInstancesCount((String)Matchers.eq((Object)this.scenarioGridColumnMock1.getFactIdentifier().getClassName()));
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)VerificationModeFactory.times((int)1))).insertNewColumn((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)Matchers.eq((Object)this.scenarioGridColumnMock1), Matchers.eq((int)5), ((Boolean)Matchers.eq((Object)Boolean.FALSE)).booleanValue());
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)VerificationModeFactory.times((int)1))).setInstanceHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), (String)Matchers.eq((Object)(this.VALUE_1 + "_copy_" + "1")), (String)Matchers.eq((Object)this.FULL_CLASS_NAME_1));
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)Mockito.never())).setPropertyHeader((ScenarioSimulationContext)Matchers.any(), (ScenarioGridColumn)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (Optional)Matchers.any());
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.never())).duplicateColumnValues(Matchers.anyInt(), Matchers.eq((int)0));
    }

    @Test
    public void executeIfSelectedColumn_WithInstanceAndProperty() {
        ((DuplicateInstanceCommand)this.command).executeIfSelectedColumn(this.scenarioSimulationContextLocal, this.scenarioGridColumnMock1);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)VerificationModeFactory.times((int)1))).getInstancesCount((String)Matchers.eq((Object)this.scenarioGridColumnMock1.getFactIdentifier().getClassName()));
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)VerificationModeFactory.times((int)1))).insertNewColumn((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)Matchers.eq((Object)this.scenarioGridColumnMock1), Matchers.eq((int)5), ((Boolean)Matchers.eq((Object)Boolean.FALSE)).booleanValue());
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)VerificationModeFactory.times((int)1))).setInstanceHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), (String)Matchers.eq((Object)(this.VALUE_1 + "_copy_" + "1")), (String)Matchers.eq((Object)this.FULL_CLASS_NAME_1));
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)VerificationModeFactory.times((int)1))).setPropertyHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), (String)Matchers.eq((Object)"value_1_copy_1.test"), (String)Matchers.eq((Object)this.VALUE_CLASS_NAME), (Optional)Matchers.eq(Optional.of(this.GRID_PROPERTY_TITLE_1)));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)VerificationModeFactory.times((int)1))).duplicateColumnValues(Matchers.eq((int)4), Matchers.eq((int)0));
    }

    @Test
    public void executeIfSelectedColumn_WithInstanceAndPropertyAndThreeColumns() {
        this.addNewColumn(this.scenarioGridColumnMock2, this.headerMetaDatasMock2, this.informationHeaderMetaDataMock2, this.propertyHeaderMetaDataMock2, this.factIdentifierMock2, this.factMappingMock2, this.factMappingValueMock2, 5, 6, 5, "value_2", "GRID_PROPERTY_TITLE_2", "GRID_COLUMN_ID_2", "FACT_ALIAS_2", this.VALUE_CLASS_NAME, "second", "test.scesim.TestClass_2", "FACT_IDENTIFIER_NAME_2");
        this.addNewColumn(this.scenarioGridColumnMock3, this.headerMetaDatasMock3, this.informationHeaderMetaDataMock2, this.propertyHeaderMetaDataMock3, this.factIdentifierMock2, this.factMappingMock3, this.factMappingValueMock3, 5, 6, 6, "value_2", "GRID_PROPERTY_TITLE_3", "GRID_COLUMN_ID_3", "FACT_ALIAS_3", this.VALUE_CLASS_NAME, "third", "test.scesim.TestClass_2", "FACT_IDENTIFIER_NAME_3");
        ((DuplicateInstanceCommand)this.command).executeIfSelectedColumn(this.scenarioSimulationContextLocal, this.scenarioGridColumnMock2);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)VerificationModeFactory.times((int)1))).getInstancesCount((String)Matchers.eq((Object)this.scenarioGridColumnMock2.getFactIdentifier().getClassName()));
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)VerificationModeFactory.times((int)1))).insertNewColumn((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)Matchers.eq((Object)this.scenarioGridColumnMock2), Matchers.eq((int)7), ((Boolean)Matchers.eq((Object)Boolean.FALSE)).booleanValue());
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)VerificationModeFactory.times((int)1))).insertNewColumn((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)Matchers.eq((Object)this.scenarioGridColumnMock3), Matchers.eq((int)8), ((Boolean)Matchers.eq((Object)Boolean.FALSE)).booleanValue());
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)VerificationModeFactory.times((int)2))).setInstanceHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), (String)Matchers.eq((Object)"value_2_copy_2"), (String)Matchers.eq((Object)"test.scesim.TestClass_2"));
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)VerificationModeFactory.times((int)1))).setPropertyHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), (String)Matchers.eq((Object)"value_2_copy_2.second"), (String)Matchers.eq((Object)this.VALUE_CLASS_NAME), (Optional)Matchers.eq(Optional.of("GRID_PROPERTY_TITLE_2")));
        ((DuplicateInstanceCommand)Mockito.verify((Object)((DuplicateInstanceCommand)this.command), (VerificationMode)VerificationModeFactory.times((int)1))).setPropertyHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), (String)Matchers.eq((Object)"value_2_copy_2.third"), (String)Matchers.eq((Object)this.VALUE_CLASS_NAME), (Optional)Matchers.eq(Optional.of("GRID_PROPERTY_TITLE_3")));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)VerificationModeFactory.times((int)1))).duplicateColumnValues(Matchers.eq((int)5), Matchers.eq((int)0));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)VerificationModeFactory.times((int)1))).duplicateColumnValues(Matchers.eq((int)6), Matchers.eq((int)0));
    }
}

