/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationDocksHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.workbench.client.docks.AuthoringWorkbenchDocks;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.workbench.docks.UberfireDock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationDocksHandlerTest {
    @Mock
    private AuthoringWorkbenchDocks authoringWorkbenchDocks;
    @InjectMocks
    private ScenarioSimulationDocksHandler scenarioSimulationDocksHandler;

    @Test
    public void correctAmountOfItems() {
        Assert.assertEquals((long)MANAGED_DOCKS.values().length, (long)this.scenarioSimulationDocksHandler.provideDocks("identifier").size());
    }

    @Test
    public void expandToolsDock() {
        Collection docks = this.scenarioSimulationDocksHandler.provideDocks("id");
        UberfireDock toolsDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.TOOLS.index];
        this.scenarioSimulationDocksHandler.expandToolsDock();
        ((AuthoringWorkbenchDocks)Mockito.verify((Object)this.authoringWorkbenchDocks)).expandAuthoringDock(toolsDock);
    }

    @Test
    public void expandTestResultsDock() {
        Collection docks = this.scenarioSimulationDocksHandler.provideDocks("id");
        UberfireDock reportDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.REPORT.index];
        this.scenarioSimulationDocksHandler.expandTestResultsDock();
        ((AuthoringWorkbenchDocks)Mockito.verify((Object)this.authoringWorkbenchDocks)).expandAuthoringDock(reportDock);
    }

    @Test
    public void setScesimPath() {
        Collection docks = this.scenarioSimulationDocksHandler.provideDocks("id");
        UberfireDock settingsDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.SETTINGS.index];
        UberfireDock toolsDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.TOOLS.index];
        UberfireDock cheatSheetDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.CHEATSHEET.index];
        String TEST_PATH = "TEST_PATH";
        this.scenarioSimulationDocksHandler.setScesimEditorId(TEST_PATH);
        Assert.assertTrue((boolean)settingsDock.getPlaceRequest().getParameters().containsKey("scesimeditorid"));
        Assert.assertEquals((Object)TEST_PATH, (Object)settingsDock.getPlaceRequest().getParameter("scesimeditorid", "null"));
        Assert.assertTrue((boolean)toolsDock.getPlaceRequest().getParameters().containsKey("scesimeditorid"));
        Assert.assertEquals((Object)TEST_PATH, (Object)toolsDock.getPlaceRequest().getParameter("scesimeditorid", "null"));
        Assert.assertTrue((boolean)cheatSheetDock.getPlaceRequest().getParameters().containsKey("scesimeditorid"));
        Assert.assertEquals((Object)TEST_PATH, (Object)cheatSheetDock.getPlaceRequest().getParameter("scesimeditorid", "null"));
    }

    private static enum MANAGED_DOCKS {
        SETTINGS(0),
        TOOLS(1),
        CHEATSHEET(2),
        REPORT(3);

        private int index;

        private MANAGED_DOCKS(int index) {
            this.index = index;
        }
    }
}

