/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.menu;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.ExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderGivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.OtherContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.UnmodifiableColumnGridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationGridHandlerTest;
import org.drools.workbench.screens.scenariosimulation.client.menu.ScenarioContextMenuRegistry;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioContextMenuRegistryTest
extends AbstractScenarioSimulationGridHandlerTest {
    @Mock
    private OtherContextMenu otherContextMenuMock;
    @Mock
    private HeaderGivenContextMenu headerGivenContextMenuMock;
    @Mock
    private HeaderExpectedContextMenu headerExpectedContextMenuMock;
    @Mock
    private GivenContextMenu givenContextMenuMock;
    @Mock
    private ExpectedContextMenu expectedContextMenuMock;
    @Mock
    private GridContextMenu gridContextMenuMock;
    @Mock
    private UnmodifiableColumnGridContextMenu unmodifiableColumnGridContextMenuMock;
    @Mock
    private ContextMenuEvent contextMenuEventMock;
    @Mock
    private NativeEvent contextNativeEventMock;
    @Mock
    private Element contextMenuEventTargetMock;
    @Mock
    private Document contextMenuEventTargetOwnerMock;
    private ScenarioContextMenuRegistry scenarioContextMenuRegistry;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        ((ContextMenuEvent)Mockito.doReturn((Object)this.contextNativeEventMock).when((Object)this.contextMenuEventMock)).getNativeEvent();
        ((ContextMenuEvent)Mockito.doReturn((Object)this.contextMenuEventTargetMock).when((Object)this.contextMenuEventMock)).getRelativeElement();
        ((Element)Mockito.doReturn((Object)this.contextMenuEventTargetOwnerMock).when((Object)this.contextMenuEventTargetMock)).getOwnerDocument();
        this.scenarioContextMenuRegistry = new ScenarioContextMenuRegistry(this.otherContextMenuMock, this.headerGivenContextMenuMock, this.headerExpectedContextMenuMock, this.givenContextMenuMock, this.expectedContextMenuMock, this.gridContextMenuMock, this.unmodifiableColumnGridContextMenuMock);
    }

    @Test
    public void testManageHeaderRightClick() {
        int clickPointX = 5;
        int clickPointy = 6;
        ((NativeEvent)Mockito.doReturn((Object)5).when((Object)this.contextNativeEventMock)).getClientX();
        ((NativeEvent)Mockito.doReturn((Object)6).when((Object)this.contextNativeEventMock)).getClientY();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.scenarioContextMenuRegistry.manageRightClick(this.scenarioGridMock, this.contextMenuEventMock)).as("Click to [0,0] header cell", new Object[0])).isTrue();
        ((ExpectedContextMenu)Mockito.verify((Object)this.expectedContextMenuMock)).show(5, 6, 0, this.COLUMN_GROUP, false, this.simulationDescriptorMock.getType().equals((Object)ScenarioSimulationModel.Type.RULE));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.headerExpectedContextMenuMock});
    }

    @Test
    public void testManageHeaderRightClick_ClickOutsideHeader() {
        int clickPointX = 5;
        int clickPointY = 11;
        ((NativeEvent)Mockito.doReturn((Object)5).when((Object)this.contextNativeEventMock)).getClientX();
        ((NativeEvent)Mockito.doReturn((Object)11).when((Object)this.contextNativeEventMock)).getClientY();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.scenarioContextMenuRegistry.manageRightClick(this.scenarioGridMock, this.contextMenuEventMock)).as("Click point y more then header max y", new Object[0])).isFalse();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.expectedContextMenuMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.headerExpectedContextMenuMock});
    }

    @Test
    public void testManageHeaderRightClick_NoColumnGroup() {
        int clickPointX = 5;
        int clickPointY = 6;
        ((NativeEvent)Mockito.doReturn((Object)5).when((Object)this.contextNativeEventMock)).getClientX();
        ((NativeEvent)Mockito.doReturn((Object)6).when((Object)this.contextNativeEventMock)).getClientY();
        ((ScenarioHeaderMetaData)Mockito.doReturn((Object)"").when((Object)this.informationHeaderMetaDataMock)).getColumnGroup();
        ((ScenarioHeaderMetaData)Mockito.doReturn((Object)"EXPECT").when((Object)this.informationHeaderMetaDataMock)).getTitle();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.scenarioContextMenuRegistry.manageRightClick(this.scenarioGridMock, this.contextMenuEventMock)).as("Context menu according to column title", new Object[0])).isTrue();
        ((HeaderExpectedContextMenu)Mockito.verify((Object)this.headerExpectedContextMenuMock)).show(5, 6);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.expectedContextMenuMock});
    }

    @Test
    public void testManageBodyRightClick() {
        int clickPointX = 5;
        int clickPointY = 11;
        double widgetHeight = 50.0;
        double rowHeight = 50.0 - this.HEADER_HEIGHT;
        ((NativeEvent)Mockito.doReturn((Object)5).when((Object)this.contextNativeEventMock)).getClientX();
        ((NativeEvent)Mockito.doReturn((Object)11).when((Object)this.contextNativeEventMock)).getClientY();
        ((ScenarioGrid)Mockito.doReturn((Object)50.0).when((Object)this.scenarioGridMock)).getHeight();
        ((ScenarioGridModel)Mockito.doReturn((Object)1).when((Object)this.scenarioGridModelMock)).getRowCount();
        GridRow gridRowMock = (GridRow)Mockito.mock(GridRow.class);
        ((ScenarioGridModel)Mockito.doReturn((Object)gridRowMock).when((Object)this.scenarioGridModelMock)).getRow(0);
        ((GridRow)Mockito.doReturn((Object)rowHeight).when((Object)gridRowMock)).getHeight();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.scenarioContextMenuRegistry.manageRightClick(this.scenarioGridMock, this.contextMenuEventMock)).as("Click to expect/given body cell", new Object[0])).isTrue();
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuMock)).show(5, 11, 0, 0, this.COLUMN_GROUP, true, this.simulationDescriptorMock.getType().equals((Object)ScenarioSimulationModel.Type.RULE));
    }

    @Test
    public void testManageBodyRightClick_Unmodifiable() {
        int clickPointX = 5;
        int clickPointY = 11;
        double widgetHeight = 50.0;
        double rowHeight = 50.0 - this.HEADER_HEIGHT;
        ((NativeEvent)Mockito.doReturn((Object)5).when((Object)this.contextNativeEventMock)).getClientX();
        ((NativeEvent)Mockito.doReturn((Object)11).when((Object)this.contextNativeEventMock)).getClientY();
        ((ScenarioGrid)Mockito.doReturn((Object)50.0).when((Object)this.scenarioGridMock)).getHeight();
        ((ScenarioGridModel)Mockito.doReturn((Object)1).when((Object)this.scenarioGridModelMock)).getRowCount();
        GridRow gridRowMock = (GridRow)Mockito.mock(GridRow.class);
        ((ScenarioGridModel)Mockito.doReturn((Object)gridRowMock).when((Object)this.scenarioGridModelMock)).getRow(0);
        ((GridRow)Mockito.doReturn((Object)rowHeight).when((Object)gridRowMock)).getHeight();
        ((ScenarioHeaderMetaData)Mockito.doReturn((Object)"").when((Object)this.informationHeaderMetaDataMock)).getColumnGroup();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.scenarioContextMenuRegistry.manageRightClick(this.scenarioGridMock, this.contextMenuEventMock)).as("Click to row number/description body cell", new Object[0])).isTrue();
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuMock)).show(5, 11, 0);
    }
}

