/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.popup;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.HeadingElement;
import org.drools.workbench.screens.scenariosimulation.client.popup.AbstractScenarioPopupView;
import org.jboss.errai.common.client.dom.CSSStyleDeclaration;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.Button;
import org.uberfire.client.views.pfly.widgets.Modal;
import org.uberfire.mvp.Command;

public abstract class AbstractScenarioPopupViewTest {
    protected AbstractScenarioPopupView popupView;
    @Mock
    protected Command okCommandMock;
    @Mock
    protected Button cancelButtonMock;
    @Mock
    protected Button okButtonMock;
    @Mock
    protected MouseEvent mouseEventMock;
    @Mock
    protected HTMLElement elementMock;
    @Mock
    protected TranslationService translationServiceMock;
    @Mock
    protected Modal modalMock;
    @Mock
    protected CSSStyleDeclaration styleMock;
    @Mock
    protected HeadingElement mainTitleMock;
    protected final String MAIN_TITLE_TEXT = "MAIN_TITLE_TEXT";
    protected final String OK_BUTTON_TEXT = "OK_BUTTON_TEXT";

    @Test
    public void init() {
        this.popupView.init();
        ((Button)Mockito.verify((Object)this.cancelButtonMock, (VerificationMode)Mockito.times((int)1))).setText(Matchers.anyString());
    }

    @Test
    public void show() {
        this.popupView.show("MAIN_TITLE_TEXT", "OK_BUTTON_TEXT", this.okCommandMock);
        this.verifyShow("MAIN_TITLE_TEXT");
        Assert.assertEquals((Object)this.okCommandMock, (Object)this.popupView.okCommand);
    }

    @Test
    public void getElement() {
        HTMLElement retrieved = this.popupView.getElement();
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void hide() {
        this.popupView.hide();
        ((Modal)Mockito.verify((Object)this.modalMock, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void onOkClick() {
        this.popupView.okCommand = null;
        this.popupView.onOkClick(this.mouseEventMock);
        ((Command)Mockito.verify((Object)this.okCommandMock, (VerificationMode)Mockito.never())).execute();
        ((AbstractScenarioPopupView)Mockito.verify((Object)this.popupView, (VerificationMode)Mockito.times((int)1))).hide();
        Mockito.reset((Object[])new AbstractScenarioPopupView[]{this.popupView});
        this.popupView.okCommand = this.okCommandMock;
        this.popupView.onOkClick(this.mouseEventMock);
        ((Command)Mockito.verify((Object)this.okCommandMock, (VerificationMode)Mockito.times((int)1))).execute();
        ((AbstractScenarioPopupView)Mockito.verify((Object)this.popupView, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void onCancelClick() {
        this.popupView.onCancelClick(this.mouseEventMock);
        ((AbstractScenarioPopupView)Mockito.verify((Object)this.popupView, (VerificationMode)Mockito.times((int)1))).hide();
    }

    protected void verifyShow(String mainTitleText) {
        ((AbstractScenarioPopupView)Mockito.verify((Object)this.popupView, (VerificationMode)Mockito.times((int)1))).conditionalShow((Element)Matchers.eq((Object)this.mainTitleMock), (String)Matchers.eq((Object)mainTitleText));
        ((Modal)Mockito.verify((Object)this.modalMock, (VerificationMode)Mockito.times((int)1))).show();
    }

    protected void commonSetup() {
        Mockito.when((Object)this.translationServiceMock.getTranslation("ConfirmPopup.Cancel")).thenReturn((Object)"ConfirmPopup.Cancel");
        Mockito.when((Object)this.elementMock.getStyle()).thenReturn((Object)this.styleMock);
        Mockito.when((Object)this.modalMock.getElement()).thenReturn((Object)this.elementMock);
    }
}

