/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.LabelElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import junit.framework.TestCase;
import org.drools.workbench.screens.scenariosimulation.client.events.SetInstanceHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SetPropertyHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractTestToolsTest;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class TestToolsPresenterTest
extends AbstractTestToolsTest {
    @Mock
    private TestToolsView testToolsViewMock;
    @Mock
    private LabelElement dataObjectListContainerSeparatorMock;
    @Mock
    private Style dataObjectListContainerSeparatorStyleMock;
    @Mock
    private DivElement dataObjectListContainerMock;
    @Mock
    private LabelElement simpleJavaTypeListContainerSeparatorMock;
    @Mock
    private Style simpleJavaTypeListContainerSeparatorStyleMock;
    @Mock
    private DivElement simpleJavaTypeListContainerMock;
    @Mock
    private LabelElement instanceListContainerSeparatorMock;
    @Mock
    private Style instanceListContainerSeparatorStyleMock;
    @Mock
    private DivElement instanceListContainerMock;
    @Mock
    private LabelElement simpleJavaInstanceListContainerSeparatorMock;
    @Mock
    private Style simpleJavaInstanceListContainerSeparatorStyleMock;
    @Mock
    private DivElement simpleJavaInstanceListContainerMock;
    @Mock
    private ListGroupItemPresenter listGroupItemPresenterMock;
    @Mock
    private ListGroupItemView selectedListGroupItemViewMock;
    @Mock
    private FieldItemView selectedFieldItemViewMock;
    @Mock
    private EventBus eventBusMock;
    private TestToolsPresenter testToolsPresenter;

    @Override
    @Before
    public void setup() {
        super.setup();
        String firstKey = (String)this.dataObjectFactTreeMap.firstKey();
        FactModelTree factModelTree = (FactModelTree)this.dataObjectFactTreeMap.get(firstKey);
        String firstPropertyKey = (String)new ArrayList(factModelTree.getSimpleProperties().keySet()).get(0);
        String firstPropertyClass = (String)factModelTree.getSimpleProperties().get(firstPropertyKey);
        Mockito.when((Object)this.selectedListGroupItemViewMock.getActualClassName()).thenReturn((Object)firstKey);
        Mockito.when((Object)this.selectedFieldItemViewMock.getFullPath()).thenReturn((Object)firstKey);
        Mockito.when((Object)this.selectedFieldItemViewMock.getFieldName()).thenReturn((Object)firstPropertyKey);
        Mockito.when((Object)this.selectedFieldItemViewMock.getClassName()).thenReturn((Object)firstPropertyClass);
        Mockito.when((Object)this.dataObjectListContainerSeparatorMock.getStyle()).thenReturn((Object)this.dataObjectListContainerSeparatorStyleMock);
        Mockito.when((Object)this.simpleJavaTypeListContainerSeparatorMock.getStyle()).thenReturn((Object)this.simpleJavaTypeListContainerSeparatorStyleMock);
        Mockito.when((Object)this.instanceListContainerSeparatorMock.getStyle()).thenReturn((Object)this.instanceListContainerSeparatorStyleMock);
        Mockito.when((Object)this.simpleJavaInstanceListContainerSeparatorMock.getStyle()).thenReturn((Object)this.simpleJavaInstanceListContainerSeparatorStyleMock);
        Mockito.when((Object)this.testToolsViewMock.getDataObjectListContainerSeparator()).thenReturn((Object)this.dataObjectListContainerSeparatorMock);
        Mockito.when((Object)this.testToolsViewMock.getDataObjectListContainer()).thenReturn((Object)this.dataObjectListContainerMock);
        Mockito.when((Object)this.testToolsViewMock.getSimpleJavaTypeListContainerSeparator()).thenReturn((Object)this.simpleJavaTypeListContainerSeparatorMock);
        Mockito.when((Object)this.testToolsViewMock.getSimpleJavaTypeListContainer()).thenReturn((Object)this.simpleJavaTypeListContainerMock);
        Mockito.when((Object)this.testToolsViewMock.getInstanceListContainerSeparator()).thenReturn((Object)this.instanceListContainerSeparatorMock);
        Mockito.when((Object)this.testToolsViewMock.getInstanceListContainer()).thenReturn((Object)this.instanceListContainerMock);
        Mockito.when((Object)this.testToolsViewMock.getSimpleJavaInstanceListContainerSeparator()).thenReturn((Object)this.simpleJavaInstanceListContainerSeparatorMock);
        Mockito.when((Object)this.testToolsViewMock.getSimpleJavaInstanceListContainer()).thenReturn((Object)this.simpleJavaInstanceListContainerMock);
        Mockito.when((Object)this.listGroupItemPresenterMock.getDivElement(this.FACT_NAME, this.FACT_MODEL_TREE)).thenReturn((Object)this.dataObjectListContainerMock);
        this.testToolsPresenter = (TestToolsPresenter)Mockito.spy((Object)new TestToolsPresenter(this.testToolsViewMock, this.listGroupItemPresenterMock){
            {
                this.dataObjectFieldsMap = TestToolsPresenterTest.this.dataObjectFactTreeMap;
                this.simpleJavaTypeFieldsMap = TestToolsPresenterTest.this.simpleJavaTypeTreeMap;
                this.instanceFieldsMap = TestToolsPresenterTest.this.instanceFactTreeMap;
                this.simpleJavaInstanceFieldsMap = TestToolsPresenterTest.this.simpleJavaInstanceFactTreeMap;
                this.eventBus = TestToolsPresenterTest.this.eventBusMock;
            }
        });
    }

    @Test
    public void onSetup() {
        this.testToolsPresenter.setup();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).init((Object)this.testToolsPresenter);
    }

    @Test
    public void getTitle() {
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.testTools(), (Object)this.testToolsPresenter.getTitle());
    }

    @Test
    public void onClearSearch() {
        this.testToolsPresenter.onClearSearch();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).clearInputSearch();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).hideClearButton();
    }

    @Test
    public void onClearNameField() {
        this.testToolsPresenter.onClearNameField();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).clearNameField();
    }

    @Test
    public void onClearStatus() {
        this.testToolsPresenter.onClearStatus();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).onClearSearch();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).onClearNameField();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).clearDataObjectList();
    }

    @Test
    public void clearDataObjectList() {
        this.testToolsPresenter.clearDataObjectList();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).getDataObjectListContainer();
        ((DivElement)Mockito.verify((Object)this.dataObjectListContainerMock, (VerificationMode)Mockito.times((int)1))).removeAllChildren();
    }

    @Test
    public void clearSimpleJavaTypeList() {
        this.testToolsPresenter.clearSimpleJavaTypeList();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).getSimpleJavaTypeListContainer();
        ((DivElement)Mockito.verify((Object)this.simpleJavaTypeListContainerMock, (VerificationMode)Mockito.times((int)1))).removeAllChildren();
    }

    @Test
    public void clearInstanceList() {
        this.testToolsPresenter.clearInstanceList();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).getInstanceListContainer();
        ((DivElement)Mockito.verify((Object)this.instanceListContainerMock, (VerificationMode)Mockito.times((int)1))).removeAllChildren();
    }

    @Test
    public void clearSimpleJavaInstanceFieldList() {
        this.testToolsPresenter.clearSimpleJavaInstanceFieldList();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).getSimpleJavaInstanceListContainer();
        ((DivElement)Mockito.verify((Object)this.simpleJavaInstanceListContainerMock, (VerificationMode)Mockito.times((int)1))).removeAllChildren();
    }

    @Test
    public void updateDataObjectListSeparatorNotEmpty() {
        Mockito.when((Object)this.dataObjectListContainerMock.getChildCount()).thenReturn((Object)2);
        this.testToolsPresenter.updateDataObjectListSeparator();
        ((DivElement)Mockito.verify((Object)this.dataObjectListContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).getDataObjectListContainerSeparator();
        ((Style)Mockito.verify((Object)this.dataObjectListContainerSeparatorStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
    }

    @Test
    public void updateDataObjectListSeparatorEmpty() {
        Mockito.when((Object)this.dataObjectListContainerMock.getChildCount()).thenReturn((Object)0);
        this.testToolsPresenter.updateDataObjectListSeparator();
        ((DivElement)Mockito.verify((Object)this.dataObjectListContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).getDataObjectListContainerSeparator();
        ((Style)Mockito.verify((Object)this.dataObjectListContainerSeparatorStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
    }

    @Test
    public void updateSimpleJavaTypeListSeparatorNotEmpty() {
        Mockito.when((Object)this.simpleJavaTypeListContainerMock.getChildCount()).thenReturn((Object)2);
        this.testToolsPresenter.updateSimpleJavaTypeListSeparator();
        ((DivElement)Mockito.verify((Object)this.simpleJavaTypeListContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).getSimpleJavaTypeListContainerSeparator();
        ((Style)Mockito.verify((Object)this.simpleJavaTypeListContainerSeparatorStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
    }

    @Test
    public void updateSimpleJavaTypeListSeparatorEmpty() {
        Mockito.when((Object)this.simpleJavaTypeListContainerMock.getChildCount()).thenReturn((Object)0);
        this.testToolsPresenter.updateSimpleJavaTypeListSeparator();
        ((DivElement)Mockito.verify((Object)this.simpleJavaTypeListContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).getSimpleJavaTypeListContainerSeparator();
        ((Style)Mockito.verify((Object)this.simpleJavaTypeListContainerSeparatorStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
    }

    @Test
    public void updateInstanceListSeparatorNotEmpty() {
        Mockito.when((Object)this.instanceListContainerMock.getChildCount()).thenReturn((Object)2);
        this.testToolsPresenter.updateInstanceListSeparator();
        ((DivElement)Mockito.verify((Object)this.instanceListContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).getInstanceListContainerSeparator();
        ((Style)Mockito.verify((Object)this.instanceListContainerSeparatorStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
    }

    @Test
    public void updateInstanceListSeparatorEmpty() {
        Mockito.when((Object)this.instanceListContainerMock.getChildCount()).thenReturn((Object)0);
        this.testToolsPresenter.updateInstanceListSeparator();
        ((DivElement)Mockito.verify((Object)this.instanceListContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).getInstanceListContainerSeparator();
        ((Style)Mockito.verify((Object)this.instanceListContainerSeparatorStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
    }

    @Test
    public void updateSimpleJavaInstanceFieldListSeparatorNotEmpty() {
        Mockito.when((Object)this.simpleJavaInstanceListContainerMock.getChildCount()).thenReturn((Object)2);
        this.testToolsPresenter.updateSimpleJavaInstanceFieldListSeparator();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).getSimpleJavaInstanceListContainerSeparator();
        ((Style)Mockito.verify((Object)this.simpleJavaInstanceListContainerSeparatorStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
    }

    @Test
    public void updateSimpleJavaInstanceFieldListSeparatorEmpty() {
        Mockito.when((Object)this.simpleJavaInstanceListContainerMock.getChildCount()).thenReturn((Object)0);
        this.testToolsPresenter.updateSimpleJavaInstanceFieldListSeparator();
        ((DivElement)Mockito.verify((Object)this.simpleJavaInstanceListContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).getSimpleJavaInstanceListContainerSeparator();
        ((Style)Mockito.verify((Object)this.simpleJavaInstanceListContainerSeparatorStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
    }

    @Test
    public void getFactModelTree() {
        this.testToolsPresenter.setDataObjectFieldsMap(this.dataObjectFactTreeMap);
        String factName = this.getRandomFactModelTree(this.dataObjectFactTreeMap, 0);
        Optional retrieved = this.testToolsPresenter.getFactModelTreeFromFactTypeMap(factName);
        Assert.assertNotNull((Object)retrieved);
        TestCase.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals(this.dataObjectFactTreeMap.get(factName), retrieved.get());
    }

    @Test
    public void setFactTypeFieldsMap() {
        this.testToolsPresenter.setDataObjectFieldsMap(this.dataObjectFactTreeMap);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)this.dataObjectFactTreeMap.size()))).addDataObjectListGroupItemView(Matchers.anyString(), (FactModelTree)Matchers.anyObject());
    }

    @Test
    public void onShowClearButton() {
        this.testToolsPresenter.onShowClearButton();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).showClearButton();
    }

    @Test
    public void setEventBus() {
        this.testToolsPresenter.setEventBus(this.eventBusMock);
        Assert.assertEquals((Object)this.eventBusMock, (Object)this.testToolsPresenter.eventBus);
    }

    @Test
    public void onSearchedEvent() {
        String searched = "";
        this.testToolsPresenter.onSearchedEvent(searched);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).clearLists();
        this.testToolsPresenter.dataObjectFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(searched)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).addDataObjectListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenter.simpleJavaTypeFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(searched)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).addSimpleJavaTypeListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenter.instanceFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(searched)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).addInstanceListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenter.simpleJavaInstanceFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(searched)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).addSimpleJavaInstanceListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).updateSeparators();
    }

    @Test
    public void onPerfectMatchSearchedEventNotEquals() {
        String search = "";
        this.testToolsPresenter.onPerfectMatchSearchedEvent(search, true);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).clearLists();
        this.testToolsPresenter.dataObjectFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenter.filterTerm((String)entry.getKey(), search, true)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).addDataObjectListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenter.simpleJavaTypeFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenter.filterTerm((String)entry.getKey(), search, true)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).addSimpleJavaTypeListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenter.instanceFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenter.filterTerm((String)entry.getKey(), search, true)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).addInstanceListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenter.simpleJavaInstanceFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenter.filterTerm((String)entry.getKey(), search, true)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).addSimpleJavaInstanceListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).updateSeparators();
    }

    @Test
    public void onPerfectMatchSearchedEventEquals() {
        String search = "";
        this.testToolsPresenter.onPerfectMatchSearchedEvent(search, false);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).clearLists();
        this.testToolsPresenter.dataObjectFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenter.filterTerm((String)entry.getKey(), search, false)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).addDataObjectListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenter.simpleJavaTypeFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenter.filterTerm((String)entry.getKey(), search, false)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).addSimpleJavaTypeListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenter.instanceFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenter.filterTerm((String)entry.getKey(), search, false)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).addInstanceListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenter.simpleJavaInstanceFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenter.filterTerm((String)entry.getKey(), search, false)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).addSimpleJavaInstanceListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).updateSeparators();
    }

    @Test
    public void addListGroupItemView() {
        this.testToolsPresenter.addDataObjectListGroupItemView(this.FACT_NAME, this.FACT_MODEL_TREE);
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).getDataObjectListContainer();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).getDivElement((String)Matchers.eq((Object)this.FACT_NAME), (FactModelTree)Matchers.eq((Object)this.FACT_MODEL_TREE));
        ((DivElement)Mockito.verify((Object)this.dataObjectListContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.anyObject());
    }

    @Test
    public void onEnableEditorTabWithoutFactName() {
        this.testToolsPresenter.onEnableEditorTab();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).onSearchedEvent((String)Matchers.eq((Object)""));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).enable();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).enable(Matchers.anyString());
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).enableEditorTab();
    }

    @Test
    public void onEnableEditorTabWithFactName() {
        this.testToolsPresenter.onEnableEditorTab(this.FACT_NAME, null, false);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).onPerfectMatchSearchedEvent((String)Matchers.eq((Object)this.FACT_NAME), Matchers.eq((boolean)false));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).enable((String)Matchers.eq((Object)this.FACT_NAME));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).enable();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).enableEditorTab();
    }

    @Test
    public void onDisableEditorTab() {
        this.testToolsPresenter.onDisableEditorTab();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).disable();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).enable();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).disableEditorTab();
    }

    @Test
    public void onModifyColumn() {
        this.testToolsPresenter.editingColumnEnabled = true;
        this.testToolsPresenter.selectedFieldItemView = null;
        this.testToolsPresenter.selectedListGroupItemView = null;
        this.testToolsPresenter.onModifyColumn();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(SetInstanceHeaderEvent.class));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(SetPropertyHeaderEvent.class));
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
        this.testToolsPresenter.selectedListGroupItemView = null;
        this.testToolsPresenter.selectedFieldItemView = this.selectedFieldItemViewMock;
        this.testToolsPresenter.onModifyColumn();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SetPropertyHeaderEvent.class));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(SetInstanceHeaderEvent.class));
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
        this.testToolsPresenter.selectedListGroupItemView = this.selectedListGroupItemViewMock;
        this.testToolsPresenter.selectedFieldItemView = null;
        this.testToolsPresenter.onModifyColumn();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(SetPropertyHeaderEvent.class));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SetInstanceHeaderEvent.class));
    }

    @Test
    public void clearLists() {
        this.testToolsPresenter.clearLists();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).clearDataObjectList();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).clearSimpleJavaTypeList();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).clearInstanceList();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).clearSimpleJavaInstanceFieldList();
    }

    @Test
    public void updateSeparators() {
        this.testToolsPresenter.updateSeparators();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).updateDataObjectListSeparator();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).updateSimpleJavaTypeListSeparator();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).updateInstanceListSeparator();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenter, (VerificationMode)Mockito.times((int)1))).updateSimpleJavaInstanceFieldListSeparator();
    }

    @Test
    public void filterTerm() {
        String key = this.getRandomString();
        String search = String.join((CharSequence)";", IntStream.range(0, 4).mapToObj(i -> this.getRandomString()).collect(Collectors.toSet()));
        TestCase.assertTrue((boolean)this.testToolsPresenter.filterTerm(key, key, false));
        Assert.assertFalse((boolean)this.testToolsPresenter.filterTerm(key, key, true));
        Assert.assertFalse((boolean)this.testToolsPresenter.filterTerm(key, search, false));
        TestCase.assertTrue((boolean)this.testToolsPresenter.filterTerm(key, search, true));
        search = search + ";" + key;
        TestCase.assertTrue((boolean)this.testToolsPresenter.filterTerm(key, search, false));
        Assert.assertFalse((boolean)this.testToolsPresenter.filterTerm(key, search, true));
    }
}

