/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.IsWidget;
import elemental2.dom.DomGlobal;
import elemental2.promise.Promise;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DMNDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DMODataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.events.ImportEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.RedoEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.UndoEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationDocksHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationHasBusyIndicatorDefaultErrorCallback;
import org.drools.workbench.screens.scenariosimulation.client.popup.ConfirmPopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popup.CustomBusyPopup;
import org.drools.workbench.screens.scenariosimulation.client.producers.ScenarioSimulationProducer;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageReportView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SubDockView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.SimulationRunResult;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.drools.workbench.screens.scenariosimulation.service.ImportExportService;
import org.drools.workbench.screens.scenariosimulation.service.ImportExportType;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.enterprise.client.jaxrs.MarshallingWrapper;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.kie.workbench.common.workbench.client.test.TestRunnerReportingPanel;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.docks.UberfireDocksInteractionEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.file.exports.TextContent;
import org.uberfire.ext.editor.commons.client.file.exports.TextFileExport;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="ScenarioSimulationEditor", supportedTypes={ScenarioSimulationResourceType.class})
public class ScenarioSimulationEditorPresenter
extends KieEditor<ScenarioSimulationModel> {
    public static final String IDENTIFIER = "ScenarioSimulationEditor";
    protected String packageName = "";
    protected ObservablePath path;
    protected EventBus eventBus;
    protected ScenarioGridPanel scenarioGridPanel;
    protected DataManagementStrategy dataManagementStrategy;
    protected ScenarioSimulationContext context;
    protected ScenarioSimulationModel model;
    protected TestRunnerReportingPanel testRunnerReportingPanel;
    protected SimulationRunResult lastRunResult;
    private ImportsWidgetPresenter importsWidget;
    private AsyncPackageDataModelOracleFactory oracleFactory;
    private Caller<ScenarioSimulationService> service;
    private Caller<DMNTypeService> dmnTypeService;
    private Caller<ImportExportService> importExportService;
    private ScenarioSimulationResourceType type;
    private ScenarioSimulationView view;
    private Command populateTestToolsCommand;
    private TextFileExport textFileExport;
    private ConfirmPopupPresenter confirmPopupPresenter;
    private ScenarioSimulationDocksHandler scenarioSimulationDocksHandler;
    private static final AtomicLong SCENARIO_PRESENTER_COUNTER = new AtomicLong();
    protected long scenarioPresenterId;

    public ScenarioSimulationEditorPresenter() {
    }

    @Inject
    public ScenarioSimulationEditorPresenter(Caller<ScenarioSimulationService> service, ScenarioSimulationProducer scenarioSimulationProducer, ScenarioSimulationResourceType type, ImportsWidgetPresenter importsWidget, AsyncPackageDataModelOracleFactory oracleFactory, PlaceManager placeManager, TestRunnerReportingPanel testRunnerReportingPanel, ScenarioSimulationDocksHandler scenarioSimulationDocksHandler, Caller<DMNTypeService> dmnTypeService, Caller<ImportExportService> importExportService, TextFileExport textFileExport, ConfirmPopupPresenter confirmPopupPresenter) {
        super((KieEditorView)scenarioSimulationProducer.getScenarioSimulationView());
        this.testRunnerReportingPanel = testRunnerReportingPanel;
        this.scenarioSimulationDocksHandler = scenarioSimulationDocksHandler;
        this.dmnTypeService = dmnTypeService;
        this.importExportService = importExportService;
        this.view = (ScenarioSimulationView)this.baseView;
        this.service = service;
        this.type = type;
        this.importsWidget = importsWidget;
        this.oracleFactory = oracleFactory;
        this.placeManager = placeManager;
        this.context = scenarioSimulationProducer.getScenarioSimulationContext();
        this.eventBus = scenarioSimulationProducer.getEventBus();
        this.textFileExport = textFileExport;
        this.confirmPopupPresenter = confirmPopupPresenter;
        this.scenarioGridPanel = this.view.getScenarioGridPanel();
        this.context.setScenarioSimulationEditorPresenter(this);
        this.view.init(this);
        this.populateTestToolsCommand = this.getPopulateTestToolsCommand();
        this.scenarioGridPanel.select();
        this.scenarioPresenterId = SCENARIO_PRESENTER_COUNTER.getAndIncrement();
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.type);
        this.path = path;
        this.testRunnerReportingPanel.reset();
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
        this.scenarioGridPanel.unregister();
        super.onClose();
    }

    @OnMayClose
    public boolean mayClose() {
        return !this.isDirty();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        super.getMenus(menusConsumer);
    }

    public void showDocks() {
        super.showDocks();
        this.registerDock("testRunnerReportingPanel", (IsWidget)this.testRunnerReportingPanel.asWidget());
        this.scenarioSimulationDocksHandler.addDocks();
        this.scenarioSimulationDocksHandler.setScesimEditorId(String.valueOf(this.scenarioPresenterId));
        this.expandToolsDock();
        this.registerTestToolsCallback();
        this.resetDocks();
        this.populateRightDocks("org.drools.scenariosimulation.TestTools");
    }

    public void hideDocks() {
        super.hideDocks();
        this.scenarioSimulationDocksHandler.removeDocks();
        this.view.getScenarioGridLayer().getScenarioGrid().clearSelections();
        this.unRegisterTestToolsCallback();
        this.clearTestToolsStatus();
    }

    public void onUberfireDocksInteractionEvent(@Observes UberfireDocksInteractionEvent uberfireDocksInteractionEvent) {
        if (this.isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEvent) && !"org.drools.scenariosimulation.TestTools".equals(uberfireDocksInteractionEvent.getTargetDock().getIdentifier())) {
            this.populateRightDocks(uberfireDocksInteractionEvent.getTargetDock().getIdentifier());
        }
    }

    public void expandToolsDock() {
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("org.drools.scenariosimulation.TestTools");
        if (!PlaceStatus.OPEN.equals((Object)this.placeManager.getStatus((PlaceRequest)placeRequest))) {
            this.scenarioSimulationDocksHandler.expandToolsDock();
        }
    }

    public ScenarioSimulationView getView() {
        return this.view;
    }

    public ScenarioSimulationModel getModel() {
        return this.model;
    }

    public void reloadTestTools(boolean disable) {
        this.populateTestToolsCommand.execute();
        if (disable) {
            this.getTestToolsPresenter(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.TestTools")).ifPresent(TestToolsView.Presenter::onDisableEditorTab);
        }
    }

    public void onRunScenario() {
        List<Integer> indexes = IntStream.range(0, this.context.getStatus().getSimulation().getUnmodifiableScenarios().size()).boxed().collect(Collectors.toList());
        this.onRunScenario(indexes);
    }

    public void onRunScenario(List<Integer> indexOfScenarioToRun) {
        this.view.getScenarioGridPanel().getScenarioGrid().getModel().resetErrors();
        this.model.setSimulation(this.context.getStatus().getSimulation());
        Simulation simulation = this.model.getSimulation();
        List toRun = simulation.getScenarioWithIndex().stream().filter(elem -> indexOfScenarioToRun.contains(elem.getIndex() - 1)).collect(Collectors.toList());
        this.view.showBusyIndicator(ScenarioSimulationEditorConstants.INSTANCE.running());
        ((ScenarioSimulationService)this.service.call(this.getRefreshModelCallback(), (ErrorCallback)new ScenarioSimulationHasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).runScenario((Path)this.versionRecordManager.getCurrentPath(), simulation.getSimulationDescriptor(), toRun);
    }

    public void onUndo() {
        this.eventBus.fireEvent((GwtEvent)new UndoEvent());
    }

    public void onRedo() {
        this.eventBus.fireEvent((GwtEvent)new RedoEvent());
    }

    public void setUndoButtonEnabledStatus(boolean enabled) {
        this.view.getUndoMenuItem().setEnabled(enabled);
    }

    public void setRedoButtonEnabledStatus(boolean enabled) {
        this.view.getRedoMenuItem().setEnabled(enabled);
    }

    public void addDownloadMenuItem(FileMenuBuilder fileMenuBuilder) {
        fileMenuBuilder.addNewTopLevelMenu(this.view.getDownloadMenuItem(this.getPathSupplier()));
    }

    public DataManagementStrategy getDataManagementStrategy() {
        return this.dataManagementStrategy;
    }

    public void onImport(String fileContents) {
        ((ImportExportService)this.importExportService.call(this.getImportCallBack(), this.getImportErrorCallback())).importSimulation(ImportExportType.CSV, (Object)fileContents, this.context.getStatus().getSimulation());
    }

    protected void resetDocks() {
        this.getSettingsPresenter(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.Settings")).ifPresent(SubDockView.Presenter::reset);
        this.getCheatSheetPresenter(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.CheatSheet")).ifPresent(SubDockView.Presenter::reset);
        this.getTestToolsPresenter(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.TestTools")).ifPresent(SubDockView.Presenter::reset);
        this.getCoverageReportPresenter(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.CoverageReport")).ifPresent(SubDockView.Presenter::reset);
        this.testRunnerReportingPanel.reset();
    }

    protected boolean isUberfireDocksInteractionEventToManage(UberfireDocksInteractionEvent uberfireDocksInteractionEvent) {
        return uberfireDocksInteractionEvent.getTargetDock() != null && uberfireDocksInteractionEvent.getTargetDock().getPlaceRequest().getParameter("scesimeditorid", "").equals(String.valueOf(this.scenarioPresenterId));
    }

    protected RemoteCallback<SimulationRunResult> getRefreshModelCallback() {
        return this::refreshModelContent;
    }

    protected void refreshModelContent(SimulationRunResult newData) {
        this.view.hideBusyIndicator();
        if (this.model == null) {
            return;
        }
        Simulation simulation = this.model.getSimulation();
        for (ScenarioWithIndex scenarioWithIndex : newData.getScenarioWithIndex()) {
            int index = scenarioWithIndex.getIndex() - 1;
            simulation.replaceScenario(index, scenarioWithIndex.getScenario());
        }
        this.view.refreshContent(simulation);
        this.context.getStatus().setSimulation(simulation);
        this.scenarioSimulationDocksHandler.expandTestResultsDock();
        this.testRunnerReportingPanel.onTestRun(newData.getTestResultMessage());
        this.dataManagementStrategy.setModel(this.model);
        this.lastRunResult = newData;
    }

    protected void registerTestToolsCallback() {
        this.placeManager.registerOnOpenCallback((PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.TestTools"), this.populateTestToolsCommand);
    }

    protected void unRegisterTestToolsCallback() {
        this.placeManager.getOnOpenCallbacks((PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.TestTools")).remove(this.populateTestToolsCommand);
    }

    protected ErrorCallback<Object> getImportErrorCallback() {
        return (error, exception) -> {
            this.confirmPopupPresenter.show(ScenarioSimulationEditorConstants.INSTANCE.importErrorTitle(), ScenarioSimulationEditorConstants.INSTANCE.importFailedMessage());
            return false;
        };
    }

    protected Promise<Void> makeMenuBar() {
        this.fileMenuBuilder.addNewTopLevelMenu(this.view.getRunScenarioMenuItem());
        this.fileMenuBuilder.addNewTopLevelMenu(this.view.getUndoMenuItem());
        this.fileMenuBuilder.addNewTopLevelMenu(this.view.getRedoMenuItem());
        this.fileMenuBuilder.addNewTopLevelMenu(this.view.getExportToCsvMenuItem());
        this.fileMenuBuilder.addNewTopLevelMenu(this.view.getImportMenuItem());
        this.view.getUndoMenuItem().setEnabled(false);
        this.view.getRedoMenuItem().setEnabled(false);
        return super.makeMenuBar();
    }

    protected Supplier<ScenarioSimulationModel> getContentSupplier() {
        return () -> this.model;
    }

    protected void save(String commitMessage) {
        ((ScenarioSimulationService)this.service.call(this.getSaveSuccessCallback(this.getJsonModel(this.model).hashCode()), (ErrorCallback)new ScenarioSimulationHasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.baseView))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model, (Object)this.metadata, commitMessage);
    }

    protected void addCommonActions(FileMenuBuilder fileMenuBuilder) {
        fileMenuBuilder.addNewTopLevelMenu(this.versionRecordManager.buildMenu()).addNewTopLevelMenu(this.alertsButtonMenuItemBuilder.build());
    }

    protected void loadContent() {
        CustomBusyPopup.showMessage(CommonConstants.INSTANCE.Loading());
        ((ScenarioSimulationService)this.service.call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    protected void onDownload(Supplier<Path> pathSupplier) {
        String downloadURL = this.getFileDownloadURL(pathSupplier);
        this.open(downloadURL);
    }

    protected void open(String downloadURL) {
        DomGlobal.window.open((Object)downloadURL);
    }

    protected void showImportDialog() {
        this.eventBus.fireEvent((GwtEvent)new ImportEvent());
    }

    protected void onExportToCsv() {
        ((ImportExportService)this.importExportService.call(this.getExportCallBack(), (ErrorCallback)new ScenarioSimulationHasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).exportSimulation(ImportExportType.CSV, this.context.getStatus().getSimulation());
    }

    protected RemoteCallback<Object> getExportCallBack() {
        return rawResult -> {
            TextContent textContent = TextContent.create((String)((String)rawResult));
            this.textFileExport.export((Object)textContent, this.path.getFileName() + ImportExportType.CSV.getExtension());
        };
    }

    protected RemoteCallback<Simulation> getImportCallBack() {
        return simulation -> {
            this.cleanReadOnlyColumn((Simulation)simulation);
            this.model.setSimulation(simulation);
            this.view.setContent(this.model.getSimulation());
            this.context.getStatus().setSimulation(this.model.getSimulation());
            this.view.onResize();
        };
    }

    protected void cleanReadOnlyColumn(Simulation simulation) {
        SimulationDescriptor simulationDescriptor = simulation.getSimulationDescriptor();
        for (int i = 0; i < simulation.getUnmodifiableScenarios().size(); ++i) {
            Scenario scenario = simulation.getScenarioByIndex(i);
            for (FactMapping factMapping : simulationDescriptor.getUnmodifiableFactMappings()) {
                if (!this.isColumnReadOnly(factMapping)) continue;
                scenario.getFactMappingValue(factMapping.getFactIdentifier(), factMapping.getExpressionIdentifier()).ifPresent(fmv -> fmv.setRawValue(null));
            }
        }
    }

    private boolean isColumnReadOnly(FactMapping factMapping) {
        return !FactMappingType.OTHER.equals((Object)factMapping.getExpressionIdentifier().getType()) && factMapping.getExpressionElements().isEmpty();
    }

    protected void populateRightDocks(String identifier) {
        if (this.dataManagementStrategy != null) {
            PlaceRequest currentRightDockPlaceRequest = this.getCurrentRightDockPlaceRequest(identifier);
            switch (identifier) {
                case "org.drools.scenariosimulation.Settings": {
                    this.getSettingsPresenter(currentRightDockPlaceRequest).ifPresent(presenter -> {
                        this.setSettings((SettingsView.Presenter)presenter);
                        presenter.setCurrentPath(this.path);
                    });
                    break;
                }
                case "org.drools.scenariosimulation.TestTools": {
                    this.getTestToolsPresenter(currentRightDockPlaceRequest).ifPresent(this::setTestTools);
                    break;
                }
                case "org.drools.scenariosimulation.CheatSheet": {
                    this.getCheatSheetPresenter(currentRightDockPlaceRequest).ifPresent(presenter -> {
                        if (!presenter.isCurrentlyShow(this.path)) {
                            this.setCheatSheet((CheatSheetView.Presenter)presenter);
                            presenter.setCurrentPath(this.path);
                        }
                    });
                    break;
                }
                case "org.drools.scenariosimulation.CoverageReport": {
                    this.getCoverageReportPresenter(currentRightDockPlaceRequest).ifPresent(presenter -> {
                        this.setCoverageReport((CoverageReportView.Presenter)presenter);
                        presenter.setCurrentPath(this.path);
                    });
                }
            }
        }
    }

    protected void setTestTools(TestToolsView.Presenter presenter) {
        this.context.setTestToolsPresenter(presenter);
        presenter.setEventBus(this.eventBus);
        this.dataManagementStrategy.populateTestTools(presenter, this.scenarioGridPanel.getScenarioGrid().getModel());
    }

    protected void clearTestToolsStatus() {
        this.getTestToolsPresenter(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.TestTools")).ifPresent(TestToolsView.Presenter::onClearStatus);
    }

    protected void setCheatSheet(CheatSheetView.Presenter presenter) {
        ScenarioSimulationModel.Type type = this.dataManagementStrategy instanceof DMODataManagementStrategy ? ScenarioSimulationModel.Type.RULE : ScenarioSimulationModel.Type.DMN;
        presenter.initCheatSheet(type);
    }

    protected void setSettings(SettingsView.Presenter presenter) {
        ScenarioSimulationModel.Type type = this.dataManagementStrategy instanceof DMODataManagementStrategy ? ScenarioSimulationModel.Type.RULE : ScenarioSimulationModel.Type.DMN;
        presenter.setScenarioType(type, this.model.getSimulation().getSimulationDescriptor(), this.path.getFileName());
        presenter.setSaveCommand(this.getSaveCommand());
    }

    protected void setCoverageReport(CoverageReportView.Presenter presenter) {
        ScenarioSimulationModel.Type type = this.dataManagementStrategy instanceof DMODataManagementStrategy ? ScenarioSimulationModel.Type.RULE : ScenarioSimulationModel.Type.DMN;
        SimulationRunMetadata simulationRunMetadata = this.lastRunResult != null ? this.lastRunResult.getSimulationRunMetadata() : null;
        presenter.populateCoverageReport(type, simulationRunMetadata);
    }

    protected String getJsonModel(ScenarioSimulationModel model) {
        return MarshallingWrapper.toJSON((Object)model);
    }

    protected boolean isDirty() {
        try {
            this.view.getScenarioGridPanel().getScenarioGrid().getModel().resetErrors();
            int currentHashcode = MarshallingWrapper.toJSON((Object)this.model).hashCode();
            return this.originalHash != currentHashcode;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return this.service;
    }

    protected Caller<? extends SupportsRename> getRenameServiceCaller() {
        return this.service;
    }

    protected Caller<? extends SupportsCopy> getCopyServiceCaller() {
        return this.service;
    }

    protected Caller<? extends SupportsSaveAndRename<ScenarioSimulationModel, Metadata>> getSaveAndRenameServiceCaller() {
        return this.service;
    }

    protected String getEditorIdentifier() {
        return IDENTIFIER;
    }

    protected void getModelSuccessCallbackMethod(ScenarioSimulationModelContent content) {
        if (this.versionRecordManager.getCurrentPath() == null) {
            return;
        }
        this.packageName = content.getDataModel().getPackageName();
        this.resetEditorPages(content.getOverview());
        this.dataManagementStrategy = ScenarioSimulationModel.Type.RULE.equals((Object)content.getModel().getSimulation().getSimulationDescriptor().getType()) ? new DMODataManagementStrategy(this.oracleFactory, this.context) : new DMNDataManagementStrategy(this.dmnTypeService, this.context, this.eventBus);
        this.dataManagementStrategy.manageScenarioSimulationModelContent(this.versionRecordManager.getCurrentPath(), content);
        this.populateRightDocks("org.drools.scenariosimulation.TestTools");
        this.populateRightDocks("org.drools.scenariosimulation.Settings");
        this.model = content.getModel();
        if (this.dataManagementStrategy instanceof DMODataManagementStrategy) {
            this.importsWidget.setContent(((DMODataManagementStrategy)this.dataManagementStrategy).getOracle(), this.model.getImports(), this.isReadOnly);
            this.addImportsTab((IsWidget)this.importsWidget);
        }
        this.baseView.hideBusyIndicator();
        this.view.setContent(this.model.getSimulation());
        this.context.getStatus().setSimulation(this.model.getSimulation());
        this.setOriginalHash(this.getJsonModel(this.model).hashCode());
        CustomBusyPopup.close();
    }

    protected Optional<CheatSheetView.Presenter> getCheatSheetPresenter(PlaceRequest placeRequest) {
        Optional<CheatSheetView> cheatSheetView = this.getCheatSheetView(placeRequest);
        return cheatSheetView.map(SubDockView::getPresenter);
    }

    protected Optional<TestToolsView.Presenter> getTestToolsPresenter(PlaceRequest placeRequest) {
        Optional<TestToolsView> testToolsView = this.getTestToolsView(placeRequest);
        return testToolsView.map(TestToolsView::getPresenter);
    }

    protected Optional<SettingsView.Presenter> getSettingsPresenter(PlaceRequest placeRequest) {
        Optional<SettingsView> settingsView = this.getSettingsView(placeRequest);
        return settingsView.map(SubDockView::getPresenter);
    }

    protected Optional<CoverageReportView.Presenter> getCoverageReportPresenter(PlaceRequest placeRequest) {
        Optional<CoverageReportView> coverageReportViewMap = this.getCoverageReportView(placeRequest);
        return coverageReportViewMap.map(SubDockView::getPresenter);
    }

    protected Command getSaveCommand() {
        return () -> this.save("Save");
    }

    protected PlaceRequest getCurrentRightDockPlaceRequest(String identifier) {
        DefaultPlaceRequest toReturn = new DefaultPlaceRequest(identifier);
        toReturn.addParameter("scesimeditorid", String.valueOf(this.scenarioPresenterId));
        return toReturn;
    }

    protected String getFileDownloadURL(Supplier<Path> pathSupplier) {
        return GWT.getModuleBaseURL() + "defaulteditor/download?path=" + pathSupplier.get().toURI();
    }

    private RemoteCallback<ScenarioSimulationModelContent> getModelSuccessCallback() {
        return this::getModelSuccessCallbackMethod;
    }

    private Optional<TestToolsView> getTestToolsView(PlaceRequest placeRequest) {
        Activity activity = this.placeManager.getActivity(placeRequest);
        if (activity != null) {
            AbstractWorkbenchActivity testToolsActivity = (AbstractWorkbenchActivity)activity;
            return Optional.of((TestToolsView)testToolsActivity.getWidget());
        }
        return Optional.empty();
    }

    private Optional<CheatSheetView> getCheatSheetView(PlaceRequest placeRequest) {
        Activity activity = this.placeManager.getActivity(placeRequest);
        if (activity != null) {
            AbstractWorkbenchActivity cheatSheetActivity = (AbstractWorkbenchActivity)activity;
            return Optional.of((CheatSheetView)cheatSheetActivity.getWidget());
        }
        return Optional.empty();
    }

    private Optional<SettingsView> getSettingsView(PlaceRequest placeRequest) {
        Activity activity = this.placeManager.getActivity(placeRequest);
        if (activity != null) {
            AbstractWorkbenchActivity settingsActivity = (AbstractWorkbenchActivity)activity;
            return Optional.of((SettingsView)settingsActivity.getWidget());
        }
        return Optional.empty();
    }

    private Optional<CoverageReportView> getCoverageReportView(PlaceRequest placeRequest) {
        Activity activity = this.placeManager.getActivity(placeRequest);
        if (activity != null) {
            AbstractWorkbenchActivity settingsActivity = (AbstractWorkbenchActivity)activity;
            return Optional.of((CoverageReportView)settingsActivity.getWidget());
        }
        return Optional.empty();
    }

    private Command getPopulateTestToolsCommand() {
        return () -> this.populateRightDocks("org.drools.scenariosimulation.TestTools");
    }
}

