/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioCommandRegistry;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AppendRowCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.command.client.Command;
import org.kie.workbench.common.command.client.CommandResult;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioCommandRegistryTest
extends AbstractScenarioSimulationTest {
    private ScenarioCommandRegistry scenarioCommandRegistry;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.scenarioCommandRegistry = (ScenarioCommandRegistry)Mockito.spy((Object)new ScenarioCommandRegistry(){});
    }

    @Test
    public void undoEmpty() {
        this.scenarioCommandRegistry.undoneCommands.clear();
        CommandResult retrieved = this.scenarioCommandRegistry.undo(this.scenarioSimulationContextLocal);
        Assert.assertEquals((Object)CommandResult.Type.WARNING, (Object)retrieved.getType());
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistry, (VerificationMode)Mockito.never())).commonOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioSimulationCommand)Matchers.eq((Object)this.appendRowCommandMock), Matchers.eq((boolean)true));
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistry, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void undoNotEmpty() {
        int currentSize = this.scenarioCommandRegistry.undoneCommands.size();
        this.scenarioCommandRegistry.register(this.scenarioSimulationContextLocal, (AbstractScenarioSimulationCommand)this.appendRowCommandMock);
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistry, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        this.scenarioCommandRegistry.undo(this.scenarioSimulationContextLocal);
        Assert.assertEquals((long)(currentSize + 1), (long)this.scenarioCommandRegistry.undoneCommands.size());
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistry, (VerificationMode)Mockito.times((int)1))).commonOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioSimulationCommand)Matchers.eq((Object)this.appendRowCommandMock), Matchers.eq((boolean)true));
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistry, (VerificationMode)Mockito.times((int)2))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void redoEmpty() {
        this.scenarioCommandRegistry.undoneCommands.clear();
        this.scenarioCommandRegistry.redo(this.scenarioSimulationContextLocal);
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistry, (VerificationMode)Mockito.never())).commonOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioSimulationCommand)Matchers.eq((Object)this.appendRowCommandMock), Matchers.eq((boolean)true));
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistry, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void redoNotEmpty() {
        this.scenarioCommandRegistry.undoneCommands.push(this.appendRowCommandMock);
        int currentSize = this.scenarioCommandRegistry.undoneCommands.size();
        this.scenarioCommandRegistry.redo(this.scenarioSimulationContextLocal);
        Assert.assertEquals((long)(currentSize - 1), (long)this.scenarioCommandRegistry.undoneCommands.size());
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistry, (VerificationMode)Mockito.times((int)1))).commonOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioSimulationCommand)Matchers.eq((Object)this.appendRowCommandMock), Matchers.eq((boolean)false));
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistry, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void setUndoRedoButtonStatus() {
        this.scenarioCommandRegistry.clear();
        this.scenarioCommandRegistry.undoneCommands.clear();
        this.scenarioCommandRegistry.setUndoRedoButtonStatus(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setUndoButtonEnabledStatus(Matchers.eq((boolean)false));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setRedoButtonEnabledStatus(Matchers.eq((boolean)false));
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.scenarioSimulationEditorPresenterMock});
        this.scenarioCommandRegistry.register((Command)this.appendRowCommandMock);
        this.scenarioCommandRegistry.setUndoRedoButtonStatus(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setUndoButtonEnabledStatus(Matchers.eq((boolean)true));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setRedoButtonEnabledStatus(Matchers.eq((boolean)false));
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.scenarioSimulationEditorPresenterMock});
        this.scenarioCommandRegistry.undoneCommands.push(this.appendRowCommandMock);
        this.scenarioCommandRegistry.setUndoRedoButtonStatus(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setUndoButtonEnabledStatus(Matchers.eq((boolean)true));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setRedoButtonEnabledStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void commonOperationUndo() {
        this.scenarioCommandRegistry.commonOperation(this.scenarioSimulationContextLocal, (AbstractScenarioSimulationCommand)this.appendRowCommandMock, true);
        ((AppendRowCommand)Mockito.verify((Object)this.appendRowCommandMock, (VerificationMode)Mockito.times((int)1))).undo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        ((AppendRowCommand)Mockito.verify((Object)this.appendRowCommandMock, (VerificationMode)Mockito.never())).redo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void commonOperationRedo() {
        this.scenarioCommandRegistry.commonOperation(this.scenarioSimulationContextLocal, (AbstractScenarioSimulationCommand)this.appendRowCommandMock, false);
        ((AppendRowCommand)Mockito.verify((Object)this.appendRowCommandMock, (VerificationMode)Mockito.times((int)1))).redo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        ((AppendRowCommand)Mockito.verify((Object)this.appendRowCommandMock, (VerificationMode)Mockito.never())).undo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }
}

