/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractSelectedColumnCommandTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.InsertColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class InsertColumnCommandTest
extends AbstractSelectedColumnCommandTest {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.command = (AbstractScenarioSimulationCommand)Mockito.spy((Object)new InsertColumnCommand(){

            protected ScenarioGridColumn getScenarioGridColumnLocal(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader, ScenarioCellTextAreaSingletonDOMElementFactory factoryCell, String placeHolder) {
                return InsertColumnCommandTest.this.gridColumnMock;
            }
        });
        Assert.assertTrue((boolean)this.command.isUndoable());
        this.scenarioSimulationContextLocal.getStatus().setColumnId("COLUMN ID");
        this.scenarioSimulationContextLocal.getStatus().setColumnIndex(3);
    }

    @Test
    public void executeIfSelectedColumn_NotIsRightIsAsProperty() {
        Mockito.when((Object)this.gridColumnMock.isInstanceAssigned()).thenReturn((Object)Boolean.TRUE);
        this.commonTest(false, true, 3);
    }

    @Test
    public void executeIfSelectedColumn_IsRightIsAsProperty() {
        Mockito.when((Object)this.gridColumnMock.isInstanceAssigned()).thenReturn((Object)Boolean.TRUE);
        this.commonTest(true, true, 4);
    }

    @Test
    public void executeIfSelectedColumn_NotIsRightNotIsAsProperty() {
        this.commonTest(false, false, 2);
    }

    @Test
    public void executeIfSelectedColumn_NotIsAsProperty() {
        this.commonTest(true, false, 4);
    }

    protected void commonTest(boolean right, boolean asProperty, int expectedIndex) {
        this.scenarioSimulationContextLocal.getStatus().setRight(right);
        this.scenarioSimulationContextLocal.getStatus().setAsProperty(asProperty);
        ((InsertColumnCommand)this.command).executeIfSelectedColumn(this.scenarioSimulationContextLocal, this.gridColumnMock);
        boolean cloneInstance = this.scenarioSimulationContextLocal.getStatus().isAsProperty() && this.gridColumnMock.isInstanceAssigned();
        ((InsertColumnCommand)Mockito.verify((Object)((InsertColumnCommand)this.command), (VerificationMode)Mockito.times((int)1))).insertNewColumn((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), Matchers.eq((int)expectedIndex), Matchers.eq((boolean)cloneInstance));
    }
}

