/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.AbstractScenarioSimulationEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioMenuItem;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorWrapper;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.events.ImportEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.RedoEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.UndoEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationDocksHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationHasBusyIndicatorDefaultErrorCallback;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.popup.ConfirmPopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.producers.ScenarioSimulationProducer;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageReportPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageReportView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestRunnerReportingPanelWrapper;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.SimulationRunResult;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDocksInteractionEvent;
import org.uberfire.ext.editor.commons.client.file.exports.TextFileExport;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationEditorPresenterTest
extends AbstractScenarioSimulationEditorTest {
    private ScenarioSimulationEditorPresenter presenter;
    @Mock
    private ScenarioSimulationEditorWrapper scenarioSimulationEditorWrapper;
    @Mock
    private ScenarioGrid scenarioGridMock;
    @Mock
    private ScenarioGridLayer scenarioGridLayerMock;
    @Mock
    private ScenarioSimulationView scenarioSimulationViewMock;
    @Mock
    private ScenarioGridModel scenarioGridModelMock;
    @Mock
    private ScenarioSimulationProducer scenarioSimulationProducerMock;
    @Mock
    private PlaceManager placeManagerMock;
    @Mock
    private AbstractWorkbenchActivity testToolsActivityMock;
    @Mock
    private TestToolsView testToolsViewMock;
    @Mock
    private ObservablePath pathMock;
    @Mock
    private PathPlaceRequest placeRequestMock;
    @Mock
    private ScenarioSimulationContext contextMock;
    @Mock
    private ScenarioSimulationContext.Status statusMock;
    @Mock
    private TestRunnerReportingPanelWrapper testRunnerReportingPanelMock;
    @Mock
    private IsWidget testRunnerReportingPanelWidgetMock;
    @Mock
    private ScenarioSimulationDocksHandler scenarioSimulationDocksHandlerMock;
    @Mock
    private ScenarioMenuItem runScenarioMenuItemMock;
    @Mock
    private ScenarioMenuItem undoMenuItemMock;
    @Mock
    private ScenarioMenuItem redoMenuItemMock;
    @Mock
    private ScenarioMenuItem exportToCsvMenuItemMock;
    @Mock
    private DataManagementStrategy dataManagementStrategyMock;
    @Mock
    private TextFileExport textFileExportMock;
    @Captor
    private ArgumentCaptor<List<ScenarioWithIndex>> scenarioWithIndexCaptor;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.scenarioGridLayerMock.getScenarioGrid()).thenReturn((Object)this.scenarioGridMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getScenarioGridPanel()).thenReturn((Object)this.scenarioGridPanelMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getScenarioGridLayer()).thenReturn((Object)this.scenarioGridLayerMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getRunScenarioMenuItem()).thenReturn((Object)this.runScenarioMenuItemMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getUndoMenuItem()).thenReturn((Object)this.undoMenuItemMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getRedoMenuItem()).thenReturn((Object)this.redoMenuItemMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getExportToCsvMenuItem()).thenReturn((Object)this.exportToCsvMenuItemMock);
        Mockito.when((Object)this.scenarioGridPanelMock.getScenarioGrid()).thenReturn((Object)this.scenarioGridMock);
        Mockito.when((Object)this.scenarioGridMock.getModel()).thenReturn((Object)this.scenarioGridModelMock);
        Mockito.when((Object)this.scenarioSimulationProducerMock.getScenarioSimulationView()).thenReturn((Object)this.scenarioSimulationViewMock);
        Mockito.when((Object)this.scenarioSimulationProducerMock.getScenarioSimulationContext()).thenReturn((Object)this.contextMock);
        Mockito.when((Object)this.placeRequestMock.getIdentifier()).thenReturn((Object)"ScenarioSimulationEditor");
        Mockito.when((Object)this.testToolsViewMock.getPresenter()).thenReturn((Object)this.testToolsPresenterMock);
        Mockito.when((Object)this.testToolsActivityMock.getWidget()).thenReturn((Object)this.testToolsViewMock);
        Mockito.when((Object)this.placeRequestMock.getPath()).thenReturn((Object)this.pathMock);
        Mockito.when((Object)this.contextMock.getStatus()).thenReturn((Object)this.statusMock);
        Mockito.when((Object)this.statusMock.getSimulation()).thenReturn((Object)this.simulationMock);
        Mockito.when((Object)this.simulationMock.getUnmodifiableScenarios()).thenReturn(Arrays.asList(new Scenario()));
        Mockito.when((Object)this.testRunnerReportingPanelMock.asWidget()).thenReturn((Object)this.testRunnerReportingPanelWidgetMock);
        this.presenter = (ScenarioSimulationEditorPresenter)Mockito.spy((Object)new ScenarioSimulationEditorPresenter(this.scenarioSimulationProducerMock, (ScenarioSimulationResourceType)Mockito.mock(ScenarioSimulationResourceType.class), this.placeManagerMock, this.testRunnerReportingPanelMock, this.scenarioSimulationDocksHandlerMock, this.textFileExportMock, (ConfirmPopupPresenter)Mockito.mock(ConfirmPopupPresenter.class)){
            {
                this.path = ScenarioSimulationEditorPresenterTest.this.pathMock;
                this.scenarioGridPanel = ScenarioSimulationEditorPresenterTest.this.scenarioGridPanelMock;
                this.packageName = "scenario.package";
                this.eventBus = ScenarioSimulationEditorPresenterTest.this.eventBusMock;
                this.context = ScenarioSimulationEditorPresenterTest.this.contextMock;
                this.dataManagementStrategy = ScenarioSimulationEditorPresenterTest.this.dataManagementStrategyMock;
                this.model = ScenarioSimulationEditorPresenterTest.this.scenarioSimulationModelMock;
                this.testRunnerReportingPanel = ScenarioSimulationEditorPresenterTest.this.testRunnerReportingPanelMock;
            }

            protected void clearTestToolsStatus() {
            }

            protected void open(String downloadURL) {
            }

            public String getJsonModel(ScenarioSimulationModel model) {
                return "";
            }
        });
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.of(this.cheatSheetPresenterMock)).when((Object)this.presenter)).getCheatSheetPresenter((PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.of(this.testToolsPresenterMock)).when((Object)this.presenter)).getTestToolsPresenter((PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.of(this.settingsPresenterMock)).when((Object)this.presenter)).getSettingsPresenter((PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.of(this.coverageReportPresenterMock)).when((Object)this.presenter)).getCoverageReportPresenter((PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
        Mockito.when((Object)this.presenter.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)this.placeRequestMock);
    }

    @Test
    public void init() {
        this.presenter.init(this.scenarioSimulationEditorWrapper, this.observablePathMock);
        ((TestRunnerReportingPanelWrapper)Mockito.verify((Object)this.testRunnerReportingPanelMock, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void onClose() {
        this.presenter.onClose();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).unregister();
    }

    @Test
    public void showDocks_PlaceStatusOpen() {
        this.presenter.init(this.scenarioSimulationEditorWrapper, this.observablePathMock);
        this.presenter.showDocks(PlaceStatus.OPEN);
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapper, (VerificationMode)Mockito.times((int)1))).wrappedRegisterDock((String)Matchers.eq((Object)"testRunnerReportingPanel"), (IsWidget)Matchers.eq((Object)this.testRunnerReportingPanelWidgetMock));
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).addDocks();
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).setScesimEditorId((String)Matchers.eq((Object)String.valueOf(this.presenter.scenarioPresenterId)));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).expandToolsDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).registerTestToolsCallback();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).resetDocks();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).populateRightDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.TestTools"));
    }

    @Test
    public void showDocks_PlaceStatusClose() {
        this.presenter.init(this.scenarioSimulationEditorWrapper, this.observablePathMock);
        this.presenter.showDocks(PlaceStatus.CLOSE);
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapper, (VerificationMode)Mockito.times((int)1))).wrappedRegisterDock((String)Matchers.eq((Object)"testRunnerReportingPanel"), (IsWidget)Matchers.eq((Object)this.testRunnerReportingPanelWidgetMock));
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).addDocks();
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).setScesimEditorId((String)Matchers.eq((Object)String.valueOf(this.presenter.scenarioPresenterId)));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).expandToolsDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).registerTestToolsCallback();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).resetDocks();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).populateRightDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.TestTools"));
    }

    @Test
    public void hideDocks() {
        this.presenter.hideDocks();
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock)).removeDocks();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).clearSelections();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter)).unRegisterTestToolsCallback();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter)).clearTestToolsStatus();
    }

    @Test
    public void expandToolsDock() {
        this.presenter.expandToolsDock();
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).expandToolsDock();
    }

    @Test
    public void reloadTestTools_NotDisable() {
        this.presenter.reloadTestTools(false);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).getTestToolsPresenter((PlaceRequest)Matchers.any());
    }

    @Test
    public void reloadTestTools_Disable() {
        this.presenter.reloadTestTools(true);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).getTestToolsPresenter((PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
    }

    @Test
    public void onRunTest() {
        this.presenter.init(this.scenarioSimulationEditorWrapper, this.observablePathMock);
        this.presenter.onRunScenario();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onRunScenario((List)Matchers.eq(Arrays.asList(0)));
    }

    @Test
    public void onRunScenario() {
        this.scenarioWithIndexLocal.add(new ScenarioWithIndex(1, new Scenario()));
        this.scenarioWithIndexLocal.add(new ScenarioWithIndex(2, new Scenario()));
        this.scenarioWithIndexLocal.add(new ScenarioWithIndex(3, new Scenario()));
        Mockito.when((Object)this.simulationMock.getScenarioByIndex(Matchers.anyInt())).thenReturn(Mockito.mock(Scenario.class));
        List<Integer> indexList = Arrays.asList(0, 2);
        this.presenter.init(this.scenarioSimulationEditorWrapper, this.observablePathMock);
        this.presenter.onRunScenario(indexList);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).resetErrors();
        ((ScenarioSimulationModel)Mockito.verify((Object)this.scenarioSimulationModelMock, (VerificationMode)Mockito.times((int)1))).setSimulation(this.simulationMock);
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(Matchers.anyString());
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapper, (VerificationMode)Mockito.times((int)1))).onRunScenario((RemoteCallback)Matchers.any(), (ScenarioSimulationHasBusyIndicatorDefaultErrorCallback)Matchers.any(), (SimulationDescriptor)Matchers.any(), (List)this.scenarioWithIndexCaptor.capture());
        List capturedValue = (List)this.scenarioWithIndexCaptor.getValue();
        Assert.assertEquals((long)2L, (long)capturedValue.size());
        for (Integer requestedIndex : indexList) {
            Assert.assertEquals((long)1L, (long)capturedValue.stream().filter(elem -> elem.getIndex() == requestedIndex + 1).count());
        }
    }

    @Test
    public void onUndo() {
        this.presenter.onUndo();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(UndoEvent.class));
    }

    @Test
    public void onRedo() {
        this.presenter.onRedo();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(RedoEvent.class));
    }

    @Test
    public void setUndoButtonEnabledStatus() {
        this.presenter.setUndoButtonEnabledStatus(true);
        ((ScenarioMenuItem)Mockito.verify((Object)this.undoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)true));
        Mockito.reset((Object[])new ScenarioMenuItem[]{this.undoMenuItemMock});
        this.presenter.setUndoButtonEnabledStatus(false);
        ((ScenarioMenuItem)Mockito.verify((Object)this.undoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void setRedoButtonEnabledStatus() {
        this.presenter.setRedoButtonEnabledStatus(true);
        ((ScenarioMenuItem)Mockito.verify((Object)this.redoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)true));
        Mockito.reset((Object[])new ScenarioMenuItem[]{this.redoMenuItemMock});
        this.presenter.setRedoButtonEnabledStatus(false);
        ((ScenarioMenuItem)Mockito.verify((Object)this.redoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void runScenarioButtonIsAdded() {
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        Supplier pathSupplierMock = (Supplier)Mockito.mock(Supplier.class);
        ((ScenarioSimulationView)Mockito.doReturn((Object)menuItem).when((Object)this.scenarioSimulationViewMock)).getDownloadMenuItem((Supplier)Matchers.same((Object)pathSupplierMock));
        this.presenter.init(this.scenarioSimulationEditorWrapper, this.observablePathMock);
        this.presenter.addDownloadMenuItem(this.fileMenuBuilderMock, pathSupplierMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock)).addNewTopLevelMenu(menuItem);
    }

    @Test
    public void onImport() {
        String FILE_CONTENT = "FILE_CONTENT";
        this.presenter.init(this.scenarioSimulationEditorWrapper, this.observablePathMock);
        this.presenter.onImport(FILE_CONTENT);
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapper, (VerificationMode)Mockito.times((int)1))).onImport((String)Matchers.eq((Object)FILE_CONTENT), (RemoteCallback)Matchers.isA(RemoteCallback.class), (ErrorCallback)Matchers.isA(ErrorCallback.class), (Simulation)Matchers.same((Object)this.simulationMock));
    }

    @Test
    public void resetDocks() {
        this.presenter.resetDocks();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).getCheatSheetPresenter((PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
        ((CheatSheetPresenter)Mockito.verify((Object)this.cheatSheetPresenterMock, (VerificationMode)Mockito.times((int)1))).reset();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).getTestToolsPresenter((PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).reset();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).getSettingsPresenter((PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterMock, (VerificationMode)Mockito.times((int)1))).reset();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).getCoverageReportPresenter((PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
        ((CoverageReportPresenter)Mockito.verify((Object)this.coverageReportPresenterMock, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void onUberfireDocksInteractionEventCheatSheet() {
        UberfireDocksInteractionEvent uberfireDocksInteractionEventMock = (UberfireDocksInteractionEvent)Mockito.mock(UberfireDocksInteractionEvent.class);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        this.presenter.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.never())).getTargetDock();
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenter});
        this.presenter.dataManagementStrategy = null;
        this.presenter.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).getCheatSheetPresenter((PlaceRequest)Matchers.any());
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenter});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        this.presenter.dataManagementStrategy = this.dataManagementStrategyMock;
        UberfireDock targetDockMock = (UberfireDock)Mockito.mock(UberfireDock.class);
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"UNKNOWN");
        this.presenter.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).getCheatSheetPresenter((PlaceRequest)Matchers.any());
        PlaceRequest cheatSheetPlaceRequestMock = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenter});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        Mockito.when((Object)this.presenter.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)cheatSheetPlaceRequestMock);
        this.presenter.dataManagementStrategy = this.dataManagementStrategyMock;
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.empty()).when((Object)this.presenter)).getCheatSheetPresenter((PlaceRequest)Matchers.eq((Object)cheatSheetPlaceRequestMock));
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"org.drools.scenariosimulation.CheatSheet");
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        this.presenter.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).getCheatSheetPresenter((PlaceRequest)Matchers.eq((Object)cheatSheetPlaceRequestMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setCheatSheet((CheatSheetView.Presenter)Matchers.eq((Object)this.cheatSheetPresenterMock));
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenter});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        Mockito.when((Object)this.presenter.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)cheatSheetPlaceRequestMock);
        this.presenter.dataManagementStrategy = this.dataManagementStrategyMock;
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.of(this.cheatSheetPresenterMock)).when((Object)this.presenter)).getCheatSheetPresenter((PlaceRequest)Matchers.eq((Object)cheatSheetPlaceRequestMock));
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"org.drools.scenariosimulation.CheatSheet");
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        this.presenter.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).getCheatSheetPresenter((PlaceRequest)Matchers.eq((Object)cheatSheetPlaceRequestMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).setCheatSheet((CheatSheetView.Presenter)Matchers.eq((Object)this.cheatSheetPresenterMock));
    }

    @Test
    public void onUberfireDocksInteractionEventSettings() {
        UberfireDocksInteractionEvent uberfireDocksInteractionEventMock = (UberfireDocksInteractionEvent)Mockito.mock(UberfireDocksInteractionEvent.class);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        this.presenter.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.never())).getTargetDock();
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenter});
        this.presenter.dataManagementStrategy = null;
        this.presenter.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).getCheatSheetPresenter((PlaceRequest)Matchers.any());
        PlaceRequest settingsPlaceRequestMock = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenter});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        Mockito.when((Object)this.presenter.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)settingsPlaceRequestMock);
        this.presenter.dataManagementStrategy = this.dataManagementStrategyMock;
        UberfireDock targetDockMock = (UberfireDock)Mockito.mock(UberfireDock.class);
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"UNKNOWN");
        this.presenter.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).getCheatSheetPresenter((PlaceRequest)Matchers.any());
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenter});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        this.presenter.dataManagementStrategy = this.dataManagementStrategyMock;
        Mockito.when((Object)this.presenter.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)settingsPlaceRequestMock);
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.empty()).when((Object)this.presenter)).getSettingsPresenter((PlaceRequest)Matchers.eq((Object)settingsPlaceRequestMock));
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"org.drools.scenariosimulation.Settings");
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        this.presenter.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).getSettingsPresenter((PlaceRequest)Matchers.eq((Object)settingsPlaceRequestMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setSettings((SettingsView.Presenter)Matchers.eq((Object)this.settingsPresenterMock));
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenter});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        this.presenter.dataManagementStrategy = this.dataManagementStrategyMock;
        Mockito.when((Object)this.presenter.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)settingsPlaceRequestMock);
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.of(this.settingsPresenterMock)).when((Object)this.presenter)).getSettingsPresenter((PlaceRequest)Matchers.eq((Object)settingsPlaceRequestMock));
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"org.drools.scenariosimulation.Settings");
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        this.presenter.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).getSettingsPresenter((PlaceRequest)Matchers.eq((Object)settingsPlaceRequestMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).getSaveCommand();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).setSettings((SettingsView.Presenter)Matchers.eq((Object)this.settingsPresenterMock));
        PlaceRequest coverageReportPlaceRequestMock = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenter});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        this.presenter.dataManagementStrategy = this.dataManagementStrategyMock;
        Mockito.when((Object)this.presenter.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)coverageReportPlaceRequestMock);
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.of(this.coverageReportPresenterMock)).when((Object)this.presenter)).getCoverageReportPresenter((PlaceRequest)Matchers.eq((Object)coverageReportPlaceRequestMock));
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"org.drools.scenariosimulation.CoverageReport");
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        this.presenter.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).getCoverageReportPresenter((PlaceRequest)Matchers.eq((Object)coverageReportPlaceRequestMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).setCoverageReport((CoverageReportView.Presenter)Matchers.eq((Object)this.coverageReportPresenterMock));
    }

    @Test
    public void isUberfireDocksInteractionEventToManage() {
        UberfireDocksInteractionEvent uberfireDocksInteractionEventMock = (UberfireDocksInteractionEvent)Mockito.mock(UberfireDocksInteractionEvent.class);
        ((UberfireDocksInteractionEvent)Mockito.doReturn(null).when((Object)uberfireDocksInteractionEventMock)).getTargetDock();
        Assert.assertFalse((boolean)this.presenter.isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock));
        UberfireDock targetDockMock = (UberfireDock)Mockito.mock(UberfireDock.class);
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        Mockito.when((Object)this.placeRequestMock.getParameter((String)Matchers.eq((Object)"scesimeditorid"), (String)Matchers.eq((Object)""))).thenReturn((Object)"UNKNOWN");
        Assert.assertFalse((boolean)this.presenter.isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock));
        ((PathPlaceRequest)Mockito.doReturn((Object)String.valueOf(this.presenter.scenarioPresenterId)).when((Object)this.placeRequestMock)).getParameter((String)Matchers.eq((Object)"scesimeditorid"), (String)Matchers.eq((Object)""));
        Assert.assertTrue((boolean)this.presenter.isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock));
    }

    @Test
    public void refreshModelContent() {
        Mockito.when((Object)this.scenarioSimulationModelMock.getSimulation()).thenReturn((Object)this.simulationMock);
        ArrayList<ScenarioWithIndex> entries = new ArrayList<ScenarioWithIndex>();
        int scenarioNumber = 1;
        int scenarioIndex = scenarioNumber - 1;
        Scenario scenario = (Scenario)Mockito.mock(Scenario.class);
        entries.add(new ScenarioWithIndex(scenarioNumber, scenario));
        Assert.assertNull((Object)this.presenter.lastRunResult);
        TestResultMessage testResultMessage = (TestResultMessage)Mockito.mock(TestResultMessage.class);
        this.presenter.refreshModelContent(new SimulationRunResult(entries, new SimulationRunMetadata(), testResultMessage));
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).replaceScenario(Matchers.eq((int)scenarioIndex), (Scenario)Matchers.eq((Object)scenario));
        Assert.assertEquals((Object)this.scenarioSimulationModelMock, (Object)this.presenter.getModel());
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).refreshContent((Simulation)Matchers.eq((Object)this.simulationMock));
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).expandTestResultsDock();
        ((DataManagementStrategy)Mockito.verify((Object)this.dataManagementStrategyMock, (VerificationMode)Mockito.times((int)1))).setModel((ScenarioSimulationModel)Matchers.eq((Object)this.scenarioSimulationModelMock));
        ((TestRunnerReportingPanelWrapper)Mockito.verify((Object)this.testRunnerReportingPanelMock, (VerificationMode)Mockito.times((int)1))).onTestRun((TestResultMessage)Matchers.eq((Object)testResultMessage));
        Assert.assertNotNull((Object)this.presenter.lastRunResult);
    }

    @Test
    public void makeMenuBar() {
        this.presenter.makeMenuBar(this.fileMenuBuilderMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.runScenarioMenuItemMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.undoMenuItemMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.redoMenuItemMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.exportToCsvMenuItemMock);
        ((ScenarioMenuItem)Mockito.verify((Object)this.undoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
        ((ScenarioMenuItem)Mockito.verify((Object)this.redoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void isDirty() {
        Mockito.when((Object)this.scenarioSimulationViewMock.getScenarioGridPanel()).thenThrow(new Throwable[]{new RuntimeException()});
        Assert.assertFalse((boolean)this.presenter.isDirty());
    }

    @Test
    public void onDownload() {
        String DOWNLOAD_URL = "DOWNLOAD_URL";
        Supplier pathSupplierMock = (Supplier)Mockito.mock(Supplier.class);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)DOWNLOAD_URL).when((Object)this.presenter)).getFileDownloadURL((Supplier)Matchers.eq((Object)pathSupplierMock));
        this.presenter.onDownload(pathSupplierMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).getFileDownloadURL((Supplier)Matchers.eq((Object)pathSupplierMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).open((String)Matchers.eq((Object)DOWNLOAD_URL));
    }

    @Test
    public void showImportDialog() {
        this.presenter.showImportDialog();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(ImportEvent.class));
    }

    @Test
    public void setTestTools() {
        this.presenter.setTestTools((TestToolsView.Presenter)this.testToolsPresenterMock);
        ((ScenarioSimulationContext)Mockito.verify((Object)this.contextMock, (VerificationMode)Mockito.times((int)1))).setTestToolsPresenter((TestToolsView.Presenter)this.testToolsPresenterMock);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).setEventBus(this.eventBusMock);
        ((DataManagementStrategy)Mockito.verify((Object)this.dataManagementStrategyMock, (VerificationMode)Mockito.times((int)1))).populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioGridModelMock);
    }

    @Test
    public void setCheatSheet() {
        this.presenter.setCheatSheet((CheatSheetView.Presenter)this.cheatSheetPresenterMock);
        ((CheatSheetPresenter)Mockito.verify((Object)this.cheatSheetPresenterMock, (VerificationMode)Mockito.times((int)1))).initCheatSheet((ScenarioSimulationModel.Type)Matchers.any());
    }

    @Test
    public void setSettings() {
        Command saveCommandMock = (Command)Mockito.mock(Command.class);
        Mockito.when((Object)this.presenter.getSaveCommand()).thenReturn((Object)saveCommandMock);
        this.presenter.setSettings((SettingsView.Presenter)this.settingsPresenterMock);
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterMock, (VerificationMode)Mockito.times((int)1))).setScenarioType((ScenarioSimulationModel.Type)Matchers.any(), (SimulationDescriptor)Matchers.any(), Matchers.anyString());
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterMock, (VerificationMode)Mockito.times((int)1))).setSaveCommand((Command)Matchers.eq((Object)saveCommandMock));
    }

    @Test
    public void populateRightDocks_Settings() {
        Mockito.when((Object)this.presenter.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)this.placeRequestMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.of(this.settingsPresenterMock)).when((Object)this.presenter)).getSettingsPresenter((PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
        this.presenter.populateRightDocks("org.drools.scenariosimulation.Settings");
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).setSettings((SettingsView.Presenter)Matchers.eq((Object)this.settingsPresenterMock));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterMock, (VerificationMode)Mockito.times((int)1))).setCurrentPath((ObservablePath)Matchers.eq((Object)this.pathMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setTestTools((TestToolsView.Presenter)Matchers.any());
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setCoverageReport((CoverageReportView.Presenter)Matchers.any());
        ((CoverageReportPresenter)Mockito.verify((Object)this.coverageReportPresenterMock, (VerificationMode)Mockito.never())).setCurrentPath((ObservablePath)Matchers.any());
    }

    @Test
    public void populateRightDocks_TestTools() {
        Mockito.when((Object)this.presenter.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)this.placeRequestMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.of(this.testToolsPresenterMock)).when((Object)this.presenter)).getTestToolsPresenter((PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
        this.presenter.populateRightDocks("org.drools.scenariosimulation.TestTools");
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setSettings((SettingsView.Presenter)Matchers.any());
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterMock, (VerificationMode)Mockito.never())).setCurrentPath((ObservablePath)Matchers.any());
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).setTestTools((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock));
        ((CheatSheetPresenter)Mockito.verify((Object)this.cheatSheetPresenterMock, (VerificationMode)Mockito.never())).setCurrentPath((ObservablePath)Matchers.any());
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setCheatSheet((CheatSheetView.Presenter)Matchers.any());
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setCoverageReport((CoverageReportView.Presenter)Matchers.any());
        ((CoverageReportPresenter)Mockito.verify((Object)this.coverageReportPresenterMock, (VerificationMode)Mockito.never())).setCurrentPath((ObservablePath)Matchers.any());
    }

    @Test
    public void populateRightDocks_CheatSheetPresenter_NotShown() {
        Mockito.when((Object)this.presenter.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)this.placeRequestMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.of(this.testToolsPresenterMock)).when((Object)this.presenter)).getTestToolsPresenter((PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
        this.presenter.populateRightDocks("org.drools.scenariosimulation.CheatSheet");
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setSettings((SettingsView.Presenter)Matchers.any());
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterMock, (VerificationMode)Mockito.never())).setCurrentPath((ObservablePath)Matchers.any());
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setTestTools((TestToolsView.Presenter)Matchers.any());
        ((CheatSheetPresenter)Mockito.verify((Object)this.cheatSheetPresenterMock, (VerificationMode)Mockito.times((int)1))).setCurrentPath(this.pathMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).setCheatSheet((CheatSheetView.Presenter)Matchers.eq((Object)this.cheatSheetPresenterMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setCoverageReport((CoverageReportView.Presenter)Matchers.any());
        ((CoverageReportPresenter)Mockito.verify((Object)this.coverageReportPresenterMock, (VerificationMode)Mockito.never())).setCurrentPath((ObservablePath)Matchers.any());
    }

    @Test
    public void populateRightDocks_CheatSheetPresenter_IsShown() {
        Mockito.when((Object)this.cheatSheetPresenterMock.isCurrentlyShow(this.pathMock)).thenReturn((Object)true);
        Mockito.when((Object)this.presenter.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)this.placeRequestMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.of(this.testToolsPresenterMock)).when((Object)this.presenter)).getTestToolsPresenter((PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
        this.presenter.populateRightDocks("org.drools.scenariosimulation.CheatSheet");
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setSettings((SettingsView.Presenter)Matchers.any());
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterMock, (VerificationMode)Mockito.never())).setCurrentPath((ObservablePath)Matchers.any());
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setTestTools((TestToolsView.Presenter)Matchers.any());
        ((CheatSheetPresenter)Mockito.verify((Object)this.cheatSheetPresenterMock, (VerificationMode)Mockito.never())).setCurrentPath((ObservablePath)Matchers.any());
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setCheatSheet((CheatSheetView.Presenter)Matchers.any());
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setCoverageReport((CoverageReportView.Presenter)Matchers.any());
        ((CoverageReportPresenter)Mockito.verify((Object)this.coverageReportPresenterMock, (VerificationMode)Mockito.never())).setCurrentPath((ObservablePath)Matchers.any());
    }

    @Test
    public void populateRightDocks_CoverageReportPresenter() {
        this.presenter.populateRightDocks("org.drools.scenariosimulation.CoverageReport");
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setSettings((SettingsView.Presenter)Matchers.any());
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterMock, (VerificationMode)Mockito.never())).setCurrentPath((ObservablePath)Matchers.any());
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setTestTools((TestToolsView.Presenter)Matchers.any());
        ((CheatSheetPresenter)Mockito.verify((Object)this.cheatSheetPresenterMock, (VerificationMode)Mockito.never())).setCurrentPath((ObservablePath)Matchers.any());
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setCheatSheet((CheatSheetView.Presenter)Matchers.any());
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).setCoverageReport((CoverageReportView.Presenter)Matchers.eq((Object)this.coverageReportPresenterMock));
        ((CoverageReportPresenter)Mockito.verify((Object)this.coverageReportPresenterMock, (VerificationMode)Mockito.times((int)1))).setCurrentPath((ObservablePath)Matchers.eq((Object)this.pathMock));
    }

    @Test
    public void getModelSuccessCallbackMethod() {
        this.presenter.getModelSuccessCallbackMethod(this.dataManagementStrategyMock, this.modelLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).populateRightDocks("org.drools.scenariosimulation.TestTools");
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).populateRightDocks("org.drools.scenariosimulation.Settings");
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).setContent((Simulation)Matchers.eq((Object)this.content.getModel().getSimulation()));
        ((ScenarioSimulationContext.Status)Mockito.verify((Object)this.statusMock, (VerificationMode)Mockito.times((int)1))).setSimulation((Simulation)Matchers.eq((Object)this.content.getModel().getSimulation()));
    }

    @Test
    public void onExportToCsv() {
        this.presenter.init(this.scenarioSimulationEditorWrapper, this.observablePathMock);
        this.presenter.onExportToCsv();
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapper, (VerificationMode)Mockito.times((int)1))).onExportToCsv((RemoteCallback)Matchers.isA(RemoteCallback.class), (ScenarioSimulationHasBusyIndicatorDefaultErrorCallback)Matchers.isA(ScenarioSimulationHasBusyIndicatorDefaultErrorCallback.class), (Simulation)Matchers.eq((Object)this.simulationMock));
    }

    @Test
    public void cleanReadOnlyColumn() {
        Simulation simulation = new Simulation();
        SimulationDescriptor simulationDescriptor = simulation.getSimulationDescriptor();
        FactMapping test1 = simulationDescriptor.addFactMapping(FactIdentifier.create((String)"test1", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"", (FactMappingType)FactMappingType.GIVEN));
        FactMapping test2 = simulationDescriptor.addFactMapping(FactIdentifier.create((String)"test2", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"", (FactMappingType)FactMappingType.GIVEN));
        test1.addExpressionElement("test", String.class.getCanonicalName());
        Scenario scenario = simulation.addScenario();
        scenario.addMappingValue(test1.getFactIdentifier(), test1.getExpressionIdentifier(), (Object)"value");
        scenario.addMappingValue(test2.getFactIdentifier(), test2.getExpressionIdentifier(), (Object)"value");
        this.presenter.cleanReadOnlyColumn(simulation);
        Assert.assertNotNull((Object)((FactMappingValue)scenario.getFactMappingValue(test1.getFactIdentifier(), test1.getExpressionIdentifier()).get()).getRawValue());
        Assert.assertNull((Object)((FactMappingValue)scenario.getFactMappingValue(test2.getFactIdentifier(), test2.getExpressionIdentifier()).get()).getRawValue());
    }
}

