/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickEvent;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.MouseEvent;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationGridHandlerTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridWidgetMouseEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellEditAction;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioSimulationGridWidgetMouseEventHandlerTest
extends AbstractScenarioSimulationGridHandlerTest {
    @Mock
    private MouseEvent nativeClickEvent;
    @Mock
    private DoubleClickEvent nativeDoubleClickEvent;
    @Mock
    private BaseGridRendererHelper rendererHelper;
    @Mock
    private BaseGridRendererHelper.RenderingInformation renderingInformation;
    @Mock
    private BaseGridRendererHelper.ColumnInformation columnInformation;
    @Mock
    private BaseGridRendererHelper.RenderingBlockInformation renderingBlockInformation;
    @Mock
    private GridCellEditAction gridCellEditActionMock;
    private NodeMouseClickEvent clickEvent;
    private NodeMouseDoubleClickEvent doubleClickEvent;
    private ScenarioSimulationGridWidgetMouseEventHandler handler;
    private Point2D relativeLocation = new Point2D(32.0, 64.0);
    private Point2D computedLocation = new Point2D(100.0, 200.0);

    @Override
    @Before
    public void setup() {
        super.setUp();
        this.clickEvent = new NodeMouseClickEvent(this.nativeClickEvent);
        this.doubleClickEvent = new NodeMouseDoubleClickEvent(this.nativeDoubleClickEvent);
        Mockito.when((Object)this.scenarioGridMock.getRendererHelper()).thenReturn((Object)this.rendererHelper);
        Mockito.when((Object)this.scenarioGridMock.getViewport()).thenReturn((Object)this.viewportMock);
        Mockito.when((Object)this.scenarioGridMock.getComputedLocation()).thenReturn((Object)this.computedLocation);
        Mockito.when((Object)this.rendererHelper.getRenderingInformation()).thenReturn((Object)this.renderingInformation);
        Mockito.when((Object)this.rendererHelper.getColumnInformation(Matchers.anyDouble())).thenReturn((Object)this.columnInformation);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)this.gridColumnMock);
        Mockito.when((Object)this.renderingInformation.getBodyBlockInformation()).thenReturn((Object)this.renderingBlockInformation);
        Mockito.when((Object)this.renderingInformation.getFloatingBlockInformation()).thenReturn((Object)this.renderingBlockInformation);
        Mockito.when((Object)this.renderingInformation.getAllColumns()).thenReturn((Object)this.columnsMock);
        Mockito.when((Object)this.informationHeaderMetaDataMock.getSupportedEditAction()).thenReturn((Object)GridCellEditAction.SINGLE_CLICK);
        this.handler = (ScenarioSimulationGridWidgetMouseEventHandler)Mockito.spy((Object)new ScenarioSimulationGridWidgetMouseEventHandler());
    }

    @Test
    public void handleHeaderCell_NullColumn() {
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn(null);
        this.commonHandleHeaderCell(true, true, 1, false, false);
    }

    @Test
    public void handleHeaderCell_NonEditableColumn() {
        this.commonHandleHeaderCell(false, false, 1, false, true);
    }

    @Test
    public void handleHeaderCell_EditableColumn_NotStartEdit() {
        this.commonHandleHeaderCell(true, false, 1, true, false);
    }

    @Test
    public void handleHeaderCell_EditableColumn_StartEdit() {
        this.commonHandleHeaderCell(true, true, 1, true, true);
    }

    @Test
    public void handleHeaderCell_EditableColumn_WrongSelectedSize() {
        this.commonHandleHeaderCell(true, true, 3, false, true);
    }

    @Test
    public void handleBodyCell_NotEditSupportedLocal() {
        this.commonHandleBodyCell(false, true, 1, false, false);
    }

    @Test
    public void handleBodyCell_NotStartEditLocal() {
        this.commonHandleBodyCell(true, false, 1, true, false);
    }

    @Test
    public void handleBodyCell_StartEditLocal() {
        this.commonHandleBodyCell(true, true, 1, true, true);
    }

    @Test
    public void handleBodyCell_WrongSelectedSize() {
        this.commonHandleBodyCell(true, true, 3, false, false);
    }

    private void commonHandleHeaderCell(boolean editSupportedLocal, boolean startEditLocal, int selectedHeaderCellsSize, boolean startEditLocalCalled, boolean expectedResult) {
        int uiHeaderColumnIndex = 0;
        int uiHeaderRowIndex = 0;
        this.scenarioGridMock.getModel().getSelectedHeaderCells().clear();
        IntStream.range(0, selectedHeaderCellsSize).forEach(i -> this.scenarioGridMock.getModel().getSelectedHeaderCells().add(Mockito.mock(GridData.SelectedCell.class)));
        ((ScenarioSimulationGridWidgetMouseEventHandler)Mockito.doReturn((Object)editSupportedLocal).when((Object)this.handler)).editSupportedLocal((GridCellEditAction)Matchers.any(), (AbstractNodeMouseEvent)Matchers.any());
        ((ScenarioSimulationGridWidgetMouseEventHandler)Mockito.doReturn((Object)startEditLocal).when((Object)this.handler)).startEditLocal((ScenarioGrid)Matchers.eq((Object)this.scenarioGridMock), Matchers.eq((int)uiHeaderColumnIndex), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), Matchers.eq((int)uiHeaderRowIndex), Matchers.eq((boolean)true));
        if (expectedResult) {
            Assert.assertTrue((boolean)this.handler.handleHeaderCell((GridWidget)this.scenarioGridMock, this.relativeLocation, uiHeaderRowIndex, uiHeaderColumnIndex, (AbstractNodeMouseEvent)this.clickEvent));
        } else {
            Assert.assertFalse((boolean)this.handler.handleHeaderCell((GridWidget)this.scenarioGridMock, this.relativeLocation, uiHeaderRowIndex, uiHeaderColumnIndex, (AbstractNodeMouseEvent)this.clickEvent));
        }
        if (startEditLocalCalled) {
            ((ScenarioSimulationGridWidgetMouseEventHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).startEditLocal((ScenarioGrid)Matchers.eq((Object)this.scenarioGridMock), Matchers.eq((int)uiHeaderColumnIndex), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), Matchers.eq((int)uiHeaderRowIndex), Matchers.eq((boolean)true));
        } else {
            ((ScenarioSimulationGridWidgetMouseEventHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).startEditLocal((ScenarioGrid)Matchers.eq((Object)this.scenarioGridMock), Matchers.eq((int)uiHeaderColumnIndex), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), Matchers.eq((int)uiHeaderRowIndex), Matchers.eq((boolean)true));
        }
    }

    private void commonHandleBodyCell(boolean editSupportedLocal, boolean startEditLocal, int selectedCellsSize, boolean startEditLocalCalled, boolean expectedResult) {
        int uiHeaderColumnIndex = 0;
        int uiHeaderRowIndex = 0;
        this.scenarioGridMock.getModel().getSelectedCells().clear();
        IntStream.range(0, selectedCellsSize).forEach(i -> this.scenarioGridMock.getModel().getSelectedCells().add(Mockito.mock(GridData.SelectedCell.class)));
        ((ScenarioSimulationGridWidgetMouseEventHandler)Mockito.doReturn((Object)editSupportedLocal).when((Object)this.handler)).editSupportedLocal((GridCellEditAction)Matchers.any(), (AbstractNodeMouseEvent)Matchers.any());
        ((ScenarioSimulationGridWidgetMouseEventHandler)Mockito.doReturn((Object)startEditLocal).when((Object)this.handler)).startEditLocal((ScenarioGrid)Matchers.eq((Object)this.scenarioGridMock), Matchers.eq((int)uiHeaderColumnIndex), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), Matchers.eq((int)uiHeaderRowIndex), Matchers.eq((boolean)false));
        if (expectedResult) {
            Assert.assertTrue((boolean)this.handler.handleBodyCell((GridWidget)this.scenarioGridMock, this.relativeLocation, uiHeaderRowIndex, uiHeaderColumnIndex, (AbstractNodeMouseEvent)this.clickEvent));
        } else {
            Assert.assertFalse((boolean)this.handler.handleBodyCell((GridWidget)this.scenarioGridMock, this.relativeLocation, uiHeaderRowIndex, uiHeaderColumnIndex, (AbstractNodeMouseEvent)this.clickEvent));
        }
        if (startEditLocalCalled) {
            ((ScenarioSimulationGridWidgetMouseEventHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).startEditLocal((ScenarioGrid)Matchers.eq((Object)this.scenarioGridMock), Matchers.eq((int)uiHeaderColumnIndex), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), Matchers.eq((int)uiHeaderRowIndex), Matchers.eq((boolean)false));
        } else {
            ((ScenarioSimulationGridWidgetMouseEventHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).startEditLocal((ScenarioGrid)Matchers.eq((Object)this.scenarioGridMock), Matchers.eq((int)uiHeaderColumnIndex), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), Matchers.eq((int)uiHeaderRowIndex), Matchers.eq((boolean)false));
        }
    }
}

