/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.widgets;

import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridWidgetMouseEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.menu.ScenarioContextMenuRegistry;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.renderers.ScenarioGridRenderer;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationBuilders;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridRow;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.DefaultGridWidgetCellSelectorMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.SelectionExtension;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioGridTest {
    @Mock
    private ScenarioGridModel scenarioGridModelMock;
    @Mock
    private ScenarioGridLayer scenarioGridLayerMock;
    @Mock
    private ScenarioGridRenderer scenarioGridRendererMock;
    @Mock
    private ScenarioSimulationBuilders.HeaderBuilder headerBuilderMock;
    @Mock
    private ScenarioGridColumn scenarioGridColumnMock;
    @Mock
    private ScenarioHeaderMetaData propertyHeaderMetadataMock;
    @Mock
    private EventBus eventBusMock;
    @Mock
    private BaseGridRendererHelper rendererHelperMock;
    @Mock
    private BaseGridRendererHelper.RenderingInformation renderingInformationMock;
    @Mock
    private BaseGridRendererHelper.ColumnInformation columnInformationMock;
    @Mock
    private BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformationMock;
    @Mock
    private Viewport viewportMock;
    @Mock
    private ScenarioContextMenuRegistry scenarioContextMenuRegistryMock;
    private FactMapping factMappingDescription;
    private FactMapping factMappingGiven;
    private FactMapping factMappingInteger;
    private FactIdentifier factIdentifierGiven;
    private FactIdentifier factIdentifierInteger;
    private Simulation simulation = new Simulation();
    private ScenarioGrid scenarioGrid;

    @Before
    public void setup() {
        Mockito.when((Object)this.scenarioGridColumnMock.getPropertyHeaderMetaData()).thenReturn((Object)this.propertyHeaderMetadataMock);
        this.factIdentifierGiven = new FactIdentifier("GIVEN", "GIVEN");
        this.factIdentifierInteger = new FactIdentifier("Integer", "java.lang.Integer");
        this.factMappingDescription = new FactMapping("EXPRESSION_ALIAS_DESCRIPTION", FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        this.factMappingGiven = new FactMapping("EXPRESSION_ALIAS_GIVEN", this.factIdentifierGiven, new ExpressionIdentifier("GIVEN", FactMappingType.GIVEN));
        this.factMappingInteger = new FactMapping("EXPRESSION_ALIAS_INTEGER", this.factIdentifierInteger, new ExpressionIdentifier("GIVEN", FactMappingType.GIVEN));
        this.simulation = this.getSimulation();
        this.scenarioGrid = (ScenarioGrid)Mockito.spy((Object)new ScenarioGrid(this.scenarioGridModelMock, this.scenarioGridLayerMock, this.scenarioGridRendererMock, this.scenarioContextMenuRegistryMock){

            protected void appendRow(int rowIndex, Scenario scenario) {
            }

            protected ScenarioSimulationBuilders.HeaderBuilder getHeaderBuilderLocal(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType) {
                return ScenarioGridTest.this.headerBuilderMock;
            }

            protected ScenarioGridColumn getScenarioGridColumnLocal(ScenarioSimulationBuilders.HeaderBuilder headerBuilder, String placeHolder) {
                return ScenarioGridTest.this.scenarioGridColumnMock;
            }

            protected BaseGridRendererHelper getBaseGridRendererHelper() {
                return ScenarioGridTest.this.rendererHelperMock;
            }

            public Viewport getViewport() {
                return ScenarioGridTest.this.viewportMock;
            }

            protected ScenarioHeaderMetaData getColumnScenarioHeaderMetaData(ScenarioGridColumn scenarioGridColumn, int rowIndex) {
                return ScenarioGridTest.this.propertyHeaderMetadataMock;
            }

            protected EnableTestToolsEvent getEnableTestToolsEvent(ScenarioGrid scenarioGrid, ScenarioGridColumn scenarioGridColumn, ScenarioHeaderMetaData scenarioHeaderMetaData, int uiColumnIndex, String group) {
                return new EnableTestToolsEvent();
            }
        });
        Mockito.when((Object)this.rendererHelperMock.getRenderingInformation()).thenReturn((Object)this.renderingInformationMock);
        Mockito.when((Object)this.renderingInformationMock.getHeaderRowsHeight()).thenReturn((Object)100.0);
        Mockito.when((Object)this.renderingInformationMock.getFloatingBlockInformation()).thenReturn((Object)this.floatingBlockInformationMock);
        Mockito.when((Object)this.propertyHeaderMetadataMock.getColumnGroup()).thenReturn((Object)"GIVEN");
        this.scenarioGrid.setEventBus(this.eventBusMock);
    }

    @Test
    public void testDefaultNodeMouseClickHandlers() {
        List handlers = this.scenarioGrid.getNodeMouseClickEventHandlers((GridSelectionManager)this.scenarioGridLayerMock);
        Assert.assertEquals((long)1L, (long)handlers.size());
        Assert.assertTrue((boolean)(handlers.get(0) instanceof DefaultGridWidgetCellSelectorMouseEventHandler));
    }

    @Test
    public void testDefaultNodeMouseDoubleClickHandlers() {
        List handlers = this.scenarioGrid.getNodeMouseDoubleClickEventHandlers((GridSelectionManager)this.scenarioGridLayerMock, (GridPinnedModeManager)this.scenarioGridLayerMock);
        Assert.assertEquals((long)1L, (long)handlers.size());
        Assert.assertTrue((boolean)(handlers.get(0) instanceof ScenarioSimulationGridWidgetMouseEventHandler));
    }

    @Test
    public void setContent() {
        this.scenarioGrid.setContent(this.simulation);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).bindContent((Simulation)Matchers.eq((Object)this.simulation));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).setHeaderColumns((Simulation)Matchers.eq((Object)this.simulation));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).appendRows((Simulation)Matchers.eq((Object)this.simulation));
    }

    @Test
    public void setHeaderColumns() {
        this.scenarioGrid.setHeaderColumns(this.simulation);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)6))).setHeaderColumn(Matchers.anyInt(), (FactMapping)Matchers.isA(FactMapping.class), Matchers.eq((boolean)true));
    }

    @Test
    public void setHeaderColumn() {
        String columnId = this.factMappingDescription.getExpressionIdentifier().getName();
        FactMappingType type = this.factMappingDescription.getExpressionIdentifier().getType();
        String columnGroup = type.name();
        this.scenarioGrid.setHeaderColumn(1, this.factMappingDescription, true);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).isPropertyAssigned(Matchers.eq((boolean)true), (FactMapping)Matchers.eq((Object)this.factMappingDescription));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).getPlaceholder(Matchers.eq((boolean)true), (FactMapping)Matchers.any());
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).getScenarioGridColumnLocal((String)Matchers.eq((Object)"EXPRESSION_ALIAS_DESCRIPTION"), (String)Matchers.any(), (String)Matchers.eq((Object)columnId), (String)Matchers.eq((Object)columnGroup), (FactMappingType)Matchers.eq((Object)type), Matchers.anyString());
        ((ScenarioGridColumn)Mockito.verify((Object)this.scenarioGridColumnMock, (VerificationMode)Mockito.times((int)1))).setColumnWidthMode(GridColumn.ColumnWidthMode.FIXED);
        Mockito.reset((Object[])new ScenarioGrid[]{this.scenarioGrid});
        Mockito.reset((Object[])new ScenarioGridColumn[]{this.scenarioGridColumnMock});
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModelMock});
        columnId = this.factMappingGiven.getExpressionIdentifier().getName();
        type = this.factMappingGiven.getExpressionIdentifier().getType();
        columnGroup = type.name();
        this.scenarioGrid.setHeaderColumn(1, this.factMappingGiven, true);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).isPropertyAssigned(Matchers.eq((boolean)true), (FactMapping)Matchers.eq((Object)this.factMappingGiven));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).getPlaceholder(Matchers.eq((boolean)false), (FactMapping)Matchers.any());
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).getScenarioGridColumnLocal((String)Matchers.eq((Object)"EXPRESSION_ALIAS_GIVEN"), (String)Matchers.any(), (String)Matchers.eq((Object)columnId), (String)Matchers.eq((Object)columnGroup), (FactMappingType)Matchers.eq((Object)type), Matchers.anyString());
        ((ScenarioGridColumn)Mockito.verify((Object)this.scenarioGridColumnMock, (VerificationMode)Mockito.never())).setColumnWidthMode((GridColumn.ColumnWidthMode)Matchers.any());
    }

    @Test
    public void getScenarioGridColumnLocal() {
        String columnId = this.factMappingDescription.getExpressionIdentifier().getName();
        String instanceTitle = this.factMappingDescription.getFactIdentifier().getName();
        String propertyTitle = "PROPERTY TITLE";
        FactMappingType type = this.factMappingDescription.getExpressionIdentifier().getType();
        String columnGroup = type.name();
        this.scenarioGrid.getScenarioGridColumnLocal(instanceTitle, propertyTitle, columnId, columnGroup, type, ScenarioSimulationEditorConstants.INSTANCE.insertValue());
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).getHeaderBuilderLocal((String)Matchers.eq((Object)instanceTitle), (String)Matchers.eq((Object)propertyTitle), (String)Matchers.eq((Object)columnId), (String)Matchers.eq((Object)columnGroup), (FactMappingType)Matchers.eq((Object)type));
    }

    @Test
    public void isInstanceAssigned() {
        Assert.assertTrue((boolean)this.scenarioGrid.isInstanceAssigned(FactIdentifier.DESCRIPTION));
        Assert.assertFalse((boolean)this.scenarioGrid.isInstanceAssigned(FactIdentifier.INDEX));
        Assert.assertFalse((boolean)this.scenarioGrid.isInstanceAssigned(FactIdentifier.EMPTY));
        Assert.assertTrue((boolean)this.scenarioGrid.isInstanceAssigned(this.factIdentifierGiven));
    }

    @Test
    public void isPropertyAssigned() {
        this.factMappingDescription.getExpressionElements().clear();
        Assert.assertTrue((boolean)this.scenarioGrid.isPropertyAssigned(false, this.factMappingDescription));
        Assert.assertTrue((boolean)this.scenarioGrid.isPropertyAssigned(true, this.factMappingDescription));
        this.factMappingDescription.getExpressionElements().add(new ExpressionElement("test"));
        Assert.assertTrue((boolean)this.scenarioGrid.isPropertyAssigned(false, this.factMappingDescription));
        Assert.assertTrue((boolean)this.scenarioGrid.isPropertyAssigned(true, this.factMappingDescription));
        this.factMappingGiven.getExpressionElements().clear();
        Assert.assertFalse((boolean)this.scenarioGrid.isPropertyAssigned(false, this.factMappingGiven));
        Assert.assertFalse((boolean)this.scenarioGrid.isPropertyAssigned(true, this.factMappingGiven));
        this.factMappingGiven.getExpressionElements().add(new ExpressionElement("test"));
        Assert.assertFalse((boolean)this.scenarioGrid.isPropertyAssigned(false, this.factMappingGiven));
        Assert.assertTrue((boolean)this.scenarioGrid.isPropertyAssigned(true, this.factMappingGiven));
        this.factMappingInteger.getExpressionElements().clear();
        Assert.assertFalse((boolean)this.scenarioGrid.isPropertyAssigned(false, this.factMappingInteger));
        Assert.assertTrue((boolean)this.scenarioGrid.isPropertyAssigned(true, this.factMappingInteger));
    }

    @Test
    public void getPlaceholder() {
        FactMapping stringFactMapping = new FactMapping(FactIdentifier.create((String)"test", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"test", (FactMappingType)FactMappingType.GIVEN));
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.insertValue(), (Object)this.scenarioGrid.getPlaceholder(true, stringFactMapping));
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.defineValidType(), (Object)this.scenarioGrid.getPlaceholder(false, stringFactMapping));
        FactMapping localDateFactMapping = new FactMapping(FactIdentifier.create((String)"test", (String)LocalDate.class.getCanonicalName()), ExpressionIdentifier.create((String)"test", (FactMappingType)FactMappingType.GIVEN));
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.dateFormatPlaceholder(), (Object)this.scenarioGrid.getPlaceholder(true, localDateFactMapping));
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.defineValidType(), (Object)this.scenarioGrid.getPlaceholder(false, localDateFactMapping));
    }

    @Test
    public void appendRows() {
        this.scenarioGrid.appendRows(this.simulation);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).appendRow(Matchers.anyInt(), (Scenario)Matchers.isA(Scenario.class));
    }

    @Test
    public void testAdjustSelection() {
        boolean uiColumnIndex = false;
        boolean uiRowIndex = false;
        ScenarioGridColumn columnMock = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Collections.singletonList(columnMock));
        GridData.SelectedCell selectedHeaderCell = (GridData.SelectedCell)Mockito.mock(GridData.SelectedCell.class);
        Mockito.when((Object)selectedHeaderCell.getColumnIndex()).thenReturn((Object)0);
        Mockito.when((Object)selectedHeaderCell.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Collections.singletonList(selectedHeaderCell));
        this.scenarioGrid.adjustSelection((SelectionExtension)Mockito.mock(SelectionExtension.class), false);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid)).signalTestTools();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid)).setSelectedColumnAndHeader(0, 0);
        ((EventBus)Mockito.verify((Object)this.eventBusMock)).fireEvent((GwtEvent)Matchers.any(EnableTestToolsEvent.class));
        ((ScenarioContextMenuRegistry)Mockito.verify((Object)this.scenarioContextMenuRegistryMock, (VerificationMode)Mockito.times((int)1))).hideMenus();
        ((ScenarioContextMenuRegistry)Mockito.verify((Object)this.scenarioContextMenuRegistryMock, (VerificationMode)Mockito.times((int)1))).hideErrorReportPopover();
    }

    @Test
    public void testShowContextMenuDescription() {
        boolean uiColumnIndex = false;
        boolean uiRowIndex = false;
        double columnWidth = 100.0;
        GridColumn columnMock = (GridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)columnMock.getWidth()).thenReturn((Object)100.0);
        Mockito.when((Object)((ScenarioGridColumn)columnMock).getFactIdentifier()).thenReturn((Object)FactIdentifier.DESCRIPTION);
        Mockito.when((Object)columnMock.getHeaderMetaData()).thenReturn(Collections.singletonList(Mockito.mock(GridColumn.HeaderMetaData.class)));
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Collections.singletonList(columnMock));
        double rowHeight = 40.0;
        GridRow gridRow = (GridRow)Mockito.mock(ScenarioGridRow.class);
        Mockito.when((Object)gridRow.getHeight()).thenReturn((Object)40.0);
        Mockito.when((Object)this.scenarioGridModelMock.getRow(0)).thenReturn((Object)gridRow);
        Mockito.when((Object)this.rendererHelperMock.getColumnInformation(50.0)).thenReturn((Object)this.columnInformationMock);
        Mockito.when((Object)this.columnInformationMock.getColumn()).thenReturn((Object)columnMock);
    }

    @Test
    public void testShowContextMenuGivenOrExpect() {
        String columnGroup = "grp";
        ScenarioHeaderMetaData scenarioHeaderMetaDataMock = (ScenarioHeaderMetaData)Mockito.mock(ScenarioHeaderMetaData.class);
        Mockito.when((Object)scenarioHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)"grp");
        boolean uiColumnIndex = false;
        boolean uiRowIndex = false;
        double columnWidth = 100.0;
        GridColumn columnMock = (GridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)columnMock.getWidth()).thenReturn((Object)100.0);
        Mockito.when((Object)((ScenarioGridColumn)columnMock).getFactIdentifier()).thenReturn((Object)FactIdentifier.EMPTY);
        Mockito.when((Object)columnMock.getHeaderMetaData()).thenReturn(Collections.singletonList(scenarioHeaderMetaDataMock));
        Mockito.when((Object)((ScenarioGridColumn)columnMock).getInformationHeaderMetaData()).thenReturn((Object)scenarioHeaderMetaDataMock);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Collections.singletonList(columnMock));
        double rowHeight = 40.0;
        GridRow gridRow = (GridRow)Mockito.mock(ScenarioGridRow.class);
        Mockito.when((Object)gridRow.getHeight()).thenReturn((Object)40.0);
        Mockito.when((Object)this.scenarioGridModelMock.getRow(0)).thenReturn((Object)gridRow);
        Mockito.when((Object)this.rendererHelperMock.getColumnInformation(50.0)).thenReturn((Object)this.columnInformationMock);
        Mockito.when((Object)this.columnInformationMock.getColumn()).thenReturn((Object)columnMock);
    }

    private Simulation getSimulation() {
        Simulation toReturn = new Simulation();
        SimulationDescriptor simulationDescriptor = toReturn.getSimulationDescriptor();
        simulationDescriptor.setType(ScenarioSimulationModel.Type.RULE);
        simulationDescriptor.addFactMapping(FactIdentifier.INDEX.getName(), FactIdentifier.INDEX, ExpressionIdentifier.INDEX);
        simulationDescriptor.addFactMapping(FactIdentifier.DESCRIPTION.getName(), FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        Scenario scenario = toReturn.addScenario();
        int row = toReturn.getUnmodifiableScenarios().indexOf(scenario);
        scenario.setDescription(null);
        IntStream.range(2, 4).forEach(id -> {
            ExpressionIdentifier givenExpression = ExpressionIdentifier.create((String)(row + "|" + id), (FactMappingType)FactMappingType.GIVEN);
            simulationDescriptor.addFactMapping(FactMapping.getInstancePlaceHolder((int)id), FactIdentifier.EMPTY, givenExpression);
            scenario.addMappingValue(FactIdentifier.EMPTY, givenExpression, null);
        });
        IntStream.range(2, 4).forEach(id -> {
            ExpressionIdentifier expectedExpression = ExpressionIdentifier.create((String)(row + "|" + (id += 2)), (FactMappingType)FactMappingType.EXPECT);
            simulationDescriptor.addFactMapping(FactMapping.getInstancePlaceHolder((int)id), FactIdentifier.EMPTY, expectedExpression);
            scenario.addMappingValue(FactIdentifier.EMPTY, expectedExpression, null);
        });
        return toReturn;
    }

    @Test
    public void signalTestToolsHeaderCellSelected() {
        boolean uiColumnIndex = false;
        boolean uiRowIndex = false;
        ScenarioGridColumn columnMock = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Collections.singletonList(columnMock));
        GridData.SelectedCell selectedHeaderCell = (GridData.SelectedCell)Mockito.mock(GridData.SelectedCell.class);
        Mockito.when((Object)selectedHeaderCell.getColumnIndex()).thenReturn((Object)0);
        Mockito.when((Object)selectedHeaderCell.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Collections.singletonList(selectedHeaderCell));
        this.scenarioGrid.signalTestToolsHeaderCellSelected(columnMock, selectedHeaderCell, 0);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(EnableTestToolsEvent.class));
    }

    @Test
    public void signalTestToolsHeaderCellSelected_EmptyInstance() {
        boolean uiColumnIndex = false;
        boolean uiRowIndex = false;
        ScenarioGridColumn columnMock = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Collections.singletonList(columnMock));
        Mockito.when((Object)columnMock.isInstanceAssigned()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyHeaderMetadataMock.getMetadataType()).thenReturn((Object)ScenarioHeaderMetaData.MetadataType.INSTANCE);
        GridData.SelectedCell selectedHeaderCell = (GridData.SelectedCell)Mockito.mock(GridData.SelectedCell.class);
        Mockito.when((Object)selectedHeaderCell.getColumnIndex()).thenReturn((Object)0);
        Mockito.when((Object)selectedHeaderCell.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Collections.singletonList(selectedHeaderCell));
        this.scenarioGrid.signalTestToolsHeaderCellSelected(columnMock, selectedHeaderCell, 0);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(ReloadTestToolsEvent.class));
    }
}

