/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationViewImpl;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationViewImplTest {
    @Mock
    private ScenarioGrid scenarioGrid;
    @Mock
    private ScenarioGridModel scenarioGridModel;
    @Mock
    private ScenarioGridLayer scenarioGridLayer;
    @Mock
    private ScenarioGridPanel scenarioGridPanel;
    private ScenarioSimulationViewImpl scenarioView;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.scenarioGridPanel.getScenarioGridLayer()).thenReturn((Object)this.scenarioGridLayer);
        Mockito.when((Object)this.scenarioGridPanel.getScenarioGrid()).thenReturn((Object)this.scenarioGrid);
        Mockito.when((Object)this.scenarioGrid.getModel()).thenReturn((Object)this.scenarioGridModel);
        this.scenarioView = new ScenarioSimulationViewImpl();
        this.scenarioView.setScenarioGridPanel(this.scenarioGridPanel);
    }

    @Test
    public void testKeyboardNavigationPrepared() {
        Simulation simulationModel = (Simulation)Mockito.mock(Simulation.class);
        Mockito.when((Object)this.scenarioGridModel.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)this.scenarioGridModel.getRowCount()).thenReturn((Object)1);
        this.scenarioView.setContent(simulationModel);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid)).setContent(simulationModel);
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanel)).setFocus(true);
    }

    @Test
    public void testKeyboardNavigationPrepared_noDataInScenario() {
        Simulation simulationModel = (Simulation)Mockito.mock(Simulation.class);
        Mockito.when((Object)this.scenarioGridModel.getColumnCount()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModel.getRowCount()).thenReturn((Object)0);
        this.scenarioView.setContent(simulationModel);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid)).setContent(simulationModel);
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanel)).setFocus(true);
    }
}

