/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import java.util.Optional;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationGridHandlerTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.CommonOnMoveHandler;
import org.drools.workbench.screens.scenariosimulation.client.popover.ErrorReportPopoverPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popover.PopoverView;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class CommonOnMoveHandlerTest
extends AbstractScenarioSimulationGridHandlerTest {
    private CommonOnMoveHandler commonOnMoveHandler;
    @Mock
    private ErrorReportPopoverPresenter errorReportPopupPresenterMock;
    @Mock
    private Scenario scenarioMock;
    @Mock
    private FactMappingValue factMappingValueMock;
    @Mock
    private AbsolutePanel scrollPanelMock;
    @Mock
    private Element elementMock;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.commonOnMoveHandler = (CommonOnMoveHandler)Mockito.spy((Object)new CommonOnMoveHandler(){
            {
                this.errorReportPopupPresenter = CommonOnMoveHandlerTest.this.errorReportPopupPresenterMock;
                this.scenarioGrid = CommonOnMoveHandlerTest.this.scenarioGridMock;
                this.scenarioGridPanel = CommonOnMoveHandlerTest.this.scenarioGridPanelMock;
            }

            protected Point2D retrieveCellMiddleXYPosition(GridColumn<?> column, int uiRowIndex) {
                return new Point2D((double)TestProperties.DX.intValue(), (double)TestProperties.DY.intValue());
            }

            protected Point2D convertDOMToGridCoordinateLocal(double canvasX, double canvasY) {
                return new Point2D((double)TestProperties.MX.intValue(), (double)TestProperties.MY.intValue());
            }
        });
        Mockito.when((Object)this.simulationMock.getScenarioByIndex(((Integer)Matchers.isA(Integer.class)).intValue())).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactMapping)Matchers.any())).thenReturn(Optional.of(this.factMappingValueMock));
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        Mockito.when((Object)this.factMappingValueMock.getRawValue()).thenReturn((Object)"raw");
        Mockito.when((Object)this.factMappingValueMock.getErrorValue()).thenReturn((Object)"error");
        Mockito.when((Object)this.scenarioGridLayerMock.getWidth()).thenReturn((Object)TestProperties.LARGE_LAYER);
        Mockito.when((Object)this.gridColumnMock.getWidth()).thenReturn((Object)TestProperties.CELL_WIDTH);
        Mockito.when((Object)this.scenarioGridPanelMock.getScrollPanel()).thenReturn((Object)this.scrollPanelMock);
        Mockito.when((Object)this.scrollPanelMock.getElement()).thenReturn((Object)this.elementMock);
        Mockito.when((Object)this.elementMock.getScrollTop()).thenReturn((Object)0);
        Mockito.when((Object)this.elementMock.getScrollLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.errorReportPopupPresenterMock.isShown()).thenReturn((Object)Boolean.FALSE);
    }

    @Test
    public void handleOnMove() {
        this.commonOnMoveHandler.manageCoordinates(TestProperties.MX.intValue(), TestProperties.MY.intValue());
        ((CommonOnMoveHandler)Mockito.verify((Object)this.commonOnMoveHandler, (VerificationMode)Mockito.times((int)1))).manageCoordinates(((Integer)Matchers.eq((Object)TestProperties.MX)).intValue(), ((Integer)Matchers.eq((Object)TestProperties.MY)).intValue());
    }

    @Test
    public void manageBodyCoordinates_Right() {
        this.commonOnMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getScenarioByIndex(Matchers.eq((int)2));
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)3));
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.times((int)1))).getFactMappingValue((FactMapping)Matchers.eq((Object)this.factMappingMock));
        ((CommonOnMoveHandler)Mockito.verify((Object)this.commonOnMoveHandler, (VerificationMode)Mockito.times((int)1))).retrieveCellMiddleXYPosition((GridColumn)this.gridColumnMock, 2);
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorReason()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithError("raw", "error")), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.keep()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.apply()), (Command)Matchers.isA(Command.class), Matchers.eq((int)((int)(TestProperties.CELL_WIDTH / 2.0) + TestProperties.DX)), ((Integer)Matchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.RIGHT));
    }

    @Test
    public void manageBodyCoordinates_Left() {
        Mockito.when((Object)this.scenarioGridLayerMock.getWidth()).thenReturn((Object)TestProperties.TINY_LAYER);
        this.commonOnMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getScenarioByIndex(Matchers.eq((int)2));
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)3));
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.times((int)1))).getFactMappingValue((FactMapping)Matchers.eq((Object)this.factMappingMock));
        ((CommonOnMoveHandler)Mockito.verify((Object)this.commonOnMoveHandler, (VerificationMode)Mockito.times((int)1))).retrieveCellMiddleXYPosition((GridColumn)this.gridColumnMock, 2);
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorReason()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithError("raw", "error")), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.keep()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.apply()), (Command)Matchers.isA(Command.class), Matchers.eq((int)((int)((double)TestProperties.DX.intValue() - TestProperties.CELL_WIDTH / 2.0))), ((Integer)Matchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.LEFT));
    }

    @Test
    public void manageBodyCoordinates_NullValues() {
        Mockito.when((Object)this.factMappingValueMock.getRawValue()).thenReturn(null);
        Mockito.when((Object)this.factMappingValueMock.getErrorValue()).thenReturn(null);
        this.commonOnMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getScenarioByIndex(Matchers.eq((int)2));
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)3));
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.times((int)1))).getFactMappingValue((FactMapping)Matchers.eq((Object)this.factMappingMock));
        ((CommonOnMoveHandler)Mockito.verify((Object)this.commonOnMoveHandler, (VerificationMode)Mockito.times((int)1))).retrieveCellMiddleXYPosition((GridColumn)this.gridColumnMock, 2);
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorReason()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithError("null", "null")), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.keep()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.apply()), (Command)Matchers.isA(Command.class), Matchers.eq((int)((int)(TestProperties.CELL_WIDTH / 2.0) + TestProperties.DX)), ((Integer)Matchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.RIGHT));
    }

    @Test
    public void manageBodyCoordinates_Exception() {
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION);
        Mockito.when((Object)this.factMappingValueMock.getExceptionMessage()).thenReturn((Object)"GenericException");
        this.commonOnMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getScenarioByIndex(Matchers.eq((int)2));
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)3));
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.times((int)1))).getFactMappingValue((FactMapping)Matchers.eq((Object)this.factMappingMock));
        ((CommonOnMoveHandler)Mockito.verify((Object)this.commonOnMoveHandler, (VerificationMode)Mockito.times((int)1))).retrieveCellMiddleXYPosition((GridColumn)this.gridColumnMock, 2);
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorReason()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithException("GenericException")), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.close()), Matchers.eq((int)((int)(TestProperties.CELL_WIDTH / 2.0) + TestProperties.DX)), ((Integer)Matchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.RIGHT));
    }

    @Test
    public void manageBodyCoordinates_WithScroll() {
        Mockito.when((Object)this.elementMock.getScrollTop()).thenReturn((Object)TestProperties.SCROLL_TOP);
        Mockito.when((Object)this.elementMock.getScrollLeft()).thenReturn((Object)TestProperties.SCROLL_LEFT);
        this.commonOnMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getScenarioByIndex(Matchers.eq((int)2));
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)3));
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.times((int)1))).getFactMappingValue((FactMapping)Matchers.eq((Object)this.factMappingMock));
        ((CommonOnMoveHandler)Mockito.verify((Object)this.commonOnMoveHandler, (VerificationMode)Mockito.times((int)1))).retrieveCellMiddleXYPosition((GridColumn)this.gridColumnMock, 2);
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorReason()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithError("raw", "error")), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.keep()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.apply()), (Command)Matchers.isA(Command.class), Matchers.eq((int)((int)(TestProperties.CELL_WIDTH / 2.0 + (double)TestProperties.DX.intValue()) - TestProperties.SCROLL_LEFT)), Matchers.eq((int)(TestProperties.DY - TestProperties.SCROLL_TOP)), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.RIGHT));
    }

    @Test
    public void manageBodyCoordinates_NoError() {
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.SUCCESS);
        this.commonOnMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getScenarioByIndex(Matchers.eq((int)2));
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)3));
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.times((int)1))).getFactMappingValue((FactMapping)Matchers.eq((Object)this.factMappingMock));
        ((CommonOnMoveHandler)Mockito.verify((Object)this.commonOnMoveHandler, (VerificationMode)Mockito.never())).retrieveCellMiddleXYPosition((GridColumn)Matchers.any(), ((Integer)Matchers.isA(Integer.class)).intValue());
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.never())).show((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (Command)Matchers.any(), ((Integer)Matchers.isA(Integer.class)).intValue(), ((Integer)Matchers.isA(Integer.class)).intValue(), (PopoverView.Position)Matchers.any());
    }

    @Test
    public void manageBodyCoordinates_sameCellAndIsShown() {
        this.commonOnMoveHandler = (CommonOnMoveHandler)Mockito.spy((Object)new CommonOnMoveHandler(){
            {
                this.currentlyShownBodyColumnIndex = 0;
                this.currentlyShownBodyRowIndex = 0;
                this.errorReportPopupPresenter = CommonOnMoveHandlerTest.this.errorReportPopupPresenterMock;
                this.scenarioGrid = CommonOnMoveHandlerTest.this.scenarioGridMock;
            }
        });
        Mockito.when((Object)this.errorReportPopupPresenterMock.isShown()).thenReturn((Object)Boolean.TRUE);
        this.commonOnMoveHandler.manageBodyCoordinates(Integer.valueOf(0), Integer.valueOf(0));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.never())).getScenarioByIndex(((Integer)Matchers.isA(Integer.class)).intValue());
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.never())).getFactMappingByIndex(((Integer)Matchers.isA(Integer.class)).intValue());
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.never())).getFactMappingValue((FactMapping)Matchers.any());
        ((CommonOnMoveHandler)Mockito.verify((Object)this.commonOnMoveHandler, (VerificationMode)Mockito.never())).retrieveCellMiddleXYPosition((GridColumn)Matchers.any(), ((Integer)Matchers.isA(Integer.class)).intValue());
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.never())).show((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (Command)Matchers.any(), ((Integer)Matchers.isA(Integer.class)).intValue(), ((Integer)Matchers.isA(Integer.class)).intValue(), (PopoverView.Position)Matchers.any());
    }

    @Test
    public void manageBodyCoordinates_sameCellAndIsNotShown() {
        this.commonOnMoveHandler = (CommonOnMoveHandler)Mockito.spy((Object)new CommonOnMoveHandler(){
            {
                this.currentlyShownBodyColumnIndex = 3;
                this.currentlyShownBodyRowIndex = 2;
                this.errorReportPopupPresenter = CommonOnMoveHandlerTest.this.errorReportPopupPresenterMock;
                this.scenarioGrid = CommonOnMoveHandlerTest.this.scenarioGridMock;
                this.scenarioGridPanel = CommonOnMoveHandlerTest.this.scenarioGridPanelMock;
            }

            protected Point2D retrieveCellMiddleXYPosition(GridColumn<?> column, int uiRowIndex) {
                return new Point2D((double)TestProperties.DX.intValue(), (double)TestProperties.DY.intValue());
            }

            protected Point2D convertDOMToGridCoordinateLocal(double canvasX, double canvasY) {
                return new Point2D((double)TestProperties.MX.intValue(), (double)TestProperties.MY.intValue());
            }
        });
        this.commonOnMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getScenarioByIndex(Matchers.eq((int)2));
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)3));
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.times((int)1))).getFactMappingValue((FactMapping)Matchers.eq((Object)this.factMappingMock));
        ((CommonOnMoveHandler)Mockito.verify((Object)this.commonOnMoveHandler, (VerificationMode)Mockito.times((int)1))).retrieveCellMiddleXYPosition((GridColumn)this.gridColumnMock, 2);
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorReason()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithError("raw", "error")), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.keep()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.apply()), (Command)Matchers.isA(Command.class), Matchers.eq((int)((int)(TestProperties.CELL_WIDTH / 2.0) + TestProperties.DX)), ((Integer)Matchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.RIGHT));
    }

    @Test
    public void manageBodyCoordinates_awayFromGrid() {
        this.commonOnMoveHandler = (CommonOnMoveHandler)Mockito.spy((Object)new CommonOnMoveHandler(){
            {
                this.currentlyShownBodyColumnIndex = 0;
                this.currentlyShownBodyRowIndex = 0;
                this.errorReportPopupPresenter = CommonOnMoveHandlerTest.this.errorReportPopupPresenterMock;
                this.scenarioGrid = CommonOnMoveHandlerTest.this.scenarioGridMock;
            }
        });
        boolean inGrid = this.commonOnMoveHandler.manageBodyCoordinates(Integer.valueOf(-1), Integer.valueOf(-1));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.never())).getScenarioByIndex(((Integer)Matchers.isA(Integer.class)).intValue());
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.never())).getFactMappingByIndex(((Integer)Matchers.isA(Integer.class)).intValue());
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.never())).getFactMappingValue((FactMapping)Matchers.any());
        ((CommonOnMoveHandler)Mockito.verify((Object)this.commonOnMoveHandler, (VerificationMode)Mockito.never())).retrieveCellMiddleXYPosition((GridColumn)Matchers.any(), ((Integer)Matchers.isA(Integer.class)).intValue());
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.never())).show((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (Command)Matchers.any(), ((Integer)Matchers.isA(Integer.class)).intValue(), ((Integer)Matchers.isA(Integer.class)).intValue(), (PopoverView.Position)Matchers.any());
        Assert.assertFalse((boolean)inGrid);
    }

    @Test
    public void manageBodyCoordinates_notInGrid() {
        boolean inGrid = this.commonOnMoveHandler.manageBodyCoordinates(Integer.valueOf(-1), Integer.valueOf(-1));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.never())).getScenarioByIndex(((Integer)Matchers.isA(Integer.class)).intValue());
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.never())).getFactMappingByIndex(((Integer)Matchers.isA(Integer.class)).intValue());
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.never())).getFactMappingValue((FactMapping)Matchers.any());
        ((CommonOnMoveHandler)Mockito.verify((Object)this.commonOnMoveHandler, (VerificationMode)Mockito.never())).retrieveCellMiddleXYPosition((GridColumn)Matchers.any(), ((Integer)Matchers.isA(Integer.class)).intValue());
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.never())).show((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (Command)Matchers.any(), ((Integer)Matchers.isA(Integer.class)).intValue(), ((Integer)Matchers.isA(Integer.class)).intValue(), (PopoverView.Position)Matchers.any());
        Assert.assertFalse((boolean)inGrid);
    }

    @Test
    public void hidePopover() {
        this.commonOnMoveHandler.hidePopover();
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).hide();
    }
}

