/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.SimpleClassEntry;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.kie.soup.project.datamodel.oracle.ModelField;

public abstract class AbstractDMODataManagementStrategy
extends AbstractDataManagementStrategy {
    protected String packageName = "";

    protected abstract String getFQCNByFactName(String var1);

    protected abstract String getParametricFieldType(String var1, String var2);

    protected abstract List<String> getFactTypes();

    protected abstract boolean skipPopulateTestTools();

    protected abstract void manageDataObjects(List<String> var1, TestToolsView.Presenter var2, int var3, SortedMap<String, FactModelTree> var4, ScenarioSimulationContext var5, List<String> var6);

    @Override
    public void populateTestTools(TestToolsView.Presenter testToolsPresenter, ScenarioSimulationContext context) {
        if (this.factModelTreeHolder.getFactModelTuple() != null) {
            this.storeData(this.factModelTreeHolder.getFactModelTuple(), testToolsPresenter, context);
        } else {
            if (this.skipPopulateTestTools()) {
                return;
            }
            List<String> factTypes = this.getFactTypes();
            Map<Boolean, List<String>> partitionedFactTypes = factTypes.stream().collect(Collectors.partitioningBy(factType -> SIMPLE_CLASSES_MAP.keySet().contains(factType)));
            List<String> dataObjectsTypes = partitionedFactTypes.get(false);
            List<String> simpleJavaTypes = partitionedFactTypes.get(true);
            int expectedElements = dataObjectsTypes.size();
            TreeMap<String, FactModelTree> dataObjectsFieldsMap = new TreeMap<String, FactModelTree>();
            if (dataObjectsTypes.isEmpty()) {
                this.aggregatorCallbackMethod(testToolsPresenter, expectedElements, dataObjectsFieldsMap, context, null, simpleJavaTypes);
            } else {
                this.manageDataObjects(dataObjectsTypes, testToolsPresenter, expectedElements, dataObjectsFieldsMap, context, simpleJavaTypes);
            }
        }
    }

    public FactModelTree getFactModelTree(String factName, ModelField[] modelFields) {
        HashMap<String, String> simpleProperties = new HashMap<String, String>();
        HashMap<String, List<String>> genericTypesMap = new HashMap<String, List<String>>();
        String factPackageName = this.packageName;
        String fullFactClassName = this.getFQCNByFactName(factName);
        if (fullFactClassName != null && fullFactClassName.contains(".")) {
            factPackageName = fullFactClassName.substring(0, fullFactClassName.lastIndexOf("."));
        }
        for (ModelField modelField : modelFields) {
            if (modelField.getName().equals("this")) continue;
            String className = SIMPLE_CLASSES_MAP.containsKey(modelField.getClassName()) ? ((SimpleClassEntry)SIMPLE_CLASSES_MAP.get(modelField.getClassName())).getCanonicalName() : modelField.getClassName();
            simpleProperties.put(modelField.getName(), className);
            if (!ScenarioSimulationSharedUtils.isCollection((String)className)) continue;
            this.populateGenericTypeMap(genericTypesMap, factName, modelField.getName(), ScenarioSimulationSharedUtils.isList((String)className));
        }
        return new FactModelTree(factName, factPackageName, simpleProperties, genericTypesMap);
    }

    public void populateGenericTypeMap(Map<String, List<String>> toPopulate, String factName, String propertyName, boolean isList) {
        ArrayList<String> genericTypes = new ArrayList<String>();
        if (!isList) {
            genericTypes.add(String.class.getName());
        }
        String genericInfo = this.getParametricFieldType(factName, propertyName);
        String fullGenericInfoClassName = this.getFQCNByFactName(genericInfo);
        genericTypes.add(fullGenericInfoClassName);
        toPopulate.put(propertyName, genericTypes);
    }

    public void aggregatorCallbackMethod(TestToolsView.Presenter testToolsPresenter, int expectedElements, SortedMap<String, FactModelTree> factTypeFieldsMap, ScenarioSimulationContext context, FactModelTree result, List<String> simpleJavaTypes) {
        if (result != null) {
            factTypeFieldsMap.put(result.getFactName(), result);
        }
        if (factTypeFieldsMap.size() == expectedElements) {
            factTypeFieldsMap.values().forEach(factModelTree -> this.populateFactModelTree((FactModelTree)factModelTree, factTypeFieldsMap));
            TreeMap<String, FactModelTree> simpleJavaTypeFieldsMap = new TreeMap<String, FactModelTree>(simpleJavaTypes.stream().collect(Collectors.toMap(factType -> factType, factType -> {
                SimpleClassEntry classEntry = (SimpleClassEntry)SIMPLE_CLASSES_MAP.get(factType);
                return AbstractDMODataManagementStrategy.getSimpleClassFactModelTree(classEntry.getSimpleName(), classEntry.getCanonicalName());
            })));
            TreeMap<String, FactModelTree> visibleFacts = new TreeMap<String, FactModelTree>(factTypeFieldsMap);
            visibleFacts.putAll(simpleJavaTypeFieldsMap);
            FactModelTuple factModelTuple = new FactModelTuple(visibleFacts, new TreeMap());
            this.factModelTreeHolder.setFactModelTuple(factModelTuple);
            this.storeData(factModelTuple, testToolsPresenter, context);
        }
    }

    public void populateFactModelTree(FactModelTree toPopulate, SortedMap<String, FactModelTree> factTypeFieldsMap) {
        ArrayList toRemove = new ArrayList();
        toPopulate.getSimpleProperties().forEach((key, value) -> {
            if (factTypeFieldsMap.containsKey(value)) {
                toRemove.add(key);
                toPopulate.addExpandableProperty(key, ((FactModelTree)factTypeFieldsMap.get(value)).getFactName());
            }
        });
        toRemove.forEach(arg_0 -> ((FactModelTree)toPopulate).removeSimpleProperty(arg_0));
    }
}

