/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.SettingsScenarioSimulationDropdown;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractSubDockPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.mvp.Command;

@ApplicationScoped
@WorkbenchScreen(identifier="org.drools.scenariosimulation.Settings", preferredWidth=300)
public class SettingsPresenter
extends AbstractSubDockPresenter<SettingsView>
implements SettingsView.Presenter {
    public static final int DEFAULT_PREFERRED_WIDHT = 300;
    public static final String IDENTIFIER = "org.drools.scenariosimulation.Settings";
    protected SimulationDescriptor simulationDescriptor;
    protected Command saveCommand;
    protected SettingsScenarioSimulationDropdown settingsScenarioSimulationDropdown;
    protected boolean saveEnabled = true;

    public SettingsPresenter() {
        this.title = ScenarioSimulationEditorConstants.INSTANCE.settings();
    }

    @Inject
    public SettingsPresenter(@Named(value="SettingsDropdown") SettingsScenarioSimulationDropdown settingsScenarioSimulationDropdown, SettingsView view) {
        super(view);
        this.title = ScenarioSimulationEditorConstants.INSTANCE.settings();
        this.settingsScenarioSimulationDropdown = settingsScenarioSimulationDropdown;
    }

    @PostConstruct
    public void init() {
        ((SettingsView)this.view).getSkipFromBuildLabel().setInnerText(ScenarioSimulationEditorConstants.INSTANCE.skipSimulation());
        ((SettingsView)this.view).setupDropdown((Element)this.settingsScenarioSimulationDropdown.asWidget().asWidget().getElement());
        this.settingsScenarioSimulationDropdown.init();
    }

    @Override
    public void setScenarioType(ScenarioSimulationModel.Type scenarioType, SimulationDescriptor simulationDescriptor, String fileName) {
        this.simulationDescriptor = simulationDescriptor;
        ((SettingsView)this.view).getScenarioType().setInnerText(scenarioType.name());
        ((SettingsView)this.view).getFileName().setValue(fileName);
        ((SettingsView)this.view).getSkipFromBuild().setChecked(simulationDescriptor.isSkipFromBuild());
        ((SettingsView)this.view).getSaveButton().setDisabled(false);
        switch (scenarioType) {
            case RULE: {
                this.setRuleSettings(simulationDescriptor);
                break;
            }
            case DMN: {
                this.setDMNSettings(simulationDescriptor);
                break;
            }
        }
    }

    @Override
    public void setSaveCommand(Command saveCommand) {
        this.saveCommand = saveCommand;
    }

    @Override
    public void setSaveEnabled(boolean toSet) {
        this.saveEnabled = toSet;
        if (!this.saveEnabled) {
            ((SettingsView)this.view).removeSaveButton();
        } else {
            ((SettingsView)this.view).restoreSaveButton();
        }
    }

    @Override
    public void onSaveButton(String scenarioType) {
        if (this.saveCommand != null) {
            this.simulationDescriptor.setSkipFromBuild(((SettingsView)this.view).getSkipFromBuild().isChecked());
            switch (ScenarioSimulationModel.Type.valueOf((String)scenarioType)) {
                case RULE: {
                    this.saveRuleSettings();
                    break;
                }
                case DMN: {
                    this.saveDMNSettings();
                    break;
                }
            }
            this.saveCommand.execute();
        }
    }

    @Override
    public void reset() {
        ((SettingsView)this.view).reset();
        if (!this.saveEnabled) {
            ((SettingsView)this.view).removeSaveButton();
        }
        this.settingsScenarioSimulationDropdown.clear();
    }

    public boolean isSaveEnabled() {
        return this.saveEnabled;
    }

    public SettingsView getView() {
        return (SettingsView)this.view;
    }

    protected void setRuleSettings(SimulationDescriptor simulationDescriptor) {
        ((SettingsView)this.view).getDmnSettings().getStyle().setDisplay(Style.Display.NONE);
        ((SettingsView)this.view).getRuleSettings().getStyle().setDisplay(Style.Display.INLINE);
        ((SettingsView)this.view).getDmoSession().setValue(Optional.ofNullable(simulationDescriptor.getDmoSession()).orElse(""));
        ((SettingsView)this.view).getRuleFlowGroup().setValue(Optional.ofNullable(simulationDescriptor.getRuleFlowGroup()).orElse(""));
        ((SettingsView)this.view).getStateless().setChecked(simulationDescriptor.isStateless());
    }

    protected void setDMNSettings(SimulationDescriptor simulationDescriptor) {
        ((SettingsView)this.view).getRuleSettings().getStyle().setDisplay(Style.Display.NONE);
        ((SettingsView)this.view).getDmnSettings().getStyle().setDisplay(Style.Display.INLINE);
        ((SettingsView)this.view).getDmnName().setValue(Optional.ofNullable(simulationDescriptor.getDmnName()).orElse(""));
        ((SettingsView)this.view).getDmnNamespace().setValue(Optional.ofNullable(simulationDescriptor.getDmnNamespace()).orElse(""));
        ((SettingsView)this.view).getDmnFilePathErrorLabel().getStyle().setDisplay(Style.Display.NONE);
        ((SettingsView)this.view).getDmnFilePathErrorLabel().setInnerText("");
        this.settingsScenarioSimulationDropdown.registerOnMissingValueHandler(this::setDmnErrorPath);
        this.settingsScenarioSimulationDropdown.registerOnChangeHandler(this::validateDmnPath);
        this.settingsScenarioSimulationDropdown.loadAssets(simulationDescriptor.getDmnFilePath());
    }

    protected void saveRuleSettings() {
        this.simulationDescriptor.setDmoSession(this.getCleanValue(() -> ((SettingsView)this.view).getDmoSession().getValue()));
        this.simulationDescriptor.setRuleFlowGroup(this.getCleanValue(() -> ((SettingsView)this.view).getRuleFlowGroup().getValue()));
        this.simulationDescriptor.setStateless(((SettingsView)this.view).getStateless().isChecked());
    }

    protected void saveDMNSettings() {
        String value = this.settingsScenarioSimulationDropdown.getValue().map(KieAssetsDropdownItem::getValue).orElse("");
        this.simulationDescriptor.setDmnFilePath(this.getCleanValue(() -> value));
    }

    protected void setDmnErrorPath() {
        ((SettingsView)this.view).getDmnFilePathErrorLabel().getStyle().setDisplay(Style.Display.INLINE);
        ((SettingsView)this.view).getDmnFilePathErrorLabel().setInnerText(ScenarioSimulationEditorConstants.INSTANCE.dmnPathErrorLabel(this.simulationDescriptor.getDmnFilePath()));
        ((SettingsView)this.view).getSaveButton().setDisabled(true);
    }

    protected void validateDmnPath() {
        boolean isValid;
        Optional value = this.settingsScenarioSimulationDropdown.getValue();
        String selectedPath = value.map(KieAssetsDropdownItem::getValue).orElse(null);
        boolean bl = isValid = selectedPath != null && !selectedPath.isEmpty();
        if (!isValid) {
            ((SettingsView)this.view).getDmnFilePathErrorLabel().getStyle().setDisplay(Style.Display.INLINE);
            ((SettingsView)this.view).getDmnFilePathErrorLabel().setInnerText(ScenarioSimulationEditorConstants.INSTANCE.chooseValidDMNAsset());
            ((SettingsView)this.view).getSaveButton().setDisabled(true);
        } else {
            ((SettingsView)this.view).getDmnFilePathErrorLabel().getStyle().setDisplay(Style.Display.NONE);
            ((SettingsView)this.view).getDmnFilePathErrorLabel().setInnerText("");
            ((SettingsView)this.view).getSaveButton().setDisabled(false);
        }
    }

    private String getCleanValue(Supplier<String> supplier) {
        String rawValue = supplier.get();
        return "".equals(rawValue) ? null : rawValue;
    }
}

