/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.i18n.client.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimDataWithIndex;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractSubDockPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageReportDonutPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageReportView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageScenarioListPresenter;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.mvp.Command;

@ApplicationScoped
@WorkbenchScreen(identifier="org.drools.scenariosimulation.CoverageReport", preferredWidth=300)
public class CoverageReportPresenter
extends AbstractSubDockPresenter<CoverageReportView>
implements CoverageReportView.Presenter {
    public static final int DEFAULT_PREFERRED_WIDHT = 300;
    private static final NumberFormat numberFormat = NumberFormat.getFormat((String)"00.00");
    public static final String IDENTIFIER = "org.drools.scenariosimulation.CoverageReport";
    protected CoverageReportDonutPresenter coverageReportDonutPresenter;
    protected CoverageElementPresenter coverageElementPresenter;
    protected CoverageScenarioListPresenter coverageScenarioListPresenter;
    protected Command downloadReportCommand;

    public CoverageReportPresenter() {
        this.title = ScenarioSimulationEditorConstants.INSTANCE.coverageReport();
    }

    @Inject
    public CoverageReportPresenter(CoverageReportView view, CoverageReportDonutPresenter coverageReportDonutPresenter, CoverageElementPresenter coverageElementPresenter, CoverageScenarioListPresenter coverageScenarioListPresenter) {
        super(view);
        this.title = ScenarioSimulationEditorConstants.INSTANCE.coverageReport();
        this.coverageReportDonutPresenter = coverageReportDonutPresenter;
        this.coverageElementPresenter = coverageElementPresenter;
        this.coverageScenarioListPresenter = coverageScenarioListPresenter;
    }

    @PostConstruct
    public void init() {
        this.coverageReportDonutPresenter.init(((CoverageReportView)this.view).getDonutChart());
        this.coverageElementPresenter.initElementList(((CoverageReportView)this.view).getList());
        this.coverageScenarioListPresenter.initScenarioList(((CoverageReportView)this.view).getScenarioList());
        this.resetDownload();
    }

    @Override
    public void reset() {
        ((CoverageReportView)this.view).reset();
        this.resetDownload();
    }

    @Override
    public void populateCoverageReport(ScenarioSimulationModel.Type type, SimulationRunMetadata simulationRunMetadata) {
        if (simulationRunMetadata != null) {
            this.setSimulationRunMetadata(simulationRunMetadata, type);
        } else {
            this.showEmptyStateMessage();
        }
    }

    @Override
    public void onDownloadReportButtonClicked() {
        if (this.downloadReportCommand != null) {
            this.downloadReportCommand.execute();
        }
    }

    @Override
    public void setDownloadReportCommand(Command downloadReportCommand) {
        this.downloadReportCommand = downloadReportCommand;
        ((CoverageReportView)this.view).getDownloadReportButton().disabled = this.downloadReportCommand == null;
    }

    protected void setSimulationRunMetadata(SimulationRunMetadata simulationRunMetadata, ScenarioSimulationModel.Type type) {
        if (simulationRunMetadata.getAvailable() == 0) {
            String messageToShow = ScenarioSimulationModel.Type.DMN.equals((Object)type) ? ScenarioSimulationEditorConstants.INSTANCE.noDecisionsAvailable() : ScenarioSimulationEditorConstants.INSTANCE.noRulesAvailable();
            ((CoverageReportView)this.view).setEmptyStatusText(messageToShow);
            ((CoverageReportView)this.view).hide();
            return;
        }
        ((CoverageReportView)this.view).initText(type);
        this.populateSummary(simulationRunMetadata.getAvailable(), simulationRunMetadata.getExecuted(), simulationRunMetadata.getCoveragePercentage());
        this.populateList(simulationRunMetadata.getOutputCounter());
        this.populateScenarioList(simulationRunMetadata.getScenarioCounter(), type);
        ((CoverageReportView)this.view).show();
    }

    protected void resetDownload() {
        this.downloadReportCommand = null;
        ((CoverageReportView)this.view).getDownloadReportButton().disabled = true;
    }

    protected void showEmptyStateMessage() {
        ((CoverageReportView)this.view).setEmptyStatusText(ScenarioSimulationEditorConstants.INSTANCE.runATestToSeeCoverageReport());
        ((CoverageReportView)this.view).hide();
    }

    protected void populateSummary(int available, int executed, double coveragePercentage) {
        ((CoverageReportView)this.view).setReportAvailable(available + "");
        ((CoverageReportView)this.view).setReportExecuted(executed + "");
        String coveragePercentageFormatted = numberFormat.format(coveragePercentage);
        ((CoverageReportView)this.view).setReportCoverage(coveragePercentageFormatted + "%");
        this.coverageReportDonutPresenter.showCoverageReport(executed, available - executed);
    }

    protected void populateList(Map<String, Integer> outputCounter) {
        this.coverageElementPresenter.clear();
        ArrayList<String> elements = new ArrayList<String>(outputCounter.keySet());
        elements.sort(Comparator.naturalOrder());
        for (String element : elements) {
            this.coverageElementPresenter.addElementView(element, outputCounter.get(element) + "");
        }
    }

    protected void populateScenarioList(Map<ScenarioWithIndex, Map<String, Integer>> scenarioCounter, ScenarioSimulationModel.Type type) {
        this.coverageScenarioListPresenter.clear();
        ArrayList<ScenarioWithIndex> scenarioIndexes = new ArrayList<ScenarioWithIndex>(scenarioCounter.keySet());
        scenarioIndexes.sort(Comparator.comparingInt(ScesimDataWithIndex::getIndex));
        for (ScenarioWithIndex scenarioWithIndex : scenarioIndexes) {
            this.coverageScenarioListPresenter.addScesimDataGroup(scenarioWithIndex, scenarioCounter.get(scenarioWithIndex), type);
        }
    }
}

