/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.SettingsScenarioSimulationDropdown;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractSettingsTest;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class SettingsPresenterTest
extends AbstractSettingsTest {
    private SettingsPresenter settingsPresenter;
    @Mock
    private Command saveCommandMock;
    @Mock
    private SettingsScenarioSimulationDropdown settingsScenarioSimulationDropdownMock;
    protected Settings settingsSpy;

    @Override
    @Before
    public void setup() {
        super.setup();
        Settings settings = new Settings();
        settings.setRuleFlowGroup("RULE_FLOW_GROUP");
        settings.setDmoSession("DMO_SESSION");
        settings.setDmnFilePath("DMN_FILE_PATH");
        settings.setDmnNamespace("DMN_NAMESPACE");
        settings.setDmnName("DMN_NAME");
        settings.setStateless(true);
        settings.setSkipFromBuild(true);
        this.settingsSpy = (Settings)Mockito.spy((Object)settings);
        KieAssetsDropdownItem item = new KieAssetsDropdownItem("DMNFile", "", "DMN_FILE_PATH", null);
        Mockito.when((Object)this.settingsScenarioSimulationDropdownMock.getValue()).thenReturn(Optional.of(item));
        this.settingsPresenter = (SettingsPresenter)Mockito.spy((Object)new SettingsPresenter(this.settingsScenarioSimulationDropdownMock, this.settingsViewMock){
            {
                this.settings = SettingsPresenterTest.this.settingsSpy;
                this.settingsScenarioSimulationDropdown = SettingsPresenterTest.this.settingsScenarioSimulationDropdownMock;
                this.saveCommand = SettingsPresenterTest.this.saveCommandMock;
            }
        });
    }

    @Test
    public void onSetup() {
        this.settingsPresenter.setup();
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).init((Object)this.settingsPresenter);
    }

    @Test
    public void getTitle() {
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.settings(), (Object)this.settingsPresenter.getTitle());
    }

    @Test
    public void setScenarioTypeRULESkipTrue() {
        this.settingsSpy.setSkipFromBuild(true);
        this.settingsPresenter.setScenarioType(ScenarioSimulationModel.Type.RULE, this.settingsSpy, "FILE_NAME");
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE.name()));
        ((InputElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)true));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).setRuleSettings(this.settingsSpy);
    }

    @Test
    public void setScenarioTypeRULESkipFalse() {
        this.settingsSpy.setSkipFromBuild(false);
        this.settingsPresenter.setScenarioType(ScenarioSimulationModel.Type.RULE, this.settingsSpy, "FILE_NAME");
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE.name()));
        ((InputElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)false));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).setRuleSettings(this.settingsSpy);
    }

    @Test
    public void setScenarioTypeDMNSkipTrue() {
        this.settingsSpy.setSkipFromBuild(true);
        this.settingsPresenter.setScenarioType(ScenarioSimulationModel.Type.DMN, this.settingsSpy, "FILE_NAME");
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN.name()));
        ((InputElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)true));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).setDMNSettings(this.settingsSpy);
    }

    @Test
    public void setScenarioTypeDMNSkipFalse() {
        this.settingsSpy.setSkipFromBuild(false);
        this.settingsPresenter.setScenarioType(ScenarioSimulationModel.Type.DMN, this.settingsSpy, "FILE_NAME");
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN.name()));
        ((InputElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)false));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).setDMNSettings(this.settingsSpy);
    }

    @Test
    public void setRuleSettings() {
        this.settingsPresenter.setRuleSettings(this.settingsSpy);
        ((Style)Mockito.verify((Object)this.dmnSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((Style)Mockito.verify((Object)this.ruleSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((InputElement)Mockito.verify((Object)this.dmoSessionMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"DMO_SESSION"));
        ((InputElement)Mockito.verify((Object)this.ruleFlowGroupMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"RULE_FLOW_GROUP"));
        ((InputElement)Mockito.verify((Object)this.statelessMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)this.settingsSpy.isStateless()));
    }

    @Test
    public void setDMNSettings() {
        this.settingsPresenter.setDMNSettings(this.settingsSpy);
        ((Style)Mockito.verify((Object)this.ruleSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((Style)Mockito.verify((Object)this.dmnSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((InputElement)Mockito.verify((Object)this.dmnNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"DMN_NAME"));
        ((InputElement)Mockito.verify((Object)this.dmnNamespaceMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"DMN_NAMESPACE"));
        ((Style)Mockito.verify((Object)this.dmnFilePathErrorLabelStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((SpanElement)Mockito.verify((Object)this.dmnFilePathErrorLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)""));
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).registerOnMissingValueHandler((Command)Matchers.isA(Command.class));
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).registerOnChangeHandler((Command)Matchers.isA(Command.class));
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).loadAssets((String)Matchers.eq((Object)"DMN_FILE_PATH"));
    }

    @Test
    public void resetTest() {
        this.settingsPresenter.reset();
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).reset();
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void setDmnErrorPath() {
        this.settingsPresenter.setDmnErrorPath();
        ((Style)Mockito.verify((Object)this.dmnFilePathErrorLabelStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((SpanElement)Mockito.verify((Object)this.dmnFilePathErrorLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.dmnPathErrorLabel(this.settingsSpy.getDmnFilePath())));
    }

    @Test
    public void validateDmnPath_Valid() {
        this.settingsPresenter.validateDmnPath();
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)2))).getValue();
        ((Style)Mockito.verify((Object)this.dmnFilePathErrorLabelStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((SpanElement)Mockito.verify((Object)this.dmnFilePathErrorLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)""));
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setDmnFilePath("DMN_FILE_PATH");
    }

    @Test
    public void validateDmnPath_Invalid() {
        KieAssetsDropdownItem item = new KieAssetsDropdownItem("DMNFile", "", "", null);
        Mockito.when((Object)this.settingsScenarioSimulationDropdownMock.getValue()).thenReturn(Optional.of(item));
        this.settingsPresenter.validateDmnPath();
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).getValue();
        ((Style)Mockito.verify((Object)this.dmnFilePathErrorLabelStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((SpanElement)Mockito.verify((Object)this.dmnFilePathErrorLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.chooseValidDMNAsset()));
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.never())).setDmnFilePath(Matchers.anyString());
    }

    @Test
    public void syncDmoSession() {
        this.settingsPresenter.syncDmoSession();
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setDmoSession((String)Matchers.eq((Object)"DMO_SESSION"));
    }

    @Test
    public void syncRuleFlowGroup() {
        this.settingsPresenter.syncRuleFlowGroup();
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setRuleFlowGroup((String)Matchers.eq((Object)"RULE_FLOW_GROUP"));
    }

    @Test
    public void syncStateless() {
        this.settingsPresenter.syncStateless();
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setStateless(Matchers.eq((boolean)true));
    }

    @Test
    public void syncDmnFilePath() {
        this.settingsPresenter.syncDmnFilePath();
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setDmnFilePath((String)Matchers.eq((Object)"DMN_FILE_PATH"));
    }

    @Test
    public void syncSkipFromBuild() {
        this.settingsPresenter.syncSkipFromBuild();
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setSkipFromBuild(Matchers.eq((boolean)true));
    }
}

