/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionEditorUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class CollectionEditorUtilsTest {
    @Mock
    private SpanElement faAngleRightMock;
    @Mock
    private LIElement liElementMock;
    @Mock
    private Style styleMock;

    @Before
    public void setup() {
        Mockito.when((Object)this.liElementMock.getStyle()).thenReturn((Object)this.styleMock);
    }

    @Test
    public void toggleRowExpansionToExpandTrueSpanElement() {
        this.commonToggleRowExpansionSpanElement(true);
    }

    @Test
    public void toggleRowExpansionToExpandFalseSpanElement() {
        this.commonToggleRowExpansionSpanElement(false);
    }

    @Test
    public void toggleRowExpansionToExpandTrueLIElement() {
        this.commonToggleRowExpansionLIElement(true);
    }

    @Test
    public void toggleRowExpansionToExpandFalseLIElement() {
        this.commonToggleRowExpansionLIElement(false);
    }

    @Test
    public void setSpanAttributeAttributes() {
        String dataI18nKey = "DATA_I18N_KEY";
        String innerText = "INNER_TEXT";
        String dataField = "DATA_FIELD";
        CollectionEditorUtils.setSpanAttributeAttributes((String)dataI18nKey, (String)innerText, (String)dataField, (SpanElement)this.faAngleRightMock);
        ((SpanElement)Mockito.verify((Object)this.faAngleRightMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)innerText));
        ((SpanElement)Mockito.verify((Object)this.faAngleRightMock, (VerificationMode)Mockito.times((int)1))).setAttribute((String)Matchers.eq((Object)"data-i18n-key"), (String)Matchers.eq((Object)dataI18nKey));
        ((SpanElement)Mockito.verify((Object)this.faAngleRightMock, (VerificationMode)Mockito.times((int)1))).setAttribute((String)Matchers.eq((Object)"data-field"), (String)Matchers.eq((Object)dataField));
    }

    private void commonToggleRowExpansionSpanElement(boolean toExpand) {
        CollectionEditorUtils.toggleRowExpansion((SpanElement)this.faAngleRightMock, (boolean)toExpand);
        String classToadd = toExpand ? "fa-angle-down" : "fa-angle-right";
        String classToRemove = toExpand ? "fa-angle-right" : "fa-angle-down";
        ((SpanElement)Mockito.verify((Object)this.faAngleRightMock, (VerificationMode)Mockito.times((int)1))).addClassName(classToadd);
        ((SpanElement)Mockito.verify((Object)this.faAngleRightMock, (VerificationMode)Mockito.times((int)1))).removeClassName(classToRemove);
    }

    private void commonToggleRowExpansionLIElement(boolean isShown) {
        CollectionEditorUtils.toggleRowExpansion((LIElement)this.liElementMock, (boolean)isShown);
        Style.Display displayToSet = isShown ? Style.Display.NONE : Style.Display.BLOCK;
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(displayToSet);
        if (isShown) {
            ((LIElement)Mockito.verify((Object)this.liElementMock, (VerificationMode)Mockito.times((int)1))).addClassName("node-hidden");
        } else {
            ((LIElement)Mockito.verify((Object)this.liElementMock, (VerificationMode)Mockito.times((int)1))).removeClassName("node-hidden");
        }
    }
}

