/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.menu;

import com.google.gwt.dom.client.LIElement;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.web.bindery.event.shared.Event;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.DeleteRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DuplicateRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.InsertRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.RunSingleScenarioEvent;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class GridContextMenuTest {
    @Mock
    private LIElement insertRowAboveLIElementMock;
    @Mock
    private LIElement insertRowBelowLIElementMock;
    @Mock
    private LIElement duplicateRowLIElementMock;
    @Mock
    private LIElement deleteRowLIElementMock;
    @Mock
    private LIElement runSingleScenarioElementMock;
    @Mock
    private LIElement createdElementMock;
    @Mock
    private LIElement gridTitleElementMock;
    private GridContextMenu gridContextMenuSpy;

    @Before
    public void setup() {
        this.gridContextMenuSpy = (GridContextMenu)Mockito.spy((Object)new GridContextMenu(){
            {
                this.insertRowAboveLIElement = GridContextMenuTest.this.insertRowAboveLIElementMock;
                this.insertRowBelowLIElement = GridContextMenuTest.this.insertRowBelowLIElementMock;
                this.duplicateRowLIElement = GridContextMenuTest.this.duplicateRowLIElementMock;
                this.deleteRowLIElement = GridContextMenuTest.this.deleteRowLIElementMock;
                this.runSingleScenarioElement = GridContextMenuTest.this.runSingleScenarioElementMock;
                this.gridTitleElement = GridContextMenuTest.this.gridTitleElementMock;
            }

            public LIElement addExecutableMenuItem(String id, String label, String i18n) {
                return GridContextMenuTest.this.createdElementMock;
            }

            public void mapEvent(LIElement executableMenuItem, Event toBeMapped) {
            }

            protected void updateExecutableMenuItemAttributes(LIElement toUpdate, String id, String label, String i18n) {
            }

            public LIElement addMenuItem(String id, String label, String i18n) {
                return GridContextMenuTest.this.createdElementMock;
            }

            public void removeMenuItem(LIElement toRemove) {
            }

            public void show(GridWidget gridWidget, int mx, int my) {
            }
        });
    }

    @Test
    public void initMenu() {
        this.gridContextMenuSpy.initMenu();
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"gridcontextmenu-insert-row-above"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.insertRowAbove()), (String)Matchers.eq((Object)"insertRowAbove"));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"gridcontextmenu-insert-row-below"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.insertRowBelow()), (String)Matchers.eq((Object)"insertRowBelow"));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"gridcontextmenu-duplicate-row"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.duplicateRow()), (String)Matchers.eq((Object)"duplicateRow"));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"gridcontextmenu-delete-row"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.deleteRow()), (String)Matchers.eq((Object)"deleteRow"));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"gridcontextmenu-run-single-scenario"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.runSingleScenario()), (String)Matchers.eq((Object)"runSingleScenario"));
    }

    @Test
    public void show_Simulation_NullRunScenarioElement() {
        this.gridContextMenuSpy.runSingleScenarioElement = null;
        this.gridContextMenuSpy.show(GridWidget.SIMULATION, 0, 0, 1);
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).show((GridWidget)Matchers.eq((Object)GridWidget.SIMULATION), Matchers.eq((int)0), Matchers.eq((int)0));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowAboveLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowBelowLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.duplicateRowLIElementMock), (Event)Matchers.isA(DuplicateRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.deleteRowLIElementMock), (Event)Matchers.isA(DeleteRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"gridcontextmenu-run-single-scenario"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.runSingleScenario()), (String)Matchers.eq((Object)"runSingleScenario"));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.createdElementMock), (Event)Matchers.isA(RunSingleScenarioEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).updateMenuItemAttributes((LIElement)Matchers.eq((Object)this.gridTitleElementMock), (String)Matchers.eq((Object)"gridcontextmenu-grid-title"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.scenario()), (String)Matchers.eq((Object)"scenario"));
    }

    @Test
    public void show_Simulation_NotNullRunScenarioElement() {
        this.gridContextMenuSpy.show(GridWidget.SIMULATION, 0, 0, 1);
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).show((GridWidget)Matchers.eq((Object)GridWidget.SIMULATION), Matchers.eq((int)0), Matchers.eq((int)0));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowAboveLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowBelowLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.duplicateRowLIElementMock), (Event)Matchers.isA(DuplicateRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.deleteRowLIElementMock), (Event)Matchers.isA(DeleteRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.never())).addExecutableMenuItem((String)Matchers.eq((Object)"gridcontextmenu-run-single-scenario"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.runSingleScenario()), (String)Matchers.eq((Object)"runSingleScenario"));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.runSingleScenarioElementMock), (Event)Matchers.isA(RunSingleScenarioEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).updateMenuItemAttributes((LIElement)Matchers.eq((Object)this.gridTitleElementMock), (String)Matchers.eq((Object)"gridcontextmenu-grid-title"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.scenario()), (String)Matchers.eq((Object)"scenario"));
    }

    @Test
    public void show_Background_NullRunScenarioElement() {
        this.gridContextMenuSpy.runSingleScenarioElement = null;
        this.gridContextMenuSpy.show(GridWidget.BACKGROUND, 0, 0, 1);
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).show((GridWidget)Matchers.eq((Object)GridWidget.BACKGROUND), Matchers.eq((int)0), Matchers.eq((int)0));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowAboveLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowBelowLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.duplicateRowLIElementMock), (Event)Matchers.isA(DuplicateRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.deleteRowLIElementMock), (Event)Matchers.isA(DeleteRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.never())).addExecutableMenuItem((String)Matchers.eq((Object)"gridcontextmenu-run-single-scenario"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.runSingleScenario()), (String)Matchers.eq((Object)"runSingleScenario"));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.never())).mapEvent((LIElement)Matchers.eq((Object)this.createdElementMock), (Event)Matchers.isA(RunSingleScenarioEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.never())).updateMenuItemAttributes((LIElement)Matchers.any(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void show_Background_NotNullRunScenarioElement() {
        this.gridContextMenuSpy.show(GridWidget.BACKGROUND, 0, 0, 1);
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).show((GridWidget)Matchers.eq((Object)GridWidget.BACKGROUND), Matchers.eq((int)0), Matchers.eq((int)0));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowAboveLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowBelowLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.duplicateRowLIElementMock), (Event)Matchers.isA(DuplicateRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.deleteRowLIElementMock), (Event)Matchers.isA(DeleteRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.never())).addExecutableMenuItem((String)Matchers.eq((Object)"gridcontextmenu-run-single-scenario"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.runSingleScenario()), (String)Matchers.eq((Object)"runSingleScenario"));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.never())).mapEvent((LIElement)Matchers.eq((Object)this.createdElementMock), (Event)Matchers.isA(RunSingleScenarioEvent.class));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).updateMenuItemAttributes((LIElement)Matchers.eq((Object)this.gridTitleElementMock), (String)Matchers.eq((Object)"gridcontextmenu-grid-title"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.background()), (String)Matchers.eq((Object)"background"));
    }
}

