/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.AbstractScenarioSimulationEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.models.AbstractScesimGridModel;
import org.drools.workbench.screens.scenariosimulation.client.models.BackgroundGridModel;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenterData;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractDataManagementStrategyTest
extends AbstractScenarioSimulationEditorTest {
    protected AbstractDataManagementStrategy abstractDataManagementStrategySpy;
    @Captor
    ArgumentCaptor<TestToolsPresenterData> testToolsPresenterDataArgumentCaptor;

    @Override
    public void setup() {
        super.setup();
        this.abstractDataManagementStrategySpy = (AbstractDataManagementStrategy)Mockito.spy((Object)new AbstractDataManagementStrategy(){

            public void populateTestTools(TestToolsView.Presenter testToolsPresenter, ScenarioSimulationContext context, GridWidget gridWidget) {
            }

            public void manageScenarioSimulationModelContent(ObservablePath currentPath, ScenarioSimulationModelContent toManage) {
            }

            public boolean isADataType(String value) {
                return false;
            }
        });
    }

    @Test
    public void getSimpleClassFactModelTree() {
        Class[] expectedClazzes;
        for (Class expectedClazz : expectedClazzes = new Class[]{String.class, Boolean.class, Integer.class, Double.class, Number.class}) {
            FactModelTree retrieved = AbstractDataManagementStrategy.getSimpleClassFactModelTree((String)expectedClazz.getSimpleName(), (String)expectedClazz.getCanonicalName());
            Assert.assertNotNull((Object)retrieved);
            String key = expectedClazz.getSimpleName();
            Assert.assertEquals((Object)key, (Object)retrieved.getFactName());
            String fullName = expectedClazz.getCanonicalName();
            String packageName = fullName.substring(0, fullName.lastIndexOf("."));
            Assert.assertEquals((Object)packageName, (Object)retrieved.getFullPackage());
            Map simpleProperties = retrieved.getSimpleProperties();
            Assert.assertNotNull((Object)simpleProperties);
            Assert.assertEquals((long)1L, (long)simpleProperties.size());
            Util.assertTrue((boolean)simpleProperties.containsKey("value"));
            String simplePropertyValue = (String)simpleProperties.get("value");
            Assert.assertNotNull((Object)simplePropertyValue);
            Assert.assertEquals((Object)fullName, (Object)simplePropertyValue);
        }
    }

    @Test
    public void setModel() {
        this.abstractDataManagementStrategySpy.model = null;
        ScenarioSimulationModel modelMock = (ScenarioSimulationModel)Mockito.mock(ScenarioSimulationModel.class);
        this.abstractDataManagementStrategySpy.setModel(modelMock);
        Assert.assertEquals((Object)modelMock, (Object)this.abstractDataManagementStrategySpy.model);
    }

    @Test
    public void getPropertiesToHideMapNotSelectedColumnNotInstanceAssigned() {
        this.commonGetPropertiesToHideMap(true, false);
    }

    @Test
    public void getPropertiesToHideMapSelectedColumnNotInstanceAssigned() {
        this.commonGetPropertiesToHideMap(false, false);
    }

    @Test
    public void getPropertiesToHideMapSelectedColumnInstanceAssigned() {
        this.commonGetPropertiesToHideMap(false, true);
    }

    @Test
    public void getPropertiesToHideListNoPropertyAssigned() {
        this.commonGetPropertiesToHideList(false);
    }

    @Test
    public void getPropertiesToHideListPropertyAssigned() {
        this.commonGetPropertiesToHideList(true);
    }

    @Test
    public void storeDataSimulation() {
        ScenarioSimulationContext scenarioSimulationContextSpy = (ScenarioSimulationContext)Mockito.spy((Object)this.scenarioSimulationContextLocal);
        ((ScenarioSimulationContext)Mockito.doReturn((Object)this.simulationMock).when((Object)scenarioSimulationContextSpy)).getAbstractScesimModelByGridWidget(GridWidget.SIMULATION);
        FactModelTuple factModelTuple = this.getFactTuple();
        this.abstractDataManagementStrategySpy.storeData(factModelTuple, (TestToolsView.Presenter)this.testToolsPresenterMock, scenarioSimulationContextSpy, GridWidget.SIMULATION);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).populateTestTools((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.capture());
        Assert.assertNotNull((Object)this.testToolsPresenterDataArgumentCaptor.getValue());
        Assert.assertNotNull((Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getDataObjectFieldsMap());
        Assert.assertNotNull((Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getHiddenFieldsMap());
        Assert.assertNotNull((Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getInstanceFieldsMap());
        Assert.assertNotNull((Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getPropertiesToHide());
        Assert.assertNotNull((Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getSimpleJavaInstanceFieldsMap());
        Assert.assertNotNull((Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getSimpleJavaTypeFieldsMap());
        Assert.assertEquals((Object)GridWidget.SIMULATION, (Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getGridWidget());
        ((ScenarioSimulationContext)Mockito.verify((Object)scenarioSimulationContextSpy, (VerificationMode)Mockito.times((int)1))).setDataObjectFieldsMap((SortedMap)Matchers.isA(SortedMap.class));
        ((ScenarioSimulationContext)Mockito.verify((Object)scenarioSimulationContextSpy, (VerificationMode)Mockito.times((int)1))).setDataObjectsInstancesName((Set)Matchers.isA(Set.class));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).setSimpleJavaTypeInstancesName((Set)Matchers.isA(Set.class));
    }

    @Test
    public void storeDataBackground() {
        ScenarioSimulationContext scenarioSimulationContextSpy = (ScenarioSimulationContext)Mockito.spy((Object)this.scenarioSimulationContextLocal);
        ((ScenarioSimulationContext)Mockito.doReturn((Object)this.backgroundMock).when((Object)scenarioSimulationContextSpy)).getAbstractScesimModelByGridWidget(GridWidget.BACKGROUND);
        FactModelTuple factModelTuple = this.getFactTuple();
        this.abstractDataManagementStrategySpy.storeData(factModelTuple, (TestToolsView.Presenter)this.testToolsPresenterMock, scenarioSimulationContextSpy, GridWidget.BACKGROUND);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).populateTestTools((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.capture());
        Assert.assertNotNull((Object)this.testToolsPresenterDataArgumentCaptor.getValue());
        Assert.assertNotNull((Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getDataObjectFieldsMap());
        Assert.assertNotNull((Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getHiddenFieldsMap());
        Assert.assertNotNull((Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getInstanceFieldsMap());
        Assert.assertNotNull((Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getPropertiesToHide());
        Assert.assertNotNull((Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getSimpleJavaInstanceFieldsMap());
        Assert.assertNotNull((Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getSimpleJavaTypeFieldsMap());
        Assert.assertEquals((Object)GridWidget.BACKGROUND, (Object)((TestToolsPresenterData)this.testToolsPresenterDataArgumentCaptor.getValue()).getGridWidget());
        ((ScenarioSimulationContext)Mockito.verify((Object)scenarioSimulationContextSpy, (VerificationMode)Mockito.times((int)1))).setDataObjectFieldsMap((SortedMap)Matchers.isA(SortedMap.class));
        ((ScenarioSimulationContext)Mockito.verify((Object)scenarioSimulationContextSpy, (VerificationMode)Mockito.never())).setDataObjectsInstancesName((Set)Matchers.isA(Set.class));
        ((BackgroundGridModel)Mockito.verify((Object)this.backgroundGridModelMock, (VerificationMode)Mockito.never())).setSimpleJavaTypeInstancesName((Set)Matchers.isA(Set.class));
    }

    @Test
    public void getInstanceMap() {
        SortedMap<String, FactModelTree> sourceMap = this.getSourceMap();
        SortedMap retrieved = this.abstractDataManagementStrategySpy.getInstanceMap(sourceMap);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isEmpty());
        this.abstractDataManagementStrategySpy.setModel(this.modelLocal);
        retrieved = this.abstractDataManagementStrategySpy.getInstanceMap(sourceMap);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)2L, (long)retrieved.size());
    }

    private SortedMap<String, FactModelTree> getSourceMap() {
        TreeMap<String, FactModelTree> toReturn = new TreeMap<String, FactModelTree>();
        FactModelTree toPut = new FactModelTree("Void", "package", new HashMap(), new HashMap());
        toReturn.put("Void", toPut);
        return toReturn;
    }

    private FactModelTuple getFactTuple() {
        return new FactModelTuple(new TreeMap(), new TreeMap());
    }

    private void commonGetPropertiesToHideMap(boolean selectedColumnNull, boolean isInstanceAssigned) {
        if (selectedColumnNull) {
            ((ScenarioGridModel)Mockito.doReturn(null).when((Object)this.scenarioGridModelMock)).getSelectedColumn();
        } else if (isInstanceAssigned) {
            ((ScenarioGridModel)Mockito.doReturn((Object)this.gridColumnMock).when((Object)this.scenarioGridModelMock)).getSelectedColumn();
            ((ScenarioGridColumn)Mockito.doReturn((Object)true).when((Object)this.gridColumnMock)).isInstanceAssigned();
            ((AbstractDataManagementStrategy)Mockito.doReturn(new ArrayList()).when((Object)this.abstractDataManagementStrategySpy)).getPropertiesToHide((ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), (AbstractScesimGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
        }
        Map retrieved = this.abstractDataManagementStrategySpy.getPropertiesToHide((AbstractScesimGridModel)this.scenarioGridModelMock);
        if (selectedColumnNull) {
            Assert.assertTrue((boolean)retrieved.isEmpty());
            ((AbstractDataManagementStrategy)Mockito.verify((Object)this.abstractDataManagementStrategySpy, (VerificationMode)Mockito.never())).getPropertiesToHide((ScenarioGridColumn)Matchers.isA(ScenarioGridColumn.class), (AbstractScesimGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
        } else if (isInstanceAssigned) {
            ((AbstractDataManagementStrategy)Mockito.verify((Object)this.abstractDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getPropertiesToHide((ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), (AbstractScesimGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
        } else {
            ((AbstractDataManagementStrategy)Mockito.verify((Object)this.abstractDataManagementStrategySpy, (VerificationMode)Mockito.never())).getPropertiesToHide((ScenarioGridColumn)Matchers.isA(ScenarioGridColumn.class), (AbstractScesimGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
        }
        Mockito.reset((Object[])new AbstractDataManagementStrategy[]{this.abstractDataManagementStrategySpy});
    }

    private void commonGetPropertiesToHideList(boolean isPropertyAssigned) {
        ((ScenarioGridColumn)Mockito.doReturn((Object)isPropertyAssigned).when((Object)this.gridColumnMock)).isPropertyAssigned();
        List retrieved = this.abstractDataManagementStrategySpy.getPropertiesToHide(this.gridColumnMock, (AbstractScesimGridModel)this.scenarioGridModelMock);
        if (isPropertyAssigned) {
            Assert.assertTrue((boolean)retrieved.isEmpty());
            ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.never())).getAbstractScesimModel();
        } else {
            ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).getAbstractScesimModel();
            ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).getInstanceScenarioGridColumns((ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock));
        }
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModelMock});
    }
}

