/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.popup;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.ParagraphElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.screens.scenariosimulation.client.popup.AbstractScenarioPopupView;
import org.drools.workbench.screens.scenariosimulation.client.popup.FileUploadPopup;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.mvp.Command;

@Templated
public class FileUploadPopupView
extends AbstractScenarioPopupView
implements FileUploadPopup {
    private static final String FAKEPATH = "c:\\fakepath\\";
    @DataField(value="file")
    protected InputElement file = Document.get().createHiddenInputElement();
    @DataField(value="fileText")
    protected InputElement fileText = Document.get().createTextInputElement();
    @DataField(value="chooseButton")
    protected SpanElement chooseButton = Document.get().createSpanElement();
    @DataField(value="upload-warning")
    protected ParagraphElement uploadWarning = Document.get().createPElement();
    protected List<String> acceptedExtension = new ArrayList<String>();
    protected static String fileContents;
    protected static String fileName;

    public static void fileLoaded(String fileContents) {
        FileUploadPopupView.fileContents = fileContents;
    }

    @Override
    public void show(String mainTitleText, String okButtonText, Command okCommand) {
        fileContents = "";
        this.fileText.setValue("");
        if (!this.acceptedExtension.isEmpty()) {
            this.file.setAccept(String.join((CharSequence)",", this.acceptedExtension));
        }
        this.uploadWarning.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.uploadWarning());
        this.okButton.setEnabled(false);
        super.show(mainTitleText, okButtonText, okCommand);
    }

    @Override
    public String getFileContents() {
        return fileContents;
    }

    @Override
    public String getFileName() {
        return fileName;
    }

    @Override
    public void setAcceptedExtension(List<String> acceptedExtension) {
        this.acceptedExtension.clear();
        this.acceptedExtension.addAll(acceptedExtension);
    }

    @EventHandler(value={"chooseButton"})
    public void onChooseButtonClickEvent(ClickEvent clickEvent) {
        this.file.click();
    }

    @EventHandler(value={"file"})
    public void onFileChangeEvent(ChangeEvent event) {
        fileName = this.file.getValue();
        if (fileName.toLowerCase().startsWith(FAKEPATH)) {
            fileName = fileName.substring(FAKEPATH.length());
        }
        this.fileText.setValue(fileName);
        JavaScriptObject files = this.file.getPropertyJSO("files");
        FileUploadPopupView.readTextFile(files);
        if (!"".equals(this.fileText.getValue())) {
            this.okButton.setEnabled(true);
        }
    }

    public static native void readTextFile(JavaScriptObject var0);

    static {
        fileName = null;
    }
}

