/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractTestToolsTest;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemViewImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class FieldItemViewTest
extends AbstractTestToolsTest {
    @Mock
    private SpanElement fieldNameElementMock;
    @Mock
    private SpanElement checkElementMock;
    @Mock
    private Style checkElementStyleMock;
    @Mock
    private FieldItemPresenter fieldItemPresenter;
    private FieldItemViewImpl fieldItemViewSpy;
    private String INNER_HTML;
    private String ID_ATTRIBUTE;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.INNER_HTML = "<a>FIELD_NAME</a> [" + this.FACT_MODEL_TREE.getFactName() + "]";
        this.ID_ATTRIBUTE = "fieldElement-FACT_NAME-FIELD_NAME";
        this.fieldItemViewSpy = (FieldItemViewImpl)Mockito.spy((Object)new FieldItemViewImpl(){
            {
                this.fieldNameElement = FieldItemViewTest.this.fieldNameElementMock;
                this.fieldElement = FieldItemViewTest.this.lIElementMock;
                this.checkElement = FieldItemViewTest.this.checkElementMock;
            }
        });
        this.fieldItemViewSpy.setPresenter((FieldItemView.Presenter)this.fieldItemPresenter);
        Mockito.when((Object)this.checkElementMock.getStyle()).thenReturn((Object)this.checkElementStyleMock);
    }

    @Test
    public void setFieldData() {
        this.fieldItemViewSpy.setFieldData("TestClass.listProperty", "FACT_NAME", "FIELD_NAME", this.FACT_MODEL_TREE.getFactName());
        ((SpanElement)Mockito.verify((Object)this.fieldNameElementMock, (VerificationMode)Mockito.times((int)1))).setInnerHTML((String)Matchers.eq((Object)this.INNER_HTML));
        ((SpanElement)Mockito.verify((Object)this.fieldNameElementMock, (VerificationMode)Mockito.times((int)1))).setAttribute((String)Matchers.eq((Object)"id"), (String)Matchers.eq((Object)this.ID_ATTRIBUTE));
        ((SpanElement)Mockito.verify((Object)this.fieldNameElementMock, (VerificationMode)Mockito.times((int)1))).setAttribute((String)Matchers.eq((Object)"fieldName"), (String)Matchers.eq((Object)"FIELD_NAME"));
        ((SpanElement)Mockito.verify((Object)this.fieldNameElementMock, (VerificationMode)Mockito.times((int)1))).setAttribute((String)Matchers.eq((Object)"className"), (String)Matchers.eq((Object)this.FACT_MODEL_TREE.getFactName()));
        ((SpanElement)Mockito.verify((Object)this.fieldNameElementMock, (VerificationMode)Mockito.times((int)1))).setAttribute((String)Matchers.eq((Object)"fullPath"), (String)Matchers.eq((Object)"TestClass.listProperty"));
    }

    @Test
    public void onFieldElementSelected() {
        this.fieldItemViewSpy.onFieldElementSelected();
        ((LIElement)Mockito.verify((Object)this.lIElementMock, (VerificationMode)Mockito.times((int)1))).addClassName((String)Matchers.eq((Object)"selected"));
        ((FieldItemViewImpl)Mockito.verify((Object)this.fieldItemViewSpy, (VerificationMode)Mockito.times((int)1))).showCheck(Matchers.eq((boolean)true));
        ((FieldItemPresenter)Mockito.verify((Object)this.fieldItemPresenter, (VerificationMode)Mockito.times((int)1))).onFieldElementClick((FieldItemView)Matchers.eq((Object)this.fieldItemViewSpy));
    }

    @Test
    public void onFieldElementClicked() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fieldItemViewSpy, this.lIElementMock, this.fieldItemPresenter});
        this.fieldItemViewSpy.onFieldElementClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((LIElement)inOrder.verify((Object)this.lIElementMock, Mockito.times((int)1))).addClassName((String)Matchers.eq((Object)"selected"));
        ((FieldItemViewImpl)inOrder.verify((Object)this.fieldItemViewSpy, Mockito.times((int)1))).showCheck(Matchers.eq((boolean)true));
        ((FieldItemPresenter)inOrder.verify((Object)this.fieldItemPresenter, Mockito.times((int)1))).onFieldElementClick((FieldItemView)Matchers.eq((Object)this.fieldItemViewSpy));
    }

    @Test
    public void showCheck() {
        this.fieldItemViewSpy.showCheck(true);
        ((Style)Mockito.verify((Object)this.checkElementStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
        Mockito.reset((Object[])new Object[0]);
        this.fieldItemViewSpy.showCheck(false);
        ((Style)Mockito.verify((Object)this.checkElementStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
    }

    @Test
    public void isCheckShown() {
        Mockito.when((Object)this.checkElementStyleMock.getDisplay()).thenReturn((Object)Style.Display.NONE.getCssName());
        Assert.assertFalse((boolean)this.fieldItemViewSpy.isCheckShown());
        Mockito.reset((Object[])new Object[0]);
        Mockito.when((Object)this.checkElementStyleMock.getDisplay()).thenReturn((Object)Style.Display.BLOCK.getCssName());
        Assert.assertTrue((boolean)this.fieldItemViewSpy.isCheckShown());
    }

    @Test
    public void unselect() {
        this.fieldItemViewSpy.unselect();
        ((LIElement)Mockito.verify((Object)this.lIElementMock, (VerificationMode)Mockito.times((int)1))).removeClassName((String)Matchers.eq((Object)"selected"));
        ((Style)Mockito.verify((Object)this.checkElementStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
    }
}

