/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.Optional;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioGridCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioGridCommandTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.SetInstanceHeaderCommand;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

@RunWith(value=GwtMockitoTestRunner.class)
public class SetInstanceHeaderCommandTest
extends AbstractScenarioGridCommandTest {
    @Mock
    private List<GridColumn<?>> mockGridColumns;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.mockGridColumns.indexOf(this.gridColumnMock)).thenReturn((Object)3);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(this.mockGridColumns);
        this.commandSpy = (AbstractScenarioGridCommand)Mockito.spy((Object)new SetInstanceHeaderCommand(GridWidget.SIMULATION){

            protected ScenarioGridColumn getScenarioGridColumnLocal(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader, ScenarioCellTextAreaSingletonDOMElementFactory factoryCell, String placeHolder) {
                return SetInstanceHeaderCommandTest.this.gridColumnMock;
            }

            protected Optional<FactIdentifier> getFactIdentifierByColumnTitle(String columnTitle, ScenarioSimulationContext context) {
                return Optional.empty();
            }
        });
        this.settingsLocal.setType(ScenarioSimulationModel.Type.RULE);
    }

    @Test
    public void executeNoColumn() {
        this.gridColumnMock = null;
        this.commandSpy.execute(this.scenarioSimulationContextLocal);
        ((SetInstanceHeaderCommand)Mockito.verify((Object)((SetInstanceHeaderCommand)this.commandSpy), (VerificationMode)Mockito.never())).executeIfSelectedColumn(this.scenarioSimulationContextLocal, this.gridColumnMock);
    }

    @Test
    public void executeDMN() {
        this.scenarioSimulationContextLocal.getStatus().setFullPackage("test.scesim");
        this.scenarioSimulationContextLocal.getStatus().setClassName(TestProperties.VALUE_CLASS_NAME);
        this.settingsLocal.setType(ScenarioSimulationModel.Type.DMN);
        this.commandSpy.execute(this.scenarioSimulationContextLocal);
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setEditableHeaders(Matchers.eq((boolean)false));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.atLeastOnce())).getInformationHeaderMetaData();
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)Matchers.eq((Object)TestProperties.VALUE_CLASS_NAME));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setInstanceAssigned(Matchers.eq((boolean)true));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(Matchers.eq((boolean)false));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateColumnInstance(Matchers.eq((int)3), (GridColumn)Matchers.eq((Object)this.gridColumnMock));
    }

    @Test
    public void executeRULE() {
        this.scenarioSimulationContextLocal.getStatus().setFullPackage("test.scesim");
        this.scenarioSimulationContextLocal.getStatus().setClassName(TestProperties.VALUE_CLASS_NAME);
        this.settingsLocal.setType(ScenarioSimulationModel.Type.RULE);
        this.commandSpy.execute(this.scenarioSimulationContextLocal);
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setEditableHeaders(Matchers.eq((boolean)true));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.atLeastOnce())).getInformationHeaderMetaData();
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)Matchers.eq((Object)TestProperties.VALUE_CLASS_NAME));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setInstanceAssigned(Matchers.eq((boolean)true));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(Matchers.eq((boolean)false));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateColumnInstance(Matchers.eq((int)3), (GridColumn)Matchers.eq((Object)this.gridColumnMock));
    }
}

