/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractTestToolsTest;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemViewImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ListGroupItemViewImplTest
extends AbstractTestToolsTest {
    @Mock
    private ListGroupItemPresenter listGroupItemPresenterMock;
    @Mock
    private DivElement listGroupItemMock;
    @Mock
    private DivElement listGroupItemHeaderMock;
    @Mock
    private DivElement listGroupItemContainerMock;
    @Mock
    private DivElement listGroupElementMock;
    @Mock
    private SpanElement fullClassNameMock;
    @Mock
    private SpanElement faAngleRightMock;
    @Mock
    private SpanElement checkElementMock;
    @Mock
    private Style checkElementStyleMock;
    @Mock
    private UListElement factPropertiesMock;
    @Mock
    private LIElement factFieldMock;
    private ListGroupItemViewImpl listGroupItemViewSpy;

    @Override
    @Before
    public void setup() {
        this.listGroupItemViewSpy = (ListGroupItemViewImpl)Mockito.spy((Object)new ListGroupItemViewImpl(){
            {
                this.factName = "FACT_NAME";
                this.listGroupItem = ListGroupItemViewImplTest.this.listGroupItemMock;
                this.listGroupItemHeader = ListGroupItemViewImplTest.this.listGroupItemHeaderMock;
                this.listGroupItemContainer = ListGroupItemViewImplTest.this.listGroupItemContainerMock;
                this.listGroupElement = ListGroupItemViewImplTest.this.listGroupElementMock;
                this.faAngleRight = ListGroupItemViewImplTest.this.faAngleRightMock;
                this.fullClassName = ListGroupItemViewImplTest.this.fullClassNameMock;
                this.factProperties = ListGroupItemViewImplTest.this.factPropertiesMock;
                this.checkElement = ListGroupItemViewImplTest.this.checkElementMock;
            }
        });
        this.listGroupItemViewSpy.init((ListGroupItemView.Presenter)this.listGroupItemPresenterMock);
        Mockito.when((Object)this.checkElementMock.getStyle()).thenReturn((Object)this.checkElementStyleMock);
    }

    @Test
    public void onFullClassNameClick() {
        Mockito.when((Object)this.listGroupElementMock.getClassName()).thenReturn((Object)"not-empty disabled");
        this.listGroupItemViewSpy.onFullClassNameClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DivElement)Mockito.verify((Object)this.listGroupItemMock, (VerificationMode)Mockito.never())).addClassName((String)Matchers.eq((Object)"selected"));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).onSelectedElement((ListGroupItemView)Matchers.eq((Object)this.listGroupItemViewSpy));
        Mockito.when((Object)this.listGroupElementMock.getClassName()).thenReturn((Object)"empty");
        this.listGroupItemViewSpy.onFullClassNameClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DivElement)Mockito.verify((Object)this.listGroupItemMock, (VerificationMode)Mockito.times((int)1))).addClassName((String)Matchers.eq((Object)"selected"));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).onSelectedElement((ListGroupItemView)Matchers.eq((Object)this.listGroupItemViewSpy));
    }

    @Test
    public void unselect() {
        this.listGroupItemViewSpy.unselect();
        ((DivElement)Mockito.verify((Object)this.listGroupItemMock, (VerificationMode)Mockito.times((int)1))).removeClassName((String)Matchers.eq((Object)"selected"));
        ((ListGroupItemViewImpl)Mockito.verify((Object)this.listGroupItemViewSpy, (VerificationMode)Mockito.times((int)1))).showCheck(Matchers.eq((boolean)false));
    }

    @Test
    public void showCheck() {
        this.listGroupItemViewSpy.showCheck(true);
        ((Style)Mockito.verify((Object)this.checkElementStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
        ((DivElement)Mockito.verify((Object)this.listGroupItemMock, (VerificationMode)Mockito.times((int)1))).addClassName((String)Matchers.eq((Object)"selected"));
        Mockito.reset((Object[])new Object[0]);
        this.listGroupItemViewSpy.showCheck(false);
        ((Style)Mockito.verify((Object)this.checkElementStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((DivElement)Mockito.verify((Object)this.listGroupItemMock, (VerificationMode)Mockito.times((int)1))).removeClassName((String)Matchers.eq((Object)"selected"));
    }

    @Test
    public void isCheckShown() {
        Mockito.when((Object)this.checkElementStyleMock.getDisplay()).thenReturn((Object)Style.Display.NONE.getCssName());
        Assert.assertFalse((boolean)this.listGroupItemViewSpy.isCheckShown());
        Mockito.reset((Object[])new Object[0]);
        Mockito.when((Object)this.checkElementStyleMock.getDisplay()).thenReturn((Object)Style.Display.BLOCK.getCssName());
        Assert.assertTrue((boolean)this.listGroupItemViewSpy.isCheckShown());
    }

    @Test
    public void onFaAngleRightClick() {
        String toReturn = "list-group-item list-view-pf-expand-active";
        Mockito.when((Object)this.listGroupItemHeaderMock.getClassName()).thenReturn((Object)toReturn);
        this.listGroupItemViewSpy.onFaAngleRightClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion((ListGroupItemView)Matchers.eq((Object)this.listGroupItemViewSpy), Matchers.eq((boolean)true));
        Mockito.when((Object)this.listGroupItemHeaderMock.getClassName()).thenReturn((Object)"list-group-item");
        this.listGroupItemViewSpy.onFaAngleRightClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion((ListGroupItemView)Matchers.eq((Object)this.listGroupItemViewSpy), Matchers.eq((boolean)false));
    }

    @Test
    public void setFactName() {
        this.listGroupItemViewSpy.setFactName("FACT_NAME");
        ((SpanElement)Mockito.verify((Object)this.fullClassNameMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)"FACT_NAME"));
    }

    @Test
    public void addFactField() {
        this.listGroupItemViewSpy.addFactField(this.factFieldMock);
        ((UListElement)Mockito.verify((Object)this.factPropertiesMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.anyObject());
    }

    @Test
    public void closeRow() {
        this.listGroupItemViewSpy.closeRow();
        ((DivElement)Mockito.verify((Object)this.listGroupItemHeaderMock, (VerificationMode)Mockito.times((int)1))).removeClassName((String)Matchers.eq((Object)"list-view-pf-expand-active"));
        ((DivElement)Mockito.verify((Object)this.listGroupItemContainerMock, (VerificationMode)Mockito.times((int)1))).addClassName((String)Matchers.eq((Object)"hidden"));
        ((SpanElement)Mockito.verify((Object)this.faAngleRightMock, (VerificationMode)Mockito.times((int)1))).removeClassName((String)Matchers.eq((Object)"fa-angle-down"));
    }

    @Test
    public void expandRow() {
        this.listGroupItemViewSpy.expandRow();
        ((DivElement)Mockito.verify((Object)this.listGroupItemHeaderMock, (VerificationMode)Mockito.times((int)1))).addClassName((String)Matchers.eq((Object)"list-view-pf-expand-active"));
        ((DivElement)Mockito.verify((Object)this.listGroupItemContainerMock, (VerificationMode)Mockito.times((int)1))).removeClassName((String)Matchers.eq((Object)"hidden"));
        ((SpanElement)Mockito.verify((Object)this.faAngleRightMock, (VerificationMode)Mockito.times((int)1))).addClassName((String)Matchers.eq((Object)"fa-angle-down"));
    }
}

