/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.renderers;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.function.BiFunction;
import org.drools.workbench.screens.scenariosimulation.client.renderers.ScenarioGridRendererTheme;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl.ColumnRenderingStrategyFlattened;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl.StringColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

public class ScenarioGridColumnRenderer
extends StringColumnRenderer {
    public Group renderCell(GridCell<String> cell, GridBodyCellRenderContext context) {
        String value;
        Text text;
        if (cell == null || cell.getValue() == null || cell.getValue().getValue() == null && cell.getValue().getPlaceHolder() == null) {
            return null;
        }
        ScenarioGridRendererTheme theme = (ScenarioGridRendererTheme)context.getRenderer().getTheme();
        if (cell instanceof ScenarioGridCell && cell.getValue() != null && (cell.getValue().getValue() == null || ((String)cell.getValue().getValue()).isEmpty()) && cell.getValue().getPlaceHolder() != null) {
            text = theme.getPlaceholderText();
            value = cell.getValue().getPlaceHolder();
        } else {
            text = ((ScenarioGridCell)cell).isErrorMode() ? theme.getErrorText() : theme.getBodyText();
            value = this.getValueToShow((ScenarioGridCell)cell);
        }
        return this.internalRenderCell(cell, context, text, value);
    }

    public List<GridRenderer.RendererCommand> renderColumn(GridColumn<?> column, GridBodyColumnRenderContext context, BaseGridRendererHelper rendererHelper, BaseGridRendererHelper.RenderingInformation renderingInformation, BiFunction<Boolean, GridColumn<?>, Boolean> columnRenderingConstraint) {
        return ColumnRenderingStrategyFlattened.render(column, (GridBodyColumnRenderContext)context, (BaseGridRendererHelper)rendererHelper, (BaseGridRendererHelper.RenderingInformation)renderingInformation, columnRenderingConstraint);
    }

    protected Group internalRenderCell(GridCell<String> cell, GridBodyCellRenderContext context, Text text, String value) {
        if (value == null) {
            return null;
        }
        GridRenderer renderer = context.getRenderer();
        ScenarioGridRendererTheme theme = (ScenarioGridRendererTheme)renderer.getTheme();
        Group g = new Group();
        text.setText(value);
        text.setListening(false);
        text.setX(context.getCellWidth() / 2.0);
        text.setY(context.getCellHeight() / 2.0);
        this.applyBackgroundColor((ScenarioGridCell)cell, context, g, theme);
        g.add((IPrimitive)text);
        return g;
    }

    protected void applyBackgroundColor(ScenarioGridCell cell, GridBodyCellRenderContext context, Group group, ScenarioGridRendererTheme theme) {
        if (cell.isErrorMode()) {
            Rectangle bodyErrorBackground = theme.getBodyErrorBackground((GridCell<?>)cell);
            bodyErrorBackground.setWidth(context.getCellWidth());
            bodyErrorBackground.setHeight(context.getCellHeight());
            group.add((IPrimitive)bodyErrorBackground);
        }
    }

    protected String getValueToShow(ScenarioGridCell scenarioGridCell) {
        String rawValue = scenarioGridCell.getValue() != null ? (String)scenarioGridCell.getValue().getValue() : null;
        return rawValue != null && (scenarioGridCell.isList() || scenarioGridCell.isMap()) ? this.getCollectionString(rawValue, scenarioGridCell.isList()) : rawValue;
    }

    protected String getCollectionString(String jsonString, boolean isList) {
        try {
            JSONValue jsonValue = JSONParser.parseStrict((String)jsonString);
            if (jsonValue instanceof JSONString) {
                return isList ? "List()" : "Map()";
            }
            String toFormat = isList ? "List(%s)" : "Map(%s)";
            int size = -1;
            size = isList ? jsonValue.isArray().size() : jsonValue.isObject().keySet().size();
            return toFormat.replace("%s", String.valueOf(size));
        }
        catch (Exception e) {
            return jsonString;
        }
    }
}

