/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.LabelElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TextAreaElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.Map;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.AbstractCollectionEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionView;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionViewImpl;
import org.drools.workbench.screens.scenariosimulation.client.events.CloseCompositeEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SaveEditorEvent;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class CollectionViewImplTest
extends AbstractCollectionEditorTest {
    private CollectionViewImpl collectionEditorViewImplSpy;
    @Mock
    private DivElement collectionEditorModalBodyMock;
    @Mock
    private LabelElement createLabelMock;
    @Mock
    private LabelElement collectionCreationModeLabelMock;
    @Mock
    private SpanElement collectionCreationCreateLabelMock;
    @Mock
    private SpanElement collectionCreationCreateSpanMock;
    @Mock
    private SpanElement collectionCreationDefineLabelMock;
    @Mock
    private SpanElement collectionCreationDefineSpanMock;
    @Mock
    private ButtonElement saveButtonMock;
    @Mock
    private SpanElement saveButtonSpanTextMock;
    @Mock
    private ButtonElement cancelButtonMock;
    @Mock
    private ButtonElement removeButtonMock;
    @Mock
    private SpanElement removeButtonSpanTextMock;
    @Mock
    private ButtonElement addItemButtonMock;
    @Mock
    private InputElement createCollectionRadioMock;
    @Mock
    private InputElement defineCollectionRadioMock;
    @Mock
    private SpanElement addItemButtonLabelMock;
    @Mock
    private DivElement createCollectionContainerMock;
    @Mock
    private Style createCollectionContainerStyleMock;
    @Mock
    private DivElement defineCollectionContainerMock;
    @Mock
    private Style defineCollectionContainerStyleMock;
    @Mock
    private Style addItemButtonStyleMock;
    @Mock
    private TextAreaElement expressionElementMock;

    @Override
    @Before
    public void setup() {
        Mockito.when((Object)this.collectionEditorModalBodyMock.getStyle()).thenReturn((Object)this.styleMock);
        Mockito.when((Object)this.createCollectionContainerMock.getStyle()).thenReturn((Object)this.createCollectionContainerStyleMock);
        Mockito.when((Object)this.defineCollectionContainerMock.getStyle()).thenReturn((Object)this.defineCollectionContainerStyleMock);
        Mockito.when((Object)this.addItemButtonMock.getStyle()).thenReturn((Object)this.addItemButtonStyleMock);
        this.collectionEditorViewImplSpy = (CollectionViewImpl)Mockito.spy((Object)new CollectionViewImpl(){
            {
                this.presenter = CollectionViewImplTest.this.collectionPresenterMock;
                this.collectionEditorModalBody = CollectionViewImplTest.this.collectionEditorModalBodyMock;
                this.createLabel = CollectionViewImplTest.this.createLabelMock;
                this.collectionCreationModeLabel = CollectionViewImplTest.this.collectionCreationModeLabelMock;
                this.collectionCreationCreateLabel = CollectionViewImplTest.this.collectionCreationCreateLabelMock;
                this.collectionCreationCreateSpan = CollectionViewImplTest.this.collectionCreationCreateSpanMock;
                this.collectionCreationDefineLabel = CollectionViewImplTest.this.collectionCreationDefineLabelMock;
                this.collectionCreationDefineSpan = CollectionViewImplTest.this.collectionCreationDefineSpanMock;
                this.createCollectionContainer = CollectionViewImplTest.this.createCollectionContainerMock;
                this.defineCollectionContainer = CollectionViewImplTest.this.defineCollectionContainerMock;
                this.expressionElement = CollectionViewImplTest.this.expressionElementMock;
                this.saveButton = CollectionViewImplTest.this.saveButtonMock;
                this.cancelButton = CollectionViewImplTest.this.cancelButtonMock;
                this.removeButton = CollectionViewImplTest.this.removeButtonMock;
                this.addItemButtonLabel = CollectionViewImplTest.this.addItemButtonLabelMock;
                this.addItemButton = CollectionViewImplTest.this.addItemButtonMock;
                this.createCollectionRadio = CollectionViewImplTest.this.createCollectionRadioMock;
                this.defineCollectionRadio = CollectionViewImplTest.this.defineCollectionRadioMock;
                this.removeButtonSpanText = CollectionViewImplTest.this.removeButtonSpanTextMock;
                this.saveButtonSpanText = CollectionViewImplTest.this.saveButtonSpanTextMock;
            }
        });
    }

    @Test
    public void initListStructure() {
        this.collectionEditorViewImplSpy.initListStructure("key", Collections.EMPTY_MAP, Collections.EMPTY_MAP, ScenarioSimulationModel.Type.DMN);
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).commonInit((ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN));
        ((LabelElement)Mockito.verify((Object)this.createLabelMock, (VerificationMode)Mockito.atLeast((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelList());
        ((LabelElement)Mockito.verify((Object)this.collectionCreationModeLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.collectionListCreation());
        ((SpanElement)Mockito.verify((Object)this.collectionCreationCreateLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelList());
        ((SpanElement)Mockito.verify((Object)this.collectionCreationCreateSpanMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelListDescription());
        ((SpanElement)Mockito.verify((Object)this.collectionCreationDefineLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.defineLabelList());
        ((SpanElement)Mockito.verify((Object)this.collectionCreationDefineSpanMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.defineLabelListDescription());
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).initListStructure((String)Matchers.eq((Object)"key"), (Map)Matchers.eq((Object)Collections.EMPTY_MAP), (Map)Matchers.eq((Object)Collections.EMPTY_MAP), (CollectionView)Matchers.eq((Object)this.collectionEditorViewImplSpy));
        ((SpanElement)Mockito.verify((Object)this.addItemButtonLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.addNewListItem());
        Assert.assertTrue((boolean)this.collectionEditorViewImplSpy.listWidget);
    }

    @Test
    public void initMapStructure() {
        this.collectionEditorViewImplSpy.initMapStructure("key", Collections.EMPTY_MAP, Collections.EMPTY_MAP, ScenarioSimulationModel.Type.DMN);
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).commonInit((ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN));
        ((LabelElement)Mockito.verify((Object)this.createLabelMock, (VerificationMode)Mockito.atLeast((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelMap());
        ((LabelElement)Mockito.verify((Object)this.collectionCreationModeLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.collectionMapCreation());
        ((SpanElement)Mockito.verify((Object)this.collectionCreationCreateLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelMap());
        ((SpanElement)Mockito.verify((Object)this.collectionCreationCreateSpanMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelMapDescription());
        ((SpanElement)Mockito.verify((Object)this.collectionCreationDefineLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.defineLabelMap());
        ((SpanElement)Mockito.verify((Object)this.collectionCreationDefineSpanMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.defineLabelMapDescription());
        ((SpanElement)Mockito.verify((Object)this.addItemButtonLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.addNewMapItem());
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).initMapStructure((String)Matchers.eq((Object)"key"), (Map)Matchers.eq((Object)Collections.EMPTY_MAP), (Map)Matchers.eq((Object)Collections.EMPTY_MAP), (CollectionView)Matchers.eq((Object)this.collectionEditorViewImplSpy));
        Assert.assertFalse((boolean)this.collectionEditorViewImplSpy.listWidget);
    }

    @Test
    public void commonInit_RuleScenario() {
        this.collectionEditorViewImplSpy.commonInit(ScenarioSimulationModel.Type.RULE);
        Assert.assertEquals((Object)ScenarioSimulationModel.Type.RULE, (Object)this.collectionEditorViewImplSpy.scenarioType);
        ((SpanElement)Mockito.verify((Object)this.saveButtonSpanTextMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.saveButton());
        ((ButtonElement)Mockito.verify((Object)this.cancelButtonMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.cancelButton());
        ((SpanElement)Mockito.verify((Object)this.removeButtonSpanTextMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.removeButton());
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).enableCreateCollectionContainer(Matchers.eq((boolean)true));
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).initAndRegisterHandlerForExpressionTextArea();
    }

    @Test
    public void commonInit_DMNScenario() {
        this.collectionEditorViewImplSpy.commonInit(ScenarioSimulationModel.Type.DMN);
        Assert.assertEquals((Object)ScenarioSimulationModel.Type.DMN, (Object)this.collectionEditorViewImplSpy.scenarioType);
        ((SpanElement)Mockito.verify((Object)this.saveButtonSpanTextMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.saveButton());
        ((ButtonElement)Mockito.verify((Object)this.cancelButtonMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.cancelButton());
        ((SpanElement)Mockito.verify((Object)this.removeButtonSpanTextMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.removeButton());
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).enableCreateCollectionContainer(Matchers.eq((boolean)true));
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.never())).initAndRegisterHandlerForExpressionTextArea();
    }

    @Test
    public void setValue() {
        String testValue = "TEST-JSON";
        this.collectionEditorViewImplSpy.setValue(testValue);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)testValue));
    }

    @Test
    public void onCloseCollectionEditorButtonClick() {
        this.collectionEditorViewImplSpy.onCloseCollectionEditorButtonClick(this.clickEventMock);
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(CloseCompositeEvent.class));
    }

    @Test
    public void onCancelButtonClick() {
        this.collectionEditorViewImplSpy.onCancelButtonClick(this.clickEventMock);
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void onRemoveButtonClick() {
        this.collectionEditorViewImplSpy.onRemoveButtonClick(this.clickEventMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).remove();
    }

    @Test
    public void onSaveButtonClick() {
        this.collectionEditorViewImplSpy.onSaveButtonClick(this.clickEventMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).save();
    }

    @Test
    public void onAddItemButton() {
        this.collectionEditorViewImplSpy.onAddItemButton(this.clickEventMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).showEditingBox();
    }

    @Test
    public void onFaAngleRightClick() {
        ((CollectionViewImpl)Mockito.doReturn((Object)true).when((Object)this.collectionEditorViewImplSpy)).isShown();
        this.collectionEditorViewImplSpy.onFaAngleRightClick(this.clickEventMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion(Matchers.eq((boolean)true));
        Mockito.reset((Object[])new CollectionPresenter[]{this.collectionPresenterMock});
        Mockito.reset((Object[])new ClickEvent[]{this.clickEventMock});
        ((CollectionViewImpl)Mockito.doReturn((Object)false).when((Object)this.collectionEditorViewImplSpy)).isShown();
        this.collectionEditorViewImplSpy.onFaAngleRightClick(this.clickEventMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion(Matchers.eq((boolean)false));
    }

    @Test
    public void toggleRowExpansion() {
        ((CollectionViewImpl)Mockito.doReturn((Object)true).when((Object)this.collectionEditorViewImplSpy)).isShown();
        this.collectionEditorViewImplSpy.toggleRowExpansion();
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).toggleRowExpansion(false);
        Mockito.reset((Object[])new CollectionViewImpl[]{this.collectionEditorViewImplSpy});
        ((CollectionViewImpl)Mockito.doReturn((Object)false).when((Object)this.collectionEditorViewImplSpy)).isShown();
        this.collectionEditorViewImplSpy.toggleRowExpansion();
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).toggleRowExpansion(true);
    }

    @Test
    public void updateValue() {
        this.collectionEditorViewImplSpy.updateValue("TEST_VALUE");
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SaveEditorEvent.class));
    }

    @Test
    public void close() {
        this.collectionEditorViewImplSpy.close();
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(CloseCompositeEvent.class));
    }

    @Test
    public void setFixedHeight() {
        double value = 23.0;
        Style.Unit unit = Style.Unit.PX;
        this.collectionEditorViewImplSpy.setFixedHeight(value, unit);
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setHeight(Matchers.eq((double)value), (Style.Unit)Matchers.eq((Object)unit));
    }

    @Test
    public void enableCreateCollectionContainer_CreateList() {
        this.enableCreateCollectionContainer(true, true);
    }

    @Test
    public void enableCreateCollectionContainer_CreateMap() {
        this.enableCreateCollectionContainer(true, false);
    }

    @Test
    public void enableCreateCollectionContainer_DefineList() {
        this.enableCreateCollectionContainer(false, true);
    }

    @Test
    public void enableCreateCollectionContainer_DefineMap() {
        this.enableCreateCollectionContainer(false, false);
    }

    private void enableCreateCollectionContainer(boolean toEnable, boolean isList) {
        this.collectionEditorViewImplSpy.listWidget = isList;
        this.collectionEditorViewImplSpy.enableCreateCollectionContainer(toEnable);
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).showCreateCollectionContainer(Matchers.eq((boolean)toEnable));
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).showDefineCollectionContainer(Matchers.eq((!toEnable ? 1 : 0) != 0));
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).showAddItemButton(Matchers.eq((boolean)toEnable));
        if (isList) {
            ((LabelElement)Mockito.verify((Object)this.createLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.createLabelList()));
        } else {
            ((LabelElement)Mockito.verify((Object)this.createLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.createLabelMap()));
        }
    }

    @Test
    public void checkExpressionSyntax_Rule() {
        this.collectionEditorViewImplSpy.scenarioType = ScenarioSimulationModel.Type.RULE;
        this.collectionEditorViewImplSpy.ensureExpressionSyntax();
        ((TextAreaElement)Mockito.verify((Object)this.expressionElementMock, (VerificationMode)Mockito.times((int)1))).setValue(Matchers.anyString());
    }

    @Test
    public void checkExpressionSyntax_DMN() {
        this.collectionEditorViewImplSpy.scenarioType = ScenarioSimulationModel.Type.DMN;
        this.collectionEditorViewImplSpy.ensureExpressionSyntax();
        ((TextAreaElement)Mockito.verify((Object)this.expressionElementMock, (VerificationMode)Mockito.never())).setValue(Matchers.anyString());
    }

    @Test
    public void setExpression() {
        this.collectionEditorViewImplSpy.setExpression("test");
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).enableCreateCollectionContainer(Matchers.eq((boolean)false));
        ((TextAreaElement)Mockito.verify((Object)this.expressionElementMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"test"));
    }

    @Test
    public void enableEditingMode_False() {
        this.collectionEditorViewImplSpy.enableEditingMode(false);
        ((InputElement)Mockito.verify((Object)this.createCollectionRadioMock)).setDisabled(Matchers.eq((boolean)false));
        ((InputElement)Mockito.verify((Object)this.defineCollectionRadioMock)).setDisabled(Matchers.eq((boolean)false));
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).showAddItemButton(Matchers.eq((boolean)true));
        ((ButtonElement)Mockito.verify((Object)this.addItemButtonMock)).setDisabled(Matchers.eq((boolean)false));
        ((ButtonElement)Mockito.verify((Object)this.cancelButtonMock)).setDisabled(Matchers.eq((boolean)false));
        ((ButtonElement)Mockito.verify((Object)this.removeButtonMock)).setDisabled(Matchers.eq((boolean)false));
        ((ButtonElement)Mockito.verify((Object)this.saveButtonMock)).setDisabled(Matchers.eq((boolean)false));
    }

    @Test
    public void enableEditingMode_True() {
        this.collectionEditorViewImplSpy.enableEditingMode(true);
        ((InputElement)Mockito.verify((Object)this.createCollectionRadioMock)).setDisabled(Matchers.eq((boolean)true));
        ((InputElement)Mockito.verify((Object)this.defineCollectionRadioMock)).setDisabled(Matchers.eq((boolean)true));
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImplSpy, (VerificationMode)Mockito.times((int)1))).showAddItemButton(Matchers.eq((boolean)false));
        ((ButtonElement)Mockito.verify((Object)this.addItemButtonMock)).setDisabled(Matchers.eq((boolean)true));
        ((ButtonElement)Mockito.verify((Object)this.cancelButtonMock)).setDisabled(Matchers.eq((boolean)true));
        ((ButtonElement)Mockito.verify((Object)this.removeButtonMock)).setDisabled(Matchers.eq((boolean)true));
        ((ButtonElement)Mockito.verify((Object)this.saveButtonMock)).setDisabled(Matchers.eq((boolean)true));
    }

    @Test
    public void showCreateCollectionContainer() {
        this.collectionEditorViewImplSpy.showCreateCollectionContainer(false);
        this.checkStyleDisplay(this.createCollectionContainerStyleMock, false);
        this.collectionEditorViewImplSpy.showCreateCollectionContainer(true);
        this.checkStyleDisplay(this.createCollectionContainerStyleMock, true);
    }

    @Test
    public void showDefineCollectionContainer() {
        this.collectionEditorViewImplSpy.showDefineCollectionContainer(false);
        this.checkStyleDisplay(this.defineCollectionContainerStyleMock, false);
        this.collectionEditorViewImplSpy.showDefineCollectionContainer(true);
        this.checkStyleDisplay(this.defineCollectionContainerStyleMock, true);
    }

    @Test
    public void showAddItemButton() {
        this.collectionEditorViewImplSpy.showAddItemButton(false);
        this.checkStyleDisplay(this.addItemButtonStyleMock, false);
        this.collectionEditorViewImplSpy.showAddItemButton(true);
        this.checkStyleDisplay(this.addItemButtonStyleMock, true);
    }

    private void checkStyleDisplay(Style styleElement, boolean show) {
        if (show) {
            ((Style)Mockito.verify((Object)styleElement, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.BLOCK);
        } else {
            ((Style)Mockito.verify((Object)styleElement, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.NONE);
        }
    }
}

