/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.popover;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.popover.AbstractPopoverView;
import org.drools.workbench.screens.scenariosimulation.client.popover.PopoverView;
import org.jboss.errai.common.client.dom.CSSStyleDeclaration;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.client.views.pfly.widgets.PopoverOptions;

@RunWith(value=LienzoMockitoTestRunner.class)
public class AbstractPopoverViewTest {
    public static final String EDITOR_TITLE_TEXT = "EDITOR_TITLE_TEXT";
    public static final int MX = 36;
    public static final int MY = 52;
    public static final String TOP_PX = "52px";
    public static final String LEFT_PX = "36px";
    private AbstractPopoverView abstractPopoverView;
    @Mock
    private HTMLElement elementMock;
    @Mock
    private CSSStyleDeclaration styleMock;
    @Mock
    private Div popoverElementMock;
    @Mock
    private Div popoverContainerMock;
    @Mock
    private Div popoverContentMock;
    @Mock
    private Popover popoverMock;
    @Mock
    protected JQueryProducer.JQuery<Popover> jQueryPopoverMock;
    @Mock
    private ElementWrapperWidget<Object> wrappedWidgetMock;

    @Before
    public void setup() {
        this.abstractPopoverView = (AbstractPopoverView)Mockito.spy((Object)new AbstractPopoverView(){
            {
                this.wrappedWidget = AbstractPopoverViewTest.this.wrappedWidgetMock;
                this.popover = AbstractPopoverViewTest.this.popoverMock;
                this.popoverElement = AbstractPopoverViewTest.this.popoverElementMock;
                this.popoverContentElement = AbstractPopoverViewTest.this.popoverContentMock;
                this.popoverContainerElement = AbstractPopoverViewTest.this.popoverContainerMock;
                this.jQueryPopover = AbstractPopoverViewTest.this.jQueryPopoverMock;
            }

            public HTMLElement getElement() {
                return AbstractPopoverViewTest.this.elementMock;
            }
        });
        Mockito.when((Object)this.jQueryPopoverMock.wrap((Element)Matchers.any())).thenReturn((Object)this.popoverMock);
        Mockito.when((Object)this.popoverElementMock.getStyle()).thenReturn((Object)this.styleMock);
    }

    @Test
    public void setupIsShown() {
        ((AbstractPopoverView)Mockito.doReturn((Object)Boolean.TRUE).when((Object)this.abstractPopoverView)).isShown();
        this.abstractPopoverView.setup(Optional.of(EDITOR_TITLE_TEXT), 36, 52, PopoverView.Position.RIGHT);
        ((AbstractPopoverView)Mockito.verify((Object)this.abstractPopoverView, (VerificationMode)Mockito.times((int)1))).hide();
        ((AbstractPopoverView)Mockito.verify((Object)this.abstractPopoverView, (VerificationMode)Mockito.times((int)1))).addWidgetToRootPanel();
        ((Div)Mockito.verify((Object)this.popoverElementMock, (VerificationMode)Mockito.times((int)1))).setAttribute("title", EDITOR_TITLE_TEXT);
        ((JQueryProducer.JQuery)Mockito.verify(this.jQueryPopoverMock, (VerificationMode)Mockito.times((int)1))).wrap((Element)this.elementMock);
        ((Popover)Mockito.verify((Object)this.popoverMock, (VerificationMode)Mockito.times((int)1))).popover((PopoverOptions)Matchers.isA(PopoverOptions.class));
        ((CSSStyleDeclaration)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setProperty((String)Matchers.eq((Object)"top"), (String)Matchers.eq((Object)TOP_PX));
        ((CSSStyleDeclaration)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setProperty((String)Matchers.eq((Object)"left"), (String)Matchers.eq((Object)LEFT_PX));
        ((CSSStyleDeclaration)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setProperty((String)Matchers.eq((Object)"position"), (String)Matchers.eq((Object)"absolute"));
    }

    @Test
    public void setupIsNotShown() {
        ((AbstractPopoverView)Mockito.doReturn((Object)Boolean.FALSE).when((Object)this.abstractPopoverView)).isShown();
        this.abstractPopoverView.setup(Optional.of(EDITOR_TITLE_TEXT), 36, 52, PopoverView.Position.RIGHT);
        ((AbstractPopoverView)Mockito.verify((Object)this.abstractPopoverView, (VerificationMode)Mockito.never())).hide();
        ((AbstractPopoverView)Mockito.verify((Object)this.abstractPopoverView, (VerificationMode)Mockito.times((int)1))).addWidgetToRootPanel();
        ((Div)Mockito.verify((Object)this.popoverElementMock, (VerificationMode)Mockito.times((int)1))).setAttribute("title", EDITOR_TITLE_TEXT);
        ((JQueryProducer.JQuery)Mockito.verify(this.jQueryPopoverMock, (VerificationMode)Mockito.times((int)1))).wrap((Element)this.elementMock);
        ((Popover)Mockito.verify((Object)this.popoverMock, (VerificationMode)Mockito.times((int)1))).popover((PopoverOptions)Matchers.isA(PopoverOptions.class));
        ((CSSStyleDeclaration)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setProperty((String)Matchers.eq((Object)"top"), (String)Matchers.eq((Object)TOP_PX));
        ((CSSStyleDeclaration)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setProperty((String)Matchers.eq((Object)"left"), (String)Matchers.eq((Object)LEFT_PX));
        ((CSSStyleDeclaration)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setProperty((String)Matchers.eq((Object)"position"), (String)Matchers.eq((Object)"absolute"));
    }

    @Test
    public void show() {
        this.abstractPopoverView.show();
        ((AbstractPopoverView)Mockito.verify((Object)this.abstractPopoverView, (VerificationMode)Mockito.times((int)1))).scheduleTask();
    }

    @Test
    public void hideIsShown() {
        ((AbstractPopoverView)Mockito.doReturn((Object)Boolean.TRUE).when((Object)this.abstractPopoverView)).isShown();
        Assert.assertNotNull((Object)this.abstractPopoverView.wrappedWidget);
        this.abstractPopoverView.hide();
        ((Popover)Mockito.verify((Object)this.popoverMock, (VerificationMode)Mockito.times((int)1))).destroy();
        ((AbstractPopoverView)Mockito.verify((Object)this.abstractPopoverView, (VerificationMode)Mockito.times((int)1))).removeWidgetFromRootPanel();
        Assert.assertNull((Object)this.abstractPopoverView.wrappedWidget);
    }

    @Test
    public void hideNotIsShown() {
        ((AbstractPopoverView)Mockito.doReturn((Object)Boolean.FALSE).when((Object)this.abstractPopoverView)).isShown();
        this.abstractPopoverView.hide();
        ((Popover)Mockito.verify((Object)this.popoverMock, (VerificationMode)Mockito.never())).hide();
        ((Popover)Mockito.verify((Object)this.popoverMock, (VerificationMode)Mockito.never())).destroy();
        ((AbstractPopoverView)Mockito.verify((Object)this.abstractPopoverView, (VerificationMode)Mockito.never())).removeWidgetFromRootPanel();
    }
}

