/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationDocksHandler;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.docks.AuthoringEditorDock;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractScenarioSimulationDocksHandlerTest {
    @Mock
    private AuthoringEditorDock authoringWorkbenchDocksMock;
    @Mock
    private CheatSheetPresenter cheatSheetPresenterMock;
    @Mock
    private TestToolsPresenter testToolsPresenterMock;
    @Mock
    private SettingsPresenter settingsPresenterMock;
    @Mock
    private PlaceManager placeManagerMock;
    private AbstractScenarioSimulationDocksHandler abstractScenarioSimulationDocksHandlerSpy;

    @Before
    public void setup() {
        this.abstractScenarioSimulationDocksHandlerSpy = (AbstractScenarioSimulationDocksHandler)Mockito.spy((Object)new AbstractScenarioSimulationDocksHandler(){
            {
                this.authoringWorkbenchDocks = AbstractScenarioSimulationDocksHandlerTest.this.authoringWorkbenchDocksMock;
                this.placeManager = AbstractScenarioSimulationDocksHandlerTest.this.placeManagerMock;
            }

            public void expandTestResultsDock() {
            }
        });
        ((AbstractScenarioSimulationDocksHandler)Mockito.doReturn(Optional.of(this.cheatSheetPresenterMock)).when((Object)this.abstractScenarioSimulationDocksHandlerSpy)).getCheatSheetPresenter();
        ((AbstractScenarioSimulationDocksHandler)Mockito.doReturn(Optional.of(this.testToolsPresenterMock)).when((Object)this.abstractScenarioSimulationDocksHandlerSpy)).getTestToolsPresenter();
        ((AbstractScenarioSimulationDocksHandler)Mockito.doReturn(Optional.of(this.settingsPresenterMock)).when((Object)this.abstractScenarioSimulationDocksHandlerSpy)).getSettingsPresenter();
    }

    @Test
    public void provideDocks() {
        Collection docks = this.abstractScenarioSimulationDocksHandlerSpy.provideDocks("id");
        Assert.assertEquals((long)MANAGED_DOCKS.values().length, (long)docks.size());
        UberfireDock cheetSheetDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.CHEATSHEET.ordinal()];
        Assert.assertNotNull((Object)cheetSheetDock);
        Assert.assertEquals((Object)"org.drools.scenariosimulation.CheatSheet", (Object)cheetSheetDock.getPlaceRequest().getIdentifier());
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.scenarioCheatSheet(), (Object)cheetSheetDock.getLabel());
        Assert.assertEquals((Object)UberfireDockPosition.EAST, (Object)cheetSheetDock.getDockPosition());
        Assert.assertEquals((Object)"FILE_TEXT", (Object)cheetSheetDock.getIconType());
        UberfireDock settingsDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.SETTINGS.ordinal()];
        Assert.assertNotNull((Object)settingsDock);
        Assert.assertEquals((Object)"org.drools.scenariosimulation.Settings", (Object)settingsDock.getPlaceRequest().getIdentifier());
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.settings(), (Object)settingsDock.getLabel());
        Assert.assertEquals((Object)UberfireDockPosition.EAST, (Object)settingsDock.getDockPosition());
        Assert.assertEquals((Object)"SLIDERS", (Object)settingsDock.getIconType());
        UberfireDock testToolsDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.TOOLS.ordinal()];
        Assert.assertNotNull((Object)testToolsDock);
        Assert.assertEquals((Object)"org.drools.scenariosimulation.TestTools", (Object)testToolsDock.getPlaceRequest().getIdentifier());
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.testTools(), (Object)testToolsDock.getLabel());
        Assert.assertEquals((Object)UberfireDockPosition.EAST, (Object)testToolsDock.getDockPosition());
        Assert.assertEquals((Object)"INFO_CIRCLE", (Object)testToolsDock.getIconType());
    }

    @Test
    public void expandToolsDockClose() {
        Collection docks = this.abstractScenarioSimulationDocksHandlerSpy.provideDocks("id");
        UberfireDock toolsDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.TOOLS.ordinal()];
        Mockito.when((Object)this.placeManagerMock.getStatus((PlaceRequest)Matchers.eq((Object)this.abstractScenarioSimulationDocksHandlerSpy.getTestToolsPlaceManager()))).thenReturn((Object)PlaceStatus.CLOSE);
        this.abstractScenarioSimulationDocksHandlerSpy.expandToolsDock();
        ((AuthoringEditorDock)Mockito.verify((Object)this.authoringWorkbenchDocksMock, (VerificationMode)Mockito.times((int)1))).expandAuthoringDock((UberfireDock)Matchers.eq((Object)toolsDock));
    }

    @Test
    public void expandToolsDockOpen() {
        Collection docks = this.abstractScenarioSimulationDocksHandlerSpy.provideDocks("id");
        UberfireDock toolsDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.TOOLS.ordinal()];
        Mockito.when((Object)this.placeManagerMock.getStatus((PlaceRequest)Matchers.eq((Object)this.abstractScenarioSimulationDocksHandlerSpy.getTestToolsPlaceManager()))).thenReturn((Object)PlaceStatus.OPEN);
        this.abstractScenarioSimulationDocksHandlerSpy.expandToolsDock();
        ((AuthoringEditorDock)Mockito.verify((Object)this.authoringWorkbenchDocksMock, (VerificationMode)Mockito.never())).expandAuthoringDock((UberfireDock)Matchers.eq((Object)toolsDock));
    }

    @Test
    public void expandSettingsDockClose() {
        Collection docks = this.abstractScenarioSimulationDocksHandlerSpy.provideDocks("id");
        UberfireDock settingsDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.SETTINGS.ordinal()];
        Mockito.when((Object)this.placeManagerMock.getStatus((PlaceRequest)Matchers.eq((Object)this.abstractScenarioSimulationDocksHandlerSpy.getSettingsPlaceManager()))).thenReturn((Object)PlaceStatus.CLOSE);
        this.abstractScenarioSimulationDocksHandlerSpy.expandSettingsDock();
        ((AuthoringEditorDock)Mockito.verify((Object)this.authoringWorkbenchDocksMock, (VerificationMode)Mockito.times((int)1))).expandAuthoringDock((UberfireDock)Matchers.eq((Object)settingsDock));
    }

    @Test
    public void expandSettingsDockOpen() {
        Collection docks = this.abstractScenarioSimulationDocksHandlerSpy.provideDocks("id");
        UberfireDock settingsDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.SETTINGS.ordinal()];
        Mockito.when((Object)this.placeManagerMock.getStatus((PlaceRequest)Matchers.eq((Object)this.abstractScenarioSimulationDocksHandlerSpy.getSettingsPlaceManager()))).thenReturn((Object)PlaceStatus.OPEN);
        this.abstractScenarioSimulationDocksHandlerSpy.expandSettingsDock();
        ((AuthoringEditorDock)Mockito.verify((Object)this.authoringWorkbenchDocksMock, (VerificationMode)Mockito.never())).expandAuthoringDock((UberfireDock)Matchers.eq((Object)settingsDock));
    }

    @Test
    public void setScesimPath() {
        Collection docks = this.abstractScenarioSimulationDocksHandlerSpy.provideDocks("id");
        UberfireDock settingsDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.SETTINGS.ordinal()];
        UberfireDock toolsDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.TOOLS.ordinal()];
        UberfireDock cheatSheetDock = (UberfireDock)docks.toArray()[MANAGED_DOCKS.CHEATSHEET.ordinal()];
        String TEST_PATH = "TEST_PATH";
        this.abstractScenarioSimulationDocksHandlerSpy.setScesimEditorId(TEST_PATH);
        Assert.assertTrue((boolean)settingsDock.getPlaceRequest().getParameters().containsKey("scesimeditorid"));
        Assert.assertEquals((Object)TEST_PATH, (Object)settingsDock.getPlaceRequest().getParameter("scesimeditorid", "null"));
        Assert.assertTrue((boolean)toolsDock.getPlaceRequest().getParameters().containsKey("scesimeditorid"));
        Assert.assertEquals((Object)TEST_PATH, (Object)toolsDock.getPlaceRequest().getParameter("scesimeditorid", "null"));
        Assert.assertTrue((boolean)cheatSheetDock.getPlaceRequest().getParameters().containsKey("scesimeditorid"));
        Assert.assertEquals((Object)TEST_PATH, (Object)cheatSheetDock.getPlaceRequest().getParameter("scesimeditorid", "null"));
    }

    @Test
    public void resetDocks() {
        this.abstractScenarioSimulationDocksHandlerSpy.resetDocks();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).reset();
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterMock, (VerificationMode)Mockito.times((int)1))).reset();
        ((CheatSheetPresenter)Mockito.verify((Object)this.cheatSheetPresenterMock, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void addDocks() {
        this.abstractScenarioSimulationDocksHandlerSpy.addDocks();
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerSpy, (VerificationMode)Mockito.times((int)1))).refreshDocks(Matchers.eq((boolean)true), Matchers.eq((boolean)false));
    }

    @Test
    public void removeDocks() {
        this.abstractScenarioSimulationDocksHandlerSpy.removeDocks();
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerSpy, (VerificationMode)Mockito.times((int)1))).refreshDocks(Matchers.eq((boolean)true), Matchers.eq((boolean)true));
    }

    @Test
    public void getCurrentRightDockPlaceRequest() {
        PlaceRequest placeRequest = this.abstractScenarioSimulationDocksHandlerSpy.getCurrentRightDockPlaceRequest("identifier");
        Assert.assertNotNull((Object)placeRequest);
        Assert.assertEquals((Object)"identifier", (Object)placeRequest.getIdentifier());
        Assert.assertNotNull((Object)placeRequest.getParameter("scesimeditorid", ""));
    }

    @Test
    public void getTestToolsView() {
        TestToolsView testToolsViewMock = (TestToolsView)Mockito.mock(TestToolsView.class);
        AbstractWorkbenchActivity activityMock = (AbstractWorkbenchActivity)Mockito.mock(AbstractWorkbenchActivity.class);
        Mockito.when((Object)activityMock.getWidget()).thenReturn((Object)testToolsViewMock);
        PlaceRequest placeRequest = this.abstractScenarioSimulationDocksHandlerSpy.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.TestTools");
        Mockito.when((Object)this.placeManagerMock.getActivity((PlaceRequest)Matchers.eq((Object)placeRequest))).thenReturn((Object)activityMock);
        Optional optional = this.abstractScenarioSimulationDocksHandlerSpy.getTestToolsView(placeRequest);
        Assert.assertSame((Object)testToolsViewMock, optional.get());
    }

    @Test
    public void getTestToolsView_NullActivity() {
        PlaceRequest placeRequest = this.abstractScenarioSimulationDocksHandlerSpy.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.TestTools");
        Mockito.when((Object)this.placeManagerMock.getActivity((PlaceRequest)Matchers.eq((Object)placeRequest))).thenReturn(null);
        Optional optional = this.abstractScenarioSimulationDocksHandlerSpy.getTestToolsView(placeRequest);
        Assert.assertFalse((boolean)optional.isPresent());
    }

    @Test
    public void getCheatSheetView() {
        CheatSheetView cheatSheetViewMock = (CheatSheetView)Mockito.mock(CheatSheetView.class);
        AbstractWorkbenchActivity activityMock = (AbstractWorkbenchActivity)Mockito.mock(AbstractWorkbenchActivity.class);
        Mockito.when((Object)activityMock.getWidget()).thenReturn((Object)cheatSheetViewMock);
        PlaceRequest placeRequest = this.abstractScenarioSimulationDocksHandlerSpy.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.CheatSheet");
        Mockito.when((Object)this.placeManagerMock.getActivity((PlaceRequest)Matchers.eq((Object)placeRequest))).thenReturn((Object)activityMock);
        Optional optional = this.abstractScenarioSimulationDocksHandlerSpy.getCheatSheetView(placeRequest);
        Assert.assertSame((Object)cheatSheetViewMock, optional.get());
    }

    @Test
    public void getCheatSheetView_NullActivity() {
        PlaceRequest placeRequest = this.abstractScenarioSimulationDocksHandlerSpy.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.CheatSheet");
        Mockito.when((Object)this.placeManagerMock.getActivity((PlaceRequest)Matchers.eq((Object)placeRequest))).thenReturn(null);
        Optional optional = this.abstractScenarioSimulationDocksHandlerSpy.getCheatSheetView(placeRequest);
        Assert.assertFalse((boolean)optional.isPresent());
    }

    @Test
    public void getSettingsView() {
        SettingsView settingsViewMock = (SettingsView)Mockito.mock(SettingsView.class);
        AbstractWorkbenchActivity activityMock = (AbstractWorkbenchActivity)Mockito.mock(AbstractWorkbenchActivity.class);
        Mockito.when((Object)activityMock.getWidget()).thenReturn((Object)settingsViewMock);
        PlaceRequest placeRequest = this.abstractScenarioSimulationDocksHandlerSpy.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.Settings");
        Mockito.when((Object)this.placeManagerMock.getActivity((PlaceRequest)Matchers.eq((Object)placeRequest))).thenReturn((Object)activityMock);
        Optional optional = this.abstractScenarioSimulationDocksHandlerSpy.getSettingsView(placeRequest);
        Assert.assertSame((Object)settingsViewMock, optional.get());
    }

    @Test
    public void getSettings_NullActivity() {
        PlaceRequest placeRequest = this.abstractScenarioSimulationDocksHandlerSpy.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.Settings");
        Mockito.when((Object)this.placeManagerMock.getActivity((PlaceRequest)Matchers.eq((Object)placeRequest))).thenReturn(null);
        Optional optional = this.abstractScenarioSimulationDocksHandlerSpy.getSettingsView(placeRequest);
        Assert.assertFalse((boolean)optional.isPresent());
    }

    private static enum MANAGED_DOCKS {
        SETTINGS,
        TOOLS,
        CHEATSHEET;

    }
}

