/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractNewScenarioTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.NewScenarioSimulationHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.SourceTypeSelector;
import org.drools.workbench.screens.scenariosimulation.client.handlers.TitledAttachmentFileWidget;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.ActivityResourceType;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewScenarioSimulationHandlerTest
extends AbstractNewScenarioTest {
    @Mock
    private BusyIndicatorView busyIndicatorViewMock;
    @Mock
    private ScenarioSimulationService scenarioSimulationServiceMock;
    @Mock
    private ScenarioSimulationResourceType resourceTypeMock;
    @Mock
    private EventSourceMock notificationEventMock;
    @Mock
    private EventSourceMock newResourceSuccessEventMock;
    @Mock
    private PlaceManager placeManagerMock;
    @Mock
    private AuthorizationManager authorizationManagerMock;
    @Mock
    private SessionInfo sessionInfoMock;
    @Mock
    private User userMock;
    @Captor
    private ArgumentCaptor<ResourceRef> refArgumentCaptor;
    @Mock
    private TitledAttachmentFileWidget uploadWidgetMock;
    @Mock
    private SourceTypeSelector sourceTypeSelectorMock;
    private NewScenarioSimulationHandler handler;
    private CallerMock<ScenarioSimulationService> scenarioSimulationServiceCallerMock;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.scenarioSimulationServiceCallerMock = new CallerMock((Object)this.scenarioSimulationServiceMock);
        this.handler = (NewScenarioSimulationHandler)Mockito.spy((Object)new NewScenarioSimulationHandler(this.resourceTypeMock, this.busyIndicatorViewMock, (Event)this.notificationEventMock, (Event)this.newResourceSuccessEventMock, this.placeManagerMock, (Caller)this.scenarioSimulationServiceCallerMock, this.authorizationManagerMock, this.sessionInfoMock, this.scenarioSimulationDropdownMock){
            {
                this.uploadWidget = NewScenarioSimulationHandlerTest.this.uploadWidgetMock;
                this.sourceTypeSelector = NewScenarioSimulationHandlerTest.this.sourceTypeSelectorMock;
            }
        });
        Mockito.when((Object)this.sessionInfoMock.getIdentity()).thenReturn((Object)this.userMock);
    }

    @Test
    public void createValidDMO() {
        this.createCommon(ScenarioSimulationModel.Type.RULE, true, true);
    }

    @Test
    public void createInvalidDMN() {
        this.createCommon(ScenarioSimulationModel.Type.DMN, false, false);
    }

    @Test
    public void createValidDMN() {
        this.createCommon(ScenarioSimulationModel.Type.DMN, true, true);
    }

    @Test
    public void checkCanCreateWhenFeatureDisabled() {
        Mockito.when((Object)this.authorizationManagerMock.authorize((Resource)Matchers.any(ResourceRef.class), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.userMock))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.handler.canCreate());
        this.assertResourceRef();
    }

    @Test
    public void checkCanCreateWhenFeatureEnabled() {
        Mockito.when((Object)this.authorizationManagerMock.authorize((Resource)Matchers.any(ResourceRef.class), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.userMock))).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.handler.canCreate());
        this.assertResourceRef();
    }

    @Test
    public void checkRightResourceType() throws Exception {
        ((SourceTypeSelector)Mockito.doReturn((Object)true).when((Object)this.sourceTypeSelectorMock)).validate();
        Mockito.when((Object)this.sourceTypeSelectorMock.getSelectedType()).thenReturn((Object)ScenarioSimulationModel.Type.RULE);
        this.handler.create(new Package(), "newfile.scesim", (NewResourcePresenter)Mockito.mock(NewResourcePresenter.class));
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorViewMock)).showBusyIndicator("Saving");
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorViewMock)).hideBusyIndicator();
        ((EventSourceMock)Mockito.verify((Object)this.notificationEventMock)).fire(Matchers.any(NotificationEvent.class));
        ((EventSourceMock)Mockito.verify((Object)this.newResourceSuccessEventMock)).fire(Matchers.any(NewResourcePresenter.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManagerMock)).goTo((Path)Matchers.any(Path.class));
    }

    @Test
    public void getCommandMethod() {
        NewResourcePresenter newResourcePresenterMock = (NewResourcePresenter)Mockito.mock(NewResourcePresenter.class);
        this.handler.getCommandMethod(newResourcePresenterMock);
        ((TitledAttachmentFileWidget)Mockito.verify((Object)this.uploadWidgetMock, (VerificationMode)Mockito.times((int)1))).clearStatus();
        ((NewResourcePresenter)Mockito.verify((Object)newResourcePresenterMock, (VerificationMode)Mockito.times((int)1))).show((NewResourceHandler)Matchers.any());
    }

    private void createCommon(ScenarioSimulationModel.Type type, boolean validate, boolean called) {
        ((SourceTypeSelector)Mockito.doReturn((Object)validate).when((Object)this.sourceTypeSelectorMock)).validate();
        Mockito.when((Object)this.sourceTypeSelectorMock.getSelectedType()).thenReturn((Object)type);
        this.handler.create((Package)Mockito.mock(Package.class), "BASEFILENAME", (NewResourcePresenter)Mockito.mock(NewResourcePresenter.class));
        if (called) {
            ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorViewMock, (VerificationMode)Mockito.times((int)1))).showBusyIndicator((String)Matchers.eq((Object)CommonConstants.INSTANCE.Saving()));
            ((ScenarioSimulationService)Mockito.verify((Object)this.scenarioSimulationServiceMock, (VerificationMode)Mockito.times((int)1))).create((Path)Matchers.any(), (String)Matchers.any(), (ScenarioSimulationModel)Matchers.any(), (String)Matchers.any(), (ScenarioSimulationModel.Type)Matchers.any(), (String)Matchers.isNull(String.class));
        }
    }

    private void assertResourceRef() {
        ((AuthorizationManager)Mockito.verify((Object)this.authorizationManagerMock)).authorize((Resource)this.refArgumentCaptor.capture(), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.userMock));
        Assert.assertEquals((Object)"ScenarioSimulationEditor", (Object)((ResourceRef)this.refArgumentCaptor.getValue()).getIdentifier());
        Assert.assertEquals((Object)ActivityResourceType.EDITOR, (Object)((ResourceRef)this.refArgumentCaptor.getValue()).getResourceType());
    }
}

