/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import java.util.Optional;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationGridHandlerTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationMainGridPanelMouseMoveHandler;
import org.drools.workbench.screens.scenariosimulation.client.popover.ErrorReportPopoverPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popover.PopoverView;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioSimulationMainGridPanelMouseMoveHandlerTest
extends AbstractScenarioSimulationGridHandlerTest {
    private final int ABSOLUTE_LEFT = 0;
    private final int CELL_HEIGHT = 30;
    private ScenarioSimulationMainGridPanelMouseMoveHandler mouseMoveHandler;
    @Mock
    private ErrorReportPopoverPresenter errorReportPopupPresenterMock;
    @Mock
    private Scenario scenarioMock;
    @Mock
    private FactMappingValue factMappingValueMock;
    @Mock
    private AbsolutePanel scrollPanelMock;
    @Mock
    private NodeMouseMoveEvent mouseMoveEvent;
    @Mock
    private Element elementMock;
    @Mock
    private DivElement layerElementMock;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.mouseMoveHandler = (ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.spy((Object)new ScenarioSimulationMainGridPanelMouseMoveHandler(){
            {
                this.errorReportPopupPresenter = ScenarioSimulationMainGridPanelMouseMoveHandlerTest.this.errorReportPopupPresenterMock;
                this.scenarioGrid = ScenarioSimulationMainGridPanelMouseMoveHandlerTest.this.scenarioGridMock;
                this.scenarioGridPanel = ScenarioSimulationMainGridPanelMouseMoveHandlerTest.this.scenarioGridPanelMock;
            }

            protected Point2D retrieveCellMiddleXYPosition(GridColumn<?> column, int uiRowIndex) {
                return new Point2D((double)TestProperties.DX.intValue(), (double)TestProperties.DY.intValue());
            }

            protected Point2D convertDOMToGridCoordinateLocal(double canvasX, double canvasY) {
                return new Point2D((double)TestProperties.MX.intValue(), (double)TestProperties.MY.intValue());
            }

            protected int getCellHeight(GridColumn<?> column, int uiRowIndex) {
                return 30;
            }
        });
        Mockito.when((Object)this.simulationMock.getDataByIndex(((Integer)Matchers.isA(Integer.class)).intValue())).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactMapping)Matchers.any())).thenReturn(Optional.of(this.factMappingValueMock));
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        Mockito.when((Object)this.factMappingValueMock.getRawValue()).thenReturn((Object)"raw");
        Mockito.when((Object)this.factMappingValueMock.getErrorValue()).thenReturn((Object)"error");
        Mockito.when((Object)this.scenarioGridLayerMock.getWidth()).thenReturn((Object)TestProperties.LARGE_LAYER);
        Mockito.when((Object)this.gridColumnMock.getWidth()).thenReturn((Object)TestProperties.CELL_WIDTH);
        Mockito.when((Object)this.scenarioGridPanelMock.getScrollPanel()).thenReturn((Object)this.scrollPanelMock);
        Mockito.when((Object)this.scrollPanelMock.getElement()).thenReturn((Object)this.elementMock);
        Mockito.when((Object)this.elementMock.getScrollTop()).thenReturn((Object)0);
        Mockito.when((Object)this.elementMock.getScrollLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.errorReportPopupPresenterMock.isShown()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.mouseMoveEvent.getX()).thenReturn((Object)TestProperties.MX);
        Mockito.when((Object)this.mouseMoveEvent.getY()).thenReturn((Object)TestProperties.MY);
        Mockito.when((Object)this.layerElementMock.getAbsoluteLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridLayerMock.getElement()).thenReturn((Object)this.layerElementMock);
    }

    @Test
    public void onNodeMouseMove() {
        this.mouseMoveHandler.onNodeMouseMove(this.mouseMoveEvent);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).manageCoordinates(((Integer)Matchers.eq((Object)TestProperties.MX)).intValue(), ((Integer)Matchers.eq((Object)TestProperties.MY)).intValue());
    }

    @Test
    public void hidePopover() {
        this.mouseMoveHandler.hidePopover();
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void manageBodyCoordinatesNotInGrid() {
        boolean inGrid = this.mouseMoveHandler.manageBodyCoordinates(Integer.valueOf(-1), Integer.valueOf(-1));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.never())).getDataByIndex(((Integer)Matchers.isA(Integer.class)).intValue());
        ((ScesimModelDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.never())).getFactMappingByIndex(((Integer)Matchers.isA(Integer.class)).intValue());
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.never())).getFactMappingValue((FactMapping)Matchers.any());
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.never())).retrieveCellMiddleXYPosition((GridColumn)Matchers.any(), ((Integer)Matchers.isA(Integer.class)).intValue());
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.never())).setup((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (Command)Matchers.any(), ((Integer)Matchers.isA(Integer.class)).intValue(), ((Integer)Matchers.isA(Integer.class)).intValue(), (PopoverView.Position)Matchers.any());
        Assert.assertFalse((boolean)inGrid);
    }

    @Test
    public void manageBodyCoordinatesSameCellIsShown() {
        this.mouseMoveHandler.currentlyShownBodyRowIndex = 2;
        this.mouseMoveHandler.currentlyShownBodyColumnIndex = 3;
        ((ErrorReportPopoverPresenter)Mockito.doReturn((Object)true).when((Object)this.errorReportPopupPresenterMock)).isShown();
        this.mouseMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.never())).getModel();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.never())).getDataByIndex(Matchers.eq((int)2));
    }

    @Test
    public void manageBodyCoordinatesSameCellNotShown() {
        this.mouseMoveHandler.currentlyShownBodyRowIndex = 2;
        this.mouseMoveHandler.currentlyShownBodyColumnIndex = 3;
        ((ErrorReportPopoverPresenter)Mockito.doReturn((Object)false).when((Object)this.errorReportPopupPresenterMock)).isShown();
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.doNothing().when((Object)this.mouseMoveHandler)).manageFactMappingValue((FactMappingValue)Matchers.eq((Object)this.factMappingValueMock), Integer.valueOf(Matchers.eq((int)2)), Integer.valueOf(Matchers.eq((int)3)));
        this.mouseMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).getModel();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getDataByIndex(Matchers.eq((int)2));
    }

    @Test
    public void manageBodyCoordinatesNotShownWithoutFactMappingValue() {
        ((ErrorReportPopoverPresenter)Mockito.doReturn((Object)false).when((Object)this.errorReportPopupPresenterMock)).isShown();
        ((Scenario)Mockito.doReturn(Optional.empty()).when((Object)this.scenarioMock)).getFactMappingValue((FactMapping)Matchers.eq((Object)this.factMappingMock));
        this.mouseMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).getModel();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getDataByIndex(Matchers.eq((int)2));
        ((ScesimModelDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)3));
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.times((int)1))).getFactMappingValue((FactMapping)Matchers.eq((Object)this.factMappingMock));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.never())).manageFactMappingValue((FactMappingValue)Matchers.isA(FactMappingValue.class), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()));
    }

    @Test
    public void manageBodyCoordinatesNotShownWithFactMappingValue() {
        ((ErrorReportPopoverPresenter)Mockito.doReturn((Object)false).when((Object)this.errorReportPopupPresenterMock)).isShown();
        ((Scenario)Mockito.doReturn(Optional.of(this.factMappingValueMock)).when((Object)this.scenarioMock)).getFactMappingValue((FactMapping)Matchers.eq((Object)this.factMappingMock));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.doNothing().when((Object)this.mouseMoveHandler)).manageFactMappingValue((FactMappingValue)Matchers.eq((Object)this.factMappingValueMock), Integer.valueOf(Matchers.eq((int)2)), Integer.valueOf(Matchers.eq((int)3)));
        this.mouseMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).getModel();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getDataByIndex(Matchers.eq((int)2));
        ((ScesimModelDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)3));
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.times((int)1))).getFactMappingValue((FactMapping)Matchers.eq((Object)this.factMappingMock));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).manageFactMappingValue((FactMappingValue)Matchers.eq((Object)this.factMappingValueMock), Integer.valueOf(Matchers.eq((int)2)), Integer.valueOf(Matchers.eq((int)3)));
    }

    @Test
    public void manageFactMappingValueSuccess() {
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.SUCCESS);
        this.mouseMoveHandler.manageFactMappingValue(this.factMappingValueMock, Integer.valueOf(2), Integer.valueOf(3));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.never())).manageFailedFactMappingValue((FactMappingValue)Matchers.eq((Object)this.factMappingValueMock), Integer.valueOf(Matchers.eq((int)2)), Integer.valueOf(Matchers.eq((int)3)));
    }

    @Test
    public void manageFactMappingValueNotSuccess() {
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.doNothing().when((Object)this.mouseMoveHandler)).manageFailedFactMappingValue((FactMappingValue)Matchers.eq((Object)this.factMappingValueMock), Integer.valueOf(Matchers.eq((int)2)), Integer.valueOf(Matchers.eq((int)3)));
        this.mouseMoveHandler.manageFactMappingValue(this.factMappingValueMock, Integer.valueOf(2), Integer.valueOf(3));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).manageFailedFactMappingValue((FactMappingValue)Matchers.eq((Object)this.factMappingValueMock), Integer.valueOf(Matchers.eq((int)2)), Integer.valueOf(Matchers.eq((int)3)));
    }

    @Test
    public void manageFailedFactMappingValueRight() {
        int expectedDx = (int)(TestProperties.CELL_WIDTH / 2.0) + TestProperties.DX;
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.doNothing().when((Object)this.mouseMoveHandler)).setupPopupPresenter((FactMappingValue)Matchers.eq((Object)this.factMappingValueMock), Matchers.eq((int)0), Matchers.eq((int)3), Matchers.eq((int)expectedDx), ((Integer)Matchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.RIGHT));
        this.mouseMoveHandler.manageFailedFactMappingValue(this.factMappingValueMock, Integer.valueOf(0), Integer.valueOf(3));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).retrieveCellMiddleXYPosition((GridColumn)this.gridColumnMock, 0);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).setupPopupPresenter((FactMappingValue)Matchers.eq((Object)this.factMappingValueMock), Matchers.eq((int)0), Matchers.eq((int)3), Matchers.eq((int)expectedDx), ((Integer)Matchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.RIGHT));
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void manageFailedFactMappingValueLeft() {
        Mockito.when((Object)this.scenarioGridLayerMock.getWidth()).thenReturn((Object)TestProperties.TINY_LAYER);
        int expectedDx = (int)((double)TestProperties.DX.intValue() - TestProperties.CELL_WIDTH / 2.0);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.doNothing().when((Object)this.mouseMoveHandler)).setupPopupPresenter((FactMappingValue)Matchers.eq((Object)this.factMappingValueMock), Matchers.eq((int)0), Matchers.eq((int)3), Matchers.eq((int)expectedDx), ((Integer)Matchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.RIGHT));
        this.mouseMoveHandler.manageFailedFactMappingValue(this.factMappingValueMock, Integer.valueOf(0), Integer.valueOf(3));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).retrieveCellMiddleXYPosition((GridColumn)this.gridColumnMock, 0);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).setupPopupPresenter((FactMappingValue)Matchers.eq((Object)this.factMappingValueMock), Matchers.eq((int)0), Matchers.eq((int)3), Matchers.eq((int)expectedDx), ((Integer)Matchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.LEFT));
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void manageFailedFactMappingValueTop() {
        Mockito.when((Object)this.scenarioGridLayerMock.getWidth()).thenReturn((Object)TestProperties.SMALLEST_LAYER);
        Mockito.when((Object)this.layerElementMock.getAbsoluteLeft()).thenReturn((Object)4000);
        int expectedDy = TestProperties.DY - 15;
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.doNothing().when((Object)this.mouseMoveHandler)).setupPopupPresenter((FactMappingValue)Matchers.eq((Object)this.factMappingValueMock), Matchers.eq((int)0), Matchers.eq((int)3), ((Integer)Matchers.eq((Object)TestProperties.DX)).intValue(), Matchers.eq((int)expectedDy), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.RIGHT));
        this.mouseMoveHandler.manageFailedFactMappingValue(this.factMappingValueMock, Integer.valueOf(0), Integer.valueOf(3));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).retrieveCellMiddleXYPosition((GridColumn)this.gridColumnMock, 0);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).setupPopupPresenter((FactMappingValue)Matchers.eq((Object)this.factMappingValueMock), Matchers.eq((int)0), Matchers.eq((int)3), ((Integer)Matchers.eq((Object)TestProperties.DX)).intValue(), Matchers.eq((int)expectedDy), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.TOP));
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void setupPopupPresenterFailedWithoutValues() {
        Mockito.when((Object)this.factMappingValueMock.getRawValue()).thenReturn(null);
        Mockito.when((Object)this.factMappingValueMock.getErrorValue()).thenReturn(null);
        this.mouseMoveHandler.setupPopupPresenter(this.factMappingValueMock, 2, 3, TestProperties.DX.intValue(), TestProperties.DY.intValue(), PopoverView.Position.RIGHT);
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).setup((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorReason()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithError("null", "null")), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.keep()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.apply()), (Command)Matchers.isA(Command.class), ((Integer)Matchers.eq((Object)TestProperties.DX)).intValue(), ((Integer)Matchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.RIGHT));
    }

    @Test
    public void setupPopupPresenterWithScrollFailedWithError() {
        Mockito.when((Object)this.elementMock.getScrollTop()).thenReturn((Object)TestProperties.SCROLL_TOP);
        Mockito.when((Object)this.elementMock.getScrollLeft()).thenReturn((Object)TestProperties.SCROLL_LEFT);
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        this.mouseMoveHandler.setupPopupPresenter(this.factMappingValueMock, 2, 3, TestProperties.DX.intValue(), TestProperties.DY.intValue(), PopoverView.Position.RIGHT);
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).setup((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorReason()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithError("raw", "error")), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.keep()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.apply()), (Command)Matchers.isA(Command.class), ((Integer)Matchers.eq((Object)TestProperties.DX)).intValue(), ((Integer)Matchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.RIGHT));
    }

    @Test
    public void setupPopupPresenterWithScrollFailedWithException() {
        Mockito.when((Object)this.elementMock.getScrollTop()).thenReturn((Object)TestProperties.SCROLL_TOP);
        Mockito.when((Object)this.elementMock.getScrollLeft()).thenReturn((Object)TestProperties.SCROLL_LEFT);
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION);
        Mockito.when((Object)this.factMappingValueMock.getExceptionMessage()).thenReturn((Object)"GenericException");
        this.mouseMoveHandler.setupPopupPresenter(this.factMappingValueMock, 2, 3, TestProperties.DX.intValue(), TestProperties.DY.intValue(), PopoverView.Position.RIGHT);
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).setup((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorReason()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithException("GenericException")), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.close()), ((Integer)Matchers.eq((Object)TestProperties.DX)).intValue(), ((Integer)Matchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)Matchers.eq((Object)PopoverView.Position.RIGHT));
    }
}

