/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ClickEvent;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.AbstractCollectionEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ElementView;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class ElementViewImplTest<E extends ElementView, T extends ElementView.Presenter<E>>
extends AbstractCollectionEditorTest {
    protected T elementPresenterMock;
    protected E elementView;

    @Override
    protected void setup() {
        super.setup();
    }

    @Test
    public void onFaAngleRightClick() {
        Mockito.when((Object)this.faAngleRightMock.getClassName()).thenReturn((Object)"fa-angle-right");
        this.elementView.onFaAngleRightClick(this.clickEventMock);
        ((ElementView.Presenter)Mockito.verify(this.elementPresenterMock, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion((ElementView)Matchers.eq(this.elementView), Matchers.eq((boolean)false));
        ((ClickEvent)Mockito.verify((Object)this.clickEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
        Mockito.reset((Object[])new ClickEvent[]{this.clickEventMock});
        Mockito.reset((Object[])new ElementView.Presenter[]{this.elementPresenterMock});
        Mockito.when((Object)this.faAngleRightMock.getClassName()).thenReturn((Object)"fa-angle-down");
        this.elementView.onFaAngleRightClick(this.clickEventMock);
        ((ElementView.Presenter)Mockito.verify(this.elementPresenterMock, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion((ElementView)Matchers.eq(this.elementView), Matchers.eq((boolean)true));
        ((ClickEvent)Mockito.verify((Object)this.clickEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
    }

    @Test
    public void onEditItemButtonClick() {
        this.elementView.onEditItemButtonClick(this.clickEventMock);
        ((ElementView.Presenter)Mockito.verify(this.elementPresenterMock, (VerificationMode)Mockito.times((int)1))).onEditItem((ElementView)Matchers.eq(this.elementView));
        ((ClickEvent)Mockito.verify((Object)this.clickEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
    }

    @Test
    public void onDeleteItemButtonClick() {
        this.elementView.onDeleteItemButtonClick(this.clickEventMock);
        ((ElementView.Presenter)Mockito.verify(this.elementPresenterMock, (VerificationMode)Mockito.times((int)1))).onDeleteItem((ElementView)Matchers.eq(this.elementView));
        ((ClickEvent)Mockito.verify((Object)this.clickEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
    }

    @Test
    public void onSaveChangeButtonClick() {
        this.elementView.onSaveChangeButtonClick(this.clickEventMock);
        ((ElementView.Presenter)Mockito.verify(this.elementPresenterMock, (VerificationMode)Mockito.times((int)1))).updateItem((ElementView)Matchers.eq(this.elementView));
        ((ClickEvent)Mockito.verify((Object)this.clickEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
    }

    @Test
    public void onCancelChangeButton() {
        this.elementView.onCancelChangeButton(this.clickEventMock);
        ((ElementView.Presenter)Mockito.verify(this.elementPresenterMock, (VerificationMode)Mockito.times((int)1))).onStopEditingItem((ElementView)Matchers.eq(this.elementView));
        ((ClickEvent)Mockito.verify((Object)this.clickEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
    }

    @Test
    public void isShown() {
        Mockito.when((Object)this.faAngleRightMock.getClassName()).thenReturn((Object)"fa-angle-down");
        Assert.assertTrue((boolean)this.elementView.isShown());
        Mockito.when((Object)this.faAngleRightMock.getClassName()).thenReturn((Object)"fa-angle-right");
        Assert.assertFalse((boolean)this.elementView.isShown());
    }

    @Test
    public void toggleRowExpansion() {
        this.commonToggleRowExpansion(true);
        this.commonToggleRowExpansion(false);
    }

    private void commonToggleRowExpansion(boolean toExpand) {
        String classToAdd = toExpand ? "fa-angle-down" : "fa-angle-right";
        String classToRemove = toExpand ? "fa-angle-right" : "fa-angle-down";
        this.elementView.toggleRowExpansion(toExpand);
        ((SpanElement)Mockito.verify((Object)this.faAngleRightMock, (VerificationMode)Mockito.times((int)1))).addClassName((String)Matchers.eq((Object)classToAdd));
        ((SpanElement)Mockito.verify((Object)this.faAngleRightMock, (VerificationMode)Mockito.times((int)1))).removeClassName((String)Matchers.eq((Object)classToRemove));
        Mockito.reset((Object[])new SpanElement[]{this.faAngleRightMock});
    }
}

