/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.BackgroundDataWithIndex;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.AbstractScenarioSimulationEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioMenuItem;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorWrapper;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.ImportEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.RedoEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioNotificationEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.UndoEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationDocksHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationHasBusyIndicatorDefaultErrorCallback;
import org.drools.workbench.screens.scenariosimulation.client.popup.ConfirmPopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.producers.AbstractScenarioSimulationProducer;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridWidget;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.drools.workbench.screens.scenariosimulation.model.SimulationRunResult;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDocksInteractionEvent;
import org.uberfire.ext.editor.commons.client.file.exports.TextFileExport;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={ScenarioMenuItem.class})
public class ScenarioSimulationEditorPresenterTest
extends AbstractScenarioSimulationEditorTest {
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    @Mock
    private ScenarioSimulationEditorWrapper scenarioSimulationEditorWrapperMock;
    @Mock
    private ScenarioSimulationView scenarioSimulationViewMock;
    @Mock
    private AbstractScenarioSimulationProducer abstractScenarioSimulationProducerMock;
    @Mock
    private PlaceManager placeManagerMock;
    @Mock
    private AbstractWorkbenchActivity testToolsActivityMock;
    @Mock
    private TestToolsView testToolsViewMock;
    @Mock
    private ObservablePath pathMock;
    @Mock
    private PathPlaceRequest placeRequestMock;
    @Mock
    private AbstractScenarioSimulationDocksHandler abstractScenarioSimulationDocksHandlerMock;
    @Mock
    private ScenarioMenuItem runScenarioMenuItemMock;
    @Mock
    private ScenarioMenuItem undoMenuItemMock;
    @Mock
    private ScenarioMenuItem redoMenuItemMock;
    @Mock
    private ScenarioMenuItem exportToCsvMenuItemMock;
    @Mock
    private ScenarioMenuItem importMenuItemMock;
    @Mock
    private ScenarioMenuItem downloadMenuItemMock;
    @Mock
    private DataManagementStrategy dataManagementStrategyMock;
    @Mock
    private TextFileExport textFileExportMock;
    @Mock
    private ConfirmPopupPresenter confirmPopupPresenterMock;
    @Captor
    private ArgumentCaptor<List<ScenarioWithIndex>> scenarioWithIndexCaptor;
    @Captor
    private ArgumentCaptor<ScenarioNotificationEvent> scenarioNotificationEventArgumentCaptor;
    private ScenarioSimulationEditorPresenter presenterSpy;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.abstractScenarioSimulationProducerMock.getScenarioSimulationView()).thenReturn((Object)this.scenarioSimulationViewMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getScenarioGridWidget()).thenReturn((Object)this.scenarioGridWidgetSpy);
        Mockito.when((Object)this.abstractScenarioSimulationProducerMock.getScenarioBackgroundGridWidget()).thenReturn((Object)this.backgroundGridWidgetSpy);
        Mockito.when((Object)this.placeRequestMock.getIdentifier()).thenReturn((Object)"ScenarioSimulationEditor");
        Mockito.when((Object)this.testToolsViewMock.getPresenter()).thenReturn((Object)this.testToolsPresenterMock);
        Mockito.when((Object)this.testToolsActivityMock.getWidget()).thenReturn((Object)this.testToolsViewMock);
        Mockito.when((Object)this.placeRequestMock.getPath()).thenReturn((Object)this.pathMock);
        Mockito.when((Object)this.simulationMock.getUnmodifiableData()).thenReturn(Arrays.asList(new Scenario()));
        Mockito.when((Object)this.abstractScenarioSimulationDocksHandlerMock.getTestToolsPresenter()).thenReturn(Optional.ofNullable(this.testToolsPresenterMock));
        Mockito.when((Object)this.abstractScenarioSimulationDocksHandlerMock.getSettingsPresenter()).thenReturn(Optional.ofNullable(this.settingsPresenterMock));
        this.presenterSpy = (ScenarioSimulationEditorPresenter)Mockito.spy((Object)new ScenarioSimulationEditorPresenter(this.abstractScenarioSimulationProducerMock, (ScenarioSimulationResourceType)Mockito.mock(ScenarioSimulationResourceType.class), this.placeManagerMock, this.abstractScenarioSimulationDocksHandlerMock, this.textFileExportMock, this.confirmPopupPresenterMock){
            {
                this.path = ScenarioSimulationEditorPresenterTest.this.pathMock;
                this.packageName = "scenario.package";
                this.eventBus = ScenarioSimulationEditorPresenterTest.this.eventBusMock;
                this.context = ScenarioSimulationEditorPresenterTest.this.scenarioSimulationContextLocal;
                this.dataManagementStrategy = ScenarioSimulationEditorPresenterTest.this.dataManagementStrategyMock;
                this.model = ScenarioSimulationEditorPresenterTest.this.scenarioSimulationModelMock;
                this.undoMenuItem = ScenarioSimulationEditorPresenterTest.this.undoMenuItemMock;
                this.redoMenuItem = ScenarioSimulationEditorPresenterTest.this.redoMenuItemMock;
                this.downloadMenuItem = ScenarioSimulationEditorPresenterTest.this.downloadMenuItemMock;
                this.runScenarioMenuItem = ScenarioSimulationEditorPresenterTest.this.runScenarioMenuItemMock;
                this.exportToCSVMenuItem = ScenarioSimulationEditorPresenterTest.this.exportToCsvMenuItemMock;
                this.importMenuItem = ScenarioSimulationEditorPresenterTest.this.importMenuItemMock;
                this.scenarioSimulationEditorWrapper = ScenarioSimulationEditorPresenterTest.this.scenarioSimulationEditorWrapperMock;
            }

            protected void clearTestToolsStatus() {
            }

            protected void open(String downloadURL) {
            }

            public String getJsonModel(ScenarioSimulationModel model) {
                return "";
            }
        });
    }

    @Test
    public void setWrapper() {
        this.presenterSpy.setWrapper(this.scenarioSimulationEditorWrapperMock);
        Assert.assertSame((Object)this.scenarioSimulationEditorWrapperMock, (Object)this.presenterSpy.scenarioSimulationEditorWrapper);
    }

    @Test
    public void setPath() {
        this.presenterSpy.setPath(this.observablePathMock);
        Assert.assertSame((Object)this.observablePathMock, (Object)this.presenterSpy.path);
    }

    @Test
    public void onClose() {
        this.presenterSpy.onClose();
        ((ScenarioGridWidget)Mockito.verify((Object)this.scenarioGridWidgetSpy, (VerificationMode)Mockito.times((int)1))).unregister();
        ((ScenarioGridWidget)Mockito.verify((Object)this.backgroundGridWidgetSpy, (VerificationMode)Mockito.times((int)1))).unregister();
    }

    @Test
    public void showDocks_PlaceStatusOpen() {
        this.presenterSpy.showDocks(PlaceStatus.OPEN);
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).addDocks();
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).setScesimEditorId((String)Matchers.eq((Object)String.valueOf(this.presenterSpy.scenarioPresenterId)));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).expandToolsDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).registerTestToolsCallback();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).resetDocks();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateRightDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.TestTools"));
    }

    @Test
    public void showDocks_PlaceStatusClose() {
        this.presenterSpy.showDocks(PlaceStatus.CLOSE);
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).addDocks();
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).setScesimEditorId((String)Matchers.eq((Object)String.valueOf(this.presenterSpy.scenarioPresenterId)));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).expandToolsDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).registerTestToolsCallback();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).resetDocks();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateRightDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.TestTools"));
    }

    @Test
    public void hideDocks() {
        this.presenterSpy.hideDocks();
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerMock)).removeDocks();
        ((ScenarioGridWidget)Mockito.verify((Object)this.scenarioGridWidgetSpy, (VerificationMode)Mockito.times((int)1))).clearSelections();
        ((ScenarioGridWidget)Mockito.verify((Object)this.backgroundGridWidgetSpy, (VerificationMode)Mockito.times((int)1))).clearSelections();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy)).unRegisterTestToolsCallback();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy)).clearTestToolsStatus();
    }

    @Test
    public void expandToolsDock() {
        this.presenterSpy.expandToolsDock();
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).expandToolsDock();
    }

    @Test
    public void reloadTestTools_NotDisable() {
        this.presenterSpy.reloadTestTools(false);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateRightDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.TestTools"));
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.never())).getTestToolsPresenter();
    }

    @Test
    public void reloadTestTools_Disable() {
        this.presenterSpy.reloadTestTools(true);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateRightDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.TestTools"));
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).getTestToolsPresenter();
    }

    @Test
    public void onRunTest() {
        this.presenterSpy.onRunScenario();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).onRunScenario((List)Matchers.eq(Arrays.asList(0)));
    }

    @Test
    public void onRunScenario() {
        this.scenarioWithIndexLocal.add(new ScenarioWithIndex(1, new Scenario()));
        this.scenarioWithIndexLocal.add(new ScenarioWithIndex(2, new Scenario()));
        this.scenarioWithIndexLocal.add(new ScenarioWithIndex(3, new Scenario()));
        Mockito.when((Object)this.simulationMock.getDataByIndex(Matchers.anyInt())).thenReturn(Mockito.mock(Scenario.class));
        List<Integer> indexList = Arrays.asList(0, 2);
        this.presenterSpy.onRunScenario(indexList);
        ((ScenarioGridWidget)Mockito.verify((Object)this.scenarioGridWidgetSpy, (VerificationMode)Mockito.times((int)1))).resetErrors();
        ((ScenarioGridWidget)Mockito.verify((Object)this.backgroundGridWidgetSpy, (VerificationMode)Mockito.times((int)1))).resetErrors();
        ((ScenarioSimulationModel)Mockito.verify((Object)this.scenarioSimulationModelMock, (VerificationMode)Mockito.times((int)1))).setSimulation(this.simulationMock);
        ((ScenarioSimulationModel)Mockito.verify((Object)this.scenarioSimulationModelMock, (VerificationMode)Mockito.times((int)1))).setBackground(this.backgroundMock);
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(Matchers.anyString());
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).onRunScenario((RemoteCallback)Matchers.any(), (ScenarioSimulationHasBusyIndicatorDefaultErrorCallback)Matchers.any(), (ScesimModelDescriptor)Matchers.any(), (Settings)Matchers.eq((Object)this.settingsLocal), (List)this.scenarioWithIndexCaptor.capture(), (Background)Matchers.any());
        List capturedValue = (List)this.scenarioWithIndexCaptor.getValue();
        Assert.assertEquals((long)2L, (long)capturedValue.size());
        for (Integer requestedIndex : indexList) {
            Assert.assertEquals((long)1L, (long)capturedValue.stream().filter(elem -> elem.getIndex() == requestedIndex + 1).count());
        }
    }

    @Test
    public void onUndo() {
        this.presenterSpy.onUndo();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(UndoEvent.class));
    }

    @Test
    public void onRedo() {
        this.presenterSpy.onRedo();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(RedoEvent.class));
    }

    @Test
    public void setUndoButtonEnabledStatus() {
        this.presenterSpy.setUndoButtonEnabledStatus(true);
        ((ScenarioMenuItem)Mockito.verify((Object)this.undoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)true));
        Mockito.reset((Object[])new ScenarioMenuItem[]{this.undoMenuItemMock});
        this.presenterSpy.setUndoButtonEnabledStatus(false);
        ((ScenarioMenuItem)Mockito.verify((Object)this.undoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void setRedoButtonEnabledStatus() {
        this.presenterSpy.setRedoButtonEnabledStatus(true);
        ((ScenarioMenuItem)Mockito.verify((Object)this.redoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)true));
        Mockito.reset((Object[])new ScenarioMenuItem[]{this.redoMenuItemMock});
        this.presenterSpy.setRedoButtonEnabledStatus(false);
        ((ScenarioMenuItem)Mockito.verify((Object)this.redoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void setItemMenuEnabledTRUE() {
        this.presenterSpy.setItemMenuEnabled(true);
        ((ScenarioMenuItem)Mockito.verify((Object)this.runScenarioMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)true));
        ((ScenarioMenuItem)Mockito.verify((Object)this.importMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)true));
        ((ScenarioMenuItem)Mockito.verify((Object)this.exportToCsvMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)true));
        ((ScenarioMenuItem)Mockito.verify((Object)this.downloadMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)true));
    }

    @Test
    public void setItemMenuEnabledFALSE() {
        this.presenterSpy.setItemMenuEnabled(false);
        ((ScenarioMenuItem)Mockito.verify((Object)this.runScenarioMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
        ((ScenarioMenuItem)Mockito.verify((Object)this.importMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
        ((ScenarioMenuItem)Mockito.verify((Object)this.exportToCsvMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
        ((ScenarioMenuItem)Mockito.verify((Object)this.downloadMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void onImportSIMULATION() {
        String FILE_CONTENT = "FILE_CONTENT";
        this.presenterSpy.onImport(FILE_CONTENT, GridWidget.SIMULATION);
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).onImport((String)Matchers.eq((Object)FILE_CONTENT), (RemoteCallback)Matchers.isA(RemoteCallback.class), (ErrorCallback)Matchers.isA(ErrorCallback.class), (AbstractScesimModel)Matchers.same((Object)this.simulationMock));
    }

    @Test
    public void onImportBACKGROUND() {
        String FILE_CONTENT = "FILE_CONTENT";
        this.presenterSpy.onImport(FILE_CONTENT, GridWidget.BACKGROUND);
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).onImport((String)Matchers.eq((Object)FILE_CONTENT), (RemoteCallback)Matchers.isA(RemoteCallback.class), (ErrorCallback)Matchers.isA(ErrorCallback.class), (AbstractScesimModel)Matchers.same((Object)this.backgroundMock));
    }

    @Test
    public void onImportCheckSwitch() {
        String FILE_CONTENT = "FILE_CONTENT";
        for (GridWidget gridWidget : GridWidget.values()) {
            this.presenterSpy.onImport(FILE_CONTENT, gridWidget);
        }
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).onImport((String)Matchers.eq((Object)FILE_CONTENT), (RemoteCallback)Matchers.isA(RemoteCallback.class), (ErrorCallback)Matchers.isA(ErrorCallback.class), (AbstractScesimModel)Matchers.eq((Object)this.simulationMock));
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).onImport((String)Matchers.eq((Object)FILE_CONTENT), (RemoteCallback)Matchers.isA(RemoteCallback.class), (ErrorCallback)Matchers.isA(ErrorCallback.class), (AbstractScesimModel)Matchers.eq((Object)this.backgroundMock));
    }

    @Test
    public void resetDocks() {
        this.presenterSpy.resetDocks();
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).resetDocks();
    }

    @Test
    public void onUberfireDocksInteractionEvent() {
        UberfireDocksInteractionEvent uberfireDocksInteractionEventMock = (UberfireDocksInteractionEvent)Mockito.mock(UberfireDocksInteractionEvent.class);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenterSpy)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.never())).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).populateRightDocks(Matchers.anyString());
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.never())).populateDocks(Matchers.anyString());
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenterSpy});
        this.presenterSpy.dataManagementStrategy = null;
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).populateRightDocks(Matchers.anyString());
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.never())).populateDocks(Matchers.anyString());
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenterSpy});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        this.presenterSpy.dataManagementStrategy = this.dataManagementStrategyMock;
        UberfireDock targetDockMock = (UberfireDock)Mockito.mock(UberfireDock.class);
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenterSpy)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"org.drools.scenariosimulation.Settings");
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateRightDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.Settings"));
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).populateDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.Settings"));
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenterSpy});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        this.presenterSpy.dataManagementStrategy = this.dataManagementStrategyMock;
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenterSpy)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"org.drools.scenariosimulation.CheatSheet");
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateRightDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.CheatSheet"));
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).populateDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.CheatSheet"));
        Mockito.reset((Object[])new Object[]{this.presenterSpy, this.scenarioSimulationEditorWrapperMock, uberfireDocksInteractionEventMock});
        this.presenterSpy.dataManagementStrategy = this.dataManagementStrategyMock;
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenterSpy)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"org.drools.scenariosimulation.TestTools");
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)1))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).populateRightDocks(Matchers.anyString());
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.never())).populateDocks(Matchers.anyString());
    }

    @Test
    public void isUberfireDocksInteractionEventToManage() {
        UberfireDocksInteractionEvent uberfireDocksInteractionEventMock = (UberfireDocksInteractionEvent)Mockito.mock(UberfireDocksInteractionEvent.class);
        ((UberfireDocksInteractionEvent)Mockito.doReturn(null).when((Object)uberfireDocksInteractionEventMock)).getTargetDock();
        Assert.assertFalse((boolean)this.presenterSpy.isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock));
        UberfireDock targetDockMock = (UberfireDock)Mockito.mock(UberfireDock.class);
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        Mockito.when((Object)this.placeRequestMock.getParameter((String)Matchers.eq((Object)"scesimeditorid"), (String)Matchers.eq((Object)""))).thenReturn((Object)"UNKNOWN");
        Assert.assertFalse((boolean)this.presenterSpy.isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock));
        ((PathPlaceRequest)Mockito.doReturn((Object)String.valueOf(this.presenterSpy.scenarioPresenterId)).when((Object)this.placeRequestMock)).getParameter((String)Matchers.eq((Object)"scesimeditorid"), (String)Matchers.eq((Object)""));
        Assert.assertTrue((boolean)this.presenterSpy.isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock));
    }

    @Test
    public void refreshModelContent() {
        Mockito.when((Object)this.scenarioSimulationModelMock.getSimulation()).thenReturn((Object)this.simulationMock);
        ArrayList<ScenarioWithIndex> scenarioWithIndex = new ArrayList<ScenarioWithIndex>();
        int scenarioNumber = 1;
        int scenarioIndex = scenarioNumber - 1;
        Scenario scenario = (Scenario)Mockito.mock(Scenario.class);
        scenarioWithIndex.add(new ScenarioWithIndex(scenarioNumber, scenario));
        ArrayList<BackgroundDataWithIndex> backgroundDataWithIndex = new ArrayList<BackgroundDataWithIndex>();
        BackgroundData backgroundData = (BackgroundData)Mockito.mock(BackgroundData.class);
        backgroundDataWithIndex.add(new BackgroundDataWithIndex(scenarioNumber, backgroundData));
        TestResultMessage testResultMessage = (TestResultMessage)Mockito.mock(TestResultMessage.class);
        SimulationRunResult testRunResult = new SimulationRunResult(scenarioWithIndex, backgroundDataWithIndex, new SimulationRunMetadata(), testResultMessage);
        this.presenterSpy.refreshModelContent(testRunResult);
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).replaceData(Matchers.eq((int)scenarioIndex), (AbstractScesimData)Matchers.eq((Object)scenario));
        Assert.assertEquals((Object)this.scenarioSimulationModelMock, (Object)this.presenterSpy.getModel());
        ((ScenarioGridWidget)Mockito.verify((Object)this.scenarioGridWidgetSpy, (VerificationMode)Mockito.times((int)1))).refreshContent((AbstractScesimModel)Matchers.eq((Object)this.simulationMock));
        Assert.assertEquals((Object)this.scenarioSimulationContextLocal.getStatus().getSimulation(), (Object)this.simulationMock);
        ((Background)Mockito.verify((Object)this.backgroundMock, (VerificationMode)Mockito.times((int)1))).replaceData(Matchers.eq((int)scenarioIndex), (AbstractScesimData)Matchers.eq((Object)backgroundData));
        ((ScenarioGridWidget)Mockito.verify((Object)this.backgroundGridWidgetSpy, (VerificationMode)Mockito.times((int)1))).refreshContent((AbstractScesimModel)Matchers.eq((Object)this.backgroundMock));
        Assert.assertEquals((Object)this.scenarioSimulationContextLocal.getStatus().getBackground(), (Object)this.backgroundMock);
        Assert.assertEquals((Object)this.scenarioSimulationModelMock, (Object)this.presenterSpy.getModel());
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).expandTestResultsDock();
        ((DataManagementStrategy)Mockito.verify((Object)this.dataManagementStrategyMock, (VerificationMode)Mockito.times((int)1))).setModel((ScenarioSimulationModel)Matchers.eq((Object)this.scenarioSimulationModelMock));
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).onRefreshedModelContent((SimulationRunResult)Matchers.eq((Object)testRunResult));
    }

    @Test
    public void makeMenuBar() {
        this.presenterSpy.makeMenuBar(this.fileMenuBuilderMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addValidate((Command)Matchers.any());
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).getValidateCommand();
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.runScenarioMenuItemMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.undoMenuItemMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.redoMenuItemMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.exportToCsvMenuItemMock);
        ((ScenarioMenuItem)Mockito.verify((Object)this.undoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
        ((ScenarioMenuItem)Mockito.verify((Object)this.redoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void isDirty() {
        Mockito.when((Object)this.scenarioSimulationViewMock.getScenarioGridWidget()).thenThrow(new Throwable[]{new RuntimeException()});
        Assert.assertFalse((boolean)this.presenterSpy.isDirty());
    }

    @Test
    public void onEditTabSelected() {
        this.presenterSpy.onEditTabSelected();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.presenterSpy, this.scenarioGridWidgetSpy, this.backgroundGridWidgetSpy});
        ((ScenarioSimulationEditorPresenter)inOrder.verify((Object)this.presenterSpy, Mockito.times((int)1))).setItemMenuEnabled(Matchers.eq((boolean)true));
        ((ScenarioSimulationEditorPresenter)inOrder.verify((Object)this.presenterSpy, Mockito.times((int)1))).populateRightDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.TestTools"));
        ((ScenarioGridWidget)inOrder.verify((Object)this.scenarioGridWidgetSpy, Mockito.times((int)1))).selectAndFocus();
        ((ScenarioGridWidget)inOrder.verify((Object)this.backgroundGridWidgetSpy, Mockito.times((int)1))).deselectAndUnFocus();
    }

    @Test
    public void onBackgroundTabSelected() {
        this.presenterSpy.onBackgroundTabSelected();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.presenterSpy, this.scenarioGridWidgetSpy, this.backgroundGridWidgetSpy});
        ((ScenarioSimulationEditorPresenter)inOrder.verify((Object)this.presenterSpy, Mockito.times((int)1))).setItemMenuEnabled(Matchers.eq((boolean)true));
        ((ScenarioSimulationEditorPresenter)inOrder.verify((Object)this.presenterSpy, Mockito.times((int)1))).populateRightDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.TestTools"));
        ((ScenarioGridWidget)inOrder.verify((Object)this.backgroundGridWidgetSpy, Mockito.times((int)1))).selectAndFocus();
        ((ScenarioGridWidget)inOrder.verify((Object)this.scenarioGridWidgetSpy, Mockito.times((int)1))).deselectAndUnFocus();
    }

    @Test
    public void onOverviewSelected() {
        this.presenterSpy.onOverviewSelected();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).setItemMenuEnabled(Matchers.eq((boolean)false));
        ((ScenarioGridWidget)Mockito.verify((Object)this.scenarioGridWidgetSpy, (VerificationMode)Mockito.times((int)1))).deselectAndUnFocus();
        ((ScenarioGridWidget)Mockito.verify((Object)this.backgroundGridWidgetSpy, (VerificationMode)Mockito.times((int)1))).deselectAndUnFocus();
    }

    @Test
    public void onImportsTabSelected() {
        this.presenterSpy.onImportsTabSelected();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).setItemMenuEnabled(Matchers.eq((boolean)false));
        ((ScenarioGridWidget)Mockito.verify((Object)this.scenarioGridWidgetSpy, (VerificationMode)Mockito.times((int)1))).deselectAndUnFocus();
        ((ScenarioGridWidget)Mockito.verify((Object)this.backgroundGridWidgetSpy, (VerificationMode)Mockito.times((int)1))).deselectAndUnFocus();
    }

    @Test
    public void validateSimulation() {
        this.presenterSpy.validateSimulation();
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).validate((Simulation)Matchers.eq((Object)this.simulationMock), (Settings)Matchers.eq((Object)this.settingsLocal), (RemoteCallback)Matchers.isA(RemoteCallback.class));
    }

    @Test
    public void selectSimulationTab() {
        this.presenterSpy.selectSimulationTab();
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).selectSimulationTab();
    }

    @Test
    public void selectBackgroundTab() {
        this.presenterSpy.selectBackgroundTab();
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).selectBackgroundTab();
    }

    @Test
    public void onDownload() {
        String DOWNLOAD_URL = "DOWNLOAD_URL";
        Supplier pathSupplierMock = (Supplier)Mockito.mock(Supplier.class);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)DOWNLOAD_URL).when((Object)this.presenterSpy)).getFileDownloadURL((Supplier)Matchers.eq((Object)pathSupplierMock));
        this.presenterSpy.onDownload(pathSupplierMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).getFileDownloadURL((Supplier)Matchers.eq((Object)pathSupplierMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).open((String)Matchers.eq((Object)DOWNLOAD_URL));
    }

    @Test
    public void showImportDialogSIMULATION() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)true);
        this.presenterSpy.showImportDialog();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(ImportEvent.class));
    }

    @Test
    public void showImportDialogBACKGROUND() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)false);
        this.presenterSpy.showImportDialog();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(ImportEvent.class));
    }

    @Test
    public void showImportDialogNone() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)false);
        this.presenterSpy.showImportDialog();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(ImportEvent.class));
    }

    @Test
    public void setTestTools() {
        this.presenterSpy.setTestTools((TestToolsView.Presenter)this.testToolsPresenterMock);
        Assert.assertEquals((Object)this.scenarioSimulationContextLocal.getTestToolsPresenter(), (Object)this.testToolsPresenterMock);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.eventBusMock));
        ((DataManagementStrategy)Mockito.verify((Object)this.dataManagementStrategyMock, (VerificationMode)Mockito.times((int)1))).populateTestTools((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void setCheatSheet() {
        this.presenterSpy.setCheatSheet((CheatSheetView.Presenter)this.cheatSheetPresenterMock);
        ((CheatSheetPresenter)Mockito.verify((Object)this.cheatSheetPresenterMock, (VerificationMode)Mockito.times((int)1))).initCheatSheet((ScenarioSimulationModel.Type)Matchers.isA(ScenarioSimulationModel.Type.class));
    }

    @Test
    public void setSettings() {
        this.presenterSpy.setSettings((SettingsView.Presenter)this.settingsPresenterMock);
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterMock, (VerificationMode)Mockito.times((int)1))).setScenarioType((ScenarioSimulationModel.Type)Matchers.isA(ScenarioSimulationModel.Type.class), (Settings)Matchers.any(), Matchers.anyString());
    }

    @Test
    public void populateRightDocks() {
        this.presenterSpy.populateRightDocks("org.drools.scenariosimulation.TestTools");
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).populateDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.TestTools"));
    }

    @Test
    public void populateRightDocksEmptyDataStrategy() {
        this.presenterSpy.dataManagementStrategy = null;
        this.presenterSpy.populateRightDocks("org.drools.scenariosimulation.TestTools");
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.never())).populateDocks(Matchers.anyString());
    }

    @Test
    public void getModelSuccessCallbackMethod() {
        this.scenarioGridWidgetSpy.selectAndFocus();
        this.presenterSpy.getModelSuccessCallbackMethod(this.dataManagementStrategyMock, this.modelLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateRightDocks("org.drools.scenariosimulation.TestTools");
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateRightDocks("org.drools.scenariosimulation.Settings");
        ((ScenarioGridWidget)Mockito.verify((Object)this.scenarioGridWidgetSpy, (VerificationMode)Mockito.times((int)1))).setContent((AbstractScesimModel)Matchers.eq((Object)this.content.getModel().getSimulation()), (ScenarioSimulationModel.Type)Matchers.eq((Object)this.settingsLocal.getType()));
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).addBackgroundPage((ScenarioGridWidget)Matchers.eq((Object)this.backgroundGridWidgetSpy));
        Assert.assertEquals((Object)this.scenarioSimulationContextLocal.getStatus().getSimulation(), (Object)this.content.getModel().getSimulation());
        Assert.assertEquals((Object)this.scenarioSimulationContextLocal.getStatus().getBackground(), (Object)this.content.getModel().getBackground());
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).getValidateCommand();
        ((ScenarioGridWidget)Mockito.verify((Object)this.scenarioGridWidgetSpy, (VerificationMode)Mockito.atLeastOnce())).selectAndFocus();
    }

    @Test
    public void onExportToCsvSIMULATION() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)true);
        this.presenterSpy.onExportToCsv();
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).onExportToCsv((RemoteCallback)Matchers.isA(RemoteCallback.class), (ScenarioSimulationHasBusyIndicatorDefaultErrorCallback)Matchers.isA(ScenarioSimulationHasBusyIndicatorDefaultErrorCallback.class), (AbstractScesimModel)Matchers.eq((Object)this.simulationMock));
    }

    @Test
    public void cleanReadOnlyColumn() {
        Simulation simulation = new Simulation();
        ScesimModelDescriptor simulationDescriptor = simulation.getScesimModelDescriptor();
        FactMapping test1 = simulationDescriptor.addFactMapping(FactIdentifier.create((String)"test1", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"", (FactMappingType)FactMappingType.GIVEN));
        FactMapping test2 = simulationDescriptor.addFactMapping(FactIdentifier.create((String)"test2", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"", (FactMappingType)FactMappingType.GIVEN));
        test1.addExpressionElement("test", String.class.getCanonicalName());
        Scenario scenario = (Scenario)simulation.addData();
        scenario.addMappingValue(test1.getFactIdentifier(), test1.getExpressionIdentifier(), (Object)"value");
        scenario.addMappingValue(test2.getFactIdentifier(), test2.getExpressionIdentifier(), (Object)"value");
        this.presenterSpy.cleanReadOnlyColumn((AbstractScesimModel)simulation);
        Assert.assertNotNull((Object)((FactMappingValue)scenario.getFactMappingValue(test1.getFactIdentifier(), test1.getExpressionIdentifier()).get()).getRawValue());
        Assert.assertNull((Object)((FactMappingValue)scenario.getFactMappingValue(test2.getFactIdentifier(), test2.getExpressionIdentifier()).get()).getRawValue());
    }

    @Test
    public void getValidationCallback() {
        this.presenterSpy.getValidationCallback().callback(null);
        ((ConfirmPopupPresenter)Mockito.verify((Object)this.confirmPopupPresenterMock, (VerificationMode)Mockito.never())).show(Matchers.anyString(), Matchers.anyString());
        ArrayList<FactMappingValidationError> validationErrors = new ArrayList<FactMappingValidationError>();
        this.presenterSpy.getValidationCallback().callback(validationErrors);
        ((ConfirmPopupPresenter)Mockito.verify((Object)this.confirmPopupPresenterMock, (VerificationMode)Mockito.never())).show(Matchers.anyString(), Matchers.anyString());
        String errorMessage = "errorMessage";
        String errorId = "errorId";
        validationErrors.add(new FactMappingValidationError(errorId, errorMessage));
        this.presenterSpy.getValidationCallback().callback(validationErrors);
        ((ConfirmPopupPresenter)Mockito.verify((Object)this.confirmPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show(Matchers.anyString(), Matchers.contains((String)errorId));
        ((ConfirmPopupPresenter)Mockito.verify((Object)this.confirmPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show(Matchers.anyString(), Matchers.contains((String)errorMessage));
    }

    @Test
    public void getImportCallback() {
        List<AbstractScesimModel> toTest = Arrays.asList(new Simulation(), new Background());
        for (AbstractScesimModel abstractScesimModel : toTest) {
            FactMapping factMapping = abstractScesimModel.getScesimModelDescriptor().addFactMapping(FactIdentifier.EMPTY, ExpressionIdentifier.create((String)"empty", (FactMappingType)FactMappingType.GIVEN));
            FactMappingValue toBeRemoved = abstractScesimModel.addData().addOrUpdateMappingValue(factMapping.getFactIdentifier(), factMapping.getExpressionIdentifier(), (Object)"toBeRemoved");
            this.presenterSpy.getImportCallBack().callback((Object)abstractScesimModel);
            ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).cleanReadOnlyColumn((AbstractScesimModel)Matchers.eq((Object)abstractScesimModel));
            Assert.assertNull((Object)toBeRemoved.getRawValue());
            Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenterSpy});
        }
    }

    @Test
    public void sendNotification() {
        this.presenterSpy.sendNotification("message", NotificationEvent.NotificationType.ERROR);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)this.scenarioNotificationEventArgumentCaptor.capture());
        Assert.assertEquals((Object)"message", (Object)((ScenarioNotificationEvent)this.scenarioNotificationEventArgumentCaptor.getValue()).getMessage());
        Assert.assertEquals((Object)NotificationEvent.NotificationType.ERROR, (Object)((ScenarioNotificationEvent)this.scenarioNotificationEventArgumentCaptor.getValue()).getNotificationType());
        Assert.assertTrue((boolean)((ScenarioNotificationEvent)this.scenarioNotificationEventArgumentCaptor.getValue()).isAutoHide());
    }

    @Test
    public void sendNotificationAutoHide() {
        this.presenterSpy.sendNotification("message", NotificationEvent.NotificationType.ERROR, false);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)this.scenarioNotificationEventArgumentCaptor.capture());
        Assert.assertEquals((Object)"message", (Object)((ScenarioNotificationEvent)this.scenarioNotificationEventArgumentCaptor.getValue()).getMessage());
        Assert.assertEquals((Object)NotificationEvent.NotificationType.ERROR, (Object)((ScenarioNotificationEvent)this.scenarioNotificationEventArgumentCaptor.getValue()).getNotificationType());
        Assert.assertFalse((boolean)((ScenarioNotificationEvent)this.scenarioNotificationEventArgumentCaptor.getValue()).isAutoHide());
    }

    @Test
    public void expandSettingsDock() {
        this.presenterSpy.expandSettingsDock();
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).expandSettingsDock();
    }

    @Test
    public void reloadSettingsDock() {
        this.presenterSpy.reloadSettingsDock();
        ((AbstractScenarioSimulationDocksHandler)Mockito.verify((Object)this.abstractScenarioSimulationDocksHandlerMock, (VerificationMode)Mockito.times((int)1))).getSettingsPresenter();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).updateSettings((SettingsView.Presenter)this.settingsPresenterMock);
    }

    @Test
    public void unpublishTestResultsAlerts() {
        this.presenterSpy.unpublishTestResultsAlerts();
        ((ScenarioSimulationEditorWrapper)Mockito.verify((Object)this.scenarioSimulationEditorWrapperMock, (VerificationMode)Mockito.times((int)1))).unpublishTestResultsAlerts();
    }
}

