/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.SettingsScenarioSimulationDropdown;
import org.drools.workbench.screens.scenariosimulation.client.events.UpdateSettingsDataEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ValidateSimulationEvent;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractSettingsTest;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class SettingsPresenterTest
extends AbstractSettingsTest {
    private SettingsPresenter settingsPresenterSpy;
    @Mock
    private Command saveCommandMock;
    @Mock
    private SettingsScenarioSimulationDropdown settingsScenarioSimulationDropdownMock;
    @Mock
    private EventBus eventBusMock;
    @Captor
    private ArgumentCaptor<UpdateSettingsDataEvent> updateSettingsDataEventArgumentCaptor;
    protected Settings settingsSpy;

    @Override
    @Before
    public void setup() {
        super.setup();
        Settings settings = new Settings();
        settings.setRuleFlowGroup("RULE_FLOW_GROUP");
        settings.setDmoSession("DMO_SESSION");
        settings.setDmnFilePath("DMN_FILE_PATH");
        settings.setDmnNamespace("DMN_NAMESPACE");
        settings.setDmnName("DMN_NAME");
        settings.setStateless(true);
        settings.setSkipFromBuild(true);
        this.settingsSpy = (Settings)Mockito.spy((Object)settings);
        KieAssetsDropdownItem item = new KieAssetsDropdownItem("DMNFile", "", "DMN_FILE_PATH", null);
        Mockito.when((Object)this.settingsScenarioSimulationDropdownMock.getValue()).thenReturn(Optional.of(item));
        this.settingsPresenterSpy = (SettingsPresenter)Mockito.spy((Object)new SettingsPresenter(this.settingsScenarioSimulationDropdownMock, this.settingsViewMock){
            {
                this.settingsScenarioSimulationDropdown = SettingsPresenterTest.this.settingsScenarioSimulationDropdownMock;
                this.saveCommand = SettingsPresenterTest.this.saveCommandMock;
                this.eventBus = SettingsPresenterTest.this.eventBusMock;
            }
        });
    }

    @Test
    public void onSetup() {
        this.settingsPresenterSpy.setup();
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).init((Object)this.settingsPresenterSpy);
    }

    @Test
    public void getTitle() {
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.settings(), (Object)this.settingsPresenterSpy.getTitle());
    }

    @Test
    public void setEventBus() {
        this.settingsPresenterSpy.setEventBus(this.eventBusMock);
        Assert.assertEquals((Object)this.eventBusMock, (Object)this.settingsPresenterSpy.eventBus);
    }

    @Test
    public void setScenarioTypeRULESkipTrue() {
        this.settingsSpy.setSkipFromBuild(true);
        this.settingsPresenterSpy.setScenarioType(ScenarioSimulationModel.Type.RULE, this.settingsSpy, "FILE_NAME");
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE.name()));
        ((InputElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)true));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterSpy, (VerificationMode)Mockito.times((int)1))).setRuleSettings(this.settingsSpy);
    }

    @Test
    public void setScenarioTypeRULESkipFalse() {
        this.settingsSpy.setSkipFromBuild(false);
        this.settingsPresenterSpy.setScenarioType(ScenarioSimulationModel.Type.RULE, this.settingsSpy, "FILE_NAME");
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE.name()));
        ((InputElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)false));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterSpy, (VerificationMode)Mockito.times((int)1))).setRuleSettings(this.settingsSpy);
    }

    @Test
    public void setScenarioTypeDMNSkipTrue() {
        this.settingsSpy.setSkipFromBuild(true);
        this.settingsPresenterSpy.setScenarioType(ScenarioSimulationModel.Type.DMN, this.settingsSpy, "FILE_NAME");
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN.name()));
        ((InputElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)true));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterSpy, (VerificationMode)Mockito.times((int)1))).setDMNSettings(this.settingsSpy);
    }

    @Test
    public void setScenarioTypeDMNSkipFalse() {
        this.settingsSpy.setSkipFromBuild(false);
        this.settingsPresenterSpy.setScenarioType(ScenarioSimulationModel.Type.DMN, this.settingsSpy, "FILE_NAME");
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN.name()));
        ((InputElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)false));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterSpy, (VerificationMode)Mockito.times((int)1))).setDMNSettings(this.settingsSpy);
    }

    @Test
    public void setRuleSettings() {
        this.settingsPresenterSpy.setRuleSettings(this.settingsSpy);
        ((Style)Mockito.verify((Object)this.dmnSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((Style)Mockito.verify((Object)this.ruleSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterSpy, (VerificationMode)Mockito.times((int)1))).updateRuleSettings((Settings)Matchers.eq((Object)this.settingsSpy));
    }

    @Test
    public void updateRuleSettings() {
        this.settingsPresenterSpy.updateRuleSettings(this.settingsSpy);
        ((InputElement)Mockito.verify((Object)this.dmoSessionMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"DMO_SESSION"));
        ((InputElement)Mockito.verify((Object)this.ruleFlowGroupMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"RULE_FLOW_GROUP"));
        ((InputElement)Mockito.verify((Object)this.statelessMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)this.settingsSpy.isStateless()));
    }

    @Test
    public void setDMNSettings() {
        this.settingsPresenterSpy.setDMNSettings(this.settingsSpy);
        ((Style)Mockito.verify((Object)this.ruleSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((Style)Mockito.verify((Object)this.dmnSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).registerOnMissingValueHandler((Command)Matchers.isA(Command.class));
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).registerOnChangeHandler((Command)Matchers.isA(Command.class));
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).loadAssets((String)Matchers.eq((Object)"DMN_FILE_PATH"));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterSpy, (VerificationMode)Mockito.times((int)1))).updateDMNSettings(this.settingsSpy);
    }

    @Test
    public void updateDMNSettings() {
        this.settingsPresenterSpy.updateDMNSettings(this.settingsSpy);
        ((InputElement)Mockito.verify((Object)this.dmnNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"DMN_NAME"));
        ((InputElement)Mockito.verify((Object)this.dmnNamespaceMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"DMN_NAMESPACE"));
        ((Style)Mockito.verify((Object)this.dmnFilePathErrorLabelStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((SpanElement)Mockito.verify((Object)this.dmnFilePathErrorLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)""));
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).loadAssets((String)Matchers.eq((Object)"DMN_FILE_PATH"));
    }

    @Test
    public void updateSettingsDataRule() {
        this.settingsSpy.setType(ScenarioSimulationModel.Type.RULE);
        Mockito.when((Object)this.ruleSettingsStyleMock.getDisplay()).thenReturn((Object)Style.Display.INLINE.getCssName());
        this.settingsPresenterSpy.updateSettingsData(this.settingsSpy);
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterSpy, (VerificationMode)Mockito.times((int)1))).setRuleSettings((Settings)Matchers.eq((Object)this.settingsSpy));
    }

    @Test(expected=IllegalStateException.class)
    public void updateSettingsDataRuleWrongState() {
        this.settingsSpy.setType(ScenarioSimulationModel.Type.RULE);
        Mockito.when((Object)this.ruleSettingsStyleMock.getDisplay()).thenReturn((Object)Style.Display.NONE.getCssName());
        this.settingsPresenterSpy.updateSettingsData(this.settingsSpy);
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterSpy, (VerificationMode)Mockito.never())).setRuleSettings((Settings)Matchers.eq((Object)this.settingsSpy));
    }

    @Test
    public void updateSettingsDataDMN() {
        this.settingsSpy.setType(ScenarioSimulationModel.Type.DMN);
        Mockito.when((Object)this.dmnSettingsStyleMock.getDisplay()).thenReturn((Object)Style.Display.INLINE.getCssName());
        this.settingsPresenterSpy.updateSettingsData(this.settingsSpy);
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterSpy, (VerificationMode)Mockito.times((int)1))).setDMNSettings((Settings)Matchers.eq((Object)this.settingsSpy));
    }

    @Test(expected=IllegalStateException.class)
    public void updateSettingsDataDMNWrongState() {
        this.settingsSpy.setType(ScenarioSimulationModel.Type.DMN);
        Mockito.when((Object)this.dmnSettingsStyleMock.getDisplay()).thenReturn((Object)Style.Display.NONE.getCssName());
        this.settingsPresenterSpy.updateSettingsData(this.settingsSpy);
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterSpy, (VerificationMode)Mockito.never())).setDMNSettings((Settings)Matchers.eq((Object)this.settingsSpy));
    }

    @Test
    public void resetTest() {
        this.settingsPresenterSpy.reset();
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).reset();
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void setDmnErrorPath() {
        this.settingsPresenterSpy.setDmnErrorPath(this.settingsSpy.getDmnFilePath());
        ((Style)Mockito.verify((Object)this.dmnFilePathErrorLabelStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((SpanElement)Mockito.verify((Object)this.dmnFilePathErrorLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.dmnPathErrorLabel(this.settingsSpy.getDmnFilePath())));
    }

    @Test
    public void validateDmnPath_Valid() {
        this.settingsPresenterSpy.validateSimulation();
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)2))).getValue();
        ((Style)Mockito.verify((Object)this.dmnFilePathErrorLabelStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((SpanElement)Mockito.verify((Object)this.dmnFilePathErrorLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)""));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterSpy, (VerificationMode)Mockito.times((int)1))).syncDmnFilePath();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(ValidateSimulationEvent.class));
    }

    @Test
    public void validateDmnPath_Invalid() {
        KieAssetsDropdownItem item = new KieAssetsDropdownItem("DMNFile", "", "", null);
        Mockito.when((Object)this.settingsScenarioSimulationDropdownMock.getValue()).thenReturn(Optional.of(item));
        this.settingsPresenterSpy.validateSimulation();
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).getValue();
        ((Style)Mockito.verify((Object)this.dmnFilePathErrorLabelStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((SpanElement)Mockito.verify((Object)this.dmnFilePathErrorLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.chooseValidDMNAsset()));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterSpy, (VerificationMode)Mockito.never())).syncDmnFilePath();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(ValidateSimulationEvent.class));
    }

    @Test
    public void syncDmoSessionSameValue() {
        this.settingsPresenterSpy.syncDmoSession();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)this.updateSettingsDataEventArgumentCaptor.capture());
        Assert.assertFalse((boolean)((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsValueChanged().test(this.settingsSpy));
        ((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsChangeToApply().accept(this.settingsSpy);
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setDmoSession((String)Matchers.eq((Object)"DMO_SESSION"));
    }

    @Test
    public void syncDmoSessionChangedValue() {
        InputElement inputElementMock = (InputElement)Mockito.mock(InputElement.class);
        Mockito.when((Object)inputElementMock.getValue()).thenReturn((Object)"DMO_SESSION2");
        ((SettingsView)Mockito.doReturn((Object)inputElementMock).when((Object)this.settingsViewMock)).getDmoSession();
        this.settingsPresenterSpy.syncDmoSession();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)this.updateSettingsDataEventArgumentCaptor.capture());
        Assert.assertTrue((boolean)((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsValueChanged().test(this.settingsSpy));
        ((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsChangeToApply().accept(this.settingsSpy);
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setDmoSession((String)Matchers.eq((Object)"DMO_SESSION2"));
        Assert.assertEquals((Object)"DMO_SESSION2", (Object)this.settingsSpy.getDmoSession());
    }

    @Test
    public void syncRuleFlowGroupSameValue() {
        this.settingsPresenterSpy.syncRuleFlowGroup();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)this.updateSettingsDataEventArgumentCaptor.capture());
        Assert.assertFalse((boolean)((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsValueChanged().test(this.settingsSpy));
        ((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsChangeToApply().accept(this.settingsSpy);
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setRuleFlowGroup((String)Matchers.eq((Object)"RULE_FLOW_GROUP"));
    }

    @Test
    public void syncRuleFlowGroupChangedValue() {
        InputElement inputElementMock = (InputElement)Mockito.mock(InputElement.class);
        Mockito.when((Object)inputElementMock.getValue()).thenReturn((Object)"RULE_FLOW_GROUP2");
        ((SettingsView)Mockito.doReturn((Object)inputElementMock).when((Object)this.settingsViewMock)).getRuleFlowGroup();
        this.settingsPresenterSpy.syncRuleFlowGroup();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)this.updateSettingsDataEventArgumentCaptor.capture());
        Assert.assertTrue((boolean)((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsValueChanged().test(this.settingsSpy));
        ((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsChangeToApply().accept(this.settingsSpy);
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setRuleFlowGroup((String)Matchers.eq((Object)"RULE_FLOW_GROUP2"));
        Assert.assertEquals((Object)"RULE_FLOW_GROUP2", (Object)this.settingsSpy.getRuleFlowGroup());
    }

    @Test
    public void syncStateless() {
        this.settingsPresenterSpy.syncStateless();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)this.updateSettingsDataEventArgumentCaptor.capture());
        ((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsChangeToApply().accept(this.settingsSpy);
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setStateless(Matchers.eq((boolean)true));
    }

    @Test
    public void syncDmnFilePathSameValue() {
        this.settingsPresenterSpy.syncDmnFilePath();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)this.updateSettingsDataEventArgumentCaptor.capture());
        Assert.assertFalse((boolean)((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsValueChanged().test(this.settingsSpy));
        ((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsChangeToApply().accept(this.settingsSpy);
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setDmnFilePath((String)Matchers.eq((Object)"DMN_FILE_PATH"));
    }

    @Test
    public void syncDmnFilePathChangedValue() {
        KieAssetsDropdownItem item = new KieAssetsDropdownItem("DMNFile", "", "DMN_FILE_PATH2", null);
        Mockito.when((Object)this.settingsScenarioSimulationDropdownMock.getValue()).thenReturn(Optional.of(item));
        this.settingsPresenterSpy.syncDmnFilePath();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)this.updateSettingsDataEventArgumentCaptor.capture());
        Assert.assertTrue((boolean)((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsValueChanged().test(this.settingsSpy));
        ((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsChangeToApply().accept(this.settingsSpy);
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setDmnFilePath((String)Matchers.eq((Object)"DMN_FILE_PATH2"));
        Assert.assertEquals((Object)"DMN_FILE_PATH2", (Object)this.settingsSpy.getDmnFilePath());
    }

    @Test
    public void syncSkipFromBuild() {
        this.settingsPresenterSpy.syncSkipFromBuild();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)this.updateSettingsDataEventArgumentCaptor.capture());
        ((UpdateSettingsDataEvent)this.updateSettingsDataEventArgumentCaptor.getValue()).getSettingsChangeToApply().accept(this.settingsSpy);
        ((Settings)Mockito.verify((Object)this.settingsSpy, (VerificationMode)Mockito.times((int)1))).setSkipFromBuild(Matchers.eq((boolean)true));
    }
}

