/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import junit.framework.TestCase;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.SetInstanceHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SetPropertyHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractTestToolsTest;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenterData;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class TestToolsPresenterTest
extends AbstractTestToolsTest {
    @Mock
    private TestToolsView testToolsViewMock;
    @Mock
    private DivElement divItemContainerMock;
    @Mock
    private ListGroupItemPresenter listGroupItemPresenterMock;
    @Mock
    private ListGroupItemView selectedListGroupItemViewMock;
    @Mock
    private FieldItemView selectedFieldItemViewMock;
    @Mock
    private EventBus eventBusMock;
    private TestToolsPresenter testToolsPresenterSpy;

    @Override
    @Before
    public void setup() {
        super.setup();
        String firstKey = (String)this.dataObjectFactTreeMap.firstKey();
        FactModelTree factModelTree = (FactModelTree)this.dataObjectFactTreeMap.get(firstKey);
        String firstPropertyKey = (String)new ArrayList(factModelTree.getSimpleProperties().keySet()).get(0);
        FactModelTree.PropertyTypeName firstPropertyClass = (FactModelTree.PropertyTypeName)factModelTree.getSimpleProperties().get(firstPropertyKey);
        Mockito.when((Object)this.selectedListGroupItemViewMock.getActualClassName()).thenReturn((Object)firstKey);
        Mockito.when((Object)this.selectedFieldItemViewMock.getFullPath()).thenReturn(Arrays.asList(firstKey));
        Mockito.when((Object)this.selectedFieldItemViewMock.getFieldName()).thenReturn((Object)firstPropertyKey);
        Mockito.when((Object)this.selectedFieldItemViewMock.getClassName()).thenReturn((Object)firstPropertyClass.getTypeName());
        Mockito.when((Object)this.listGroupItemPresenterMock.getDivElement("FACT_NAME", this.FACT_MODEL_TREE)).thenReturn((Object)this.divItemContainerMock);
        this.testToolsPresenterSpy = (TestToolsPresenter)Mockito.spy((Object)new TestToolsPresenter(this.testToolsViewMock, this.listGroupItemPresenterMock){
            {
                this.dataObjectFieldsMap = TestToolsPresenterTest.this.dataObjectFactTreeMap;
                this.simpleJavaTypeFieldsMap = TestToolsPresenterTest.this.simpleJavaTypeTreeMap;
                this.instanceFieldsMap = TestToolsPresenterTest.this.instanceFactTreeMap;
                this.simpleJavaInstanceFieldsMap = TestToolsPresenterTest.this.simpleJavaInstanceFactTreeMap;
                this.eventBus = TestToolsPresenterTest.this.eventBusMock;
            }
        });
    }

    @Test
    public void onSetup() {
        this.testToolsPresenterSpy.setup();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).init((Object)this.testToolsPresenterSpy);
    }

    @Test
    public void getTitle() {
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.testTools(), (Object)this.testToolsPresenterSpy.getTitle());
    }

    @Test
    public void onClearSearch() {
        this.testToolsPresenterSpy.onClearSearch();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).clearInputSearch();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).hideClearButton();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).onSearchedEvent((String)Matchers.eq((Object)""));
    }

    @Test
    public void onUndoSearch() {
        Mockito.when((Object)this.listGroupItemPresenterMock.getFilterTerm()).thenReturn((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME");
        this.testToolsPresenterSpy.onUndoSearch();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).clearInputSearch();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).hideClearButton();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).getFilterTerm();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).onPerfectMatchSearchedEvent((String)Matchers.eq((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME"), Matchers.eq((boolean)true));
    }

    @Test
    public void onClearStatus() {
        this.testToolsPresenterSpy.onClearStatus();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).onClearSearch();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).clearDataObjectList();
    }

    @Test
    public void clearDataObjectList() {
        this.testToolsPresenterSpy.clearDataObjectList();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).clearDataObjectList();
    }

    @Test
    public void clearSimpleJavaTypeList() {
        this.testToolsPresenterSpy.clearSimpleJavaTypeList();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).clearSimpleJavaTypeList();
    }

    @Test
    public void clearInstanceList() {
        this.testToolsPresenterSpy.clearInstanceList();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).clearInstanceList();
    }

    @Test
    public void clearSimpleJavaInstanceFieldList() {
        this.testToolsPresenterSpy.clearSimpleJavaInstanceFieldList();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).clearSimpleJavaInstanceFieldList();
    }

    @Test
    public void updateInstanceListSeparatorNotEmptySIMULATION() {
        this.testToolsPresenterSpy.gridWidget = GridWidget.SIMULATION;
        this.testToolsPresenterSpy.updateInstanceListSeparator();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).updateInstanceListSeparator(Matchers.eq((boolean)true));
    }

    @Test
    public void updateInstanceListSeparatorNotEmptyBACKGROUND() {
        this.testToolsPresenterSpy.gridWidget = GridWidget.BACKGROUND;
        this.testToolsPresenterSpy.updateInstanceListSeparator();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).updateInstanceListSeparator(Matchers.eq((boolean)false));
    }

    @Test
    public void updateInstanceListSeparatorEmpty() {
        this.testToolsPresenterSpy.updateInstanceListSeparator();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).updateInstanceListSeparator(Matchers.eq((boolean)false));
    }

    @Test
    public void showInstanceListContainerSeparator() {
        this.testToolsPresenterSpy.showInstanceListContainerSeparator(true);
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).showInstanceListContainerSeparator(Matchers.eq((boolean)true));
    }

    @Test
    public void getFactModelTree() {
        this.testToolsPresenterSpy.setDataObjectFieldsMap(this.dataObjectFactTreeMap);
        String factName = this.getRandomFactModelTree(this.dataObjectFactTreeMap, 0);
        Optional retrieved = this.testToolsPresenterSpy.getFactModelTreeFromFactTypeMap(factName);
        Assert.assertNotNull((Object)retrieved);
        TestCase.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals(this.dataObjectFactTreeMap.get(factName), retrieved.get());
    }

    @Test
    public void setFactTypeFieldsMap() {
        this.testToolsPresenterSpy.setDataObjectFieldsMap(this.dataObjectFactTreeMap);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)this.dataObjectFactTreeMap.size()))).addDataObjectListGroupItemView(Matchers.anyString(), (FactModelTree)Matchers.anyObject());
    }

    @Test
    public void onShowClearButton() {
        this.testToolsPresenterSpy.onShowClearButton();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).showClearButton();
    }

    @Test
    public void populateTestTools() {
        TreeMap dataObjects = new TreeMap();
        TreeMap simpleJava = new TreeMap();
        TreeMap instanceField = new TreeMap();
        TreeMap simpleJavaInstance = new TreeMap();
        TreeMap hiddenFields = new TreeMap();
        HashMap hideProperties = new HashMap();
        TestToolsPresenterData data = new TestToolsPresenterData(dataObjects, simpleJava, instanceField, simpleJavaInstance, hiddenFields, hideProperties, GridWidget.SIMULATION);
        this.testToolsPresenterSpy.populateTestTools(data);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).setDataObjectFieldsMap((SortedMap)Matchers.eq(dataObjects));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).setSimpleJavaTypeFieldsMap((SortedMap)Matchers.eq(simpleJava));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).setInstanceFieldsMap((SortedMap)Matchers.eq(instanceField));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).setSimpleJavaInstanceFieldsMap((SortedMap)Matchers.eq(simpleJavaInstance));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).setHiddenFieldsMap((SortedMap)Matchers.eq(hiddenFields));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).hideProperties((Map)Matchers.eq(hideProperties));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).setGridWidget((GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void setEventBus() {
        this.testToolsPresenterSpy.setEventBus(this.eventBusMock);
        Assert.assertEquals((Object)this.eventBusMock, (Object)this.testToolsPresenterSpy.eventBus);
    }

    @Test
    public void setGridWidgetSIMULATION() {
        this.testToolsPresenterSpy.setGridWidget(GridWidget.SIMULATION);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.never())).hideInstances();
    }

    @Test
    public void setGridWidgetBACKGROUND() {
        this.testToolsPresenterSpy.setGridWidget(GridWidget.BACKGROUND);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).hideInstances();
    }

    @Test
    public void onSearchedEvent() {
        String searched = "";
        this.testToolsPresenterSpy.onSearchedEvent(searched);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).clearLists();
        this.testToolsPresenterSpy.dataObjectFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(searched)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).addDataObjectListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenterSpy.simpleJavaTypeFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(searched)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).addSimpleJavaTypeListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenterSpy.instanceFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(searched)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).addInstanceListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenterSpy.simpleJavaInstanceFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(searched)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).addSimpleJavaInstanceListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).updateInstanceListSeparator();
    }

    @Test
    public void onPerfectMatchSearchedEventNotEquals() {
        String search = "";
        this.testToolsPresenterSpy.onPerfectMatchSearchedEvent(search, true);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).clearLists();
        this.testToolsPresenterSpy.dataObjectFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenterSpy.filterTerm((String)entry.getKey(), search, true)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).addDataObjectListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenterSpy.simpleJavaTypeFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenterSpy.filterTerm((String)entry.getKey(), search, true)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).addSimpleJavaTypeListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenterSpy.instanceFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenterSpy.filterTerm((String)entry.getKey(), search, true)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).addInstanceListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenterSpy.simpleJavaInstanceFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenterSpy.filterTerm((String)entry.getKey(), search, true)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).addSimpleJavaInstanceListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).updateInstanceListSeparator();
    }

    @Test
    public void onPerfectMatchSearchedEventEquals() {
        String search = "";
        this.testToolsPresenterSpy.onPerfectMatchSearchedEvent(search, false);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).clearLists();
        this.testToolsPresenterSpy.dataObjectFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenterSpy.filterTerm((String)entry.getKey(), search, false)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).addDataObjectListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenterSpy.simpleJavaTypeFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenterSpy.filterTerm((String)entry.getKey(), search, false)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).addSimpleJavaTypeListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenterSpy.instanceFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenterSpy.filterTerm((String)entry.getKey(), search, false)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).addInstanceListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        this.testToolsPresenterSpy.simpleJavaInstanceFieldsMap.entrySet().stream().filter(entry -> this.testToolsPresenterSpy.filterTerm((String)entry.getKey(), search, false)).forEach(filteredEntry -> ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).addSimpleJavaInstanceListGroupItemView((String)Matchers.eq(filteredEntry.getKey()), (FactModelTree)Matchers.eq(filteredEntry.getValue())));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).updateInstanceListSeparator();
    }

    @Test
    public void addListGroupItemView() {
        this.testToolsPresenterSpy.addDataObjectListGroupItemView("FACT_NAME", this.FACT_MODEL_TREE);
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).addDataObjectListGroupItem((DivElement)Matchers.eq((Object)this.divItemContainerMock));
    }

    @Test
    public void addInstanceListGroupItemView() {
        this.testToolsPresenterSpy.addInstanceListGroupItemView("FACT_NAME", this.FACT_MODEL_TREE);
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).addInstanceListGroupItem((DivElement)Matchers.eq((Object)this.divItemContainerMock));
    }

    @Test
    public void addSimpleJavaTypeListGroupItemView() {
        this.testToolsPresenterSpy.addSimpleJavaTypeListGroupItemView("FACT_NAME", this.FACT_MODEL_TREE);
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).addSimpleJavaTypeListGroupItem((DivElement)Matchers.eq((Object)this.divItemContainerMock));
    }

    @Test
    public void addSimpleJavaInstanceListGroupItemView() {
        this.testToolsPresenterSpy.addSimpleJavaInstanceListGroupItemView("FACT_NAME", this.FACT_MODEL_TREE);
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).addSimpleJavaInstanceListGroupItem((DivElement)Matchers.eq((Object)this.divItemContainerMock));
    }

    @Test
    public void onEnableEditorTabWithoutFactName() {
        this.testToolsPresenterSpy.onEnableEditorTab();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).onDisableEditorTab();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).onSearchedEvent((String)Matchers.eq((Object)""));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).enable();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).enable(Matchers.anyString());
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).enableEditorTab();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).enableSearch();
    }

    @Test
    public void onEnableEditorTabWithFactName_NotEqualsSearch() {
        this.testToolsPresenterSpy.onEnableEditorTab("FACT_NAME", null, false);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).onDisableEditorTab();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).onPerfectMatchSearchedEvent((String)Matchers.eq((Object)"FACT_NAME"), Matchers.eq((boolean)false));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).updateInstanceIsAssignedStatus((String)Matchers.eq((Object)"FACT_NAME"));
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.never())).enableSearch();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).enable((String)Matchers.eq((Object)"FACT_NAME"));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).enable();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).enableEditorTab();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).selectProperty(Matchers.anyString(), (List)Matchers.any());
    }

    @Test
    public void onEnableEditorTabWithFactName_EqualSearch() {
        this.testToolsPresenterSpy.onEnableEditorTab("FACT_NAME", null, true);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).onDisableEditorTab();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).onPerfectMatchSearchedEvent((String)Matchers.eq((Object)"FACT_NAME"), Matchers.eq((boolean)true));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.never())).updateInstanceIsAssignedStatus(Matchers.anyString());
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).enableSearch();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).enable((String)Matchers.eq((Object)"FACT_NAME"));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).enable();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).enableEditorTab();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).selectProperty(Matchers.anyString(), (List)Matchers.any());
    }

    @Test
    public void onEnableEditorTabWithProperties() {
        List<String> propertiesName = Arrays.asList("property1", "property2");
        this.testToolsPresenterSpy.onEnableEditorTab("FACT_NAME", propertiesName, false);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).onDisableEditorTab();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).onPerfectMatchSearchedEvent((String)Matchers.eq((Object)"FACT_NAME"), Matchers.eq((boolean)false));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).enable((String)Matchers.eq((Object)"FACT_NAME"));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).enable();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.never())).disableSearch();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).enableEditorTab();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).selectProperty((String)Matchers.eq((Object)"FACT_NAME"), (List)Matchers.eq(propertiesName));
    }

    @Test
    public void onDisableEditorTab() {
        this.testToolsPresenterSpy.onDisableEditorTab();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).disable();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).enable();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).disableEditorTab();
    }

    @Test
    public void setSelectedElement_InstanceAssigned() {
        Mockito.when((Object)this.selectedListGroupItemViewMock.getFactName()).thenReturn((Object)"FACT_NAME");
        Mockito.when((Object)this.listGroupItemPresenterMock.getFilterTerm()).thenReturn((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME");
        this.testToolsPresenterSpy.setSelectedElement(this.selectedListGroupItemViewMock);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).filterTerm((String)Matchers.eq((Object)"FACT_NAME"), (String)Matchers.eq((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME"), Matchers.eq((boolean)false));
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).disableAddButton();
        TestCase.assertNull((Object)this.testToolsPresenterSpy.selectedFieldItemView);
        Assert.assertEquals((Object)this.selectedListGroupItemViewMock, (Object)this.testToolsPresenterSpy.selectedListGroupItemView);
    }

    @Test
    public void setSelectedElement_InstanceNotAssigned() {
        Mockito.when((Object)this.selectedListGroupItemViewMock.getFactName()).thenReturn((Object)"FACT_NAME_2");
        Mockito.when((Object)this.listGroupItemPresenterMock.getFilterTerm()).thenReturn((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME");
        this.testToolsPresenterSpy.setSelectedElement(this.selectedListGroupItemViewMock);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).filterTerm((String)Matchers.eq((Object)"FACT_NAME_2"), (String)Matchers.eq((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME"), Matchers.eq((boolean)false));
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).enableAddButton();
        TestCase.assertNull((Object)this.testToolsPresenterSpy.selectedFieldItemView);
        Assert.assertEquals((Object)this.selectedListGroupItemViewMock, (Object)this.testToolsPresenterSpy.selectedListGroupItemView);
    }

    @Test
    public void setSelectedElementProperty_InstanceAssigned() {
        Mockito.when((Object)this.selectedFieldItemViewMock.isCheckShown()).thenReturn((Object)true);
        Mockito.when((Object)this.listGroupItemPresenterMock.isInstanceAssigned("FACT_NAME")).thenReturn((Object)true);
        Mockito.when((Object)this.selectedFieldItemViewMock.getFullPath()).thenReturn(Arrays.asList("FACT_NAME"));
        Mockito.when((Object)this.listGroupItemPresenterMock.getFilterTerm()).thenReturn((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME");
        this.testToolsPresenterSpy.setSelectedElement(this.selectedFieldItemViewMock);
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).isInstanceAssigned((String)Matchers.eq((Object)"FACT_NAME"));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).filterTerm((String)Matchers.eq((Object)"FACT_NAME"), (String)Matchers.eq((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME"), Matchers.eq((boolean)true));
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).enableAddButton();
        TestCase.assertNull((Object)this.testToolsPresenterSpy.selectedListGroupItemView);
        Assert.assertEquals((Object)this.selectedFieldItemViewMock, (Object)this.testToolsPresenterSpy.selectedFieldItemView);
    }

    @Test
    public void setSelectedElementProperty_CheckNotShown() {
        Mockito.when((Object)this.selectedFieldItemViewMock.isCheckShown()).thenReturn((Object)false);
        Mockito.when((Object)this.listGroupItemPresenterMock.isInstanceAssigned("FACT_NAME")).thenReturn((Object)true);
        Mockito.when((Object)this.selectedFieldItemViewMock.getFullPath()).thenReturn(Arrays.asList("FACT_NAME"));
        Mockito.when((Object)this.listGroupItemPresenterMock.getFilterTerm()).thenReturn((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME");
        this.testToolsPresenterSpy.setSelectedElement(this.selectedFieldItemViewMock);
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).isInstanceAssigned((String)Matchers.eq((Object)"FACT_NAME"));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.never())).filterTerm(Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean());
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).disableAddButton();
        TestCase.assertNull((Object)this.testToolsPresenterSpy.selectedListGroupItemView);
        Assert.assertEquals((Object)this.selectedFieldItemViewMock, (Object)this.testToolsPresenterSpy.selectedFieldItemView);
    }

    @Test
    public void setSelectedElementProperty_InstanceNotAssignedFactNameAlreadyAssigned() {
        Mockito.when((Object)this.selectedFieldItemViewMock.isCheckShown()).thenReturn((Object)true);
        Mockito.when((Object)this.listGroupItemPresenterMock.isInstanceAssigned("FACT_NAME")).thenReturn((Object)false);
        Mockito.when((Object)this.selectedFieldItemViewMock.getFullPath()).thenReturn(Arrays.asList("FACT_NAME"));
        Mockito.when((Object)this.listGroupItemPresenterMock.getFilterTerm()).thenReturn((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME");
        this.testToolsPresenterSpy.setSelectedElement(this.selectedFieldItemViewMock);
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).isInstanceAssigned((String)Matchers.eq((Object)"FACT_NAME"));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).filterTerm((String)Matchers.eq((Object)"FACT_NAME"), (String)Matchers.eq((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME"), Matchers.eq((boolean)false));
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).disableAddButton();
        TestCase.assertNull((Object)this.testToolsPresenterSpy.selectedListGroupItemView);
        Assert.assertEquals((Object)this.selectedFieldItemViewMock, (Object)this.testToolsPresenterSpy.selectedFieldItemView);
    }

    @Test
    public void setSelectedElementProperty_InstanceNotAssignedFactNameAlreadyAssigned_NestedProperties() {
        Mockito.when((Object)this.selectedFieldItemViewMock.isCheckShown()).thenReturn((Object)true);
        Mockito.when((Object)this.listGroupItemPresenterMock.isInstanceAssigned("FACT_NAME")).thenReturn((Object)false);
        Mockito.when((Object)this.selectedFieldItemViewMock.getFullPath()).thenReturn(Arrays.asList("FACT_NAME", "testProperty"));
        Mockito.when((Object)this.listGroupItemPresenterMock.getFilterTerm()).thenReturn((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME");
        this.testToolsPresenterSpy.setSelectedElement(this.selectedFieldItemViewMock);
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).isInstanceAssigned((String)Matchers.eq((Object)"FACT_NAME"));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).filterTerm((String)Matchers.eq((Object)"FACT_NAME"), (String)Matchers.eq((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME"), Matchers.eq((boolean)false));
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).disableAddButton();
        TestCase.assertNull((Object)this.testToolsPresenterSpy.selectedListGroupItemView);
        Assert.assertEquals((Object)this.selectedFieldItemViewMock, (Object)this.testToolsPresenterSpy.selectedFieldItemView);
    }

    @Test
    public void setSelectedElementProperty_InstanceNotAssignedFactNameNotAssigned() {
        Mockito.when((Object)this.selectedFieldItemViewMock.isCheckShown()).thenReturn((Object)true);
        Mockito.when((Object)this.listGroupItemPresenterMock.isInstanceAssigned("FACT_NAME_2")).thenReturn((Object)false);
        Mockito.when((Object)this.selectedFieldItemViewMock.getFullPath()).thenReturn(Arrays.asList("FACT_NAME_2"));
        Mockito.when((Object)this.listGroupItemPresenterMock.getFilterTerm()).thenReturn((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME");
        this.testToolsPresenterSpy.setSelectedElement(this.selectedFieldItemViewMock);
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).isInstanceAssigned((String)Matchers.eq((Object)"FACT_NAME_2"));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).filterTerm((String)Matchers.eq((Object)"FACT_NAME_2"), (String)Matchers.eq((Object)"test.scesim.TestClass_1;FACT_NAME;FULL_FACT_CLASSNAME"), Matchers.eq((boolean)false));
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).enableAddButton();
        TestCase.assertNull((Object)this.testToolsPresenterSpy.selectedListGroupItemView);
        Assert.assertEquals((Object)this.selectedFieldItemViewMock, (Object)this.testToolsPresenterSpy.selectedFieldItemView);
    }

    @Test
    public void onModifyColumn_NoSelection() {
        this.testToolsPresenterSpy.editingColumnEnabled = true;
        this.testToolsPresenterSpy.selectedFieldItemView = null;
        this.testToolsPresenterSpy.selectedListGroupItemView = null;
        this.testToolsPresenterSpy.onModifyColumn();
        ((ListGroupItemView)Mockito.verify((Object)this.selectedListGroupItemViewMock, (VerificationMode)Mockito.never())).getActualClassName();
        ((FieldItemView)Mockito.verify((Object)this.selectedFieldItemViewMock, (VerificationMode)Mockito.never())).getFullPath();
        ((FieldItemView)Mockito.verify((Object)this.selectedFieldItemViewMock, (VerificationMode)Mockito.never())).getFieldName();
        ((FieldItemView)Mockito.verify((Object)this.selectedFieldItemViewMock, (VerificationMode)Mockito.never())).getClassName();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(SetInstanceHeaderEvent.class));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(SetPropertyHeaderEvent.class));
    }

    @Test
    public void onModifyColumn_FieldItemSelected() {
        this.testToolsPresenterSpy.editingColumnEnabled = true;
        this.testToolsPresenterSpy.selectedListGroupItemView = null;
        this.testToolsPresenterSpy.selectedFieldItemView = this.selectedFieldItemViewMock;
        this.testToolsPresenterSpy.onModifyColumn();
        ((ListGroupItemView)Mockito.verify((Object)this.selectedListGroupItemViewMock, (VerificationMode)Mockito.never())).getActualClassName();
        ((FieldItemView)Mockito.verify((Object)this.selectedFieldItemViewMock, (VerificationMode)Mockito.times((int)2))).getFullPath();
        ((FieldItemView)Mockito.verify((Object)this.selectedFieldItemViewMock, (VerificationMode)Mockito.times((int)1))).getFieldName();
        ((FieldItemView)Mockito.verify((Object)this.selectedFieldItemViewMock, (VerificationMode)Mockito.times((int)1))).getClassName();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SetPropertyHeaderEvent.class));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(SetInstanceHeaderEvent.class));
    }

    @Test
    public void onModifyColumn_ListGroupSelected() {
        this.testToolsPresenterSpy.editingColumnEnabled = true;
        this.testToolsPresenterSpy.selectedListGroupItemView = this.selectedListGroupItemViewMock;
        this.testToolsPresenterSpy.selectedFieldItemView = null;
        this.testToolsPresenterSpy.onModifyColumn();
        ((ListGroupItemView)Mockito.verify((Object)this.selectedListGroupItemViewMock, (VerificationMode)Mockito.times((int)1))).getActualClassName();
        ((FieldItemView)Mockito.verify((Object)this.selectedFieldItemViewMock, (VerificationMode)Mockito.never())).getFullPath();
        ((FieldItemView)Mockito.verify((Object)this.selectedFieldItemViewMock, (VerificationMode)Mockito.never())).getFieldName();
        ((FieldItemView)Mockito.verify((Object)this.selectedFieldItemViewMock, (VerificationMode)Mockito.never())).getClassName();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SetPropertyHeaderEvent.class));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(SetInstanceHeaderEvent.class));
    }

    @Test
    public void clearLists() {
        this.testToolsPresenterSpy.clearLists();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).clearDataObjectList();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).clearSimpleJavaTypeList();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).clearInstanceList();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).clearSimpleJavaInstanceFieldList();
    }

    @Test
    public void filterTerm() {
        String key = this.getRandomString();
        String search = String.join((CharSequence)";", IntStream.range(0, 4).mapToObj(i -> this.getRandomString()).collect(Collectors.toSet()));
        TestCase.assertTrue((boolean)this.testToolsPresenterSpy.filterTerm(key, key, false));
        Assert.assertFalse((boolean)this.testToolsPresenterSpy.filterTerm(key, key, true));
        Assert.assertFalse((boolean)this.testToolsPresenterSpy.filterTerm(key, search, false));
        TestCase.assertTrue((boolean)this.testToolsPresenterSpy.filterTerm(key, search, true));
        search = search + ";" + key;
        TestCase.assertTrue((boolean)this.testToolsPresenterSpy.filterTerm(key, search, false));
        Assert.assertFalse((boolean)this.testToolsPresenterSpy.filterTerm(key, search, true));
    }

    @Test
    public void resetTest() {
        this.testToolsPresenterSpy.reset();
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).reset();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void updateInstanceIsAssignedStatus_NotPresent() {
        String instance = "CHECK_INSTANCE";
        this.testToolsPresenterSpy.updateInstanceIsAssignedStatus(instance);
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).setInstanceAssigned((String)Matchers.eq((Object)instance), Matchers.eq((boolean)false));
    }

    @Test
    public void updateInstanceIsAssignedStatus_Present() {
        String instance = "CHECK_INSTANCE";
        FactModelTree factModel = new FactModelTree(instance, "test.scesim.package", this.getMockSimpleProperties(), new HashMap());
        this.dataObjectFactTreeMap.put(instance, factModel);
        this.testToolsPresenterSpy.updateInstanceIsAssignedStatus(instance);
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).setInstanceAssigned((String)Matchers.eq((Object)instance), Matchers.eq((boolean)true));
    }

    @Test
    public void updateInstanceIsAssignedStatus_EmptyString() {
        String instance = "";
        this.testToolsPresenterSpy.updateInstanceIsAssignedStatus(instance);
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).setInstanceAssigned(Matchers.anyString(), Matchers.anyBoolean());
    }

    @Test
    public void hideInstances() {
        this.testToolsPresenterSpy.hideInstances();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).clearInstanceList();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).clearSimpleJavaInstanceFieldList();
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterSpy, (VerificationMode)Mockito.times((int)1))).showInstanceListContainerSeparator(Matchers.eq((boolean)false));
    }

    @Test
    public void clearSelection_ListGroup() {
        this.testToolsPresenterSpy.selectedListGroupItemView = this.selectedListGroupItemViewMock;
        this.testToolsPresenterSpy.selectedFieldItemView = null;
        this.testToolsPresenterSpy.clearSelection();
        ((ListGroupItemView)Mockito.verify((Object)this.selectedListGroupItemViewMock, (VerificationMode)Mockito.times((int)1))).showCheck(Matchers.eq((boolean)false));
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).disableAddButton();
    }

    @Test
    public void clearSelection_FieldItem() {
        this.testToolsPresenterSpy.selectedListGroupItemView = null;
        this.testToolsPresenterSpy.selectedFieldItemView = this.selectedFieldItemViewMock;
        this.testToolsPresenterSpy.clearSelection();
        ((FieldItemView)Mockito.verify((Object)this.selectedFieldItemViewMock, (VerificationMode)Mockito.times((int)1))).showCheck(Matchers.eq((boolean)false));
        ((TestToolsView)Mockito.verify((Object)this.testToolsViewMock, (VerificationMode)Mockito.times((int)1))).disableAddButton();
    }

    @Test
    public void isSimple() {
        TestCase.assertTrue((boolean)this.testToolsPresenterSpy.isSimple("String"));
        Assert.assertFalse((boolean)this.testToolsPresenterSpy.isSimple("Test"));
    }
}

