/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.renderers;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.renderers.ScenarioGridColumnRenderer;
import org.drools.workbench.screens.scenariosimulation.client.renderers.ScenarioGridRendererTheme;
import org.drools.workbench.screens.scenariosimulation.client.values.ScenarioGridCellValue;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioGridColumnRendererTest {
    @Mock
    private GridBodyCellRenderContext contextMock;
    @Mock
    private GridRenderer rendererMock;
    @Mock
    private ScenarioGridRendererTheme themeMock;
    @Mock
    private Text textMock;
    @Mock
    private Text placeholderMock;
    @Mock
    private Text errorTextMock;
    @Mock
    private Rectangle rectangle;
    @Mock
    private ScenarioGridCell scenarioGridCell;
    @Mock
    private Node<?> nodeMock;
    private ScenarioGridColumnRenderer scenarioGridColumnRenderer;

    @Before
    public void setUp() {
        ((Text)Mockito.doReturn(this.nodeMock).when((Object)this.textMock)).asNode();
        ((Text)Mockito.doReturn(this.nodeMock).when((Object)this.placeholderMock)).asNode();
        ((Text)Mockito.doReturn(this.nodeMock).when((Object)this.errorTextMock)).asNode();
        ((Rectangle)Mockito.doReturn(this.nodeMock).when((Object)this.rectangle)).asNode();
        Mockito.when((Object)this.themeMock.getPlaceholderText()).thenReturn((Object)this.placeholderMock);
        Mockito.when((Object)this.themeMock.getBodyText()).thenReturn((Object)this.textMock);
        Mockito.when((Object)this.rendererMock.getTheme()).thenReturn((Object)this.themeMock);
        Mockito.when((Object)this.contextMock.getRenderer()).thenReturn((Object)this.rendererMock);
        Mockito.when((Object)this.themeMock.getErrorText()).thenReturn((Object)this.errorTextMock);
        Mockito.when((Object)this.themeMock.getBodyErrorBackground((GridCell)Matchers.any())).thenReturn((Object)this.rectangle);
        this.scenarioGridColumnRenderer = (ScenarioGridColumnRenderer)Mockito.spy((Object)new ScenarioGridColumnRenderer(){

            protected String getCollectionString(String jsonString, boolean isList) {
                return jsonString;
            }
        });
    }

    @Test
    public void renderCell() {
        ScenarioGridCell cell = null;
        Group retrieved = this.scenarioGridColumnRenderer.renderCell(cell, this.contextMock);
        Assert.assertNull((Object)retrieved);
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.never())).internalRenderCell((GridCell)Matchers.any(), (GridBodyCellRenderContext)Matchers.eq((Object)this.contextMock), (Text)Matchers.any(), Matchers.anyString());
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.never())).getCollectionString(Matchers.anyString(), Matchers.anyBoolean());
        cell = new ScenarioGridCell(null);
        retrieved = this.scenarioGridColumnRenderer.renderCell((GridCell)cell, this.contextMock);
        Assert.assertNull((Object)retrieved);
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.never())).getCollectionString(Matchers.anyString(), Matchers.anyBoolean());
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.never())).internalRenderCell((GridCell)Matchers.any(), (GridBodyCellRenderContext)Matchers.eq((Object)this.contextMock), (Text)Matchers.eq((Object)this.textMock), (String)Matchers.eq(null));
        Mockito.reset((Object[])new ScenarioGridColumnRenderer[]{this.scenarioGridColumnRenderer});
        cell = new ScenarioGridCell(new ScenarioGridCellValue(null));
        retrieved = this.scenarioGridColumnRenderer.renderCell((GridCell)cell, this.contextMock);
        Assert.assertNull((Object)retrieved);
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.never())).getCollectionString(Matchers.anyString(), Matchers.anyBoolean());
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.never())).internalRenderCell((GridCell)Matchers.any(), (GridBodyCellRenderContext)Matchers.eq((Object)this.contextMock), (Text)Matchers.eq((Object)this.textMock), (String)Matchers.eq(null));
        Mockito.reset((Object[])new ScenarioGridColumnRenderer[]{this.scenarioGridColumnRenderer});
        cell = new ScenarioGridCell(new ScenarioGridCellValue("MULTIPART.VALUE"));
        retrieved = this.scenarioGridColumnRenderer.renderCell((GridCell)cell, this.contextMock);
        Assert.assertNotNull((Object)retrieved);
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.never())).getCollectionString(Matchers.anyString(), Matchers.anyBoolean());
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.times((int)1))).internalRenderCell((GridCell)Matchers.any(), (GridBodyCellRenderContext)Matchers.eq((Object)this.contextMock), (Text)Matchers.eq((Object)this.textMock), (String)Matchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioGridColumnRenderer[]{this.scenarioGridColumnRenderer});
        ScenarioGridCell scenarioGridCell = new ScenarioGridCell(new ScenarioGridCellValue("MULTIPART.VALUE", "PLACEHOLDER"));
        retrieved = this.scenarioGridColumnRenderer.renderCell((GridCell)scenarioGridCell, this.contextMock);
        Assert.assertNotNull((Object)retrieved);
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.never())).getCollectionString(Matchers.anyString(), Matchers.anyBoolean());
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.times((int)1))).internalRenderCell((GridCell)Matchers.any(), (GridBodyCellRenderContext)Matchers.eq((Object)this.contextMock), (Text)Matchers.eq((Object)this.textMock), (String)Matchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioGridColumnRenderer[]{this.scenarioGridColumnRenderer});
        scenarioGridCell = new ScenarioGridCell(new ScenarioGridCellValue(null, "PLACEHOLDER"));
        retrieved = this.scenarioGridColumnRenderer.renderCell((GridCell)scenarioGridCell, this.contextMock);
        Assert.assertNotNull((Object)retrieved);
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.times((int)1))).internalRenderCell((GridCell)Matchers.any(), (GridBodyCellRenderContext)Matchers.eq((Object)this.contextMock), (Text)Matchers.eq((Object)this.placeholderMock), (String)Matchers.eq((Object)"PLACEHOLDER"));
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.never())).getCollectionString(Matchers.anyString(), Matchers.anyBoolean());
        Mockito.reset((Object[])new ScenarioGridColumnRenderer[]{this.scenarioGridColumnRenderer});
        cell = new ScenarioGridCell(new ScenarioGridCellValue("[ \"Ford\", \"BMW\", \"Fiat\" ]"));
        cell.setListMap(true);
        retrieved = this.scenarioGridColumnRenderer.renderCell((GridCell)cell, this.contextMock);
        Assert.assertNotNull((Object)retrieved);
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.times((int)1))).internalRenderCell((GridCell)Matchers.any(), (GridBodyCellRenderContext)Matchers.eq((Object)this.contextMock), (Text)Matchers.eq((Object)this.textMock), (String)Matchers.eq((Object)"[ \"Ford\", \"BMW\", \"Fiat\" ]"));
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.times((int)1))).getCollectionString((String)Matchers.eq((Object)"[ \"Ford\", \"BMW\", \"Fiat\" ]"), Matchers.eq((boolean)true));
        Mockito.reset((Object[])new ScenarioGridColumnRenderer[]{this.scenarioGridColumnRenderer});
        cell = new ScenarioGridCell(new ScenarioGridCellValue("{\"name\":\"myname\",\"age\":29}"));
        cell.setListMap(false);
        retrieved = this.scenarioGridColumnRenderer.renderCell((GridCell)cell, this.contextMock);
        Assert.assertNotNull((Object)retrieved);
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.times((int)1))).internalRenderCell((GridCell)Matchers.any(), (GridBodyCellRenderContext)Matchers.eq((Object)this.contextMock), (Text)Matchers.eq((Object)this.textMock), (String)Matchers.eq((Object)"{\"name\":\"myname\",\"age\":29}"));
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.times((int)1))).getCollectionString((String)Matchers.eq((Object)"{\"name\":\"myname\",\"age\":29}"), Matchers.eq((boolean)false));
        Mockito.reset((Object[])new ScenarioGridColumnRenderer[]{this.scenarioGridColumnRenderer});
        cell = new ScenarioGridCell(new ScenarioGridCellValue("\"[1, 2, 3]\""));
        cell.setListMap(true);
        retrieved = this.scenarioGridColumnRenderer.renderCell((GridCell)cell, this.contextMock);
        Assert.assertNotNull((Object)retrieved);
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.times((int)1))).internalRenderCell((GridCell)Matchers.any(), (GridBodyCellRenderContext)Matchers.eq((Object)this.contextMock), (Text)Matchers.eq((Object)this.textMock), (String)Matchers.eq((Object)"\"[1, 2, 3]\""));
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.times((int)1))).getCollectionString((String)Matchers.eq((Object)"\"[1, 2, 3]\""), Matchers.eq((boolean)true));
        Mockito.reset((Object[])new ScenarioGridColumnRenderer[]{this.scenarioGridColumnRenderer});
        cell = new ScenarioGridCell(new ScenarioGridCellValue("\"[1, 2, 3]\""));
        cell.setListMap(false);
        retrieved = this.scenarioGridColumnRenderer.renderCell((GridCell)cell, this.contextMock);
        Assert.assertNotNull((Object)retrieved);
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.times((int)1))).internalRenderCell((GridCell)Matchers.any(), (GridBodyCellRenderContext)Matchers.eq((Object)this.contextMock), (Text)Matchers.eq((Object)this.textMock), (String)Matchers.eq((Object)"\"[1, 2, 3]\""));
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.times((int)1))).getCollectionString((String)Matchers.eq((Object)"\"[1, 2, 3]\""), Matchers.eq((boolean)false));
        Mockito.reset((Object[])new ScenarioGridColumnRenderer[]{this.scenarioGridColumnRenderer});
        cell = new ScenarioGridCell(new ScenarioGridCellValue("MULTIPART.VALUE"));
        cell.setErrorMode(true);
        retrieved = this.scenarioGridColumnRenderer.renderCell((GridCell)cell, this.contextMock);
        Assert.assertNotNull((Object)retrieved);
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.never())).getCollectionString(Matchers.anyString(), Matchers.anyBoolean());
        ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.times((int)1))).internalRenderCell((GridCell)Matchers.any(), (GridBodyCellRenderContext)Matchers.eq((Object)this.contextMock), (Text)Matchers.eq((Object)this.errorTextMock), (String)Matchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioGridColumnRenderer[]{this.scenarioGridColumnRenderer});
    }

    @Test
    public void internalRenderCell() {
        Assert.assertNull((Object)this.scenarioGridColumnRenderer.internalRenderCell(null, null, null, null));
        Assert.assertNull((Object)this.scenarioGridColumnRenderer.internalRenderCell((GridCell)this.scenarioGridCell, null, null, null));
        Mockito.when((Object)this.scenarioGridCell.getValue()).thenReturn(Mockito.mock(GridCellValue.class));
        Assert.assertNull((Object)this.scenarioGridColumnRenderer.internalRenderCell((GridCell)this.scenarioGridCell, null, null, null));
    }

    @Test
    public void applyBackgroundColor() {
        Group group = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)this.scenarioGridCell.isErrorMode()).thenReturn((Object)true);
        this.scenarioGridColumnRenderer.applyBackgroundColor(this.scenarioGridCell, this.contextMock, group, this.themeMock);
        ((Group)Mockito.verify((Object)group, (VerificationMode)Mockito.times((int)1))).add((IPrimitive)Matchers.any());
        Mockito.reset((Object[])new Group[]{group});
        Mockito.when((Object)this.scenarioGridCell.isErrorMode()).thenReturn((Object)false);
        this.scenarioGridColumnRenderer.applyBackgroundColor(this.scenarioGridCell, this.contextMock, group, this.themeMock);
        ((Group)Mockito.verify((Object)group, (VerificationMode)Mockito.never())).add((IPrimitive)Matchers.any());
    }

    @Test
    public void getValueToShow() {
        ScenarioGridCell cell = new ScenarioGridCell(null);
        this.commonGetValueToShow(cell, true, null, false);
        cell = new ScenarioGridCell(new ScenarioGridCellValue(null));
        this.commonGetValueToShow(cell, true, null, false);
        cell = new ScenarioGridCell(new ScenarioGridCellValue("MULTIPART.VALUE"));
        this.commonGetValueToShow(cell, false, null, false);
        cell = new ScenarioGridCell(new ScenarioGridCellValue("[ \"Ford\", \"BMW\", \"Fiat\" ]"));
        cell.setListMap(true);
        this.commonGetValueToShow(cell, false, "[ \"Ford\", \"BMW\", \"Fiat\" ]", true);
        cell = new ScenarioGridCell(new ScenarioGridCellValue("{\"name\":\"myname\",\"age\":29}"));
        cell.setListMap(false);
        this.commonGetValueToShow(cell, false, "{\"name\":\"myname\",\"age\":29}", false);
        cell = new ScenarioGridCell(new ScenarioGridCellValue("\"[1, 2, 3]\""));
        cell.setListMap(true);
        this.commonGetValueToShow(cell, false, "\"[1, 2, 3]\"", true);
        cell = new ScenarioGridCell(new ScenarioGridCellValue("\"[1, 2, 3]\""));
        cell.setListMap(false);
        this.commonGetValueToShow(cell, false, "\"[1, 2, 3]\"", false);
    }

    private void commonGetValueToShow(ScenarioGridCell scenarioGridCell, boolean expectedNull, String jsonString, boolean isList) {
        String retrieved = this.scenarioGridColumnRenderer.getValueToShow(scenarioGridCell);
        if (expectedNull) {
            Assert.assertNull((Object)retrieved);
        } else {
            Assert.assertNotNull((Object)retrieved);
            if (jsonString != null) {
                ((ScenarioGridColumnRenderer)Mockito.verify((Object)this.scenarioGridColumnRenderer, (VerificationMode)Mockito.times((int)1))).getCollectionString((String)Matchers.eq((Object)jsonString), Matchers.eq((boolean)isList));
            }
        }
        Mockito.reset((Object[])new ScenarioGridColumnRenderer[]{this.scenarioGridColumnRenderer});
    }
}

