/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.LabelElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.ParagraphElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsViewImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class TestToolsViewImplTest {
    private TestToolsViewImpl testToolsViewSpy;
    @Mock
    private AnchorElement clearSelectionElementMock;
    @Mock
    private ParagraphElement testToolsDescriptionElementMock;
    @Mock
    private LabelElement testToolObjectSelectionTitleElementMock;
    @Mock
    private TestToolsPresenter testToolsPresenterMock;
    @Mock
    private InputElement inputSearchMock;
    @Mock
    private ButtonElement clearSearchButtonMock;
    @Mock
    private ButtonElement searchButtonMock;
    @Mock
    private DivElement dataObjectListContainerMock;
    @Mock
    private DivElement simpleJavaTypeListContainerMock;
    @Mock
    private SpanElement instanceListContainerSeparatorMock;
    @Mock
    private Style instanceListStyleMock;
    @Mock
    private DivElement instanceListContainerMock;
    @Mock
    private DivElement simpleJavaInstanceListContainerMock;
    @Mock
    private DivElement kieTestToolsContentMock;
    @Mock
    private ButtonElement addButtonMock;
    @Mock
    private DivElement addButtonLabelMock;
    @Mock
    private SpanElement infoSelectDataObjectElementMock;
    @Mock
    private Style dataObjectListContainerStyleMock;
    @Mock
    private Style simpleJavaTypeListContainerStyleMock;
    @Mock
    private Style instanceListContainerStyleMock;
    @Mock
    private Style simpleJavaInstanceListStyleMock;
    @Mock
    private Style instanceListSeparatorStyleMock;

    @Before
    public void setup() {
        this.testToolsViewSpy = (TestToolsViewImpl)Mockito.spy((Object)new TestToolsViewImpl(){
            {
                this.inputSearch = TestToolsViewImplTest.this.inputSearchMock;
                this.clearSearchButton = TestToolsViewImplTest.this.clearSearchButtonMock;
                this.searchButton = TestToolsViewImplTest.this.searchButtonMock;
                this.addButton = TestToolsViewImplTest.this.addButtonMock;
                this.addButtonLabel = TestToolsViewImplTest.this.addButtonLabelMock;
                this.testToolsDescriptionElement = TestToolsViewImplTest.this.testToolsDescriptionElementMock;
                this.testToolObjectSelectionTitleElement = TestToolsViewImplTest.this.testToolObjectSelectionTitleElementMock;
                this.clearSelectionElement = TestToolsViewImplTest.this.clearSelectionElementMock;
                this.kieTestToolsContent = TestToolsViewImplTest.this.kieTestToolsContentMock;
                this.dataObjectListContainer = TestToolsViewImplTest.this.dataObjectListContainerMock;
                this.simpleJavaTypeListContainer = TestToolsViewImplTest.this.simpleJavaTypeListContainerMock;
                this.instanceListContainer = TestToolsViewImplTest.this.instanceListContainerMock;
                this.instanceListContainerSeparator = TestToolsViewImplTest.this.instanceListContainerSeparatorMock;
                this.simpleJavaInstanceListContainer = TestToolsViewImplTest.this.simpleJavaInstanceListContainerMock;
                this.infoSelectDataObjectElement = TestToolsViewImplTest.this.infoSelectDataObjectElementMock;
            }
        });
        Mockito.when((Object)this.instanceListContainerSeparatorMock.getStyle()).thenReturn((Object)this.instanceListStyleMock);
        Mockito.when((Object)this.dataObjectListContainerMock.getStyle()).thenReturn((Object)this.dataObjectListContainerStyleMock);
        Mockito.when((Object)this.simpleJavaTypeListContainerMock.getStyle()).thenReturn((Object)this.simpleJavaTypeListContainerStyleMock);
        Mockito.when((Object)this.instanceListContainerMock.getStyle()).thenReturn((Object)this.instanceListContainerStyleMock);
        Mockito.when((Object)this.simpleJavaInstanceListContainerMock.getStyle()).thenReturn((Object)this.simpleJavaInstanceListStyleMock);
        Mockito.when((Object)this.instanceListContainerSeparatorMock.getStyle()).thenReturn((Object)this.instanceListSeparatorStyleMock);
    }

    @Test
    public void init() {
        this.testToolsViewSpy.init((TestToolsView.Presenter)this.testToolsPresenterMock);
        Assert.assertSame((Object)this.testToolsPresenterMock, (Object)this.testToolsViewSpy.presenter);
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).disableEditorTab();
        ((ParagraphElement)Mockito.verify((Object)this.testToolsDescriptionElementMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.testToolsDescription()));
        ((LabelElement)Mockito.verify((Object)this.testToolObjectSelectionTitleElementMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.testToolObjectSelectionTitle()));
        ((AnchorElement)Mockito.verify((Object)this.clearSelectionElementMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.testToolClearSelection()));
        ((ButtonElement)Mockito.verify((Object)this.addButtonMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.testToolsAddButton()));
        ((DivElement)Mockito.verify((Object)this.addButtonLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.testToolsAddButtonLabel());
        ((SpanElement)Mockito.verify((Object)this.instanceListContainerSeparatorMock, (VerificationMode)Mockito.times((int)1))).setInnerText(ScenarioSimulationEditorConstants.INSTANCE.dataObjectInstances());
        ((SpanElement)Mockito.verify((Object)this.infoSelectDataObjectElementMock, (VerificationMode)Mockito.times((int)1))).setAttribute((String)Matchers.eq((Object)"title"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.testToolObjectSelectionTooltip()));
    }

    @Test
    public void onClearSearchButtonClick() {
        this.testToolsViewSpy.init((TestToolsView.Presenter)this.testToolsPresenterMock);
        this.testToolsViewSpy.onClearSearchButtonClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).onUndoSearch();
    }

    @Test
    public void onInputSearchKeyUp() {
        this.testToolsViewSpy.init((TestToolsView.Presenter)this.testToolsPresenterMock);
        this.testToolsViewSpy.onInputSearchKeyUp((KeyUpEvent)Mockito.mock(KeyUpEvent.class));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).onShowClearButton();
    }

    @Test
    public void clearInputSearch() {
        this.testToolsViewSpy.clearInputSearch();
        ((InputElement)Mockito.verify((Object)this.inputSearchMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)""));
    }

    @Test
    public void hideClearButton() {
        Mockito.reset((Object[])new ButtonElement[]{this.clearSearchButtonMock});
        this.testToolsViewSpy.hideClearButton();
        ((ButtonElement)Mockito.verify((Object)this.clearSearchButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)true));
        ((ButtonElement)Mockito.verify((Object)this.clearSearchButtonMock, (VerificationMode)Mockito.times((int)1))).setAttribute((String)Matchers.eq((Object)"style"), (String)Matchers.eq((Object)"display: none;"));
    }

    @Test
    public void showClearButton() {
        Mockito.reset((Object[])new ButtonElement[]{this.clearSearchButtonMock});
        this.testToolsViewSpy.showClearButton();
        ((ButtonElement)Mockito.verify((Object)this.clearSearchButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)false));
        ((ButtonElement)Mockito.verify((Object)this.clearSearchButtonMock, (VerificationMode)Mockito.times((int)1))).removeAttribute((String)Matchers.eq((Object)"style"));
    }

    @Test
    public void testReset() {
        this.testToolsViewSpy.reset();
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).clearDataObjectList();
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).clearSimpleJavaTypeList();
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).showInstanceListContainerSeparator(Matchers.eq((boolean)false));
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).clearInstanceList();
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).clearSimpleJavaInstanceFieldList();
    }

    @Test
    public void onClearSelectionElementClicked() {
        this.testToolsViewSpy.init((TestToolsView.Presenter)this.testToolsPresenterMock);
        this.testToolsViewSpy.onClearSelectionElementClicked((ClickEvent)Mockito.mock(ClickEvent.class));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).clearSelection();
    }

    @Test
    public void clearDataObjectList() {
        this.testToolsViewSpy.clearDataObjectList();
        ((Style)Mockito.verify((Object)this.dataObjectListContainerMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((DivElement)Mockito.verify((Object)this.dataObjectListContainerMock, (VerificationMode)Mockito.times((int)1))).removeAllChildren();
    }

    @Test
    public void clearSimpleJavaTypeList() {
        this.testToolsViewSpy.clearSimpleJavaTypeList();
        ((Style)Mockito.verify((Object)this.simpleJavaTypeListContainerMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((DivElement)Mockito.verify((Object)this.simpleJavaTypeListContainerMock, (VerificationMode)Mockito.times((int)1))).removeAllChildren();
    }

    @Test
    public void clearInstanceList() {
        this.testToolsViewSpy.clearInstanceList();
        ((Style)Mockito.verify((Object)this.instanceListContainerMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((DivElement)Mockito.verify((Object)this.instanceListContainerMock, (VerificationMode)Mockito.times((int)1))).removeAllChildren();
    }

    @Test
    public void clearSimpleJavaInstanceFieldList() {
        this.testToolsViewSpy.clearSimpleJavaInstanceFieldList();
        ((Style)Mockito.verify((Object)this.simpleJavaInstanceListContainerMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((DivElement)Mockito.verify((Object)this.simpleJavaInstanceListContainerMock, (VerificationMode)Mockito.times((int)1))).removeAllChildren();
    }

    @Test
    public void addDataObjectListGroupItem() {
        DivElement divElementMock = (DivElement)Mockito.mock(DivElement.class);
        this.testToolsViewSpy.addDataObjectListGroupItem(divElementMock);
        ((DivElement)Mockito.verify((Object)this.dataObjectListContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.eq((Object)divElementMock));
        ((Style)Mockito.verify((Object)this.dataObjectListContainerMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
    }

    @Test
    public void addSimpleJavaTypeListGroupItem() {
        DivElement divElementMock = (DivElement)Mockito.mock(DivElement.class);
        this.testToolsViewSpy.addSimpleJavaTypeListGroupItem(divElementMock);
        ((DivElement)Mockito.verify((Object)this.simpleJavaTypeListContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.eq((Object)divElementMock));
        ((Style)Mockito.verify((Object)this.simpleJavaTypeListContainerMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
    }

    @Test
    public void addInstanceListGroupItem() {
        DivElement divElementMock = (DivElement)Mockito.mock(DivElement.class);
        this.testToolsViewSpy.addInstanceListGroupItem(divElementMock);
        ((DivElement)Mockito.verify((Object)this.instanceListContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.eq((Object)divElementMock));
        ((Style)Mockito.verify((Object)this.instanceListContainerMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
    }

    @Test
    public void addSimpleJavaInstanceListGroupItem() {
        DivElement divElementMock = (DivElement)Mockito.mock(DivElement.class);
        this.testToolsViewSpy.addSimpleJavaInstanceListGroupItem(divElementMock);
        ((DivElement)Mockito.verify((Object)this.simpleJavaInstanceListContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.eq((Object)divElementMock));
        ((Style)Mockito.verify((Object)this.simpleJavaInstanceListContainerMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
    }

    @Test
    public void updateInstanceListSeparatorNotEmptyTrueParameter() {
        Mockito.when((Object)this.instanceListContainerMock.getChildCount()).thenReturn((Object)2);
        this.testToolsViewSpy.updateInstanceListSeparator(true);
        ((DivElement)Mockito.verify((Object)this.instanceListContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((Style)Mockito.verify((Object)this.instanceListContainerSeparatorMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
    }

    @Test
    public void updateInstanceListSeparatorNotEmptiesTrueParameter() {
        Mockito.when((Object)this.instanceListContainerMock.getChildCount()).thenReturn((Object)2);
        Mockito.when((Object)this.simpleJavaInstanceListContainerMock.getChildCount()).thenReturn((Object)2);
        this.testToolsViewSpy.updateInstanceListSeparator(true);
        ((DivElement)Mockito.verify((Object)this.instanceListContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((Style)Mockito.verify((Object)this.instanceListContainerSeparatorMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
    }

    @Test
    public void updateInstanceListSeparatorNotEmptyFalseParameter() {
        Mockito.when((Object)this.instanceListContainerMock.getChildCount()).thenReturn((Object)2);
        this.testToolsViewSpy.updateInstanceListSeparator(false);
        ((DivElement)Mockito.verify((Object)this.instanceListContainerMock, (VerificationMode)Mockito.never())).getChildCount();
        ((Style)Mockito.verify((Object)this.instanceListContainerSeparatorMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
    }

    @Test
    public void updateInstanceListSeparatorNotEmptiesFalseParameter() {
        Mockito.when((Object)this.instanceListContainerMock.getChildCount()).thenReturn((Object)2);
        Mockito.when((Object)this.simpleJavaInstanceListContainerMock.getChildCount()).thenReturn((Object)2);
        this.testToolsViewSpy.updateInstanceListSeparator(false);
        ((DivElement)Mockito.verify((Object)this.instanceListContainerMock, (VerificationMode)Mockito.never())).getChildCount();
        ((Style)Mockito.verify((Object)this.instanceListContainerSeparatorMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
    }

    @Test
    public void updateInstanceListSeparatorEmptyFalseParameter() {
        Mockito.when((Object)this.instanceListContainerMock.getChildCount()).thenReturn((Object)0);
        Mockito.when((Object)this.simpleJavaInstanceListContainerMock.getChildCount()).thenReturn((Object)0);
        this.testToolsViewSpy.updateInstanceListSeparator(false);
        ((DivElement)Mockito.verify((Object)this.instanceListContainerMock, (VerificationMode)Mockito.never())).getChildCount();
        ((Style)Mockito.verify((Object)this.instanceListContainerSeparatorMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
    }

    @Test
    public void updateInstanceListSeparatorEmptyTrueParameter() {
        Mockito.when((Object)this.instanceListContainerMock.getChildCount()).thenReturn((Object)0);
        Mockito.when((Object)this.simpleJavaInstanceListContainerMock.getChildCount()).thenReturn((Object)0);
        this.testToolsViewSpy.updateInstanceListSeparator(true);
        ((DivElement)Mockito.verify((Object)this.instanceListContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((Style)Mockito.verify((Object)this.instanceListContainerSeparatorMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
    }

    @Test
    public void showInstanceListContainerSeparator() {
        this.testToolsViewSpy.showInstanceListContainerSeparator(true);
        ((Style)Mockito.verify((Object)this.instanceListContainerSeparatorMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.BLOCK));
        this.testToolsViewSpy.showInstanceListContainerSeparator(false);
        ((Style)Mockito.verify((Object)this.instanceListContainerSeparatorMock.getStyle(), (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
    }

    @Test
    public void setClearSelectionAnchorDisabledStatus() {
        this.testToolsViewSpy.setClearSelectionAnchorDisabledStatus(true);
        ((AnchorElement)Mockito.verify((Object)this.clearSelectionElementMock, (VerificationMode)Mockito.times((int)1))).addClassName((String)Matchers.eq((Object)"disabled"));
        this.testToolsViewSpy.setClearSelectionAnchorDisabledStatus(false);
        ((AnchorElement)Mockito.verify((Object)this.clearSelectionElementMock, (VerificationMode)Mockito.times((int)1))).removeClassName((String)Matchers.eq((Object)"disabled"));
    }

    @Test
    public void setInfoSelectDataObjectElementDisabledStatus() {
        this.testToolsViewSpy.setInfoSelectDataObjectElementDisabledStatus(true);
        ((SpanElement)Mockito.verify((Object)this.infoSelectDataObjectElementMock, (VerificationMode)Mockito.times((int)1))).addClassName((String)Matchers.eq((Object)"disabled"));
        this.testToolsViewSpy.setInfoSelectDataObjectElementDisabledStatus(false);
        ((SpanElement)Mockito.verify((Object)this.infoSelectDataObjectElementMock, (VerificationMode)Mockito.times((int)1))).removeClassName((String)Matchers.eq((Object)"disabled"));
    }

    @Test
    public void setDisabledStatusTrue() {
        this.testToolsViewSpy.setDisabledStatus(true);
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).setClearSelectionAnchorDisabledStatus(Matchers.eq((boolean)true));
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).setInfoSelectDataObjectElementDisabledStatus(Matchers.eq((boolean)true));
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).setContainersDisabledStatus(Matchers.eq((boolean)true));
        ((DivElement)Mockito.verify((Object)this.kieTestToolsContentMock, (VerificationMode)Mockito.times((int)1))).addClassName("disabled");
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).disableSearch();
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).disableAddButton();
        ((DivElement)Mockito.verify((Object)this.kieTestToolsContentMock, (VerificationMode)Mockito.never())).removeClassName(Matchers.anyString());
    }

    @Test
    public void setDisabledStatusFalse() {
        this.testToolsViewSpy.setDisabledStatus(false);
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).setClearSelectionAnchorDisabledStatus(Matchers.eq((boolean)false));
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).setInfoSelectDataObjectElementDisabledStatus(Matchers.eq((boolean)false));
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).setContainersDisabledStatus(Matchers.eq((boolean)false));
        ((DivElement)Mockito.verify((Object)this.kieTestToolsContentMock, (VerificationMode)Mockito.never())).addClassName(Matchers.anyString());
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.never())).disableSearch();
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.never())).disableAddButton();
        ((DivElement)Mockito.verify((Object)this.kieTestToolsContentMock, (VerificationMode)Mockito.times((int)1))).removeClassName("disabled");
    }

    @Test
    public void enableSearch() {
        this.testToolsViewSpy.enableSearch();
        ((ButtonElement)Mockito.verify((Object)this.clearSearchButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)false));
        ((ButtonElement)Mockito.verify((Object)this.searchButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)false));
        ((InputElement)Mockito.verify((Object)this.inputSearchMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)false));
    }

    @Test
    public void disableSearch() {
        this.testToolsViewSpy.disableSearch();
        ((TestToolsViewImpl)Mockito.verify((Object)this.testToolsViewSpy, (VerificationMode)Mockito.times((int)1))).hideClearButton();
        ((ButtonElement)Mockito.verify((Object)this.searchButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)true));
        ((InputElement)Mockito.verify((Object)this.inputSearchMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)true));
        ((InputElement)Mockito.verify((Object)this.inputSearchMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)""));
    }
}

