/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.HeadingElement;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.AbstractCollectionEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionView;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ItemElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.KeyValueElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.editingbox.ItemEditingBoxPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.editingbox.KeyValueEditingBoxPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popup.ConfirmPopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popup.ScenarioConfirmationPopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class CollectionPresenterTest
extends AbstractCollectionEditorTest {
    @Mock
    private ItemElementPresenter listElementPresenterMock;
    @Mock
    private KeyValueElementPresenter mapElementPresenterMock;
    @Mock
    private ItemEditingBoxPresenter listEditingBoxPresenterMock;
    @Mock
    private KeyValueEditingBoxPresenter mapEditingBoxPresenterMock;
    @Mock
    private CollectionView collectionViewMock;
    private Map<String, Map<String, String>> instancePropertiesMapLocal = new HashMap<String, Map<String, String>>();
    private Map<String, String> keyPropertyMapLocal = new HashMap<String, String>();
    private Map<String, String> propertyMapLocal = new HashMap<String, String>();
    @Mock
    private UListElement elementsContainerMock;
    @Mock
    private LIElement listEditingBoxMock;
    @Mock
    private LIElement mapEditingBoxMock;
    @Mock
    private LIElement itemElementMock;
    @Mock
    private JSONString jsonStringMock;
    @Mock
    private JSONValue jsonValueMock;
    @Mock
    private JSONArray jsonArrayMock;
    @Mock
    private JSONValue jsonValueChildMock;
    @Mock
    private JSONObject jsonObjectMock;
    @Mock
    private JSONValue jsonValueNeph1Mock;
    @Mock
    private JSONValue jsonValueNeph2Mock;
    @Mock
    private JSONString jsonStringProp1Mock;
    @Mock
    private JSONString jsonStringProp2Mock;
    @Mock
    private JSONObject nestedValue1Mock;
    @Mock
    private JSONObject nestedValue2Mock;
    @Mock
    private HeadingElement editorTitleMock;
    @Mock
    private SpanElement propertyTitleMock;
    @Mock
    private ScenarioConfirmationPopupPresenter scenarioConfirmationPopupPresenterMock;
    @Mock
    private ConfirmPopupPresenter confirmPopupPresenterMock;
    private CollectionPresenter collectionEditorPresenterSpy;

    @Override
    @Before
    public void setup() {
        Mockito.when((Object)this.elementsContainerMock.getChildCount()).thenReturn((Object)3);
        Mockito.when((Object)this.editorTitleMock.getInnerText()).thenReturn((Object)"TEST-CLASSNAME#TEST-PROPERTYNAME");
        Mockito.when((Object)this.collectionViewMock.getElementsContainer()).thenReturn((Object)this.elementsContainerMock);
        Mockito.when((Object)this.collectionViewMock.getEditorTitle()).thenReturn((Object)this.editorTitleMock);
        Mockito.when((Object)this.collectionViewMock.getPropertyTitle()).thenReturn((Object)this.propertyTitleMock);
        Mockito.when((Object)this.nestedValue1Mock.keySet()).thenReturn(TestProperties.KEY_SET);
        Mockito.when((Object)this.nestedValue1Mock.get((String)Matchers.eq((Object)"prop1"))).thenReturn((Object)this.jsonValueNeph1Mock);
        Mockito.when((Object)this.nestedValue1Mock.get((String)Matchers.eq((Object)"prop2"))).thenReturn((Object)this.jsonValueNeph2Mock);
        Mockito.when((Object)this.nestedValue2Mock.keySet()).thenReturn(TestProperties.KEY_SET);
        Mockito.when((Object)this.nestedValue2Mock.get((String)Matchers.eq((Object)"prop1"))).thenReturn((Object)this.jsonValueNeph1Mock);
        Mockito.when((Object)this.nestedValue2Mock.get((String)Matchers.eq((Object)"prop2"))).thenReturn((Object)this.jsonValueNeph2Mock);
        Mockito.when((Object)this.jsonValueNeph1Mock.isString()).thenReturn((Object)this.jsonStringProp1Mock);
        Mockito.when((Object)this.jsonValueNeph2Mock.isString()).thenReturn((Object)this.jsonStringProp2Mock);
        Mockito.when((Object)this.jsonValueNeph1Mock.isObject()).thenReturn((Object)this.nestedValue1Mock);
        Mockito.when((Object)this.jsonValueNeph2Mock.isObject()).thenReturn((Object)this.nestedValue2Mock);
        Mockito.when((Object)this.jsonObjectMock.keySet()).thenReturn(TestProperties.KEY_SET);
        Mockito.when((Object)this.jsonObjectMock.get((String)Matchers.eq((Object)"prop1"))).thenReturn((Object)this.jsonValueNeph1Mock);
        Mockito.when((Object)this.jsonObjectMock.get((String)Matchers.eq((Object)"prop2"))).thenReturn((Object)this.jsonValueNeph2Mock);
        Mockito.when((Object)this.jsonValueChildMock.isObject()).thenReturn((Object)this.jsonObjectMock);
        Mockito.when((Object)this.jsonArrayMock.size()).thenReturn((Object)2);
        Mockito.when((Object)this.jsonArrayMock.get(Matchers.anyInt())).thenReturn((Object)this.jsonValueChildMock);
        Mockito.when((Object)this.jsonValueMock.isArray()).thenReturn((Object)this.jsonArrayMock);
        Mockito.when((Object)this.jsonValueMock.isObject()).thenReturn((Object)this.jsonObjectMock);
        Mockito.when((Object)this.jsonValueMock.isString()).thenReturn((Object)this.jsonStringMock);
        this.collectionEditorPresenterSpy = (CollectionPresenter)Mockito.spy((Object)new CollectionPresenter(){
            {
                this.viewsProvider = CollectionPresenterTest.this.viewsProviderMock;
                this.listElementPresenter = CollectionPresenterTest.this.listElementPresenterMock;
                this.mapElementPresenter = CollectionPresenterTest.this.mapElementPresenterMock;
                this.listEditingBoxPresenter = CollectionPresenterTest.this.listEditingBoxPresenterMock;
                this.mapEditingBoxPresenter = CollectionPresenterTest.this.mapEditingBoxPresenterMock;
                this.simplePropertiesMap = CollectionPresenterTest.this.instancePropertiesMapLocal;
                this.collectionView = CollectionPresenterTest.this.collectionViewMock;
                this.scenarioConfirmationPopupPresenter = CollectionPresenterTest.this.scenarioConfirmationPopupPresenterMock;
                this.confirmPopupPresenter = CollectionPresenterTest.this.confirmPopupPresenterMock;
            }

            protected JSONValue getJSONValue(String jsonString) {
                return CollectionPresenterTest.this.jsonValueMock;
            }

            protected String getListValue() {
                return "UPDATED_VALUE";
            }

            protected String getMapValue() {
                return "UPDATED_VALUE";
            }

            protected String getExpressionValue() {
                return "UPDATED_VALUE";
            }
        });
        this.instancePropertiesMapLocal.clear();
        Mockito.when((Object)this.listElementPresenterMock.getItemContainer((String)Matchers.any(), (Map)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)this.itemElementMock);
        Mockito.when((Object)this.mapElementPresenterMock.getKeyValueContainer((String)Matchers.any(), (Map)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)this.itemElementMock);
        Mockito.when((Object)this.listEditingBoxPresenterMock.getEditingBox((String)Matchers.any(), (Map)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)this.listEditingBoxMock);
        Mockito.when((Object)this.mapEditingBoxPresenterMock.getEditingBox((String)Matchers.any(), (Map)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)this.mapEditingBoxMock);
    }

    @Test
    public void initListStructure() {
        this.collectionEditorPresenterSpy.initListStructure("TEST-CLASSNAME#TEST-PROPERTYNAME", this.propertyMapLocal, new HashMap(), this.collectionViewMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)1))).commonInit((String)Matchers.eq((Object)"TEST-CLASSNAME#TEST-PROPERTYNAME"), (CollectionView)Matchers.eq((Object)this.collectionViewMock));
        Assert.assertTrue((boolean)this.instancePropertiesMapLocal.containsKey("TEST-CLASSNAME#TEST-PROPERTYNAME"));
        Assert.assertEquals(this.instancePropertiesMapLocal.get("TEST-CLASSNAME#TEST-PROPERTYNAME"), this.propertyMapLocal);
        ((ItemEditingBoxPresenter)Mockito.verify((Object)this.listEditingBoxPresenterMock, (VerificationMode)Mockito.times((int)1))).setCollectionEditorPresenter((CollectionView.Presenter)Matchers.eq((Object)this.collectionEditorPresenterSpy));
        ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).setCollectionEditorPresenter((CollectionView.Presenter)Matchers.eq((Object)this.collectionEditorPresenterSpy));
    }

    @Test
    public void initMapStructure() {
        this.collectionEditorPresenterSpy.initMapStructure("TEST-CLASSNAME#TEST-PROPERTYNAME", this.keyPropertyMapLocal, this.propertyMapLocal, this.collectionViewMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)1))).commonInit((String)Matchers.eq((Object)"TEST-CLASSNAME#TEST-PROPERTYNAME"), (CollectionView)Matchers.eq((Object)this.collectionViewMock));
        Assert.assertTrue((boolean)this.instancePropertiesMapLocal.containsKey("TEST-CLASSNAME#TEST-PROPERTYNAME#key"));
        Assert.assertEquals(this.instancePropertiesMapLocal.get("TEST-CLASSNAME#TEST-PROPERTYNAME#key"), this.keyPropertyMapLocal);
        Assert.assertTrue((boolean)this.instancePropertiesMapLocal.containsKey("TEST-CLASSNAME#TEST-PROPERTYNAME#value"));
        Assert.assertEquals(this.instancePropertiesMapLocal.get("TEST-CLASSNAME#TEST-PROPERTYNAME#value"), this.propertyMapLocal);
        ((KeyValueEditingBoxPresenter)Mockito.verify((Object)this.mapEditingBoxPresenterMock, (VerificationMode)Mockito.times((int)1))).setCollectionEditorPresenter((CollectionView.Presenter)Matchers.eq((Object)this.collectionEditorPresenterSpy));
        ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).setCollectionEditorPresenter((CollectionView.Presenter)Matchers.eq((Object)this.collectionEditorPresenterSpy));
    }

    @Test
    public void setValueIsListWidgetTrue() {
        this.commonSetValue(true, false);
    }

    @Test
    public void setValueIsListWidgetFalse() {
        this.commonSetValue(false, false);
    }

    @Test
    public void setValueIsExpressionWidgetList() {
        this.commonSetValue(true, true);
    }

    @Test
    public void setValueIsExpressionWidgetMap() {
        this.commonSetValue(false, true);
    }

    @Test
    public void showEditingBoxIsListWidgetTrue() {
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)true);
        this.collectionEditorPresenterSpy.showEditingBox();
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).getElementsContainer();
        ((ItemEditingBoxPresenter)Mockito.verify((Object)this.listEditingBoxPresenterMock, (VerificationMode)Mockito.times((int)1))).getEditingBox((String)Matchers.eq((Object)"TEST-CLASSNAME#TEST-PROPERTYNAME"), (Map)Matchers.any(), (Map)Matchers.any());
        ((UListElement)Mockito.verify((Object)this.elementsContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.eq((Object)this.listEditingBoxMock));
        ((LIElement)Mockito.verify((Object)this.listEditingBoxMock, (VerificationMode)Mockito.times((int)1))).scrollIntoView();
        ((LIElement)Mockito.verify((Object)this.mapEditingBoxMock, (VerificationMode)Mockito.never())).scrollIntoView();
    }

    @Test
    public void showEditingBoxIsListWidgetFalse() {
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)false);
        this.collectionEditorPresenterSpy.showEditingBox();
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).getElementsContainer();
        ((KeyValueEditingBoxPresenter)Mockito.verify((Object)this.mapEditingBoxPresenterMock, (VerificationMode)Mockito.times((int)1))).getEditingBox((String)Matchers.eq((Object)"TEST-CLASSNAME#TEST-PROPERTYNAME"), (Map)Matchers.any(), (Map)Matchers.any());
        ((UListElement)Mockito.verify((Object)this.elementsContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.eq((Object)this.mapEditingBoxMock));
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
        ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
        ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
        ((LIElement)Mockito.verify((Object)this.listEditingBoxMock, (VerificationMode)Mockito.never())).scrollIntoView();
        ((LIElement)Mockito.verify((Object)this.mapEditingBoxMock, (VerificationMode)Mockito.times((int)1))).scrollIntoView();
    }

    @Test
    public void onToggleRowExpansionIsShownTrue() {
        this.commonOnToggleRowExpansionIsShown(true, true);
        this.commonOnToggleRowExpansionIsShown(true, false);
    }

    @Test
    public void onToggleRowExpansionIsShownFalse() {
        this.commonOnToggleRowExpansionIsShown(false, true);
        this.commonOnToggleRowExpansionIsShown(false, false);
    }

    @Test
    public void addListItem() {
        this.collectionEditorPresenterSpy.addListItem(this.propertyMapLocal, new HashMap());
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).getElementsContainer();
        ((UListElement)Mockito.verify((Object)this.elementsContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).getItemContainer((String)Matchers.eq((Object)TestProperties.ITEM_ID), (Map)Matchers.eq(this.propertyMapLocal), Matchers.anyMap());
        ((UListElement)Mockito.verify((Object)this.elementsContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.eq((Object)this.itemElementMock));
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    @Test
    public void addMapItem() {
        this.collectionEditorPresenterSpy.addMapItem(this.keyPropertyMapLocal, this.propertyMapLocal);
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).getElementsContainer();
        ((UListElement)Mockito.verify((Object)this.elementsContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).getKeyValueContainer((String)Matchers.eq((Object)TestProperties.ITEM_ID), (Map)Matchers.eq(this.keyPropertyMapLocal), (Map)Matchers.eq(this.propertyMapLocal));
        ((UListElement)Mockito.verify((Object)this.elementsContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.eq((Object)this.itemElementMock));
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    @Test
    public void saveIsListWidgetTrue() {
        this.commonSave(true, false, false);
        this.commonSave(true, false, true);
    }

    @Test
    public void saveIsListWidgetFalse() {
        this.commonSave(false, false, false);
        this.commonSave(false, false, true);
    }

    @Test
    public void saveIsExpressionWidget() {
        this.commonSave(false, true, false);
        this.commonSave(false, true, true);
        this.commonSave(true, true, false);
        this.commonSave(true, true, true);
    }

    @Test
    public void removeIsListWidgetTrue() {
        this.commonRemove(true);
    }

    @Test
    public void removeIsListWidgetFalse() {
        this.commonRemove(false);
    }

    @Test
    public void okRemoveCommandMethodIsListWidgetTrue() {
        this.commonOkRemoveCommandMethod(true);
    }

    @Test
    public void okRemoveCommandMethodIsListWidgetFalse() {
        this.commonOkRemoveCommandMethod(false);
    }

    @Test
    public void commonInit() {
        this.collectionEditorPresenterSpy.collectionView = null;
        this.collectionEditorPresenterSpy.commonInit("TEST-CLASSNAME#TEST-PROPERTYNAME", this.collectionViewMock);
        Assert.assertEquals((Object)this.collectionEditorPresenterSpy.collectionView, (Object)this.collectionViewMock);
        ((HeadingElement)Mockito.verify((Object)this.editorTitleMock, (VerificationMode)Mockito.times((int)1))).setInnerText("TEST-CLASSNAME#TEST-PROPERTYNAME");
        ((SpanElement)Mockito.verify((Object)this.propertyTitleMock, (VerificationMode)Mockito.times((int)1))).setInnerText("TEST-PROPERTYNAME");
    }

    @Test
    public void populateList() {
        this.collectionEditorPresenterSpy.populateList(this.jsonValueMock);
        for (int i = 0; i < 2; ++i) {
            ((JSONArray)Mockito.verify((Object)this.jsonArrayMock, (VerificationMode)Mockito.times((int)1))).get(Matchers.eq((int)i));
        }
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)6))).getSimplePropertiesMap((JSONObject)Matchers.any());
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)2))).getExpandablePropertiesValues((JSONObject)Matchers.any());
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)2))).addListItem(Matchers.anyMap(), Matchers.anyMap());
    }

    @Test
    public void populateMap() {
        this.collectionEditorPresenterSpy.populateMap(this.jsonValueMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)2))).addMapItem(Matchers.anyMap(), Matchers.anyMap());
    }

    @Test
    public void toggleEditingStatusToDisableTrue() {
        this.collectionEditorPresenterSpy.toggleEditingStatus(true);
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).enableEditingMode(Matchers.eq((boolean)true));
        ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
        ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void toggleEditingStatusToDisableFalse() {
        this.collectionEditorPresenterSpy.toggleEditingStatus(false);
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).enableEditingMode(Matchers.eq((boolean)false));
        ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
        ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    private void commonRemove(boolean isWidget) {
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)isWidget);
        this.collectionEditorPresenterSpy.remove();
        ((ScenarioConfirmationPopupPresenter)Mockito.verify((Object)this.scenarioConfirmationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.removeCollectionMainTitle()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.removeCollectionMainQuestion()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.removeCollectionText1()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.removeCollectionQuestion()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.removeCollectionWarningText()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.remove()), (Command)Matchers.isA(Command.class));
        ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.never())).remove();
        ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.never())).remove();
    }

    private void commonOkRemoveCommandMethod(boolean isListWidget) {
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)isListWidget);
        this.collectionEditorPresenterSpy.okRemoveCommandMethod();
        if (isListWidget) {
            ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).remove();
            ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.never())).remove();
        } else {
            ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).remove();
            ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.never())).remove();
        }
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).updateValue((String)Matchers.eq(null));
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    private void commonSetValue(boolean isListWidget, boolean isExpressionList) {
        this.collectionEditorPresenterSpy.setValue(null);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.never())).getJSONValue(Matchers.anyString());
        Mockito.reset((Object[])new CollectionPresenter[]{this.collectionEditorPresenterSpy});
        this.collectionEditorPresenterSpy.setValue("");
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.never())).getJSONValue(Matchers.anyString());
        Mockito.reset((Object[])new CollectionPresenter[]{this.collectionEditorPresenterSpy});
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)isListWidget);
        Mockito.when((Object)this.collectionViewMock.isExpressionWidget()).thenReturn((Object)isExpressionList);
        if (isExpressionList) {
            Mockito.when((Object)this.collectionEditorPresenterSpy.getJSONValue("\"TEST-JSON\"")).thenReturn((Object)new JSONString("\"TEST-JSON\""));
        }
        this.collectionEditorPresenterSpy.setValue("\"TEST-JSON\"");
        if (isExpressionList) {
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)1))).populateExpression((JSONValue)Matchers.isA(JSONValue.class));
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.never())).populateCreateCollection((JSONValue)Matchers.any());
        } else if (isListWidget) {
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)1))).populateCreateCollection((JSONValue)Matchers.isA(JSONValue.class));
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.never())).populateExpression((JSONValue)Matchers.any());
        } else {
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)1))).populateCreateCollection((JSONValue)Matchers.isA(JSONValue.class));
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.never())).populateExpression((JSONValue)Matchers.any());
        }
    }

    private void commonOnToggleRowExpansionIsShown(boolean isShown, boolean isListWidget) {
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)isListWidget);
        this.collectionEditorPresenterSpy.onToggleRowExpansion(isShown);
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).toggleRowExpansion();
        if (isListWidget) {
            ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion(Matchers.eq((boolean)isShown));
        } else {
            ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion(Matchers.eq((boolean)isShown));
        }
        Mockito.reset((Object[])new CollectionView[]{this.collectionViewMock});
        Mockito.reset((Object[])new ItemElementPresenter[]{this.listElementPresenterMock});
        Mockito.reset((Object[])new KeyValueElementPresenter[]{this.mapElementPresenterMock});
    }

    private void commonSave(boolean isListWidget, boolean isExpressionWidget, boolean throwException) {
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)isListWidget);
        Mockito.when((Object)this.collectionViewMock.isExpressionWidget()).thenReturn((Object)isExpressionWidget);
        if (throwException) {
            if (isExpressionWidget) {
                Mockito.when((Object)this.collectionEditorPresenterSpy.getExpressionValue()).thenThrow(IllegalStateException.class);
            } else if (isListWidget) {
                Mockito.when((Object)this.collectionEditorPresenterSpy.getListValue()).thenThrow(IllegalStateException.class);
            } else {
                Mockito.when((Object)this.collectionEditorPresenterSpy.getMapValue()).thenThrow(IllegalStateException.class);
            }
        }
        this.collectionEditorPresenterSpy.save();
        if (isExpressionWidget) {
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)1))).getExpressionValue();
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.never())).getValueFromCreateCollection();
        } else if (isListWidget) {
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)1))).getValueFromCreateCollection();
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.never())).getExpressionValue();
        } else {
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.times((int)1))).getValueFromCreateCollection();
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenterSpy, (VerificationMode)Mockito.never())).getExpressionValue();
        }
        if (throwException) {
            ((ConfirmPopupPresenter)Mockito.verify((Object)this.confirmPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.collectionError()), (String)Matchers.any());
            ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.never())).updateValue(Matchers.anyString());
        } else {
            ((ConfirmPopupPresenter)Mockito.verify((Object)this.confirmPopupPresenterMock, (VerificationMode)Mockito.never())).show((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.collectionError()), Matchers.anyString());
            ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).updateValue((String)Matchers.eq((Object)"UPDATED_VALUE"));
        }
        Mockito.reset((Object[])new ConfirmPopupPresenter[]{this.confirmPopupPresenterMock});
        Mockito.reset((Object[])new CollectionView[]{this.collectionViewMock});
        Mockito.reset((Object[])new CollectionPresenter[]{this.collectionEditorPresenterSpy});
    }

    @Test
    public void populateExpression() {
        Mockito.when((Object)this.jsonStringMock.stringValue()).thenReturn((Object)"test-string");
        this.collectionEditorPresenterSpy.populateExpression(this.jsonValueMock);
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).setExpression("test-string");
    }
}

