/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.dropdown;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.AbstractScenarioSimulationDropdownTest;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.SettingsScenarioSimulationDropdown;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.SettingsScenarioSimulationDropdownView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdown;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class SettingsScenarioSimulationDropdownTest
extends AbstractScenarioSimulationDropdownTest {
    @Mock
    protected Command onMissingValueHandlerMock;

    @Override
    @Before
    public void setup() {
        this.viewMock = (KieAssetsDropdownView)Mockito.mock(SettingsScenarioSimulationDropdownView.class);
        this.assetsDropdown = (KieAssetsDropdown)Mockito.spy((Object)new SettingsScenarioSimulationDropdown((SettingsScenarioSimulationDropdownView)this.viewMock, this.dataProviderMock){
            {
                this.onValueChangeHandler = SettingsScenarioSimulationDropdownTest.this.onValueChangeHandlerMock;
                this.onMissingValueHandler = SettingsScenarioSimulationDropdownTest.this.onMissingValueHandlerMock;
                this.kieAssets.addAll(SettingsScenarioSimulationDropdownTest.this.assetList);
                this.currentValue = "DEFAULT_VALUE";
            }
        });
        super.setup();
    }

    @Test
    public void asWidget() {
        ((SettingsScenarioSimulationDropdown)this.assetsDropdown).asWidget();
        ((SettingsScenarioSimulationDropdownView)Mockito.verify((Object)((SettingsScenarioSimulationDropdownView)this.viewMock), (VerificationMode)Mockito.times((int)1))).asWidget();
    }

    @Override
    @Test
    public void loadAssets() {
        ((SettingsScenarioSimulationDropdown)this.assetsDropdown).loadAssets("value");
        ((KieAssetsDropdown)Mockito.verify((Object)this.assetsDropdown, (VerificationMode)Mockito.times((int)1))).clear();
        ((KieAssetsDropdown)Mockito.verify((Object)this.assetsDropdown, (VerificationMode)Mockito.times((int)1))).initializeDropdown();
        Assert.assertEquals((Object)"value", (Object)((SettingsScenarioSimulationDropdown)this.assetsDropdown).currentValue);
    }

    @Test
    public void loadAssetsSameValue() {
        Mockito.when((Object)this.viewMock.getValue()).thenReturn((Object)"DEFAULT_VALUE");
        ((SettingsScenarioSimulationDropdown)this.assetsDropdown).loadAssets("DEFAULT_VALUE");
        ((KieAssetsDropdown)Mockito.verify((Object)this.assetsDropdown, (VerificationMode)Mockito.never())).clear();
        ((KieAssetsDropdown)Mockito.verify((Object)this.assetsDropdown, (VerificationMode)Mockito.never())).initializeDropdown();
    }

    @Test
    public void loadAssetsEmptyValue() {
        Mockito.when((Object)this.viewMock.getValue()).thenReturn(null);
        ((SettingsScenarioSimulationDropdown)this.assetsDropdown).loadAssets("DEFAULT_VALUE");
        ((KieAssetsDropdown)Mockito.verify((Object)this.assetsDropdown, (VerificationMode)Mockito.times((int)1))).clear();
        ((KieAssetsDropdown)Mockito.verify((Object)this.assetsDropdown, (VerificationMode)Mockito.times((int)1))).initializeDropdown();
        Assert.assertEquals((Object)"DEFAULT_VALUE", (Object)((SettingsScenarioSimulationDropdown)this.assetsDropdown).currentValue);
    }

    @Test
    public void assetListConsumerMethod_Present() {
        ((SettingsScenarioSimulationDropdown)this.assetsDropdown).assetListConsumerMethod(this.assetList);
        ((KieAssetsDropdown)Mockito.verify((Object)this.assetsDropdown, (VerificationMode)Mockito.times((int)3))).addValue((KieAssetsDropdownItem)Matchers.isA(KieAssetsDropdownItem.class));
        ((KieAssetsDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).refreshSelectPicker();
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)((SettingsScenarioSimulationDropdown)this.assetsDropdown), (VerificationMode)Mockito.times((int)1))).isValuePresentInKieAssets((String)Matchers.eq((Object)"DEFAULT_VALUE"));
        ((SettingsScenarioSimulationDropdownView)Mockito.verify((Object)((SettingsScenarioSimulationDropdownView)this.viewMock))).initialize((String)Matchers.eq((Object)"DEFAULT_VALUE"));
        ((Command)Mockito.verify((Object)this.onMissingValueHandlerMock, (VerificationMode)Mockito.never())).execute();
        Assert.assertNull((Object)((SettingsScenarioSimulationDropdown)this.assetsDropdown).currentValue);
    }

    @Test
    public void assetListConsumerMethod_NotPresent() {
        ((SettingsScenarioSimulationDropdown)this.assetsDropdown).currentValue = "value";
        ((SettingsScenarioSimulationDropdown)this.assetsDropdown).assetListConsumerMethod(this.assetList);
        ((KieAssetsDropdown)Mockito.verify((Object)this.assetsDropdown, (VerificationMode)Mockito.times((int)3))).addValue((KieAssetsDropdownItem)Matchers.isA(KieAssetsDropdownItem.class));
        ((KieAssetsDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).refreshSelectPicker();
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)((SettingsScenarioSimulationDropdown)this.assetsDropdown), (VerificationMode)Mockito.times((int)1))).isValuePresentInKieAssets((String)Matchers.eq((Object)"value"));
        ((SettingsScenarioSimulationDropdownView)Mockito.verify((Object)((SettingsScenarioSimulationDropdownView)this.viewMock), (VerificationMode)Mockito.times((int)1))).initialize();
        ((Command)Mockito.verify((Object)this.onMissingValueHandlerMock, (VerificationMode)Mockito.times((int)1))).execute();
        Assert.assertNull((Object)((SettingsScenarioSimulationDropdown)this.assetsDropdown).currentValue);
    }

    @Test
    public void isValuePresentInKieAssets_Present() {
        Assert.assertTrue((boolean)((SettingsScenarioSimulationDropdown)this.assetsDropdown).isValuePresentInKieAssets("DEFAULT_VALUE"));
    }

    @Test
    public void isValuePresentInKieAssets_NotPresent() {
        Assert.assertFalse((boolean)((SettingsScenarioSimulationDropdown)this.assetsDropdown).isValuePresentInKieAssets("ANOTHER_VALUE"));
    }
}

