/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.FactMappingValueType;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.SetPropertyHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractSubDockPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenterData;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.uberfire.client.annotations.WorkbenchScreen;

@ApplicationScoped
@WorkbenchScreen(identifier="org.drools.scenariosimulation.TestTools", preferredWidth=300)
public class TestToolsPresenter
extends AbstractSubDockPresenter<TestToolsView>
implements TestToolsView.Presenter {
    public static final String IDENTIFIER = "org.drools.scenariosimulation.TestTools";
    protected Map<String, FactModelTree> dataObjectFieldsMap = new TreeMap<String, FactModelTree>();
    protected Map<String, FactModelTree> simpleJavaTypeFieldsMap = new TreeMap<String, FactModelTree>();
    protected Map<String, FactModelTree> instanceFieldsMap = new TreeMap<String, FactModelTree>();
    protected Map<String, FactModelTree> simpleJavaInstanceFieldsMap = new TreeMap<String, FactModelTree>();
    protected Map<String, FactModelTree> hiddenFieldsMap = new TreeMap<String, FactModelTree>();
    protected EventBus eventBus;
    protected GridWidget gridWidget;
    protected boolean editingColumnEnabled = false;
    protected ListGroupItemView selectedListGroupItemView;
    protected FieldItemView selectedFieldItemView;
    private ListGroupItemPresenter listGroupItemPresenter;

    public TestToolsPresenter() {
        this.title = ScenarioSimulationEditorConstants.INSTANCE.testTools();
    }

    @Inject
    public TestToolsPresenter(TestToolsView view, ListGroupItemPresenter listGroupItemPresenter) {
        super(view);
        this.listGroupItemPresenter = listGroupItemPresenter;
        this.listGroupItemPresenter.init(this);
        this.title = ScenarioSimulationEditorConstants.INSTANCE.testTools();
    }

    @Override
    public void onClearSearch() {
        ((TestToolsView)this.view).clearInputSearch();
        ((TestToolsView)this.view).hideClearButton();
        this.onSearchedEvent("");
    }

    @Override
    public void onUndoSearch() {
        ((TestToolsView)this.view).clearInputSearch();
        ((TestToolsView)this.view).hideClearButton();
        this.onPerfectMatchSearchedEvent(this.listGroupItemPresenter.getFilterTerm(), true);
    }

    @Override
    public void onClearStatus() {
        this.onClearSearch();
    }

    @Override
    public void clearDataObjectList() {
        ((TestToolsView)this.view).clearDataObjectList();
    }

    @Override
    public void clearSimpleJavaTypeList() {
        ((TestToolsView)this.view).clearSimpleJavaTypeList();
    }

    @Override
    public void clearInstanceList() {
        ((TestToolsView)this.view).clearInstanceList();
    }

    @Override
    public void clearSimpleJavaInstanceFieldList() {
        ((TestToolsView)this.view).clearSimpleJavaInstanceFieldList();
    }

    @Override
    public void updateInstanceListSeparator() {
        ((TestToolsView)this.view).updateInstanceListSeparator(GridWidget.SIMULATION.equals((Object)this.gridWidget));
    }

    @Override
    public void showInstanceListContainerSeparator(boolean show) {
        ((TestToolsView)this.view).showInstanceListContainerSeparator(show);
    }

    @Override
    public Optional<FactModelTree> getFactModelTreeFromFactTypeMap(String factName) {
        return Optional.ofNullable(this.dataObjectFieldsMap.get(factName));
    }

    @Override
    public Optional<FactModelTree> getFactModelTreeFromSimpleJavaTypeMap(String factName) {
        return Optional.ofNullable(this.simpleJavaTypeFieldsMap.get(factName));
    }

    @Override
    public Optional<FactModelTree> getFactModelTreeFromInstanceMap(String factName) {
        return Optional.ofNullable(this.instanceFieldsMap.get(factName));
    }

    @Override
    public Optional<FactModelTree> getFactModelTreeFromSimpleJavaInstanceMap(String factName) {
        return Optional.ofNullable(this.simpleJavaInstanceFieldsMap.get(factName));
    }

    @Override
    public FactModelTree getFactModelTreeFromHiddenMap(String factName) {
        return this.hiddenFieldsMap.get(factName);
    }

    @Override
    public void populateTestTools(TestToolsPresenterData data) {
        this.setDataObjectFieldsMap(data.getDataObjectFieldsMap());
        this.setSimpleJavaTypeFieldsMap(data.getSimpleJavaTypeFieldsMap());
        this.setInstanceFieldsMap(data.getInstanceFieldsMap());
        this.setSimpleJavaInstanceFieldsMap(data.getSimpleJavaInstanceFieldsMap());
        this.setHiddenFieldsMap(data.getHiddenFieldsMap());
        this.hideProperties(data.getPropertiesToHide());
        this.setGridWidget(data.getGridWidget());
    }

    protected void setDataObjectFieldsMap(SortedMap<String, FactModelTree> dataObjectFieldsMap) {
        this.clearDataObjectList();
        this.dataObjectFieldsMap = dataObjectFieldsMap;
        this.dataObjectFieldsMap.forEach(this::addDataObjectListGroupItemView);
    }

    protected void setSimpleJavaTypeFieldsMap(SortedMap<String, FactModelTree> simpleJavaTypeFieldsMap) {
        this.clearSimpleJavaTypeList();
        this.simpleJavaTypeFieldsMap = simpleJavaTypeFieldsMap;
        this.simpleJavaTypeFieldsMap.forEach(this::addSimpleJavaTypeListGroupItemView);
    }

    protected void setInstanceFieldsMap(SortedMap<String, FactModelTree> instanceFieldsMap) {
        this.clearInstanceList();
        this.instanceFieldsMap = instanceFieldsMap;
        this.instanceFieldsMap.forEach(this::addInstanceListGroupItemView);
        this.updateInstanceListSeparator();
    }

    protected void setSimpleJavaInstanceFieldsMap(SortedMap<String, FactModelTree> simpleJavaInstanceFieldsMap) {
        this.clearSimpleJavaInstanceFieldList();
        this.simpleJavaInstanceFieldsMap = simpleJavaInstanceFieldsMap;
        this.simpleJavaInstanceFieldsMap.forEach(this::addSimpleJavaInstanceListGroupItemView);
        this.updateInstanceListSeparator();
    }

    protected void setHiddenFieldsMap(SortedMap<String, FactModelTree> hiddenFieldsMap) {
        this.hiddenFieldsMap = hiddenFieldsMap;
    }

    protected void hideProperties(Map<String, List<List<String>>> propertiesToHide) {
        this.listGroupItemPresenter.showAll();
        propertiesToHide.entrySet().stream().forEach(stringListEntry -> ((List)stringListEntry.getValue()).forEach(propertyParts -> this.listGroupItemPresenter.hideProperty((String)stringListEntry.getKey(), (List<String>)propertyParts)));
    }

    @Override
    public void onShowClearButton() {
        ((TestToolsView)this.view).showClearButton();
    }

    @Override
    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    protected void setGridWidget(GridWidget gridWidget) {
        this.gridWidget = gridWidget;
        if (GridWidget.BACKGROUND.equals((Object)gridWidget)) {
            this.hideInstances();
        }
    }

    @Override
    public void onSearchedEvent(String search) {
        this.clearLists();
        this.dataObjectFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(search.toLowerCase())).forEach(filteredEntry -> this.addDataObjectListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.simpleJavaTypeFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(search.toLowerCase())).forEach(filteredEntry -> this.addSimpleJavaTypeListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.instanceFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(search.toLowerCase())).forEach(filteredEntry -> this.addInstanceListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.simpleJavaInstanceFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(search.toLowerCase())).forEach(filteredEntry -> this.addSimpleJavaInstanceListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.updateInstanceListSeparator();
    }

    @Override
    public void onPerfectMatchSearchedEvent(String search, boolean notEqualsSearch) {
        this.clearLists();
        this.dataObjectFieldsMap.entrySet().stream().filter(entry -> this.filterTerm((String)entry.getKey(), search, notEqualsSearch)).forEach(filteredEntry -> this.addDataObjectListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.simpleJavaTypeFieldsMap.entrySet().stream().filter(entry -> this.filterTerm((String)entry.getKey(), search, notEqualsSearch)).forEach(filteredEntry -> this.addSimpleJavaTypeListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.instanceFieldsMap.entrySet().stream().filter(entry -> this.filterTerm((String)entry.getKey(), search, notEqualsSearch)).forEach(filteredEntry -> this.addInstanceListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.simpleJavaInstanceFieldsMap.entrySet().stream().filter(entry -> this.filterTerm((String)entry.getKey(), search, notEqualsSearch)).forEach(filteredEntry -> this.addSimpleJavaInstanceListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.updateInstanceListSeparator();
    }

    @Override
    public void addDataObjectListGroupItemView(String factName, FactModelTree factModelTree) {
        ((TestToolsView)this.view).addDataObjectListGroupItem(this.listGroupItemPresenter.getDivElement(factName, factModelTree));
    }

    @Override
    public void addSimpleJavaTypeListGroupItemView(String factName, FactModelTree factModelTree) {
        ((TestToolsView)this.view).addSimpleJavaTypeListGroupItem(this.listGroupItemPresenter.getDivElement(factName, factModelTree));
    }

    @Override
    public void addInstanceListGroupItemView(String instanceName, FactModelTree factModelTree) {
        ((TestToolsView)this.view).addInstanceListGroupItem(this.listGroupItemPresenter.getDivElement(instanceName, factModelTree));
    }

    @Override
    public void addSimpleJavaInstanceListGroupItemView(String instanceName, FactModelTree factModelTree) {
        ((TestToolsView)this.view).addSimpleJavaInstanceListGroupItem(this.listGroupItemPresenter.getDivElement(instanceName, factModelTree));
    }

    @Override
    public void onEnableEditorTab() {
        this.onDisableEditorTab();
        this.listGroupItemPresenter.enable();
        this.editingColumnEnabled = true;
        ((TestToolsView)this.view).enableEditorTab();
        ((TestToolsView)this.view).enableSearch();
    }

    @Override
    public void onEnableEditorTab(String filterTerm, List<String> propertyNameElements, boolean notEqualsSearch) {
        this.onDisableEditorTab();
        this.onPerfectMatchSearchedEvent(filterTerm, notEqualsSearch);
        this.listGroupItemPresenter.enable(filterTerm);
        this.editingColumnEnabled = true;
        ((TestToolsView)this.view).enableEditorTab();
        if (!notEqualsSearch) {
            this.updateInstanceIsAssignedStatus(filterTerm);
        } else {
            ((TestToolsView)this.view).enableSearch();
        }
        if (propertyNameElements != null && !notEqualsSearch) {
            this.listGroupItemPresenter.selectProperty(filterTerm, propertyNameElements);
        }
    }

    @Override
    public void onDisableEditorTab() {
        this.onSearchedEvent("");
        this.listGroupItemPresenter.disable();
        this.editingColumnEnabled = false;
        ((TestToolsView)this.view).disableEditorTab();
        this.selectedFieldItemView = null;
        this.selectedListGroupItemView = null;
    }

    @Override
    public void setSelectedElement(ListGroupItemView selected) {
        this.selectedListGroupItemView = selected;
        this.selectedFieldItemView = null;
        if (this.filterTerm(selected.getFactName(), this.listGroupItemPresenter.getFilterTerm(), selected.isInstanceAssigned())) {
            ((TestToolsView)this.view).disableAddButton();
        } else {
            ((TestToolsView)this.view).enableAddButton();
        }
    }

    @Override
    public void setSelectedElement(FieldItemView selected) {
        this.selectedFieldItemView = selected;
        this.selectedListGroupItemView = null;
        String factName = this.selectedFieldItemView.getFullPath().get(0);
        boolean isFactNameAssigned = this.listGroupItemPresenter.isInstanceAssigned(factName);
        if (!this.selectedFieldItemView.isCheckShown() || this.filterTerm(factName, this.listGroupItemPresenter.getFilterTerm(), isFactNameAssigned)) {
            ((TestToolsView)this.view).disableAddButton();
        } else {
            ((TestToolsView)this.view).enableAddButton();
        }
    }

    @Override
    public void clearSelection() {
        if (this.selectedFieldItemView != null) {
            this.selectedFieldItemView.showCheck(false);
        } else if (this.selectedListGroupItemView != null) {
            this.selectedListGroupItemView.showCheck(false);
        }
        ((TestToolsView)this.view).disableAddButton();
    }

    @Override
    public void onModifyColumn() {
        if (this.editingColumnEnabled) {
            if (this.selectedListGroupItemView != null) {
                String className = this.selectedListGroupItemView.getActualClassName();
                this.getFactModelTreeFromMaps(className).ifPresent(factModelTree -> this.eventBus.fireEvent((GwtEvent)new SetPropertyHeaderEvent(this.gridWidget, factModelTree.getFullPackage(), factModelTree.getTypeName(), Collections.unmodifiableList(Arrays.asList(className)), factModelTree.getFullTypeName(), FactMappingValueType.EXPRESSION)));
            } else if (this.selectedFieldItemView != null) {
                String baseClass = this.selectedFieldItemView.getFullPath().get(0);
                ArrayList<String> propertyNameElements = new ArrayList<String>(this.selectedFieldItemView.getFullPath());
                if (!this.isSimple(baseClass)) {
                    propertyNameElements.add(this.selectedFieldItemView.getFieldName());
                }
                this.getFactModelTreeFromMaps(baseClass).ifPresent(factModelTree -> this.eventBus.fireEvent((GwtEvent)new SetPropertyHeaderEvent(this.gridWidget, factModelTree.getFullPackage(), factModelTree.getTypeName(), Collections.unmodifiableList(propertyNameElements), this.selectedFieldItemView.getClassName(), FactMappingValueType.NOT_EXPRESSION)));
            }
        }
    }

    @Override
    public void reset() {
        this.clearFieldsMaps();
        this.listGroupItemPresenter.reset();
        ((TestToolsView)this.view).reset();
    }

    protected void clearFieldsMaps() {
        this.dataObjectFieldsMap = new TreeMap<String, FactModelTree>();
        this.simpleJavaTypeFieldsMap = new TreeMap<String, FactModelTree>();
        this.instanceFieldsMap = new TreeMap<String, FactModelTree>();
        this.simpleJavaInstanceFieldsMap = new TreeMap<String, FactModelTree>();
        this.hiddenFieldsMap = new TreeMap<String, FactModelTree>();
    }

    @Override
    public void hideInstances() {
        this.clearInstanceList();
        this.clearSimpleJavaInstanceFieldList();
        this.showInstanceListContainerSeparator(false);
    }

    protected void updateInstanceIsAssignedStatus(String key) {
        if (key != null && !key.isEmpty()) {
            boolean assigned = this.dataObjectFieldsMap.keySet().contains(key) || this.simpleJavaTypeFieldsMap.keySet().contains(key) || this.instanceFieldsMap.keySet().contains(key) || this.simpleJavaInstanceFieldsMap.keySet().contains(key);
            this.listGroupItemPresenter.setInstanceAssigned(key, assigned);
        }
    }

    protected Optional<String> getFullPackage(String className) {
        return this.getFactModelTreeFromMaps(className).map(FactModelTree::getFullPackage);
    }

    protected Optional<FactModelTree> getFactModelTreeFromMaps(String key) {
        return Optional.ofNullable(this.getFactModelTreeFromFactTypeMap(key).orElseGet(() -> this.getFactModelTreeFromSimpleJavaTypeMap(key).orElseGet(() -> this.getFactModelTreeFromInstanceMap(key).orElseGet(() -> this.getFactModelTreeFromSimpleJavaInstanceMap(key).orElse(null)))));
    }

    protected boolean isSimple(String key) {
        return Optional.ofNullable(this.getFactModelTreeFromSimpleJavaTypeMap(key).orElseGet(() -> this.getFactModelTreeFromSimpleJavaInstanceMap(key).orElse(null))).isPresent();
    }

    protected void clearLists() {
        this.clearDataObjectList();
        this.clearSimpleJavaTypeList();
        this.clearInstanceList();
        this.clearSimpleJavaInstanceFieldList();
    }

    protected boolean filterTerm(String key, String search, boolean notEqualsSearch) {
        List<String> terms = Arrays.asList(search.split(";"));
        if (notEqualsSearch) {
            return !terms.contains(key);
        }
        return terms.contains(key);
    }
}

