/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.appformer.client.stateControl.registry.impl.DefaultRegistryImpl;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioCommandRegistryManager;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationUndoableCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AppendRowCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.command.client.CommandResult;
import org.kie.workbench.common.command.client.CommandResultBuilder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioCommandRegistryManagerTest
extends AbstractScenarioSimulationTest {
    private ScenarioCommandRegistryManager scenarioCommandRegistryManagerSpy;
    private DefaultRegistryImpl<AbstractScenarioSimulationUndoableCommand> doneCommandsRegistrySpy;
    private DefaultRegistryImpl<AbstractScenarioSimulationUndoableCommand> undoneCommandsRegistrySpy;
    @Mock
    private AbstractScenarioSimulationUndoableCommand abstractScenarioGridCommandMock;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.doneCommandsRegistrySpy = (DefaultRegistryImpl)Mockito.spy((Object)new DefaultRegistryImpl());
        this.undoneCommandsRegistrySpy = (DefaultRegistryImpl)Mockito.spy((Object)new DefaultRegistryImpl());
        this.scenarioCommandRegistryManagerSpy = (ScenarioCommandRegistryManager)Mockito.spy((Object)new ScenarioCommandRegistryManager(){
            {
                this.doneCommandsRegistry = ScenarioCommandRegistryManagerTest.this.doneCommandsRegistrySpy;
                this.undoneCommandsRegistry = ScenarioCommandRegistryManagerTest.this.undoneCommandsRegistrySpy;
            }
        });
    }

    @Test
    public void register() {
        this.undoneCommandsRegistrySpy.register((Object)this.abstractScenarioGridCommandMock);
        Assert.assertFalse((boolean)this.undoneCommandsRegistrySpy.isEmpty());
        this.scenarioCommandRegistryManagerSpy.register(this.scenarioSimulationContextLocal, this.abstractScenarioGridCommandMock);
        ((DefaultRegistryImpl)Mockito.verify(this.doneCommandsRegistrySpy, (VerificationMode)Mockito.times((int)1))).register(Matchers.eq((Object)this.abstractScenarioGridCommandMock));
        ((DefaultRegistryImpl)Mockito.verify(this.undoneCommandsRegistrySpy, (VerificationMode)Mockito.times((int)1))).clear();
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerSpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        Assert.assertTrue((boolean)this.undoneCommandsRegistrySpy.isEmpty());
    }

    @Test
    public void undoEmpty() {
        CommandResult retrieved = this.scenarioCommandRegistryManagerSpy.undo(this.scenarioSimulationContextLocal);
        Assert.assertEquals((Object)CommandResult.Type.WARNING, (Object)retrieved.getType());
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerSpy, (VerificationMode)Mockito.never())).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioSimulationUndoableCommand)Matchers.eq((Object)this.appendRowCommandMock), Matchers.eq((boolean)true));
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerSpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void undoNotEmptySameGrid() {
        this.doneCommandsRegistrySpy.register((Object)this.abstractScenarioGridCommandMock);
        ((ScenarioCommandRegistryManager)Mockito.doReturn((Object)CommandResultBuilder.SUCCESS).when((Object)this.scenarioCommandRegistryManagerSpy)).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.any(), (AbstractScenarioSimulationUndoableCommand)Matchers.any(), Matchers.anyBoolean());
        ((ScenarioCommandRegistryManager)Mockito.doReturn(Optional.empty()).when((Object)this.scenarioCommandRegistryManagerSpy)).commonUndoRedoPreexecution((ScenarioSimulationContext)Matchers.any(), (AbstractScenarioSimulationUndoableCommand)Matchers.any());
        CommandResult retrieved = this.scenarioCommandRegistryManagerSpy.undo(this.scenarioSimulationContextLocal);
        Assert.assertEquals((Object)CommandResult.Type.INFO, (Object)retrieved.getType());
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerSpy, (VerificationMode)Mockito.times((int)1))).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioSimulationUndoableCommand)Matchers.eq((Object)this.abstractScenarioGridCommandMock), Matchers.eq((boolean)true));
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerSpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void undoNotEmptyDifferentGrid() {
        this.doneCommandsRegistrySpy.register((Object)this.appendRowCommandMock);
        ((AppendRowCommand)Mockito.doReturn(Optional.of(CommandResultBuilder.SUCCESS)).when((Object)this.appendRowCommandMock)).commonUndoRedoPreExecution((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        Assert.assertFalse((boolean)this.doneCommandsRegistrySpy.isEmpty());
        this.scenarioCommandRegistryManagerSpy.undo(this.scenarioSimulationContextLocal);
        Assert.assertTrue((boolean)this.doneCommandsRegistrySpy.isEmpty());
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerSpy, (VerificationMode)Mockito.times((int)1))).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioSimulationUndoableCommand)Matchers.eq((Object)this.appendRowCommandMock), Matchers.eq((boolean)true));
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerSpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void redoEmpty() {
        this.scenarioCommandRegistryManagerSpy.redo(this.scenarioSimulationContextLocal);
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerSpy, (VerificationMode)Mockito.never())).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioSimulationUndoableCommand)Matchers.eq((Object)this.appendRowCommandMock), Matchers.eq((boolean)true));
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerSpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void redoNotEmptySameGrid() {
        this.undoneCommandsRegistrySpy.register((Object)this.abstractScenarioGridCommandMock);
        ((ScenarioCommandRegistryManager)Mockito.doReturn((Object)CommandResultBuilder.SUCCESS).when((Object)this.scenarioCommandRegistryManagerSpy)).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.any(), (AbstractScenarioSimulationUndoableCommand)Matchers.any(), Matchers.anyBoolean());
        ((ScenarioCommandRegistryManager)Mockito.doReturn(Optional.empty()).when((Object)this.scenarioCommandRegistryManagerSpy)).commonUndoRedoPreexecution((ScenarioSimulationContext)Matchers.any(), (AbstractScenarioSimulationUndoableCommand)Matchers.any());
        CommandResult retrieved = this.scenarioCommandRegistryManagerSpy.redo(this.scenarioSimulationContextLocal);
        Assert.assertEquals((Object)CommandResult.Type.INFO, (Object)retrieved.getType());
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerSpy, (VerificationMode)Mockito.never())).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioSimulationUndoableCommand)Matchers.eq((Object)this.abstractScenarioGridCommandMock), Matchers.eq((boolean)true));
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerSpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void redoNotEmptyDifferentGrid() {
        this.undoneCommandsRegistrySpy.register((Object)this.appendRowCommandMock);
        ((AppendRowCommand)Mockito.doReturn(Optional.of(CommandResultBuilder.SUCCESS)).when((Object)this.appendRowCommandMock)).commonUndoRedoPreExecution((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        Assert.assertFalse((boolean)this.undoneCommandsRegistrySpy.isEmpty());
        this.scenarioCommandRegistryManagerSpy.redo(this.scenarioSimulationContextLocal);
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerSpy, (VerificationMode)Mockito.times((int)1))).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioSimulationUndoableCommand)Matchers.eq((Object)this.appendRowCommandMock), Matchers.eq((boolean)false));
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerSpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        Assert.assertTrue((boolean)this.undoneCommandsRegistrySpy.isEmpty());
    }

    @Test
    public void setUndoRedoButtonStatus() {
        this.scenarioCommandRegistryManagerSpy.setUndoRedoButtonStatus(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setUndoButtonEnabledStatus(Matchers.eq((boolean)false));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setRedoButtonEnabledStatus(Matchers.eq((boolean)false));
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.scenarioSimulationEditorPresenterMock});
        this.doneCommandsRegistrySpy.register((Object)this.appendRowCommandMock);
        this.scenarioCommandRegistryManagerSpy.setUndoRedoButtonStatus(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setUndoButtonEnabledStatus(Matchers.eq((boolean)true));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setRedoButtonEnabledStatus(Matchers.eq((boolean)false));
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.scenarioSimulationEditorPresenterMock});
        this.undoneCommandsRegistrySpy.register((Object)this.appendRowCommandMock);
        this.scenarioCommandRegistryManagerSpy.setUndoRedoButtonStatus(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setUndoButtonEnabledStatus(Matchers.eq((boolean)true));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setRedoButtonEnabledStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void commonOperationUndo() {
        this.scenarioCommandRegistryManagerSpy.commonUndoRedoOperation(this.scenarioSimulationContextLocal, (AbstractScenarioSimulationUndoableCommand)this.appendRowCommandMock, true);
        ((AppendRowCommand)Mockito.verify((Object)this.appendRowCommandMock, (VerificationMode)Mockito.times((int)1))).undo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        ((AppendRowCommand)Mockito.verify((Object)this.appendRowCommandMock, (VerificationMode)Mockito.never())).redo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void commonOperationRedo() {
        this.scenarioCommandRegistryManagerSpy.commonUndoRedoOperation(this.scenarioSimulationContextLocal, (AbstractScenarioSimulationUndoableCommand)this.appendRowCommandMock, false);
        ((AppendRowCommand)Mockito.verify((Object)this.appendRowCommandMock, (VerificationMode)Mockito.times((int)1))).redo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        ((AppendRowCommand)Mockito.verify((Object)this.appendRowCommandMock, (VerificationMode)Mockito.never())).undo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }
}

