/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.LIElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.SimpleClassEntry;
import org.drools.workbench.screens.scenariosimulation.client.utils.ViewsProvider;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.junit.Before;
import org.mockito.Mock;

abstract class AbstractTestToolsTest {
    @Mock
    protected LIElement lIElementMock;
    @Mock
    protected ViewsProvider viewsProviderMock;
    protected SortedMap<String, FactModelTree> dataObjectFactTreeMap;
    protected SortedMap<String, FactModelTree> simpleJavaTypeTreeMap;
    protected SortedMap<String, FactModelTree> instanceFactTreeMap;
    protected SortedMap<String, FactModelTree> simpleJavaInstanceFactTreeMap;
    protected FactModelTree FACT_MODEL_TREE;
    protected String localFactName;

    AbstractTestToolsTest() {
    }

    @Before
    public void setup() {
        this.dataObjectFactTreeMap = this.getDataObjectFactTreeMap();
        this.simpleJavaTypeTreeMap = this.getSimpleJavaTypeFieldsMap();
        this.instanceFactTreeMap = new TreeMap<String, FactModelTree>();
        this.dataObjectFactTreeMap.keySet().forEach(key -> {
            FactModelTree cfr_ignored_0 = (FactModelTree)this.instanceFactTreeMap.put(this.getRandomString(), (FactModelTree)this.dataObjectFactTreeMap.get(key));
        });
        this.simpleJavaInstanceFactTreeMap = new TreeMap<String, FactModelTree>();
        this.localFactName = new ArrayList<String>(this.dataObjectFactTreeMap.keySet()).get(0);
        this.FACT_MODEL_TREE = (FactModelTree)this.dataObjectFactTreeMap.get(this.localFactName);
    }

    protected String getRandomFactModelTree(Map<String, FactModelTree> source, int position) {
        return new ArrayList<String>(source.keySet()).get(position);
    }

    protected SortedMap<String, FactModelTree> getDataObjectFactTreeMap() {
        TreeMap<String, FactModelTree> toReturn = new TreeMap<String, FactModelTree>();
        IntStream.range(0, 3).forEach(id -> {
            String key = this.getRandomString();
            FactModelTree value = new FactModelTree(key, "test.scesim.package", this.getMockSimpleProperties(), new HashMap());
            toReturn.put(key, value);
            if (id == 1) {
                value.addSimpleProperty(this.getRandomString(), this.getRandomType());
            }
            if (id == 2) {
                value.addSimpleProperty(this.getRandomString(), this.getRandomType());
                value.addSimpleProperty(this.getRandomString(), this.getRandomType());
            }
        });
        return toReturn;
    }

    protected SortedMap<String, FactModelTree> getSimpleJavaTypeFieldsMap() {
        TreeMap<String, FactModelTree> toReturn = new TreeMap<String, FactModelTree>();
        for (String key : DataManagementStrategy.SIMPLE_CLASSES_MAP.keySet()) {
            HashMap<String, FactModelTree.PropertyTypeName> simpleProperties = new HashMap<String, FactModelTree.PropertyTypeName>();
            FactModelTree.PropertyTypeName fullName = new FactModelTree.PropertyTypeName(((SimpleClassEntry)DataManagementStrategy.SIMPLE_CLASSES_MAP.get(key)).getCanonicalName());
            simpleProperties.put("value", fullName);
            String packageName = fullName.getTypeName().substring(0, fullName.getTypeName().lastIndexOf("."));
            FactModelTree value = new FactModelTree(key, packageName, simpleProperties, new HashMap());
            toReturn.put(key, value);
        }
        return toReturn;
    }

    protected Map<String, FactModelTree.PropertyTypeName> getMockSimpleProperties() {
        HashMap<String, FactModelTree.PropertyTypeName> toReturn = new HashMap<String, FactModelTree.PropertyTypeName>();
        IntStream.range(0, 3).forEach(id -> toReturn.put(this.getRandomString(), this.getRandomType()));
        return toReturn;
    }

    protected String getRandomString() {
        String letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuilder builder = new StringBuilder();
        int numberOfLetters = letters.length();
        Random random = new Random();
        int sizeOfRandomString = random.nextInt(6) + 3;
        IntStream.range(0, sizeOfRandomString).forEach(position -> builder.append(letters.charAt(random.nextInt(numberOfLetters))));
        return builder.toString();
    }

    protected FactModelTree.PropertyTypeName getRandomType() {
        int type = new Random().nextInt(4);
        switch (type) {
            case 0: {
                return new FactModelTree.PropertyTypeName("lava.lang.String");
            }
            case 1: {
                return new FactModelTree.PropertyTypeName("byte");
            }
            case 2: {
                return new FactModelTree.PropertyTypeName("java.lang.Integer");
            }
            case 3: {
                return new FactModelTree.PropertyTypeName("java.lang.Boolean");
            }
        }
        return new FactModelTree.PropertyTypeName("int");
    }
}

