/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.widgets;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValueType;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.factories.CollectionEditorSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioExpressionCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridWidgetMouseEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.menu.ScenarioContextMenuRegistry;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.AbstractScesimGridModel;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.renderers.ScenarioGridRenderer;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationBuilders;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridRow;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.DefaultGridWidgetCellSelectorMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.SelectionExtension;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioGridTest {
    @Mock
    private ScenarioGridModel scenarioGridModelMock;
    @Mock
    private ScenarioGridLayer scenarioGridLayerMock;
    @Mock
    private ScenarioGridRenderer scenarioGridRendererMock;
    @Mock
    private ScenarioSimulationBuilders.HeaderBuilder headerBuilderMock;
    @Mock
    private ScenarioGridColumn scenarioGridColumnMock;
    @Mock
    private ScenarioHeaderMetaData propertyHeaderMetadataMock;
    @Mock
    private EventBus eventBusMock;
    @Mock
    private BaseGridRendererHelper rendererHelperMock;
    @Mock
    private BaseGridRendererHelper.RenderingInformation renderingInformationMock;
    @Mock
    private BaseGridRendererHelper.ColumnInformation columnInformationMock;
    @Mock
    private BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformationMock;
    @Mock
    private Viewport viewportMock;
    @Mock
    private ScenarioContextMenuRegistry scenarioContextMenuRegistryMock;
    @Mock
    private ScenarioExpressionCellTextAreaSingletonDOMElementFactory expressionCellTextAreaSingletonDOMElementFactoryMock;
    @Mock
    private CollectionEditorSingletonDOMElementFactory collectionEditorSingletonDOMElementFactory;
    private FactMapping factMappingDescription;
    private FactMapping factMappingGiven;
    private FactMapping factMappingInteger;
    private FactIdentifier factIdentifierGiven;
    private FactIdentifier factIdentifierInteger;
    private Simulation simulation;
    private ScenarioGrid scenarioGridSpy;

    @Before
    public void setup() {
        this.simulation = this.getSimulation();
        Mockito.when((Object)this.scenarioGridColumnMock.getPropertyHeaderMetaData()).thenReturn((Object)this.propertyHeaderMetadataMock);
        Mockito.when((Object)this.scenarioGridModelMock.getAbstractScesimModel()).thenReturn(Optional.of(this.simulation));
        Mockito.when((Object)this.scenarioGridModelMock.getGridWidget()).thenReturn((Object)GridWidget.SIMULATION);
        Mockito.when((Object)this.scenarioGridModelMock.getScenarioExpressionCellTextAreaSingletonDOMElementFactory()).thenReturn((Object)this.expressionCellTextAreaSingletonDOMElementFactoryMock);
        Mockito.when((Object)this.scenarioGridModelMock.getCollectionEditorSingletonDOMElementFactory()).thenReturn((Object)this.collectionEditorSingletonDOMElementFactory);
        this.factIdentifierGiven = FactIdentifier.create((String)"GIVEN", (String)"GIVEN");
        this.factIdentifierInteger = FactIdentifier.create((String)"Integer", (String)"java.lang.Integer");
        this.factMappingDescription = new FactMapping("EXPRESSION_ALIAS_DESCRIPTION", FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        this.factMappingGiven = new FactMapping("EXPRESSION_ALIAS_GIVEN", this.factIdentifierGiven, new ExpressionIdentifier("GIVEN", FactMappingType.GIVEN));
        this.factMappingInteger = new FactMapping("EXPRESSION_ALIAS_INTEGER", this.factIdentifierInteger, new ExpressionIdentifier("GIVEN", FactMappingType.GIVEN));
        this.scenarioGridSpy = (ScenarioGrid)Mockito.spy((Object)new ScenarioGrid((AbstractScesimGridModel)this.scenarioGridModelMock, this.scenarioGridLayerMock, this.scenarioGridRendererMock, this.scenarioContextMenuRegistryMock){

            protected <T extends AbstractScesimData> void appendRow(int rowIndex, T scesimData) {
            }

            protected ScenarioSimulationBuilders.HeaderBuilder getHeaderBuilderLocal(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType) {
                return ScenarioGridTest.this.headerBuilderMock;
            }

            protected ScenarioGridColumn getScenarioGridColumnLocal(ScenarioSimulationBuilders.HeaderBuilder headerBuilder, String placeHolder) {
                return ScenarioGridTest.this.scenarioGridColumnMock;
            }

            protected BaseGridRendererHelper getBaseGridRendererHelper() {
                return ScenarioGridTest.this.rendererHelperMock;
            }

            public Viewport getViewport() {
                return ScenarioGridTest.this.viewportMock;
            }

            protected ScenarioHeaderMetaData getColumnScenarioHeaderMetaData(ScenarioGridColumn scenarioGridColumn, int rowIndex) {
                return ScenarioGridTest.this.propertyHeaderMetadataMock;
            }

            protected EnableTestToolsEvent getEnableTestToolsEvent(ScenarioGrid scenarioGrid, ScenarioGridColumn scenarioGridColumn, ScenarioHeaderMetaData scenarioHeaderMetaData, int uiColumnIndex, String group) {
                return new EnableTestToolsEvent();
            }

            public Layer getLayer() {
                return ScenarioGridTest.this.scenarioGridLayerMock;
            }
        });
        Mockito.when((Object)this.rendererHelperMock.getRenderingInformation()).thenReturn((Object)this.renderingInformationMock);
        Mockito.when((Object)this.renderingInformationMock.getHeaderRowsHeight()).thenReturn((Object)100.0);
        Mockito.when((Object)this.renderingInformationMock.getFloatingBlockInformation()).thenReturn((Object)this.floatingBlockInformationMock);
        Mockito.when((Object)this.propertyHeaderMetadataMock.getColumnGroup()).thenReturn((Object)"GIVEN");
        this.scenarioGridSpy.setEventBus(this.eventBusMock);
    }

    @Test
    public void testDefaultNodeMouseClickHandlers() {
        List handlers = this.scenarioGridSpy.getNodeMouseClickEventHandlers((GridSelectionManager)this.scenarioGridLayerMock);
        Assert.assertEquals((long)1L, (long)handlers.size());
        Assert.assertTrue((boolean)(handlers.get(0) instanceof DefaultGridWidgetCellSelectorMouseEventHandler));
    }

    @Test
    public void testDefaultNodeMouseDoubleClickHandlers() {
        List handlers = this.scenarioGridSpy.getNodeMouseDoubleClickEventHandlers((GridSelectionManager)this.scenarioGridLayerMock, (GridPinnedModeManager)this.scenarioGridLayerMock);
        Assert.assertEquals((long)1L, (long)handlers.size());
        Assert.assertTrue((boolean)(handlers.get(0) instanceof ScenarioSimulationGridWidgetMouseEventHandler));
    }

    @Test
    public void setContent() {
        InOrder callsOrder = Mockito.inOrder((Object[])new Object[]{this.scenarioGridModelMock, this.scenarioGridSpy});
        this.scenarioGridSpy.setContent((AbstractScesimModel)this.simulation, ScenarioSimulationModel.Type.RULE);
        ((ScenarioGridModel)callsOrder.verify((Object)this.scenarioGridModelMock, Mockito.times((int)1))).clear();
        ((ScenarioGridModel)callsOrder.verify((Object)this.scenarioGridModelMock, Mockito.times((int)1))).bindContent((AbstractScesimModel)ArgumentMatchers.eq((Object)this.simulation));
        ((ScenarioGrid)callsOrder.verify((Object)this.scenarioGridSpy, Mockito.times((int)1))).setHeaderColumns((AbstractScesimModel)ArgumentMatchers.eq((Object)this.simulation), (ScenarioSimulationModel.Type)ArgumentMatchers.eq((Object)ScenarioSimulationModel.Type.RULE));
        ((ScenarioGrid)callsOrder.verify((Object)this.scenarioGridSpy, Mockito.times((int)1))).appendRows((AbstractScesimModel)ArgumentMatchers.eq((Object)this.simulation));
        ((ScenarioGridModel)callsOrder.verify((Object)this.scenarioGridModelMock, Mockito.times((int)1))).loadFactMappingsWidth();
        ((ScenarioGridModel)callsOrder.verify((Object)this.scenarioGridModelMock, Mockito.times((int)1))).forceRefreshWidth();
    }

    @Test
    public void getGridWidget() {
        GridWidget retrieved = this.scenarioGridSpy.getGridWidget();
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)GridWidget.SIMULATION, (Object)retrieved);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.scenarioGridSpy.getModel(), (VerificationMode)Mockito.times((int)1))).getGridWidget();
    }

    @Test
    public void clearSelections() {
        this.scenarioGridSpy.clearSelections();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).clearSelections();
        ((ScenarioGridLayer)Mockito.verify((Object)this.scenarioGridLayerMock, (VerificationMode)Mockito.times((int)1))).batch();
    }

    @Test
    public void setSelectedColumn() {
        int columnIndex = 1;
        this.scenarioGridSpy.setSelectedColumn(columnIndex);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).selectColumn(ArgumentMatchers.eq((int)columnIndex));
    }

    @Test
    public void setSelectedColumnAndHeader() {
        int headerRowIndex = 1;
        int columnIndex = 1;
        this.scenarioGridSpy.setSelectedColumnAndHeader(headerRowIndex, columnIndex);
        InOrder callsOrder = Mockito.inOrder((Object[])new Object[]{this.scenarioGridSpy, this.scenarioGridLayerMock});
        ((ScenarioGrid)callsOrder.verify((Object)this.scenarioGridSpy, Mockito.times((int)1))).selectHeaderCell(ArgumentMatchers.eq((int)headerRowIndex), ArgumentMatchers.eq((int)columnIndex), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false));
        ((ScenarioGrid)callsOrder.verify((Object)this.scenarioGridSpy, Mockito.times((int)1))).setSelectedColumn(ArgumentMatchers.eq((int)columnIndex));
        ((ScenarioGridLayer)callsOrder.verify((Object)this.scenarioGridLayerMock, Mockito.times((int)1))).batch();
    }

    @Test
    public void setSelectedCell() {
        int rowIndex = 1;
        int columnIndex = 1;
        this.scenarioGridSpy.setSelectedCell(rowIndex, columnIndex);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)1))).selectCell(ArgumentMatchers.eq((int)rowIndex), ArgumentMatchers.eq((int)columnIndex), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false));
        ((ScenarioGridLayer)Mockito.verify((Object)this.scenarioGridLayerMock, (VerificationMode)Mockito.times((int)1))).batch();
    }

    @Test
    public void setHeaderColumns() {
        this.scenarioGridSpy.setHeaderColumns((AbstractScesimModel)this.simulation, ScenarioSimulationModel.Type.RULE);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)6))).setHeaderColumn(ArgumentMatchers.anyInt(), (FactMapping)ArgumentMatchers.isA(FactMapping.class), ArgumentMatchers.eq((boolean)true));
        this.scenarioGridSpy.setHeaderColumns((AbstractScesimModel)this.simulation, ScenarioSimulationModel.Type.DMN);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)6))).setHeaderColumn(ArgumentMatchers.anyInt(), (FactMapping)ArgumentMatchers.isA(FactMapping.class), ArgumentMatchers.eq((boolean)false));
        Background background = new Background();
        this.scenarioGridSpy.setHeaderColumns((AbstractScesimModel)background, ScenarioSimulationModel.Type.RULE);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)6))).setHeaderColumn(ArgumentMatchers.anyInt(), (FactMapping)ArgumentMatchers.isA(FactMapping.class), ArgumentMatchers.eq((boolean)false));
        this.scenarioGridSpy.setHeaderColumns((AbstractScesimModel)background, ScenarioSimulationModel.Type.DMN);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)6))).setHeaderColumn(ArgumentMatchers.anyInt(), (FactMapping)ArgumentMatchers.isA(FactMapping.class), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void setHeaderColumn() {
        String columnId = this.factMappingDescription.getExpressionIdentifier().getName();
        FactMappingType type = this.factMappingDescription.getExpressionIdentifier().getType();
        String columnGroup = type.name();
        this.scenarioGridSpy.setType(ScenarioSimulationModel.Type.RULE);
        this.scenarioGridSpy.setHeaderColumn(1, this.factMappingDescription, true);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)1))).isPropertyAssigned(ArgumentMatchers.eq((boolean)true), (FactMapping)ArgumentMatchers.eq((Object)this.factMappingDescription));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)1))).getPlaceHolder(ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true), (FactMappingValueType)ArgumentMatchers.isA(FactMappingValueType.class), ArgumentMatchers.anyString());
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)1))).getScenarioGridColumnLocal((String)ArgumentMatchers.eq((Object)"EXPRESSION_ALIAS_DESCRIPTION"), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)columnId), (String)ArgumentMatchers.eq((Object)columnGroup), (FactMappingType)ArgumentMatchers.eq((Object)type), ArgumentMatchers.anyString());
        ((ScenarioGridColumn)Mockito.verify((Object)this.scenarioGridColumnMock, (VerificationMode)Mockito.times((int)1))).setColumnWidthMode(GridColumn.ColumnWidthMode.FIXED);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).getDOMElementFactory(ArgumentMatchers.anyString(), (ScenarioSimulationModel.Type)ArgumentMatchers.eq((Object)ScenarioSimulationModel.Type.RULE), (FactMappingValueType)ArgumentMatchers.eq((Object)FactMappingValueType.NOT_EXPRESSION));
        Mockito.reset((Object[])new ScenarioGrid[]{this.scenarioGridSpy});
        Mockito.reset((Object[])new ScenarioGridColumn[]{this.scenarioGridColumnMock});
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModelMock});
        columnId = this.factMappingGiven.getExpressionIdentifier().getName();
        type = this.factMappingGiven.getExpressionIdentifier().getType();
        columnGroup = type.name();
        this.scenarioGridSpy.setHeaderColumn(1, this.factMappingGiven, true);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)1))).isPropertyAssigned(ArgumentMatchers.eq((boolean)true), (FactMapping)ArgumentMatchers.eq((Object)this.factMappingGiven));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)1))).getPlaceHolder(ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)false), (FactMappingValueType)ArgumentMatchers.eq((Object)FactMappingValueType.NOT_EXPRESSION), ArgumentMatchers.anyString());
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)1))).getScenarioGridColumnLocal((String)ArgumentMatchers.eq((Object)"EXPRESSION_ALIAS_GIVEN"), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)columnId), (String)ArgumentMatchers.eq((Object)columnGroup), (FactMappingType)ArgumentMatchers.eq((Object)type), ArgumentMatchers.anyString());
        ((ScenarioGridColumn)Mockito.verify((Object)this.scenarioGridColumnMock, (VerificationMode)Mockito.never())).setColumnWidthMode((GridColumn.ColumnWidthMode)ArgumentMatchers.any());
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.never())).getDOMElementFactory((String)ArgumentMatchers.any(), (ScenarioSimulationModel.Type)ArgumentMatchers.any(), (FactMappingValueType)ArgumentMatchers.any());
    }

    @Test
    public void getScenarioGridColumnLocal() {
        String columnId = this.factMappingDescription.getExpressionIdentifier().getName();
        String instanceTitle = this.factMappingDescription.getFactIdentifier().getName();
        String propertyTitle = "PROPERTY TITLE";
        FactMappingType type = this.factMappingDescription.getExpressionIdentifier().getType();
        String columnGroup = type.name();
        this.scenarioGridSpy.getScenarioGridColumnLocal(instanceTitle, propertyTitle, columnId, columnGroup, type, ScenarioSimulationEditorConstants.INSTANCE.insertValue());
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)1))).getHeaderBuilderLocal((String)ArgumentMatchers.eq((Object)instanceTitle), (String)ArgumentMatchers.eq((Object)propertyTitle), (String)ArgumentMatchers.eq((Object)columnId), (String)ArgumentMatchers.eq((Object)columnGroup), (FactMappingType)ArgumentMatchers.eq((Object)type));
    }

    @Test
    public void isInstanceAssigned() {
        Assert.assertTrue((boolean)this.scenarioGridSpy.isInstanceAssigned(FactIdentifier.DESCRIPTION));
        Assert.assertFalse((boolean)this.scenarioGridSpy.isInstanceAssigned(FactIdentifier.INDEX));
        Assert.assertFalse((boolean)this.scenarioGridSpy.isInstanceAssigned(FactIdentifier.EMPTY));
        Assert.assertTrue((boolean)this.scenarioGridSpy.isInstanceAssigned(this.factIdentifierGiven));
    }

    @Test
    public void isPropertyAssigned() {
        this.factMappingDescription.getExpressionElements().clear();
        Assert.assertTrue((boolean)this.scenarioGridSpy.isPropertyAssigned(false, this.factMappingDescription));
        Assert.assertTrue((boolean)this.scenarioGridSpy.isPropertyAssigned(true, this.factMappingDescription));
        this.factMappingDescription.getExpressionElements().add(new ExpressionElement("test"));
        Assert.assertTrue((boolean)this.scenarioGridSpy.isPropertyAssigned(false, this.factMappingDescription));
        Assert.assertTrue((boolean)this.scenarioGridSpy.isPropertyAssigned(true, this.factMappingDescription));
        this.factMappingGiven.getExpressionElements().clear();
        Assert.assertFalse((boolean)this.scenarioGridSpy.isPropertyAssigned(false, this.factMappingGiven));
        Assert.assertFalse((boolean)this.scenarioGridSpy.isPropertyAssigned(true, this.factMappingGiven));
        this.factMappingGiven.getExpressionElements().add(new ExpressionElement("test"));
        Assert.assertFalse((boolean)this.scenarioGridSpy.isPropertyAssigned(false, this.factMappingGiven));
        Assert.assertTrue((boolean)this.scenarioGridSpy.isPropertyAssigned(true, this.factMappingGiven));
        this.factMappingInteger.getExpressionElements().clear();
        Assert.assertFalse((boolean)this.scenarioGridSpy.isPropertyAssigned(false, this.factMappingInteger));
        Assert.assertTrue((boolean)this.scenarioGridSpy.isPropertyAssigned(true, this.factMappingInteger));
    }

    @Test
    public void appendRows() {
        this.scenarioGridSpy.appendRows((AbstractScesimModel)this.simulation);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)1))).appendRow(ArgumentMatchers.anyInt(), (AbstractScesimData)ArgumentMatchers.isA(Scenario.class));
    }

    @Test
    public void testAdjustSelection() {
        boolean uiColumnIndex = false;
        boolean uiRowIndex = false;
        ScenarioGridColumn columnMock = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Collections.singletonList(columnMock));
        GridData.SelectedCell selectedHeaderCell = (GridData.SelectedCell)Mockito.mock(GridData.SelectedCell.class);
        Mockito.when((Object)selectedHeaderCell.getColumnIndex()).thenReturn((Object)0);
        Mockito.when((Object)selectedHeaderCell.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Collections.singletonList(selectedHeaderCell));
        this.scenarioGridSpy.adjustSelection((SelectionExtension)Mockito.mock(SelectionExtension.class), false);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy)).signalTestTools();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy)).setSelectedColumn(ArgumentMatchers.eq((int)0));
        ((EventBus)Mockito.verify((Object)this.eventBusMock)).fireEvent((GwtEvent)ArgumentMatchers.any());
        ((ScenarioContextMenuRegistry)Mockito.verify((Object)this.scenarioContextMenuRegistryMock, (VerificationMode)Mockito.times((int)1))).hideMenus();
        ((ScenarioContextMenuRegistry)Mockito.verify((Object)this.scenarioContextMenuRegistryMock, (VerificationMode)Mockito.times((int)1))).hideErrorReportPopover();
    }

    @Test
    public void testShowContextMenuDescription() {
        boolean uiColumnIndex = false;
        boolean uiRowIndex = false;
        double columnWidth = 100.0;
        GridColumn columnMock = (GridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)columnMock.getWidth()).thenReturn((Object)100.0);
        Mockito.when((Object)((ScenarioGridColumn)columnMock).getFactIdentifier()).thenReturn((Object)FactIdentifier.DESCRIPTION);
        Mockito.when((Object)columnMock.getHeaderMetaData()).thenReturn(Collections.singletonList(Mockito.mock(GridColumn.HeaderMetaData.class)));
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Collections.singletonList(columnMock));
        double rowHeight = 40.0;
        GridRow gridRow = (GridRow)Mockito.mock(ScenarioGridRow.class);
        Mockito.when((Object)gridRow.getHeight()).thenReturn((Object)40.0);
        Mockito.when((Object)this.scenarioGridModelMock.getRow(0)).thenReturn((Object)gridRow);
        Mockito.when((Object)this.rendererHelperMock.getColumnInformation(50.0)).thenReturn((Object)this.columnInformationMock);
        Mockito.when((Object)this.columnInformationMock.getColumn()).thenReturn((Object)columnMock);
    }

    @Test
    public void testShowContextMenuGivenOrExpect() {
        String columnGroup = "grp";
        ScenarioHeaderMetaData scenarioHeaderMetaDataMock = (ScenarioHeaderMetaData)Mockito.mock(ScenarioHeaderMetaData.class);
        Mockito.when((Object)scenarioHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)"grp");
        boolean uiColumnIndex = false;
        boolean uiRowIndex = false;
        double columnWidth = 100.0;
        GridColumn columnMock = (GridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)columnMock.getWidth()).thenReturn((Object)100.0);
        Mockito.when((Object)((ScenarioGridColumn)columnMock).getFactIdentifier()).thenReturn((Object)FactIdentifier.EMPTY);
        Mockito.when((Object)columnMock.getHeaderMetaData()).thenReturn(Collections.singletonList(scenarioHeaderMetaDataMock));
        Mockito.when((Object)((ScenarioGridColumn)columnMock).getInformationHeaderMetaData()).thenReturn((Object)scenarioHeaderMetaDataMock);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Collections.singletonList(columnMock));
        double rowHeight = 40.0;
        GridRow gridRow = (GridRow)Mockito.mock(ScenarioGridRow.class);
        Mockito.when((Object)gridRow.getHeight()).thenReturn((Object)40.0);
        Mockito.when((Object)this.scenarioGridModelMock.getRow(0)).thenReturn((Object)gridRow);
        Mockito.when((Object)this.rendererHelperMock.getColumnInformation(50.0)).thenReturn((Object)this.columnInformationMock);
        Mockito.when((Object)this.columnInformationMock.getColumn()).thenReturn((Object)columnMock);
    }

    private Simulation getSimulation() {
        Simulation toReturn = new Simulation();
        ScesimModelDescriptor simulationDescriptor = toReturn.getScesimModelDescriptor();
        simulationDescriptor.addFactMapping(FactIdentifier.INDEX.getName(), FactIdentifier.INDEX, ExpressionIdentifier.INDEX);
        simulationDescriptor.addFactMapping(FactIdentifier.DESCRIPTION.getName(), FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        Scenario scenario = (Scenario)toReturn.addData();
        int row = toReturn.getUnmodifiableData().indexOf(scenario);
        scenario.setDescription(null);
        IntStream.range(2, 4).forEach(id -> {
            ExpressionIdentifier givenExpression = ExpressionIdentifier.create((String)(row + "|" + id), (FactMappingType)FactMappingType.GIVEN);
            simulationDescriptor.addFactMapping(FactMapping.getInstancePlaceHolder((int)id), FactIdentifier.EMPTY, givenExpression);
            scenario.addMappingValue(FactIdentifier.EMPTY, givenExpression, null);
        });
        IntStream.range(2, 4).forEach(id -> {
            ExpressionIdentifier expectedExpression = ExpressionIdentifier.create((String)(row + "|" + (id += 2)), (FactMappingType)FactMappingType.EXPECT);
            simulationDescriptor.addFactMapping(FactMapping.getInstancePlaceHolder((int)id), FactIdentifier.EMPTY, expectedExpression);
            scenario.addMappingValue(FactIdentifier.EMPTY, expectedExpression, null);
        });
        return toReturn;
    }

    @Test
    public void signalTestToolsHeaderCellSelected() {
        boolean uiColumnIndex = false;
        boolean uiRowIndex = false;
        ScenarioGridColumn columnMock = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Collections.singletonList(columnMock));
        GridData.SelectedCell selectedHeaderCell = (GridData.SelectedCell)Mockito.mock(GridData.SelectedCell.class);
        Mockito.when((Object)selectedHeaderCell.getColumnIndex()).thenReturn((Object)0);
        Mockito.when((Object)selectedHeaderCell.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Collections.singletonList(selectedHeaderCell));
        this.scenarioGridSpy.signalTestToolsHeaderCellSelected(columnMock, selectedHeaderCell, 0);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)ArgumentMatchers.isA(EnableTestToolsEvent.class));
    }

    @Test
    public void signalTestToolsHeaderCellSelected_EmptyInstance() {
        boolean uiColumnIndex = false;
        boolean uiRowIndex = false;
        ScenarioGridColumn columnMock = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Collections.singletonList(columnMock));
        Mockito.when((Object)columnMock.isInstanceAssigned()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyHeaderMetadataMock.getMetadataType()).thenReturn((Object)ScenarioHeaderMetaData.MetadataType.INSTANCE);
        GridData.SelectedCell selectedHeaderCell = (GridData.SelectedCell)Mockito.mock(GridData.SelectedCell.class);
        Mockito.when((Object)selectedHeaderCell.getColumnIndex()).thenReturn((Object)0);
        Mockito.when((Object)selectedHeaderCell.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Collections.singletonList(selectedHeaderCell));
        this.scenarioGridSpy.signalTestToolsHeaderCellSelected(columnMock, selectedHeaderCell, 0);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)ArgumentMatchers.isA(ReloadTestToolsEvent.class));
    }

    @Test
    public void ensureCellIsSelected_EmptyGrid() {
        Mockito.when((Object)this.scenarioGridModelMock.getColumnCount()).thenReturn((Object)0);
        this.scenarioGridSpy.ensureCellIsSelected();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.never())).selectCell(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.never())).signalTestTools();
    }

    @Test
    public void reselectCurrentHeaderCell() {
        ScenarioGridColumn columnMock = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Collections.singletonList(columnMock));
        ArrayList<GridData.SelectedCell> selectedHeaderCells = new ArrayList<GridData.SelectedCell>();
        selectedHeaderCells.add(new GridData.SelectedCell(0, 0));
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(selectedHeaderCells);
        this.scenarioGridSpy.selectCurrentHeaderCellGroup();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)1))).setSelectedColumnAndHeader(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)0));
    }

    @Test
    public void reselectCurrentHeaderCellMultipleColumns() {
        ScenarioGridColumn columnMock = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock.getIndex()).thenReturn((Object)0);
        ScenarioGridColumn columnMock2 = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock2.getIndex()).thenReturn((Object)1);
        ScenarioGridColumn columnMock3 = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock3.getIndex()).thenReturn((Object)2);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Arrays.asList(columnMock, columnMock2, columnMock3));
        ArrayList<GridData.SelectedCell> selectedHeaderCells = new ArrayList<GridData.SelectedCell>();
        selectedHeaderCells.add(new GridData.SelectedCell(0, 0));
        selectedHeaderCells.add(new GridData.SelectedCell(0, 1));
        selectedHeaderCells.add(new GridData.SelectedCell(0, 2));
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(selectedHeaderCells);
        this.scenarioGridSpy.selectCurrentHeaderCellGroup();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)1))).setSelectedColumnAndHeader(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)0));
    }

    @Test
    public void reselectCurrentHeaderCellMultipleMiddleColumns() {
        ScenarioGridColumn columnMock = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock.getIndex()).thenReturn((Object)0);
        ScenarioGridColumn columnMock2 = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock2.getIndex()).thenReturn((Object)1);
        ScenarioGridColumn columnMock3 = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)columnMock3.getIndex()).thenReturn((Object)2);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Arrays.asList(columnMock, columnMock2, columnMock3));
        ArrayList<GridData.SelectedCell> selectedHeaderCells = new ArrayList<GridData.SelectedCell>();
        selectedHeaderCells.add(new GridData.SelectedCell(0, 1));
        selectedHeaderCells.add(new GridData.SelectedCell(0, 2));
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(selectedHeaderCells);
        this.scenarioGridSpy.selectCurrentHeaderCellGroup();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.times((int)1))).setSelectedColumnAndHeader(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)1));
    }

    @Test
    public void reselectCurrentHeaderCell_NoHeaderCellsSelected() {
        ArrayList selectedHeaderCells = new ArrayList();
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(selectedHeaderCells);
        this.scenarioGridSpy.selectCurrentHeaderCellGroup();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridSpy, (VerificationMode)Mockito.never())).setSelectedColumnAndHeader(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }
}

