/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.factories.CollectionEditorSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioExpressionCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.models.AbstractScesimGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridWidget;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;

public class ScenarioSimulationContext {
    private static final AtomicLong STATUS_COUNTER_ID = new AtomicLong();
    private static final String ILLEGAL_WIDGET_MESSAGE_PREFIX = "Illegal GridWidget ";
    protected final ScenarioGridWidget simulationGridWidget;
    protected final ScenarioGridWidget backgroundGridWidget;
    protected ScenarioSimulationEditorPresenter scenarioSimulationEditorPresenter;
    protected TestToolsView.Presenter testToolsPresenter;
    protected SortedMap<String, FactModelTree> dataObjectFieldsMap;
    protected Set<String> dataObjectsInstancesName;
    protected Status status = new Status();

    public ScenarioSimulationContext(ScenarioGridWidget simulationGridWidget, ScenarioGridWidget backgroundGridWidget) {
        this.simulationGridWidget = simulationGridWidget;
        this.backgroundGridWidget = backgroundGridWidget;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public ScenarioSimulationEditorPresenter getScenarioSimulationEditorPresenter() {
        return this.scenarioSimulationEditorPresenter;
    }

    public void setScenarioSimulationEditorPresenter(ScenarioSimulationEditorPresenter scenarioSimulationEditorPresenter) {
        this.scenarioSimulationEditorPresenter = scenarioSimulationEditorPresenter;
    }

    public ScenarioSimulationModel getScenarioSimulationModel() {
        return this.scenarioSimulationEditorPresenter.getModel();
    }

    public TestToolsView.Presenter getTestToolsPresenter() {
        return this.testToolsPresenter;
    }

    public void setTestToolsPresenter(TestToolsView.Presenter testToolsPresenter) {
        this.testToolsPresenter = testToolsPresenter;
    }

    public SortedMap<String, FactModelTree> getDataObjectFieldsMap() {
        return this.dataObjectFieldsMap;
    }

    public void setDataObjectFieldsMap(SortedMap<String, FactModelTree> dataObjectFieldsMap) {
        this.dataObjectFieldsMap = dataObjectFieldsMap;
    }

    public void setDataObjectsInstancesName(Set<String> dataObjectsInstancesName) {
        this.dataObjectsInstancesName = dataObjectsInstancesName;
    }

    public Optional<ScenarioGridWidget> getSelectedScenarioGridWidget() {
        if (this.backgroundGridWidget.isSelected() && this.simulationGridWidget.isSelected()) {
            throw new IllegalStateException("Simulation and Background grids can not be selected at the same time");
        }
        if (!this.backgroundGridWidget.isSelected() && !this.simulationGridWidget.isSelected()) {
            return Optional.empty();
        }
        return this.backgroundGridWidget.isSelected() ? Optional.of(this.backgroundGridWidget) : Optional.of(this.simulationGridWidget);
    }

    public ScenarioGrid getSimulationGrid() {
        return this.simulationGridWidget.getScenarioGridPanel().getScenarioGrid();
    }

    public ScenarioGrid getBackgroundGrid() {
        return this.backgroundGridWidget.getScenarioGridPanel().getScenarioGrid();
    }

    public Optional<ScenarioGridPanel> getSelectedScenarioGridPanel() {
        return this.getSelectedScenarioGridWidget().map(ScenarioGridWidget::getScenarioGridPanel);
    }

    public ScenarioGridPanel getScenarioGridPanelByGridWidget(GridWidget gridWidget) {
        switch (gridWidget) {
            case SIMULATION: {
                return this.simulationGridWidget.getScenarioGridPanel();
            }
            case BACKGROUND: {
                return this.backgroundGridWidget.getScenarioGridPanel();
            }
        }
        throw new IllegalArgumentException(ILLEGAL_WIDGET_MESSAGE_PREFIX + (Object)((Object)gridWidget));
    }

    public AbstractScesimGridModel getAbstractScesimGridModelByGridWidget(GridWidget gridWidget) {
        switch (gridWidget) {
            case SIMULATION: {
                return this.simulationGridWidget.getModel();
            }
            case BACKGROUND: {
                return this.backgroundGridWidget.getModel();
            }
        }
        throw new IllegalArgumentException(ILLEGAL_WIDGET_MESSAGE_PREFIX + (Object)((Object)gridWidget));
    }

    public <T extends AbstractScesimData> AbstractScesimModel<T> getAbstractScesimModelByGridWidget(GridWidget gridWidget) {
        switch (gridWidget) {
            case SIMULATION: {
                return this.status.getSimulation();
            }
            case BACKGROUND: {
                return this.status.getBackground();
            }
        }
        throw new IllegalArgumentException(ILLEGAL_WIDGET_MESSAGE_PREFIX + (Object)((Object)gridWidget));
    }

    public Optional<AbstractScesimGridModel> getSelectedScenarioGridModel() {
        return this.getSelectedScenarioGridLayer().map(ScenarioGridLayer::getScenarioGrid).map(ScenarioGrid::getModel);
    }

    public Optional<ScenarioGridLayer> getSelectedScenarioGridLayer() {
        return this.getSelectedScenarioGridPanel().map(ScenarioGridPanel::getScenarioGridLayer);
    }

    public Optional<GridWidget> getSelectedGridWidget() {
        return this.getSelectedScenarioGridModel().map(AbstractScesimGridModel::getGridWidget);
    }

    public void setStatusSimulationIfEmpty() {
        Optional abstractScesimModel;
        if (this.status.getSimulation() == null) {
            abstractScesimModel = this.simulationGridWidget.getModel().getAbstractScesimModel();
            this.status.setSimulation((Simulation)abstractScesimModel.orElseThrow(IllegalStateException::new));
        }
        if (this.status.getBackground() == null) {
            abstractScesimModel = this.backgroundGridWidget.getModel().getAbstractScesimModel();
            this.status.setBackground((Background)abstractScesimModel.orElseThrow(IllegalStateException::new));
        }
    }

    public CollectionEditorSingletonDOMElementFactory getCollectionEditorSingletonDOMElementFactory(GridWidget gridWidget) {
        return this.getAbstractScesimGridModelByGridWidget(gridWidget).getCollectionEditorSingletonDOMElementFactory();
    }

    public ScenarioCellTextAreaSingletonDOMElementFactory getScenarioCellTextAreaSingletonDOMElementFactory(GridWidget gridWidget) {
        return this.getAbstractScesimGridModelByGridWidget(gridWidget).getScenarioCellTextAreaSingletonDOMElementFactory();
    }

    public ScenarioHeaderTextBoxSingletonDOMElementFactory getScenarioHeaderTextBoxSingletonDOMElementFactory(GridWidget gridWidget) {
        return this.getAbstractScesimGridModelByGridWidget(gridWidget).getScenarioHeaderTextBoxSingletonDOMElementFactory();
    }

    public ScenarioExpressionCellTextAreaSingletonDOMElementFactory getScenarioExpressionCellTextAreaSingletonDOMElementFactory(GridWidget gridWidget) {
        return this.getAbstractScesimGridModelByGridWidget(gridWidget).getScenarioExpressionCellTextAreaSingletonDOMElementFactory();
    }

    public void setUndoButtonEnabledStatus(boolean enabled) {
        this.scenarioSimulationEditorPresenter.setUndoButtonEnabledStatus(enabled);
    }

    public void setRedoButtonEnabledStatus(boolean enabled) {
        this.scenarioSimulationEditorPresenter.setRedoButtonEnabledStatus(enabled);
    }

    static /* synthetic */ AtomicLong access$000() {
        return STATUS_COUNTER_ID;
    }

    public class Status {
        private final long id = ScenarioSimulationContext.access$000().getAndIncrement();
        protected String columnId;
        protected int columnIndex;
        protected boolean isRight;
        protected boolean asProperty;
        protected String columnGroup;
        protected String fullPackage;
        protected String className;
        protected String importPrefix;
        protected String value;
        protected String valueClassName;
        protected boolean keepData;
        protected String gridCellValue;
        protected int rowIndex;
        protected Simulation simulation;
        protected Background background;
        protected GridWidget currentGrid;
        protected String filterTerm;
        protected boolean notEqualsSearch = false;
        protected List<String> propertyNameElements;
        protected String headerCellValue;
        protected boolean disable = true;
        protected boolean openDock = false;

        public long getId() {
            return this.id;
        }

        public String getColumnId() {
            return this.columnId;
        }

        public void setColumnId(String columnId) {
            this.columnId = columnId;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public boolean isAsProperty() {
            return this.asProperty;
        }

        public void setAsProperty(boolean asProperty) {
            this.asProperty = asProperty;
        }

        public String getColumnGroup() {
            return this.columnGroup;
        }

        public void setColumnGroup(String columnGroup) {
            this.columnGroup = columnGroup;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public boolean isRight() {
            return this.isRight;
        }

        public void setRight(boolean right) {
            this.isRight = right;
        }

        public String getFullPackage() {
            return this.fullPackage == null ? "" : this.fullPackage;
        }

        public void setFullPackage(String fullPackage) {
            this.fullPackage = fullPackage;
        }

        public boolean isKeepData() {
            return this.keepData;
        }

        public void setKeepData(boolean keepData) {
            this.keepData = keepData;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValueClassName() {
            return this.valueClassName;
        }

        public void setValueClassName(String valueClassName) {
            this.valueClassName = valueClassName;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public String getFilterTerm() {
            return this.filterTerm;
        }

        public void setFilterTerm(String filterTerm) {
            this.filterTerm = filterTerm;
        }

        public boolean isNotEqualsSearch() {
            return this.notEqualsSearch;
        }

        public void setNotEqualsSearch(boolean notEqualsSearch) {
            this.notEqualsSearch = notEqualsSearch;
        }

        public List<String> getPropertyNameElements() {
            return this.propertyNameElements;
        }

        public void setPropertyNameElements(List<String> propertyNameElements) {
            this.propertyNameElements = propertyNameElements;
        }

        public boolean isDisable() {
            return this.disable;
        }

        public void setDisable(boolean disable) {
            this.disable = disable;
        }

        public boolean isOpenDock() {
            return this.openDock;
        }

        public void setOpenDock(boolean openDock) {
            this.openDock = openDock;
        }

        public String getGridCellValue() {
            return this.gridCellValue;
        }

        public void setGridCellValue(String gridCellValue) {
            this.gridCellValue = gridCellValue;
        }

        public String getHeaderCellValue() {
            return this.headerCellValue;
        }

        public void setHeaderCellValue(String headerCellValue) {
            this.headerCellValue = headerCellValue;
        }

        public Simulation getSimulation() {
            return this.simulation;
        }

        public void setSimulation(Simulation simulation) {
            this.simulation = simulation;
        }

        public Background getBackground() {
            return this.background;
        }

        public void setBackground(Background background) {
            this.background = background;
        }

        public GridWidget getCurrentGrid() {
            return this.currentGrid;
        }

        public void setCurrentGrid(GridWidget currentGrid) {
            this.currentGrid = currentGrid;
        }

        public String getImportPrefix() {
            return this.importPrefix;
        }

        public void setImportPrefix(String importPrefix) {
            this.importPrefix = importPrefix;
        }

        public Status cloneStatus() {
            Status toReturn = new Status();
            toReturn.columnId = this.columnId;
            toReturn.columnIndex = this.columnIndex;
            toReturn.isRight = this.isRight;
            toReturn.asProperty = this.asProperty;
            toReturn.columnGroup = this.columnGroup;
            toReturn.fullPackage = this.fullPackage;
            toReturn.className = this.className;
            toReturn.value = this.value;
            toReturn.valueClassName = this.valueClassName;
            toReturn.keepData = this.keepData;
            toReturn.gridCellValue = this.gridCellValue;
            toReturn.rowIndex = this.rowIndex;
            toReturn.simulation = this.simulation.cloneModel();
            toReturn.background = this.background.cloneModel();
            toReturn.currentGrid = this.currentGrid;
            toReturn.importPrefix = this.importPrefix;
            return toReturn;
        }
    }
}

