/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.AbstractScenarioSimulationEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDMODataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.client.callbacks.Callback;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractDMODataManagementStrategyTest
extends AbstractScenarioSimulationEditorTest {
    private static final String PARAMETRIC_FIELD_TYPE = "ParametricFieldType";
    private AbstractDMODataManagementStrategy abstractDMODataManagementStrategySpy;
    private AbstractDataManagementStrategy.ResultHolder factModelTreeHolderlocal;
    private FactModelTuple factModelTupleLocal;
    private SortedMap<String, FactModelTree> visibleFactsLocal;
    private SortedMap<String, FactModelTree> hiddenFactsLocal;
    private List<String> factTypes;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.factTypes = new ArrayList<String>();
        this.visibleFactsLocal = new TreeMap<String, FactModelTree>();
        this.hiddenFactsLocal = new TreeMap<String, FactModelTree>();
        this.factModelTupleLocal = new FactModelTuple(this.visibleFactsLocal, this.hiddenFactsLocal);
        this.factModelTreeHolderlocal = new AbstractDataManagementStrategy.ResultHolder();
        this.factModelTreeHolderlocal.setFactModelTuple(this.factModelTupleLocal);
        this.abstractDMODataManagementStrategySpy = (AbstractDMODataManagementStrategy)Mockito.spy((Object)new AbstractDMODataManagementStrategy(){
            {
                this.model = AbstractDMODataManagementStrategyTest.this.modelLocal;
                this.factModelTreeHolder = AbstractDMODataManagementStrategyTest.this.factModelTreeHolderlocal;
            }

            public void manageScenarioSimulationModelContent(ObservablePath currentPath, ScenarioSimulationModelContent toManage) {
            }

            public boolean isADataType(String value) {
                return false;
            }

            protected String getFQCNByFactName(String factName) {
                return "test.scesim.TestClass";
            }

            protected String getParametricFieldType(String factName, String propertyName) {
                return AbstractDMODataManagementStrategyTest.PARAMETRIC_FIELD_TYPE;
            }

            protected List<String> getFactTypes() {
                return AbstractDMODataManagementStrategyTest.this.factTypes;
            }

            protected void getSuperType(String factType, Callback<String> callback) {
            }

            protected boolean skipPopulateTestTools() {
                return false;
            }

            protected void manageDataObjects(List<String> dataObjectsTypes, Map<String, String> superTypeMap, TestToolsView.Presenter testToolsPresenter, int expectedElements, SortedMap<String, FactModelTree> dataObjectsFieldsMap, ScenarioSimulationContext context, List<String> simpleJavaTypes, GridWidget gridWidget) {
            }
        });
    }

    @Test
    public void populateTestToolsWithoutFactModelTuple() {
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        this.abstractDMODataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((AbstractDMODataManagementStrategy)Mockito.verify((Object)this.abstractDMODataManagementStrategySpy, (VerificationMode)Mockito.never())).storeData((FactModelTuple)Matchers.eq((Object)this.factModelTupleLocal), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
        ((AbstractDMODataManagementStrategy)Mockito.verify((Object)this.abstractDMODataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).aggregatorCallbackMethod((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.eq((int)0), (SortedMap)Matchers.isA(SortedMap.class), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (FactModelTree)Matchers.eq(null), (List)Matchers.isA(List.class), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
        ((AbstractDMODataManagementStrategy)Mockito.verify((Object)this.abstractDMODataManagementStrategySpy, (VerificationMode)Mockito.never())).loadSuperTypes((List)Matchers.any(), (TestToolsView.Presenter)Matchers.any(), Matchers.anyInt(), (SortedMap)Matchers.any(), (Map)Matchers.any(), (ScenarioSimulationContext)Matchers.any(), (List)Matchers.any(), (GridWidget)Matchers.any());
    }

    @Test
    public void populateTestToolsWithoutFactModelTupleWithFactTypes() {
        this.factTypes.add("TestClass");
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        this.abstractDMODataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((AbstractDMODataManagementStrategy)Mockito.verify((Object)this.abstractDMODataManagementStrategySpy, (VerificationMode)Mockito.never())).storeData((FactModelTuple)Matchers.eq((Object)this.factModelTupleLocal), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
        ((AbstractDMODataManagementStrategy)Mockito.verify((Object)this.abstractDMODataManagementStrategySpy, (VerificationMode)Mockito.never())).aggregatorCallbackMethod((TestToolsView.Presenter)Matchers.any(), Matchers.anyInt(), (SortedMap)Matchers.any(), (ScenarioSimulationContext)Matchers.any(), (FactModelTree)Matchers.any(), (List)Matchers.any(), (GridWidget)Matchers.any());
        ((AbstractDMODataManagementStrategy)Mockito.verify((Object)this.abstractDMODataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).loadSuperTypes((List)Matchers.isA(List.class), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.eq((int)1), (SortedMap)Matchers.isA(SortedMap.class), (Map)Matchers.isA(Map.class), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (List)Matchers.isA(List.class), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void populateTestToolsWithFactModelTuple() {
        this.abstractDMODataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((AbstractDMODataManagementStrategy)Mockito.verify((Object)this.abstractDMODataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).storeData((FactModelTuple)Matchers.eq((Object)this.factModelTupleLocal), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
        ((AbstractDMODataManagementStrategy)Mockito.verify((Object)this.abstractDMODataManagementStrategySpy, (VerificationMode)Mockito.never())).loadSuperTypes((List)Matchers.any(), (TestToolsView.Presenter)Matchers.any(), Matchers.anyInt(), (SortedMap)Matchers.any(), (Map)Matchers.any(), (ScenarioSimulationContext)Matchers.any(), (List)Matchers.any(), (GridWidget)Matchers.any());
        ((AbstractDMODataManagementStrategy)Mockito.verify((Object)this.abstractDMODataManagementStrategySpy, (VerificationMode)Mockito.never())).aggregatorCallbackMethod((TestToolsView.Presenter)Matchers.any(), Matchers.anyInt(), (SortedMap)Matchers.any(), (ScenarioSimulationContext)Matchers.any(), (FactModelTree)Matchers.any(), (List)Matchers.any(), (GridWidget)Matchers.any());
    }

    @Test
    public void loadSuperTypes() {
        String factType = "factType";
        int expectedElement = 1;
        List<String> dataObjectsType = Arrays.asList(factType);
        TreeMap dataObjectsFieldMap = new TreeMap();
        HashMap superTypesMap = new HashMap();
        ArrayList javaSimpleType = new ArrayList();
        this.abstractDMODataManagementStrategySpy.loadSuperTypes(dataObjectsType, (TestToolsView.Presenter)this.testToolsPresenterMock, expectedElement, dataObjectsFieldMap, superTypesMap, this.scenarioSimulationContextLocal, javaSimpleType, GridWidget.SIMULATION);
        ((AbstractDMODataManagementStrategy)Mockito.verify((Object)this.abstractDMODataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).superTypeAggregatorCallBack((List)Matchers.eq(dataObjectsType), (Map)Matchers.eq(superTypesMap), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.eq((int)expectedElement), (SortedMap)Matchers.eq(dataObjectsFieldMap), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (List)Matchers.eq(javaSimpleType), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION), (String)Matchers.eq((Object)factType));
        ((AbstractDMODataManagementStrategy)Mockito.verify((Object)this.abstractDMODataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getSuperType((String)Matchers.eq((Object)factType), (Callback)Matchers.isA(Callback.class));
    }

    @Test
    public void superTypeAggregatorCallBack() {
        String factType = "factType";
        String factType2 = "factType2";
        int expectedElement = 2;
        List<String> dataObjectsType = Arrays.asList(factType, factType2);
        TreeMap dataObjectsFieldMap = new TreeMap();
        HashMap superTypesMap = new HashMap();
        ArrayList javaSimpleType = new ArrayList();
        Callback callback = this.abstractDMODataManagementStrategySpy.superTypeAggregatorCallBack(dataObjectsType, superTypesMap, (TestToolsView.Presenter)this.testToolsPresenterMock, expectedElement, dataObjectsFieldMap, this.scenarioSimulationContextLocal, javaSimpleType, GridWidget.SIMULATION, factType);
        callback.callback((Object)Object.class.getCanonicalName());
        Assert.assertTrue((boolean)superTypesMap.containsKey(factType));
        Assert.assertEquals((Object)Object.class.getCanonicalName(), superTypesMap.get(factType));
        Callback callback2 = this.abstractDMODataManagementStrategySpy.superTypeAggregatorCallBack(dataObjectsType, superTypesMap, (TestToolsView.Presenter)this.testToolsPresenterMock, expectedElement, dataObjectsFieldMap, this.scenarioSimulationContextLocal, javaSimpleType, GridWidget.SIMULATION, factType2);
        callback2.callback((Object)Class.class.getCanonicalName());
        Assert.assertTrue((boolean)superTypesMap.containsKey(factType2));
        Assert.assertEquals((Object)Class.class.getCanonicalName(), superTypesMap.get(factType2));
        ((AbstractDMODataManagementStrategy)Mockito.verify((Object)this.abstractDMODataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).manageDataObjects((List)Matchers.eq(dataObjectsType), (Map)Matchers.eq(superTypesMap), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.eq((int)expectedElement), (SortedMap)Matchers.eq(dataObjectsFieldMap), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (List)Matchers.eq(javaSimpleType), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void defineClassNameField_SimpleType() {
        HashMap superTypesMap = new HashMap();
        String retrieved = this.abstractDMODataManagementStrategySpy.defineClassNameField(String.class.getSimpleName(), superTypesMap);
        Assert.assertEquals((Object)String.class.getCanonicalName(), (Object)retrieved);
    }

    @Test
    public void defineClassNameField_NotSimpleNotEnum() {
        HashMap superTypesMap = new HashMap();
        String retrieved = this.abstractDMODataManagementStrategySpy.defineClassNameField("TestClass", superTypesMap);
        Assert.assertEquals((Object)"TestClass", (Object)retrieved);
    }

    @Test
    public void defineClassNameField_NotSimpleEnum() {
        HashMap<String, String> superTypesMap = new HashMap<String, String>();
        superTypesMap.put("TestClass", Enum.class.getCanonicalName());
        String retrieved = this.abstractDMODataManagementStrategySpy.defineClassNameField("TestClass", superTypesMap);
        Assert.assertEquals((Object)"test.scesim.TestClass", (Object)retrieved);
    }

    @Test
    public void getFactModelTree() {
        Map<String, FactModelTree.PropertyTypeName> simpleProperties = this.getSimplePropertiesInner();
        ModelField[] modelFields = this.getModelFieldsInner(simpleProperties);
        FactModelTree retrieved = this.abstractDMODataManagementStrategySpy.getFactModelTree("FACT_NAME", Collections.emptyMap(), modelFields);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"FACT_NAME", (Object)retrieved.getFactName());
        Assert.assertEquals((Object)"test.scesim", (Object)retrieved.getFullPackage());
        Assert.assertFalse((boolean)retrieved.getSimpleProperties().isEmpty());
        retrieved.getSimpleProperties().entrySet().forEach(entry -> {
            Assert.assertFalse((boolean)((FactModelTree.PropertyTypeName)entry.getValue()).getBaseTypeName().isPresent());
            Assert.assertEquals((Object)((FactModelTree.PropertyTypeName)entry.getValue()).getTypeName(), (Object)((FactModelTree.PropertyTypeName)entry.getValue()).getPropertyTypeNameToVisualize());
        });
    }

    @Test
    public void getFactModelTreeEnumClass() {
        ModelField[] modelFields = new ModelField[]{};
        HashMap<String, String> superTypesMap = new HashMap<String, String>();
        superTypesMap.put("FACT_NAME", Enum.class.getCanonicalName());
        FactModelTree retrieved = this.abstractDMODataManagementStrategySpy.getFactModelTree("FACT_NAME", superTypesMap, modelFields);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"FACT_NAME", (Object)retrieved.getFactName());
        Assert.assertEquals((Object)"test.scesim", (Object)retrieved.getFullPackage());
        Assert.assertTrue((boolean)retrieved.getSimpleProperties().containsKey("value"));
        Assert.assertEquals((Object)"test.scesim.TestClass", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("value")).getTypeName());
        Assert.assertEquals((Object)"test.scesim.TestClass", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("value")).getPropertyTypeNameToVisualize());
        Assert.assertFalse((boolean)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("value")).getBaseTypeName().isPresent());
        Assert.assertEquals((Object)"test.scesim.TestClass", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("value")).getPropertyTypeNameToVisualize());
    }

    private ModelField[] getModelFieldsInner(Map<String, FactModelTree.PropertyTypeName> simpleProperties) {
        ArrayList toReturn = new ArrayList();
        simpleProperties.forEach((key, value) -> toReturn.add(this.getModelFieldInner((String)key, value.getTypeName(), "String")));
        return toReturn.toArray(new ModelField[toReturn.size()]);
    }

    private ModelField getModelFieldInner(String name, String clazz, String type) {
        return new ModelField(name, clazz, ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, type);
    }

    private Map<String, FactModelTree.PropertyTypeName> getSimplePropertiesInner() {
        String[] keys = this.getRandomStringArray();
        return Arrays.stream(keys).collect(Collectors.toMap(key -> key, key -> {
            key = key + "_VALUE";
            return new FactModelTree.PropertyTypeName(key);
        }));
    }

    private String[] getRandomStringArray() {
        return new String[]{RandomStringUtils.randomAlphabetic((int)3), RandomStringUtils.randomAlphabetic((int)4), RandomStringUtils.randomAlphabetic((int)5)};
    }
}

