/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import java.util.function.Consumer;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.UpdateSettingsDataCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.command.client.CommandResult;
import org.kie.workbench.common.command.client.CommandResultBuilder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class UpdateSettingsDataCommandTest
extends AbstractScenarioSimulationTest {
    @Mock
    private Consumer consumerMock;
    protected UpdateSettingsDataCommand commandSpy;

    @Override
    @Before
    public void setup() {
        this.commandSpy = (UpdateSettingsDataCommand)Mockito.spy((Object)new UpdateSettingsDataCommand(this.consumerMock, false));
        super.setup();
    }

    @Test
    public void setRestorableStatus() {
        Settings clonedStatus = this.commandSpy.setRestorableStatusPreExecution(this.scenarioSimulationContextLocal);
        Assert.assertNotNull((Object)clonedStatus);
    }

    @Test
    public void undoWithRestorable() {
        this.commandSpy.restorableStatus = this.settingsLocal;
        this.commandSpy.undo(this.scenarioSimulationContextLocal);
        ((UpdateSettingsDataCommand)Mockito.verify((Object)this.commandSpy, (VerificationMode)Mockito.times((int)1))).setCurrentContext((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test(expected=IllegalStateException.class)
    public void undoWithoutRestorable() {
        this.commandSpy.restorableStatus = null;
        this.commandSpy.undo(this.scenarioSimulationContextLocal);
    }

    @Test
    public void redoWithRestorable() {
        this.commandSpy.restorableStatus = this.settingsLocal;
        this.commandSpy.redo(this.scenarioSimulationContextLocal);
        ((UpdateSettingsDataCommand)Mockito.verify((Object)this.commandSpy, (VerificationMode)Mockito.times((int)1))).setCurrentContext((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test(expected=IllegalStateException.class)
    public void redoWithoutRestorable() {
        this.commandSpy.restorableStatus = null;
        this.commandSpy.redo(this.scenarioSimulationContextLocal);
    }

    @Test
    public void commonUndoRedoPreExecution() {
        Optional optional = this.commandSpy.commonUndoRedoPreExecution(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).expandSettingsDock();
        Assert.assertEquals((Object)CommandResultBuilder.SUCCESS, optional.get());
    }

    @Test
    public void internalExecute() {
        this.commandSpy.internalExecute(this.scenarioSimulationContextLocal);
        ((Consumer)Mockito.verify((Object)this.consumerMock, (VerificationMode)Mockito.times((int)1))).accept(Matchers.eq((Object)this.settingsLocal));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.never())).getPopulateTestToolsCommand();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.never())).getUpdateDMNMetadataCommand();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).reloadSettingsDock();
    }

    @Test
    public void internalExecuteDMNPathChanged() {
        Mockito.when((Object)this.scenarioSimulationEditorPresenterMock.getPopulateTestToolsCommand()).thenReturn(() -> {});
        Mockito.when((Object)this.scenarioSimulationEditorPresenterMock.getUpdateDMNMetadataCommand()).thenReturn(() -> {});
        this.commandSpy = (UpdateSettingsDataCommand)Mockito.spy((Object)new UpdateSettingsDataCommand(this.consumerMock, true));
        this.commandSpy.internalExecute(this.scenarioSimulationContextLocal);
        ((Consumer)Mockito.verify((Object)this.consumerMock, (VerificationMode)Mockito.times((int)1))).accept(Matchers.eq((Object)this.settingsLocal));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).getPopulateTestToolsCommand();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).getUpdateDMNMetadataCommand();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.never())).reloadSettingsDock();
    }

    @Test
    public void setCurrentContextNullStatus() {
        this.commandSpy.restorableStatus = null;
        CommandResult returned = this.commandSpy.setCurrentContext(this.scenarioSimulationContextLocal);
        Assert.assertEquals((Object)CommandResult.Type.ERROR, (Object)returned.getType());
    }

    @Test
    public void setCurrentContext() {
        this.commandSpy.restorableStatus = this.settingsLocal;
        this.commandSpy.setCurrentContext(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationModel)Mockito.verify((Object)this.scenarioSimulationModelMock, (VerificationMode)Mockito.times((int)1))).setSettings((Settings)Matchers.eq((Object)this.settingsLocal));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).reloadSettingsDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.never())).getUpdateDMNMetadataCommand();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.never())).validateSimulation();
        ((UpdateSettingsDataCommand)Mockito.verify((Object)this.commandSpy, (VerificationMode)Mockito.times((int)1))).commonExecution((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        Assert.assertNotEquals((Object)this.settingsLocal, (Object)this.commandSpy.restorableStatus);
    }

    @Test
    public void setCurrentContextDMNPatchChanged() {
        Mockito.when((Object)this.scenarioSimulationEditorPresenterMock.getPopulateTestToolsCommand()).thenReturn(() -> {});
        this.commandSpy = (UpdateSettingsDataCommand)Mockito.spy((Object)new UpdateSettingsDataCommand(this.consumerMock, true));
        this.commandSpy.restorableStatus = this.settingsLocal;
        this.commandSpy.setCurrentContext(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationModel)Mockito.verify((Object)this.scenarioSimulationModelMock, (VerificationMode)Mockito.times((int)1))).setSettings((Settings)Matchers.eq((Object)this.settingsLocal));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).getPopulateTestToolsCommand();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).validateSimulation();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).reloadSettingsDock();
        ((UpdateSettingsDataCommand)Mockito.verify((Object)this.commandSpy, (VerificationMode)Mockito.times((int)1))).commonExecution((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        Assert.assertNotEquals((Object)this.settingsLocal, (Object)this.commandSpy.restorableStatus);
    }
}

