/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.Objects;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.UnsupportedDMNEvent;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

public abstract class AbstractDMNDataManagementStrategy
extends AbstractDataManagementStrategy {
    protected final EventBus eventBus;
    protected Path currentPath;
    protected String dmnFilePath;

    public AbstractDMNDataManagementStrategy(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    protected abstract void retrieveFactModelTuple(TestToolsView.Presenter var1, ScenarioSimulationContext var2, GridWidget var3);

    @Override
    public void populateTestTools(TestToolsView.Presenter testToolsPresenter, ScenarioSimulationContext context, GridWidget gridWidget) {
        if (this.factModelTreeHolder.getFactModelTuple() != null && Objects.equals(this.dmnFilePath, this.model.getSettings().getDmnFilePath())) {
            this.getSuccessCallback(testToolsPresenter, context, gridWidget).callback((Object)this.factModelTreeHolder.getFactModelTuple());
        } else {
            this.dmnFilePath = this.model.getSettings().getDmnFilePath();
            this.retrieveFactModelTuple(testToolsPresenter, context, gridWidget);
        }
    }

    @Override
    public void manageScenarioSimulationModelContent(ObservablePath currentPath, ScenarioSimulationModelContent toManage) {
        this.currentPath = currentPath.getOriginal();
        this.model = toManage.getModel();
    }

    @Override
    public boolean isADataType(String value) {
        return this.factModelTreeHolder.factModelTuple.getHiddenFacts().keySet().contains(value) || this.factModelTreeHolder.factModelTuple.getVisibleFacts().keySet().contains(value);
    }

    public RemoteCallback<FactModelTuple> getSuccessCallback(TestToolsView.Presenter testToolsPresenter, ScenarioSimulationContext context, GridWidget gridWidget) {
        return factMappingTuple -> this.getSuccessCallbackMethod((FactModelTuple)factMappingTuple, testToolsPresenter, context, gridWidget);
    }

    public void getSuccessCallbackMethod(FactModelTuple factModelTuple, TestToolsView.Presenter testToolsPresenter, ScenarioSimulationContext context, GridWidget gridWidget) {
        this.factModelTreeHolder.setFactModelTuple(factModelTuple);
        this.storeData(factModelTuple, testToolsPresenter, context, gridWidget);
        this.showErrorsAndCleanupState(factModelTuple);
    }

    protected void showErrorsAndCleanupState(FactModelTuple factModelTuple) {
        StringBuilder builder = new StringBuilder();
        boolean showError = false;
        if (!factModelTuple.getMultipleNestedCollectionError().isEmpty()) {
            showError = true;
            builder.append("Nested collections are not supported! Violated by:<br/>");
            factModelTuple.getMultipleNestedCollectionError().forEach(error -> builder.append("<b>" + error + "</b><br/>"));
            builder.append("<br/>");
        }
        if (!factModelTuple.getMultipleNestedObjectError().isEmpty()) {
            showError = true;
            builder.append("Complex nested objects inside a collection are not supported! Violated by:<br/>");
            factModelTuple.getMultipleNestedObjectError().forEach(error -> builder.append("<b>" + error + "</b><br/>"));
        }
        if (showError) {
            factModelTuple.getMultipleNestedCollectionError().clear();
            factModelTuple.getMultipleNestedObjectError().clear();
            this.eventBus.fireEvent((GwtEvent)new UnsupportedDMNEvent(builder.toString()));
        }
    }

    protected ErrorCallback<Message> getErrorCallback() {
        return (error, exception) -> {
            ErrorPopup.showMessage((String)exception.getMessage());
            return false;
        };
    }
}

